@extends('layouts.app')

@section('title', 'My Challenges')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-gaming font-bold text-cod-green">⚔️ My Challenges</h1>
        @if(auth()->user()->canCreateChallenges())
            <a href="{{ route('challenges.create') }}" class="bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                Create New Challenge
            </a>
        @endif
    </div>

    <!-- Status Filter Tabs -->
    <div class="flex space-x-1 mb-6">
        <a href="{{ route('challenges.my', ['filter' => 'all'] + request()->except('filter')) }}" 
           class="px-6 py-3 rounded-lg font-semibold transition-colors {{ ($filter ?? 'all') === 'all' ? 'bg-cod-green text-black' : 'bg-cod-gray text-gray-300 hover:bg-cod-light' }}">
            📊 All Challenges
        </a>
        <a href="{{ route('challenges.my', ['filter' => 'ongoing'] + request()->except('filter')) }}" 
           class="px-6 py-3 rounded-lg font-semibold transition-colors {{ ($filter ?? 'all') === 'ongoing' ? 'bg-cod-green text-black' : 'bg-cod-gray text-gray-300 hover:bg-cod-light' }}">
            🔥 Ongoing
        </a>
        <a href="{{ route('challenges.my', ['filter' => 'past'] + request()->except('filter')) }}" 
           class="px-6 py-3 rounded-lg font-semibold transition-colors {{ ($filter ?? 'all') === 'past' ? 'bg-cod-green text-black' : 'bg-cod-gray text-gray-300 hover:bg-cod-light' }}">
            📚 Past Challenges
        </a>
    </div>

    <!-- Enhanced Filters -->
    <div class="bg-cod-gray rounded-lg p-6 mb-8">
        <form method="GET" action="{{ route('challenges.my') }}">
            <input type="hidden" name="filter" value="{{ $filter ?? 'all' }}">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <select name="game_id" class="bg-cod-dark text-gray-100 border border-cod-light rounded-lg px-4 py-2">
                    <option value="">All Games</option>
                    @foreach($games as $game)
                        <option value="{{ $game->id }}" {{ request('game_id') == $game->id ? 'selected' : '' }}>
                            {{ $game->name }}
                        </option>
                    @endforeach
                </select>
                
                <button type="submit" class="bg-cod-green text-black px-6 py-2 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    🔍 Filter
                </button>
                
                <a href="{{ route('challenges.my') }}" class="bg-cod-gray text-gray-300 px-6 py-2 rounded-lg font-semibold hover:bg-cod-light transition-colors text-center">
                    Clear Filters
                </a>
            </div>
        </form>
    </div>

    <!-- Challenges Grid -->
    @if($challenges->count() > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($challenges as $challenge)
                <div class="bg-cod-gray rounded-lg p-6 border-l-4 {{ 
                    $challenge->status === 'completed' ? 'border-blue-500' : 
                    ($challenge->status === 'accepted' ? 'border-yellow-500' : 'border-cod-green') 
                }} hover:bg-cod-light transition-colors">
                    <!-- Challenge Header -->
                    <div class="flex justify-between items-start mb-4">
                        <div class="flex items-center space-x-2">
                            <img src="{{ $challenge->game->icon_url ?? asset('images/default-game.png') }}" 
                                 alt="{{ $challenge->game->name }}" 
                                 class="w-10 h-10 rounded-lg object-cover">
                            <div>
                                <h3 class="font-bold text-gray-100">{{ $challenge->game->name }}</h3>
                                <div class="text-sm text-gray-400">Best of {{ $challenge->best_of }}</div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="text-cod-green font-bold text-lg">₦{{ number_format($challenge->wager_amount) }}</div>
                            <div class="text-xs {{ 
                                $challenge->status === 'completed' ? 'text-blue-400' : 
                                ($challenge->status === 'accepted' ? 'text-yellow-400' : 'text-cod-green') 
                            }}">
                                {{ ucfirst($challenge->status) }}
                            </div>
                        </div>
                    </div>

                    <!-- Participants -->
                    <div class="mb-4">
                        <div class="flex justify-between items-center text-sm">
                            <div class="flex items-center space-x-2">
                                <span class="text-gray-400">Creator:</span>
                                <span class="text-gray-200 {{ $challenge->creator_id === auth()->id() ? 'font-bold text-cod-green' : '' }}">
                                    {{ $challenge->creator->username }}
                                    @if($challenge->creator_id === auth()->id())
                                        (You)
                                    @endif
                                </span>
                            </div>
                        </div>
                        @if($challenge->accepter)
                            <div class="flex justify-between items-center text-sm mt-1">
                                <div class="flex items-center space-x-2">
                                    <span class="text-gray-400">Accepter:</span>
                                    <span class="text-gray-200 {{ $challenge->accepter_id === auth()->id() ? 'font-bold text-cod-green' : '' }}">
                                        {{ $challenge->accepter->username }}
                                        @if($challenge->accepter_id === auth()->id())
                                            (You)
                                        @endif
                                    </span>
                                </div>
                            </div>
                        @else
                            <div class="text-sm text-gray-400 mt-1">Waiting for accepter...</div>
                        @endif
                    </div>

                    <!-- Challenge Result (for completed) -->
                    @if($challenge->status === 'completed' && $challenge->result)
                        <div class="mb-4 p-3 bg-cod-dark rounded-lg">
                            <div class="text-sm text-gray-400 mb-1">Result:</div>
                            <div class="text-sm font-semibold {{ 
                                ($challenge->result === 'creator_win' && $challenge->creator_id === auth()->id()) || 
                                ($challenge->result === 'accepter_win' && $challenge->accepter_id === auth()->id()) 
                                ? 'text-green-400' : 'text-red-400' 
                            }}">
                                @if($challenge->result === 'creator_win')
                                    🏆 {{ $challenge->creator->username }} Won
                                @elseif($challenge->result === 'accepter_win')
                                    🏆 {{ $challenge->accepter->username }} Won
                                @elseif($challenge->result === 'tie')
                                    🤝 Tie/Draw
                                @elseif($challenge->result === 'cancelled')
                                    ❌ Cancelled
                                @endif
                            </div>
                        </div>
                    @endif

                    <!-- Action Button -->
                    <div class="mt-4">
                        <a href="{{ route('challenges.show', $challenge) }}" 
                           class="block text-center bg-cod-green text-black py-2 px-4 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                            View Details
                        </a>
                    </div>

                    <!-- Timestamp -->
                    <div class="mt-3 text-xs text-gray-500 text-center">
                        {{ $challenge->created_at->diffForHumans() }}
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="mt-8">
            {{ $challenges->appends(request()->query())->links() }}
        </div>
    @else
        <!-- Empty State -->
        <div class="text-center py-16">
            <div class="w-24 h-24 bg-cod-gray rounded-full flex items-center justify-center mx-auto mb-6">
                <span class="text-4xl">⚔️</span>
            </div>
            <h3 class="text-xl font-bold text-gray-300 mb-2">
                @if(($filter ?? 'all') === 'ongoing')
                    No Ongoing Challenges
                @elseif(($filter ?? 'all') === 'past')
                    No Past Challenges
                @else
                    No Challenges Yet
                @endif
            </h3>
            <p class="text-gray-400 mb-6">
                @if(($filter ?? 'all') === 'ongoing')
                    You don't have any ongoing challenges at the moment.
                @elseif(($filter ?? 'all') === 'past')
                    You haven't completed any challenges yet.
                @else
                    You haven't participated in any challenges yet.
                @endif
            </p>
            @if(auth()->user()->canCreateChallenges())
                <a href="{{ route('challenges.create') }}" class="bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Create Your First Challenge
                </a>
            @else
                <a href="{{ route('challenges.index') }}" class="bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Browse Challenges
                </a>
            @endif
        </div>
    @endif
</div>
@endsection