@extends('layouts.app')

@section('title', 'Challenge Details')

@section('content')
<div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Challenge Header -->
    <div class="bg-cod-gray rounded-lg p-8 mb-8 gaming-glow">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
            <div>
                <h1 class="text-3xl font-gaming font-bold text-cod-green mb-2">{{ $challenge->game->name }} Challenge</h1>
                <div class="flex items-center space-x-4 text-gray-400">
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                        @if($challenge->status === 'open') bg-green-500/20 text-green-400
                        @elseif($challenge->status === 'accepted') bg-yellow-500/20 text-yellow-400
                        @elseif($challenge->status === 'completed') bg-blue-500/20 text-blue-400
                        @else bg-red-500/20 text-red-400 @endif">
                        {{ ucfirst($challenge->status) }}
                    </span>
                    <span>{{ ucfirst($challenge->game->platform) }}</span>
                    <span>Best of {{ $challenge->best_of }}</span>
                    <span>{{ $challenge->created_at->diffForHumans() }}</span>
                </div>
            </div>
            <div class="mt-4 lg:mt-0 text-center lg:text-right">
                <div class="text-3xl font-bold text-green-400">₦{{ number_format($challenge->wager_amount * 2) }}</div>
                <div class="text-sm text-gray-400">Total Prize Pool</div>
                <div class="text-xs text-gray-500 mt-1">₦{{ number_format($challenge->wager_amount) }} per player</div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-8">
            <!-- Players -->
            <div class="bg-cod-gray rounded-lg p-6">
                <h2 class="text-xl font-semibold text-cod-green mb-6">Players</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Creator -->
                    <div class="text-center">
                        <div class="bg-cod-dark rounded-lg p-6">
                            <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center mx-auto mb-4">
                                <span class="text-2xl font-bold text-black">{{ substr($challenge->creator->username, 0, 1) }}</span>
                            </div>
                            <h3 class="text-lg font-semibold text-gray-100">{{ $challenge->creator->username }}</h3>
                            <div class="text-sm text-gray-400 space-y-1">
                                <div>Level {{ $challenge->creator->level }}</div>
                                <div>{{ number_format($challenge->creator->xp) }} XP</div>
                                <div class="text-cod-green font-medium">Creator</div>
                            </div>
                        </div>
                    </div>

                    <!-- VS Divider -->
                    <div class="flex items-center justify-center">
                        <div class="text-4xl font-gaming font-bold text-cod-green">VS</div>
                    </div>

                    <!-- Accepter or Placeholder -->
                    <div class="text-center">
                        @if($challenge->accepter)
                            <div class="bg-cod-dark rounded-lg p-6">
                                <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center mx-auto mb-4">
                                    <span class="text-2xl font-bold text-black">{{ substr($challenge->accepter->username, 0, 1) }}</span>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-100">{{ $challenge->accepter->username }}</h3>
                                <div class="text-sm text-gray-400 space-y-1">
                                    <div>Level {{ $challenge->accepter->level }}</div>
                                    <div>{{ number_format($challenge->accepter->xp) }} XP</div>
                                    <div class="text-green-400 font-medium">Challenger</div>
                                </div>
                            </div>
                        @else
                            <div class="bg-cod-dark rounded-lg p-6 border-2 border-dashed border-cod-light">
                                <div class="w-16 h-16 bg-gray-600 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <span class="text-2xl text-gray-400">?</span>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-400">Waiting for challenger</h3>
                                <div class="text-sm text-gray-500">No one has accepted yet</div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Rules -->
            @if($challenge->rules_text)
                <div class="bg-cod-gray rounded-lg p-6">
                    <h2 class="text-xl font-semibold text-cod-green mb-4">Challenge Rules</h2>
                    <div class="bg-cod-dark rounded-lg p-4">
                        <p class="text-gray-300 whitespace-pre-wrap">{{ $challenge->rules_text }}</p>
                    </div>
                </div>
            @endif

            <!-- Match Proofs -->
            @if($challenge->status === 'accepted' || $challenge->status === 'completed' || $challenge->status === 'disputed')
                <div class="bg-cod-gray rounded-lg p-6">
                    <h2 class="text-xl font-semibold text-cod-green mb-4">Match Proofs</h2>
                    @if($challenge->matchProofs->count() > 0)
                        <div class="space-y-4">
                            @foreach($challenge->matchProofs as $proof)
                                <div class="bg-cod-dark rounded-lg p-4">
                                    <div class="flex items-center justify-between mb-2">
                                        <span class="font-semibold text-gray-100">{{ $proof->user->username }}</span>
                                        <span class="text-sm text-gray-400">{{ $proof->created_at->diffForHumans() }}</span>
                                    </div>
                                    @if($proof->file_url)
                                        <img src="{{ $proof->file_url }}" alt="Match proof" class="w-full max-w-md rounded border border-cod-light">
                                    @endif
                                    @if($proof->notes)
                                        <p class="text-gray-300 mt-2">{{ $proof->notes }}</p>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-8 text-gray-400">
                            <div class="text-4xl mb-2">📸</div>
                            <p>No match proofs uploaded yet</p>
                        </div>
                    @endif
                </div>
            @endif

            <!-- Dispute Information -->
            @if($challenge->dispute)
                <div class="bg-red-500/10 border border-red-500/20 rounded-lg p-6">
                    <h2 class="text-xl font-semibold text-red-400 mb-4">Dispute Information</h2>
                    <div class="space-y-2 text-gray-300">
                        <p><strong>Opened by:</strong> {{ $challenge->dispute->openedBy->username }}</p>
                        <p><strong>Reason:</strong> {{ $challenge->dispute->reason }}</p>
                        <p><strong>Status:</strong> {{ ucfirst($challenge->dispute->status) }}</p>
                        <p><strong>Opened:</strong> {{ $challenge->dispute->created_at->diffForHumans() }}</p>
                    </div>
                </div>
            @endif
        </div>

        <!-- Actions Sidebar -->
        <div class="space-y-6">
            <!-- Challenge Actions -->
            <div class="bg-cod-gray rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Actions</h3>
                
                @auth
                    @if($challenge->status === 'open' && $challenge->creator_id === auth()->id())
                        <a href="{{ route('challenges.invite', $challenge) }}" class="block w-full bg-blue-600 text-white px-4 py-3 rounded-lg font-semibold hover:bg-blue-700 transition-colors text-center mb-4">
                            Invite Friends
                        </a>
                    @endif

                    @if($challenge->status === 'open' && $challenge->canBeAcceptedBy(auth()->user()))
                        <form method="POST" action="{{ route('challenges.accept', $challenge) }}" class="mb-4">
                            @csrf
                            <button type="submit" class="w-full bg-cod-green text-black px-4 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                                Accept Challenge (₦{{ number_format($challenge->wager_amount) }})
                            </button>
                        </form>
                    @endif

                    @if($challenge->status === 'accepted' && ($challenge->creator_id === auth()->id() || $challenge->accepter_id === auth()->id()))
                        @if(!$challenge->matchProofs->where('user_id', auth()->id())->count())
                            <form method="POST" action="{{ route('challenges.submit-proof', $challenge) }}" enctype="multipart/form-data" class="mb-4">
                                @csrf
                                <div class="space-y-3">
                                    <label class="block text-sm font-medium text-gray-300">Upload Match Proof</label>
                                    <input type="file" name="proof_file" accept="image/*" required class="w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded file:border-0 file:bg-cod-green file:text-black">
                                    <textarea name="notes" placeholder="Describe the match result..." rows="3" class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded text-gray-100"></textarea>
                                    <button type="submit" class="w-full bg-cod-green text-black px-4 py-2 rounded font-semibold hover:bg-green-600 transition-colors">
                                        Submit Proof
                                    </button>
                                </div>
                            </form>
                        @endif

                        <!-- Post-Game Result Confirmation (New Flow) -->
                        @if($challenge->status === 'accepted' && !$challenge->isCompleted() && !$challenge->isDisputed())
                            @php
                                $userField = $challenge->creator_id === auth()->id() ? 'creator_claimed_result' : 'accepter_claimed_result';
                                $userClaim = $challenge->$userField;
                            @endphp

                            @if($userClaim === 'none')
                                <div class="bg-yellow-500/10 border border-yellow-500/20 rounded-lg p-4 mb-4">
                                    <h4 class="text-yellow-400 font-semibold mb-2">🏆 Confirm Match Result</h4>
                                    <p class="text-sm text-gray-300 mb-3">The match has been played. Please confirm the result:</p>
                                    <p class="text-xs text-gray-400 mb-3">💡 <strong>Note:</strong> Claiming "I Won" waits for opponent confirmation. Claiming "I Lost" immediately resolves the match.</p>
                                    
                                    <div class="grid grid-cols-2 gap-2">
                                        <form method="POST" action="{{ route('challenges.claim-result', $challenge) }}" class="inline">
                                            @csrf
                                            <input type="hidden" name="result" value="win">
                                            <button type="submit" class="w-full bg-green-500 text-white px-4 py-2 rounded font-semibold hover:bg-green-600 transition-colors">
                                                🏆 I Won
                                            </button>
                                        </form>
                                        
                                        <form method="POST" action="{{ route('challenges.claim-result', $challenge) }}" class="inline">
                                            @csrf
                                            <input type="hidden" name="result" value="loss">
                                            <button type="submit" class="w-full bg-red-500 text-white px-4 py-2 rounded font-semibold hover:bg-red-600 transition-colors"
                                                    onclick="return confirm('Are you sure you lost? This will immediately end the match and award the win to your opponent.')">
                                                😞 I Lost
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            @else
                                <div class="bg-blue-500/10 border border-blue-500/20 rounded-lg p-4 mb-4">
                                    <p class="text-blue-400 text-sm">
                                        ✅ You claimed: <strong>{{ $userClaim === 'win' ? 'Victory' : 'Defeat' }}</strong>
                                        @if($userClaim === 'win')
                                            <br>Waiting for opponent to confirm their result...
                                        @else
                                            <br>Match resolved! Your opponent wins by forfeit.
                                        @endif
                                    </p>
                                </div>
                            @endif
                        @endif

                        <!-- Evidence Upload for Disputes -->
                        @if($challenge->isDisputed() && $challenge->dispute && $challenge->bothClaimVictory())
                            @php
                                $userIsCreator = $challenge->creator_id === auth()->id();
                                $evidenceField = $userIsCreator ? 'creator_evidence_path' : 'accepter_evidence_path';
                                $hasEvidence = !empty($challenge->dispute->$evidenceField);
                            @endphp

                            @if(!$hasEvidence)
                                <div class="bg-red-500/10 border border-red-500/20 rounded-lg p-4 mb-4">
                                    <h4 class="text-red-400 font-semibold mb-2">⚠️ Evidence Required</h4>
                                    <p class="text-sm text-gray-300 mb-3">Both players claim victory. Please upload evidence (screenshot/video) to resolve this dispute:</p>
                                    
                                    <form method="POST" action="{{ route('challenges.upload-evidence', $challenge) }}" enctype="multipart/form-data">
                                        @csrf
                                        <div class="space-y-3">
                                            <input type="file" name="evidence" accept="image/*,video/*" required 
                                                   class="w-full text-sm text-gray-400 file:mr-4 file:py-2 file:px-4 file:rounded file:border-0 file:bg-red-500 file:text-white">
                                            <button type="submit" class="w-full bg-red-500 text-white px-4 py-2 rounded font-semibold hover:bg-red-600 transition-colors">
                                                📁 Upload Evidence
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            @else
                                <div class="bg-green-500/10 border border-green-500/20 rounded-lg p-4 mb-4">
                                    <p class="text-green-400 text-sm">
                                        ✅ Evidence uploaded successfully!
                                        @if($challenge->dispute->hasBothEvidence())
                                            <br>🔍 Admin has been notified and will review both evidences.
                                        @else
                                            <br>⏳ Waiting for opponent to upload their evidence.
                                        @endif
                                    </p>
                                </div>
                            @endif
                        @endif

                        <!-- Legacy Dispute Option (for non-victory conflicts) -->
                        @if($challenge->status === 'accepted' && $challenge->matchProofs->count() >= 2 && !$challenge->isDisputed() && !$challenge->hasBothClaimedResults())
                            <form method="POST" action="{{ route('challenges.dispute', $challenge) }}">
                                @csrf
                                <textarea name="reason" placeholder="Reason for dispute..." rows="3" required class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded text-gray-100 mb-2"></textarea>
                                <button type="submit" class="w-full bg-red-500 text-white px-4 py-2 rounded font-semibold hover:bg-red-600 transition-colors">
                                    Open Dispute
                                </button>
                            </form>
                        @endif
                    @endif
                @else
                    <div class="text-center">
                        <p class="text-gray-400 mb-4">Login to participate in challenges</p>
                        <a href="{{ route('login') }}" class="w-full inline-block bg-cod-green text-black text-center px-4 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                            Login
                        </a>
                    </div>
                @endauth
            </div>

            <!-- Challenge Info -->
            <div class="bg-cod-gray rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Challenge Details</h3>
                <div class="space-y-3 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-400">Game:</span>
                        <span class="text-gray-100">{{ $challenge->game->name }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Platform:</span>
                        <span class="text-gray-100">{{ ucfirst($challenge->game->platform) }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Format:</span>
                        <span class="text-gray-100">Best of {{ $challenge->best_of }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Entry Fee:</span>
                        <span class="text-gray-100">₦{{ number_format($challenge->wager_amount) }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Total Prize:</span>
                        <span class="text-green-400 font-bold">₦{{ number_format($challenge->wager_amount * 2 * 0.95) }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Created:</span>
                        <span class="text-gray-100">{{ $challenge->created_at->format('M j, Y') }}</span>
                    </div>
                </div>
            </div>

            <!-- Game Join Information -->
            @if($challenge->creator_game_username || $challenge->group_link || $challenge->group_id)
                <div class="bg-cod-gray rounded-lg p-6 border-l-4 border-cod-green">
                    <h3 class="text-lg font-semibold text-cod-green mb-4">🎮 Join Game Information</h3>
                    
                    @if($challenge->creator_game_username)
                        <div class="mb-3">
                            <span class="text-gray-400">Creator's In-Game Username:</span>
                            <div class="text-lg font-semibold text-cod-green">{{ $challenge->creator_game_username }}</div>
                        </div>
                    @endif

                    @if($challenge->group_link)
                        <div class="mb-3">
                            <span class="text-gray-400">Group/Lobby Link:</span>
                            <div>
                                <a href="{{ $challenge->group_link }}" target="_blank" class="text-cod-green hover:text-green-400 underline break-all">
                                    {{ $challenge->group_link }}
                                </a>
                            </div>
                        </div>
                    @endif

                    @if($challenge->group_id)
                        <div class="mb-3">
                            <span class="text-gray-400">Group/Room ID:</span>
                            <div class="text-lg font-semibold text-cod-green font-mono">{{ $challenge->group_id }}</div>
                        </div>
                    @endif

                    <div class="mt-4 p-3 bg-cod-dark rounded border-l-4 border-yellow-500">
                        <p class="text-sm text-yellow-400">
                            💡 <strong>Tip:</strong> Use the information above to find and join the creator's game lobby or send them a friend request.
                        </p>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection