@extends('layouts.app')

@section('title', 'My Blog Posts')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-6xl mx-auto">
        <!-- Header -->
        <div class="bg-white rounded-lg shadow-sm border p-6 mb-6">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">My Blog Posts</h1>
                    <p class="text-gray-600 mt-2">Manage your submitted blog posts</p>
                </div>
                <a href="{{ route('creator.blogs.create') }}" 
                   class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium">
                    Create New Post
                </a>
            </div>
        </div>

        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                {{ session('success') }}
            </div>
        @endif

        <!-- Posts List -->
        <div class="space-y-4">
            @forelse($posts as $post)
                <div class="bg-white rounded-lg shadow-sm border p-6">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">
                                <a href="{{ route('creator.blogs.show', $post) }}" class="hover:text-blue-600">
                                    {{ $post->title }}
                                </a>
                            </h3>
                            
                            @if($post->excerpt)
                                <p class="text-gray-600 mb-3">{{ $post->excerpt }}</p>
                            @endif

                            <div class="flex items-center space-x-4 text-sm text-gray-500">
                                <span>{{ $post->created_at->format('M j, Y') }}</span>
                                <span class="flex items-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        @if($post->status === 'published')
                                            bg-green-100 text-green-800
                                        @elseif($post->pending_approval)
                                            bg-yellow-100 text-yellow-800
                                        @else
                                            bg-gray-100 text-gray-800
                                        @endif">
                                        @if($post->status === 'published')
                                            Published
                                        @elseif($post->pending_approval)
                                            Pending Approval
                                        @else
                                            Draft
                                        @endif
                                    </span>
                                </span>
                            </div>
                        </div>

                        <div class="flex items-center space-x-2 ml-4">
                            @if($post->status === 'draft' && !$post->pending_approval)
                                <a href="{{ route('creator.blogs.edit', $post) }}" 
                                   class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                    Edit
                                </a>
                                <form action="{{ route('creator.blogs.destroy', $post) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="text-red-600 hover:text-red-800 text-sm font-medium"
                                            onclick="return confirm('Are you sure you want to delete this draft?')">
                                        Delete
                                    </button>
                                </form>
                            @elseif($post->pending_approval)
                                <a href="{{ route('creator.blogs.edit', $post) }}" 
                                   class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                    Edit
                                </a>
                            @endif
                            <a href="{{ route('creator.blogs.show', $post) }}" 
                               class="text-gray-600 hover:text-gray-800 text-sm font-medium">
                                View
                            </a>
                        </div>
                    </div>
                </div>
            @empty
                <div class="bg-white rounded-lg shadow-sm border p-12 text-center">
                    <div class="text-gray-400 mb-4">
                        <svg class="mx-auto h-12 w-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                                  d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                        </svg>
                    </div>
                    <h3 class="text-lg font-medium text-gray-900 mb-2">No blog posts yet</h3>
                    <p class="text-gray-600 mb-4">Get started by creating your first blog post.</p>
                    <a href="{{ route('creator.blogs.create') }}" 
                       class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium inline-flex items-center">
                        Create Your First Post
                    </a>
                </div>
            @endforelse
        </div>

        @if($posts->hasPages())
            <div class="mt-8">
                {{ $posts->links() }}
            </div>
        @endif
    </div>
</div>
@endsection