@extends('layouts.app')

@section('title', $post->title)

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-4xl mx-auto">
        <!-- Header -->
        <div class="bg-white rounded-lg shadow-sm border p-6 mb-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">{{ $post->title }}</h1>
                    <div class="flex items-center space-x-4 mt-2 text-sm text-gray-500">
                        <span>Created: {{ $post->created_at->format('M j, Y \a\t g:i A') }}</span>
                        <span class="flex items-center">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                @if($post->status === 'published')
                                    bg-green-100 text-green-800
                                @elseif($post->pending_approval)
                                    bg-yellow-100 text-yellow-800
                                @else
                                    bg-gray-100 text-gray-800
                                @endif">
                                @if($post->status === 'published')
                                    Published
                                @elseif($post->pending_approval)
                                    Pending Approval
                                @else
                                    Draft
                                @endif
                            </span>
                        </span>
                    </div>
                </div>
                <div class="flex items-center space-x-2">
                    @if($post->status === 'draft')
                        <a href="{{ route('creator.blogs.edit', $post) }}" 
                           class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-medium">
                            Edit
                        </a>
                    @endif
                    <a href="{{ route('creator.blogs.index') }}" 
                       class="text-gray-600 hover:text-gray-800 font-medium">
                        ← Back to My Posts
                    </a>
                </div>
            </div>
        </div>

        <!-- Content -->
        <div class="bg-white rounded-lg shadow-sm border overflow-hidden">
            @if($post->featured_image)
                <div class="aspect-video bg-gray-100">
                    <img src="{{ Storage::url($post->featured_image) }}" 
                         alt="{{ $post->title }}"
                         class="w-full h-full object-cover">
                </div>
            @endif

            <div class="p-6">
                @if($post->excerpt)
                    <div class="border-l-4 border-blue-500 pl-4 mb-6">
                        <p class="text-lg text-gray-700 italic">{{ $post->excerpt }}</p>
                    </div>
                @endif

                <div class="prose prose-lg max-w-none">
                    {!! nl2br(e($post->content)) !!}
                </div>
            </div>
        </div>

        @if($post->pending_approval)
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mt-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-yellow-800">
                            Awaiting Approval
                        </h3>
                        <div class="mt-2 text-sm text-yellow-700">
                            <p>This post is pending admin approval. You can still edit it while it's under review.</p>
                        </div>
                    </div>
                </div>
            </div>
        @elseif($post->status === 'published')
            <div class="bg-green-50 border border-green-200 rounded-lg p-4 mt-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-green-800">
                            Published
                        </h3>
                        <div class="mt-2 text-sm text-green-700">
                            <p>This post is live on the platform. <a href="{{ route('posts.show', $post->slug) }}" class="underline hover:text-green-900">View public page</a></p>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection