@extends('layouts.app')

@section('title', 'Elite Gaming Challenge Platform - ' . ($platformSettings['platform_name'] ?? 'Agamec'))

@section('content')
<div class="relative overflow-hidden">
    <!-- 1. Hero Section -->
    <section class="relative min-h-screen flex items-center justify-center bg-gradient-to-br from-black via-gray-900 to-purple-900 overflow-hidden">
        <!-- Animated Background Elements -->
        <div class="absolute inset-0">
            <!-- Gaming particles background -->
            <div class="absolute inset-0 opacity-20">
                @for ($i = 0; $i < 20; $i++)
                    <div class="absolute w-2 h-2 bg-cod-green rounded-full animate-pulse" 
                         style="top: {{ random_int(10, 90) }}%; left: {{ random_int(10, 90) }}%; animation-delay: {{ random_int(0, 3000) }}ms;"></div>
                @endfor
            </div>
            
            <!-- Geometric shapes -->
            <div class="absolute top-20 left-10 w-32 h-32 border-2 border-cod-green/30 rounded-xl rotate-45 animate-spin" style="animation-duration: 20s;"></div>
            <div class="absolute top-40 right-20 w-24 h-24 border-2 border-blue-500/30 rounded-full animate-pulse"></div>
            <div class="absolute bottom-32 left-1/4 w-16 h-16 border-2 border-purple-500/30 rotate-45 animate-bounce" style="animation-duration: 3s;"></div>
            <div class="absolute bottom-20 right-1/3 w-12 h-12 bg-gradient-to-r from-cod-green to-yellow-500 rounded-full animate-ping" style="animation-duration: 4s;"></div>
            
            <!-- Video-like overlay -->
            <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-transparent to-black/60"></div>
        </div>
        
        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <div data-aos="fade-up" data-aos-duration="1000">
                <h1 class="text-6xl md:text-8xl font-gaming font-bold text-white mb-6 leading-tight">
                    <span class="block" data-aos="fade-up" data-aos-delay="200">Welcome to</span>
                    <span class="block text-transparent bg-clip-text bg-gradient-to-r from-cod-green via-yellow-500 to-red-500 animate-pulse" data-aos="fade-up" data-aos-delay="400">{{ $platformSettings['platform_name'] ?? 'Agamec' }}</span>
                </h1>
            </div>
            
            <div data-aos="fade-up" data-aos-delay="600">
                <p class="text-2xl md:text-3xl text-gray-200 mb-4 font-bold">
                    The Ultimate Competitive Gaming Platform
                </p>
            </div>
            
            <div data-aos="fade-up" data-aos-delay="800">
                <p class="text-lg md:text-xl text-gray-300 mb-12 max-w-4xl mx-auto leading-relaxed">
                    Challenge elite players worldwide, compete in high-stakes tournaments, and transform your gaming skills into real rewards on Africa's premier gaming battleground.
                </p>
            </div>
            
            <div class="flex flex-col sm:flex-row gap-6 justify-center items-center" data-aos="fade-up" data-aos-delay="1000">
                @guest
                    <a href="{{ route('register') }}" class="gaming-button text-xl px-12 py-6 text-black font-bold transform hover:scale-110 transition-all duration-300 shadow-2xl">
                        🚀 Join the Elite
                    </a>
                    <a href="{{ route('challenges.index') }}" class="border-2 border-cod-green text-cod-green px-12 py-6 rounded-xl font-bold text-xl hover:bg-cod-green hover:text-black transition-all duration-300 transform hover:scale-110">
                        Browse Challenges
                    </a>
                @else
                    @if(auth()->user()->canCreateChallenges())
                        <a href="{{ route('challenges.create') }}" class="gaming-button text-xl px-12 py-6">
                            ⚔️ Create Challenge
                        </a>
                    @endif
                    <a href="{{ route('tournaments.index') }}" class="border-2 border-cod-green text-cod-green px-12 py-6 rounded-xl font-bold text-xl hover:bg-cod-green hover:text-black transition-all duration-300 transform hover:scale-110">
                        🏆 Join Tournament
                    </a>
                @endguest
            </div>
            
            <!-- Scroll indicator -->
            <div class="absolute bottom-10 left-1/2 transform -translate-x-1/2 animate-bounce" data-aos="fade-up" data-aos-delay="1200">
                <div class="w-6 h-10 border-2 border-cod-green rounded-full flex justify-center">
                    <div class="w-1 h-3 bg-cod-green rounded-full mt-2 animate-pulse"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- 2. Platform Statistics with Gaming Theme -->
    <section class="bg-black py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16" data-aos="fade-up">
                <h2 class="text-5xl font-gaming font-bold text-transparent bg-clip-text bg-gradient-to-r from-cod-green to-yellow-500 mb-4">
                    Platform Dominance
                </h2>
                <p class="text-gray-400 text-xl">Real numbers from real competitions</p>
            </div>
            
            <div class="grid grid-cols-2 md:grid-cols-5 gap-8">
                <div class="text-center transform hover:scale-110 transition-all duration-300" data-aos="fade-up" data-aos-delay="100">
                    <div class="bg-gradient-to-br from-gray-900 to-gray-800 p-8 rounded-2xl border border-cod-green/30 hover:border-cod-green hover:shadow-2xl hover:shadow-cod-green/20">
                        <div class="text-5xl font-gaming font-bold text-cod-green mb-3">{{ number_format($platformStats['total_players']) }}</div>
                        <div class="text-gray-400 font-medium">Elite Players</div>
                    </div>
                </div>
                <div class="text-center transform hover:scale-110 transition-all duration-300" data-aos="fade-up" data-aos-delay="200">
                    <div class="bg-gradient-to-br from-gray-900 to-gray-800 p-8 rounded-2xl border border-purple-500/30 hover:border-purple-500 hover:shadow-2xl hover:shadow-purple-500/20">
                        <div class="text-5xl font-gaming font-bold text-purple-400 mb-3">{{ number_format($platformStats['total_challenges']) }}</div>
                        <div class="text-gray-400 font-medium">Challenges Fought</div>
                    </div>
                </div>
                <div class="text-center transform hover:scale-110 transition-all duration-300" data-aos="fade-up" data-aos-delay="300">
                    <div class="bg-gradient-to-br from-gray-900 to-gray-800 p-8 rounded-2xl border border-blue-500/30 hover:border-blue-500 hover:shadow-2xl hover:shadow-blue-500/20">
                        <div class="text-5xl font-gaming font-bold text-blue-400 mb-3">{{ number_format($platformStats['total_tournaments']) }}</div>
                        <div class="text-gray-400 font-medium">Tournaments Hosted</div>
                    </div>
                </div>
                <div class="text-center transform hover:scale-110 transition-all duration-300" data-aos="fade-up" data-aos-delay="400">
                    <div class="bg-gradient-to-br from-gray-900 to-gray-800 p-8 rounded-2xl border border-green-500/30 hover:border-green-500 hover:shadow-2xl hover:shadow-green-500/20">
                        <div class="text-5xl font-gaming font-bold text-green-400 mb-3">₦{{ number_format($platformStats['total_prize_pool'], 0) }}</div>
                        <div class="text-gray-400 font-medium">Prize Pool Distributed</div>
                    </div>
                </div>
                <div class="text-center transform hover:scale-110 transition-all duration-300" data-aos="fade-up" data-aos-delay="500">
                    <div class="bg-gradient-to-br from-gray-900 to-gray-800 p-8 rounded-2xl border border-red-500/30 hover:border-red-500 hover:shadow-2xl hover:shadow-red-500/20">
                        <div class="text-5xl font-gaming font-bold text-red-400 mb-3">{{ number_format($platformStats['active_competitions']) }}</div>
                        <div class="text-gray-400 font-medium">Live Competitions</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- 3. Features Section -->
    <section class="bg-gradient-to-br from-gray-900 to-black py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16" data-aos="fade-up">
                <h2 class="text-5xl font-gaming font-bold text-white mb-4">
                    Gaming <span class="text-transparent bg-clip-text bg-gradient-to-r from-cod-green to-yellow-500">Features</span>
                </h2>
                <p class="text-gray-400 text-xl">Everything you need to dominate the competition</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Feature 1: 1v1 Challenges -->
                <div class="group" data-aos="fade-up" data-aos-delay="100">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-cod-green transform hover:scale-105 hover:shadow-2xl hover:shadow-cod-green/20 transition-all duration-300">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">⚔️</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-cod-green transition-colors">1v1 Challenges</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Challenge any player worldwide in your favorite games and compete for real money rewards.</p>
                    </div>
                </div>
                
                <!-- Feature 2: Tournaments -->
                <div class="group" data-aos="fade-up" data-aos-delay="200">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-purple-500 transform hover:scale-105 hover:shadow-2xl hover:shadow-purple-500/20 transition-all duration-300">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">🏆</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-purple-400 transition-colors">Tournaments</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Join massive tournaments with huge prize pools and compete against the best players.</p>
                    </div>
                </div>
                
                <!-- Feature 3: Player Rankings -->
                <div class="group" data-aos="fade-up" data-aos-delay="300">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-blue-500 transform hover:scale-105 hover:shadow-2xl hover:shadow-blue-500/20 transition-all duration-300">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">🎯</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-blue-400 transition-colors">Player Rankings</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Climb the leaderboards and establish yourself as a gaming legend.</p>
                    </div>
                </div>
                
                <!-- Feature 4: Secure Payments -->
                <div class="group" data-aos="fade-up" data-aos-delay="400">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-green-500 transform hover:scale-105 hover:shadow-2xl hover:shadow-green-500/20 transition-all duration-300">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">💳</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-green-400 transition-colors">Secure Payments</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Safe and instant transactions with multiple payment methods supported.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- 4. New Platform Features Section -->
    <section class="bg-gradient-to-br from-black via-purple-900 to-black py-20 relative overflow-hidden">
        <!-- Animated background particles -->
        <div class="absolute inset-0">
            @for ($i = 0; $i < 15; $i++)
                <div class="absolute w-3 h-3 bg-purple-400 rounded-full animate-pulse opacity-20" 
                     style="top: {{ random_int(10, 90) }}%; left: {{ random_int(10, 90) }}%; animation-delay: {{ random_int(0, 3000) }}ms;"></div>
            @endfor
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="text-center mb-16" data-aos="fade-up">
                <h2 class="text-5xl font-gaming font-bold text-white mb-4">
                    🚀 <span class="text-transparent bg-clip-text bg-gradient-to-r from-purple-400 to-pink-500">Platform Innovations</span>
                </h2>
                <p class="text-gray-400 text-xl">Cutting-edge features that set us apart</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Mobile-First Experience -->
                <div class="group" data-aos="fade-up" data-aos-delay="100">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-purple-500 transform hover:scale-105 hover:shadow-2xl hover:shadow-purple-500/20 transition-all duration-300 h-full">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">📱</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-purple-400 transition-colors">Mobile-First Design</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Advanced mobile navigation with hamburger menu, bottom navigation bar, and touch-optimized interface for seamless gaming on the go.</p>
                    </div>
                </div>
                
                <!-- Multiple Payment Methods -->
                <div class="group" data-aos="fade-up" data-aos-delay="200">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-green-500 transform hover:scale-105 hover:shadow-2xl hover:shadow-green-500/20 transition-all duration-300 h-full">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">💳</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-green-400 transition-colors">4 Payment Gateways</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Complete integration with Paystack, Flutterwave, PayPal, and Stripe for secure deposits, withdrawals, and instant payouts worldwide.</p>
                    </div>
                </div>
                
                <!-- Smart Forms -->
                <div class="group" data-aos="fade-up" data-aos-delay="300">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-blue-500 transform hover:scale-105 hover:shadow-2xl hover:shadow-blue-500/20 transition-all duration-300 h-full">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">✨</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-blue-400 transition-colors">Floating Label Forms</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Modern form design with floating labels, real-time validation, quick selection buttons, and enhanced user experience across all interactions.</p>
                    </div>
                </div>
                
                <!-- Multi-Channel Notifications -->
                <div class="group" data-aos="fade-up" data-aos-delay="400">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-yellow-500 transform hover:scale-105 hover:shadow-2xl hover:shadow-yellow-500/20 transition-all duration-300 h-full">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">🔔</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-yellow-400 transition-colors">Smart Notifications</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Complete notification system with email (SMTP, SendGrid, Mailgun) and SMS (Termii, Twilio, Nexmo) for tournament invites and updates.</p>
                    </div>
                </div>
                
                <!-- White-Label Platform -->
                <div class="group" data-aos="fade-up" data-aos-delay="500">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-cod-green transform hover:scale-105 hover:shadow-2xl hover:shadow-cod-green/20 transition-all duration-300 h-full">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">🎨</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-cod-green transition-colors">Dynamic Branding</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Complete white-label solution allowing custom platform names, logos, and branding throughout the entire user experience.</p>
                    </div>
                </div>
                
                <!-- Enhanced Security -->
                <div class="group" data-aos="fade-up" data-aos-delay="600">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-red-500 transform hover:scale-105 hover:shadow-2xl hover:shadow-red-500/20 transition-all duration-300 h-full">
                        <div class="text-6xl mb-6 group-hover:animate-pulse">🛡️</div>
                        <h3 class="text-2xl font-bold text-white mb-4 group-hover:text-red-400 transition-colors">Advanced Security</h3>
                        <p class="text-gray-400 group-hover:text-gray-300">Role-based access control with enum-based permissions, secure API endpoints, and comprehensive user verification systems.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- 5. How It Works Section -->
    <section class="bg-black py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16" data-aos="fade-up">
                <h2 class="text-5xl font-gaming font-bold text-white mb-4">
                    How It <span class="text-transparent bg-clip-text bg-gradient-to-r from-cod-green to-yellow-500">Works</span>
                </h2>
                <p class="text-gray-400 text-xl">Your path to gaming glory in 4 simple steps</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8 relative">
                <!-- Connection lines for desktop -->
                <div class="hidden md:block absolute top-1/2 left-0 right-0 h-0.5 bg-gradient-to-r from-cod-green via-purple-500 to-cod-green transform -translate-y-1/2 z-0"></div>
                
                <!-- Step 1 -->
                <div class="relative z-10" data-aos="fade-up" data-aos-delay="100">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-cod-green text-center hover:scale-105 transition-all duration-300">
                        <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center mx-auto mb-6 text-black font-bold text-2xl">1</div>
                        <h3 class="text-xl font-bold text-white mb-4">Post Challenge</h3>
                        <p class="text-gray-400">Create a challenge in your favorite game with your desired wager amount.</p>
                    </div>
                </div>
                
                <!-- Step 2 -->
                <div class="relative z-10" data-aos="fade-up" data-aos-delay="200">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-purple-500 text-center hover:scale-105 transition-all duration-300">
                        <div class="w-16 h-16 bg-purple-500 rounded-full flex items-center justify-center mx-auto mb-6 text-white font-bold text-2xl">2</div>
                        <h3 class="text-xl font-bold text-white mb-4">Get Accepted</h3>
                        <p class="text-gray-400">Wait for skilled players to accept your challenge and prepare for battle.</p>
                    </div>
                </div>
                
                <!-- Step 3 -->
                <div class="relative z-10" data-aos="fade-up" data-aos-delay="300">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-blue-500 text-center hover:scale-105 transition-all duration-300">
                        <div class="w-16 h-16 bg-blue-500 rounded-full flex items-center justify-center mx-auto mb-6 text-white font-bold text-2xl">3</div>
                        <h3 class="text-xl font-bold text-white mb-4">Play & Win</h3>
                        <p class="text-gray-400">Compete in your game and prove your skills against worthy opponents.</p>
                    </div>
                </div>
                
                <!-- Step 4 -->
                <div class="relative z-10" data-aos="fade-up" data-aos-delay="400">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-green-500 text-center hover:scale-105 transition-all duration-300">
                        <div class="w-16 h-16 bg-green-500 rounded-full flex items-center justify-center mx-auto mb-6 text-white font-bold text-2xl">4</div>
                        <h3 class="text-xl font-bold text-white mb-4">Get Rewarded</h3>
                        <p class="text-gray-400">Win the challenge and earn real money rewards instantly to your wallet.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- 5. Tournaments Spotlight -->
    @if($featuredTournaments && $featuredTournaments->count() > 0)
        <section class="bg-gradient-to-br from-purple-900 to-black py-20">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h2 class="text-5xl font-gaming font-bold text-white mb-4">
                        🏆 <span class="text-transparent bg-clip-text bg-gradient-to-r from-purple-400 to-pink-500">Elite Tournaments</span>
                    </h2>
                    <p class="text-gray-400 text-xl">High-stakes competitions with massive prize pools</p>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    @foreach($featuredTournaments as $index => $tournament)
                        <div class="group transform hover:scale-105 transition-all duration-300" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="bg-gradient-to-br from-gray-800 to-gray-900 rounded-2xl border border-gray-700 hover:border-purple-500 hover:shadow-2xl hover:shadow-purple-500/20 overflow-hidden">
                                <!-- Tournament Header -->
                                <div class="bg-gradient-to-r from-purple-600 to-purple-800 p-4">
                                    <div class="flex items-center justify-between">
                                        <span class="text-white font-gaming text-lg">{{ $tournament->game->name }}</span>
                                        <span class="bg-white text-purple-800 px-3 py-1 rounded-full text-xs font-bold">{{ ucfirst($tournament->status) }}</span>
                                    </div>
                                </div>
                                
                                <div class="p-6">
                                    <h3 class="text-xl font-bold text-white mb-4 group-hover:text-purple-400 transition-colors">{{ $tournament->title }}</h3>
                                    
                                    <div class="space-y-3 mb-6">
                                        <div class="flex justify-between text-sm">
                                            <span class="text-gray-400">Entry Fee:</span>
                                            <span class="text-green-400">₦{{ number_format($tournament->entry_fee) }}</span>
                                        </div>
                                        <div class="flex justify-between text-sm">
                                            <span class="text-gray-400">Prize Pool:</span>
                                            <span class="text-yellow-400 font-bold">₦{{ number_format($tournament->prize_pool ?? ($tournament->entry_fee * $tournament->participants->count() * 0.95)) }}</span>
                                        </div>
                                        <div class="flex justify-between text-sm">
                                            <span class="text-gray-400">Participants:</span>
                                            <span class="text-gray-300">{{ $tournament->participants->count() }} players</span>
                                        </div>
                                        <div class="flex justify-between text-sm">
                                            <span class="text-gray-400">Starts:</span>
                                            <span class="text-gray-300">{{ $tournament->starts_at?->format('M j, g:i A') ?? 'TBD' }}</span>
                                        </div>
                                    </div>
                                    
                                    <a href="{{ route('tournaments.show', $tournament) }}" class="block w-full bg-gradient-to-r from-purple-600 to-purple-700 hover:from-purple-500 hover:to-purple-600 text-white text-center py-3 rounded-lg font-bold transition-all duration-300 transform hover:scale-105">
                                        Join Tournament
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- 6. Player Rankings / Leaderboard -->
    <section class="bg-black py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16" data-aos="fade-up">
                <h2 class="text-5xl font-gaming font-bold text-white mb-4">
                    🎯 Top <span class="text-transparent bg-clip-text bg-gradient-to-r from-yellow-400 to-red-500">Players</span>
                </h2>
                <p class="text-gray-400 text-xl">The elite gamers dominating our platform</p>
            </div>
            
            <div class="max-w-4xl mx-auto">
                @if($topPlayers && $topPlayers->count() > 0)
                    @foreach($topPlayers->take(5) as $index => $player)
                        <div class="mb-6" data-aos="slide-right" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="bg-gradient-to-r from-gray-800 to-gray-900 rounded-2xl border border-gray-700 hover:border-yellow-500 p-6 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl hover:shadow-yellow-500/20">
                                <div class="flex items-center space-x-6">
                                    <!-- Rank -->
                                    <div class="flex-shrink-0">
                                        @if($index === 0)
                                            <div class="w-16 h-16 bg-gradient-to-br from-yellow-400 to-yellow-600 rounded-full flex items-center justify-center text-black font-bold text-xl">
                                                👑
                                            </div>
                                        @elseif($index === 1)
                                            <div class="w-16 h-16 bg-gradient-to-br from-gray-300 to-gray-500 rounded-full flex items-center justify-center text-black font-bold text-xl">
                                                🥈
                                            </div>
                                        @elseif($index === 2)
                                            <div class="w-16 h-16 bg-gradient-to-br from-orange-400 to-orange-600 rounded-full flex items-center justify-center text-black font-bold text-xl">
                                                🥉
                                            </div>
                                        @else
                                            <div class="w-16 h-16 bg-gradient-to-br from-gray-600 to-gray-800 rounded-full flex items-center justify-center text-white font-bold text-xl">
                                                {{ $index + 1 }}
                                            </div>
                                        @endif
                                    </div>
                                    
                                    <!-- Player Avatar -->
                                    <div class="flex-shrink-0">
                                        <div class="w-12 h-12 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-full flex items-center justify-center">
                                            <span class="text-black font-bold">{{ substr($player->username, 0, 1) }}</span>
                                        </div>
                                    </div>
                                    
                                    <!-- Player Info -->
                                    <div class="flex-1">
                                        <h3 class="text-lg font-bold text-white">{{ $player->username }}</h3>
                                        <p class="text-gray-400 text-sm">Level {{ $player->level }} • {{ $player->role->getDisplayName() }}</p>
                                    </div>
                                    
                                    <!-- XP -->
                                    <div class="text-right">
                                        <div class="text-2xl font-bold text-yellow-400">{{ number_format($player->xp) }}</div>
                                        <div class="text-gray-400 text-sm">XP</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="text-center py-12" data-aos="fade-up">
                        <div class="text-6xl mb-4">🎮</div>
                        <p class="text-gray-400 text-lg">Leaderboard coming soon! Be the first to claim the top spot.</p>
                    </div>
                @endif
            </div>
        </section>
    </section>

    <!-- 7. Testimonials Section -->
    <section class="bg-gradient-to-br from-blue-900 to-black py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16" data-aos="fade-up">
                <h2 class="text-5xl font-gaming font-bold text-white mb-4">
                    🗣️ <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-cyan-500">Player Reviews</span>
                </h2>
                <p class="text-gray-400 text-xl">What elite gamers say about Agamec</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Testimonial 1 -->
                <div class="group" data-aos="fade-up" data-aos-delay="100">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-blue-500 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl hover:shadow-blue-500/20">
                        <div class="flex items-center mb-6">
                            <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-full flex items-center justify-center mr-4">
                                <span class="text-white font-bold">⭐</span>
                            </div>
                            <div>
                                <h4 class="text-white font-bold">ProGamer2024</h4>
                                <p class="text-gray-400 text-sm">Level 15 Player</p>
                            </div>
                        </div>
                        <p class="text-gray-300 italic">"{{ $platformSettings['platform_name'] ?? 'Agamec' }} transformed my gaming hobby into a real income stream. The mobile interface and instant notifications make competing so convenient!"</p>
                        <div class="flex mt-4">
                            @for($i = 0; $i < 5; $i++)
                                <span class="text-yellow-400">⭐</span>
                            @endfor
                        </div>
                    </div>
                </div>
                
                <!-- Testimonial 2 -->
                <div class="group" data-aos="fade-up" data-aos-delay="200">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-green-500 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl hover:shadow-green-500/20">
                        <div class="flex items-center mb-6">
                            <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-teal-500 rounded-full flex items-center justify-center mr-4">
                                <span class="text-white font-bold">🏆</span>
                            </div>
                            <div>
                                <h4 class="text-white font-bold">EliteChampion</h4>
                                <p class="text-gray-400 text-sm">Tournament Winner</p>
                            </div>
                        </div>
                        <p class="text-gray-300 italic">"Won my first tournament and got paid through PayPal instantly! The floating label forms and mobile experience are amazing. Made ₦50,000!"</p>
                        <div class="flex mt-4">
                            @for($i = 0; $i < 5; $i++)
                                <span class="text-yellow-400">⭐</span>
                            @endfor
                        </div>
                    </div>
                </div>
                
                <!-- Testimonial 3 -->
                <div class="group" data-aos="fade-up" data-aos-delay="300">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-purple-500 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl hover:shadow-purple-500/20">
                        <div class="flex items-center mb-6">
                            <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-500 rounded-full flex items-center justify-center mr-4">
                                <span class="text-white font-bold">⚔️</span>
                            </div>
                            <div>
                                <h4 class="text-white font-bold">GameMaster99</h4>
                                <p class="text-gray-400 text-sm">Highest Level Player</p>
                            </div>
                        </div>
                        <p class="text-gray-300 italic">"Best gaming platform in Africa! Fair matches, instant payouts via 4 payment methods, and the mobile app experience is unmatched."</p>
                        <div class="flex mt-4">
                            @for($i = 0; $i < 5; $i++)
                                <span class="text-yellow-400">⭐</span>
                            @endfor
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- 8. Membership Levels -->
    <section class="bg-black py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16" data-aos="fade-up">
                <h2 class="text-5xl font-gaming font-bold text-white mb-4">
                    🎖️ <span class="text-transparent bg-clip-text bg-gradient-to-r from-cod-green to-yellow-500">Membership Levels</span>
                </h2>
                <p class="text-gray-400 text-xl">Choose your path to gaming supremacy</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <!-- Basic Level -->
                <div class="group" data-aos="fade-up" data-aos-delay="100">
                    <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-gray-500 transform hover:scale-105 transition-all duration-300 h-full">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-gradient-to-br from-gray-500 to-gray-700 rounded-full flex items-center justify-center mx-auto mb-6">
                                <span class="text-white font-bold text-xl">🥉</span>
                            </div>
                            <h3 class="text-2xl font-bold text-white mb-4">Basic</h3>
                            <p class="text-gray-400 mb-6">New players starting their journey</p>
                            <div class="space-y-3 text-sm">
                                <div class="flex items-center justify-between">
                                    <span class="text-gray-400">Max Challenge Amount:</span>
                                    <span class="text-gray-300">₦500</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-gray-400">Tournaments:</span>
                                    <span class="text-red-400">✗</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-gray-400">Requirements:</span>
                                    <span class="text-gray-300">Sign up</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Level 1 -->
                <div class="group" data-aos="fade-up" data-aos-delay="200">
                    <div class="bg-gradient-to-br from-blue-800 to-blue-900 p-8 rounded-2xl border border-blue-500 hover:border-blue-400 transform hover:scale-105 transition-all duration-300 h-full hover:shadow-2xl hover:shadow-blue-500/20">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-700 rounded-full flex items-center justify-center mx-auto mb-6">
                                <span class="text-white font-bold text-xl">🥈</span>
                            </div>
                            <h3 class="text-2xl font-bold text-white mb-4">Level 1</h3>
                            <p class="text-gray-300 mb-6">Experienced competitors</p>
                            <div class="space-y-3 text-sm">
                                <div class="flex items-center justify-between">
                                    <span class="text-gray-400">Max Challenge Amount:</span>
                                    <span class="text-blue-400">₦20,000</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-gray-400">Tournaments:</span>
                                    <span class="text-red-400">✗</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-gray-400">Requirements:</span>
                                    <span class="text-gray-300">10 wins</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Level 2 -->
                <div class="group" data-aos="fade-up" data-aos-delay="300">
                    <div class="bg-gradient-to-br from-purple-800 to-purple-900 p-8 rounded-2xl border border-purple-500 hover:border-purple-400 transform hover:scale-105 transition-all duration-300 h-full hover:shadow-2xl hover:shadow-purple-500/20">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-gradient-to-br from-purple-500 to-purple-700 rounded-full flex items-center justify-center mx-auto mb-6">
                                <span class="text-white font-bold text-xl">🥇</span>
                            </div>
                            <h3 class="text-2xl font-bold text-white mb-4">Level 2</h3>
                            <p class="text-gray-300 mb-6">Professional gamers</p>
                            <div class="space-y-3 text-sm">
                                <div class="flex items-center justify-between">
                                    <span class="text-gray-400">Max Challenge Amount:</span>
                                    <span class="text-purple-400">₦200,000</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-gray-400">Tournaments:</span>
                                    <span class="text-red-400">✗</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-gray-400">Requirements:</span>
                                    <span class="text-gray-300">50 wins</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Highest/Creator -->
                <div class="group" data-aos="fade-up" data-aos-delay="400">
                    <div class="bg-gradient-to-br from-cod-green to-yellow-600 p-8 rounded-2xl border border-cod-green hover:border-yellow-500 transform hover:scale-105 transition-all duration-300 h-full hover:shadow-2xl hover:shadow-cod-green/20">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-gradient-to-br from-yellow-400 to-cod-green rounded-full flex items-center justify-center mx-auto mb-6">
                                <span class="text-black font-bold text-xl">👑</span>
                            </div>
                            <h3 class="text-2xl font-bold text-black mb-4">Elite</h3>
                            <p class="text-black/80 mb-6">Gaming legends and creators</p>
                            <div class="space-y-3 text-sm">
                                <div class="flex items-center justify-between">
                                    <span class="text-black/70">Max Challenge Amount:</span>
                                    <span class="text-black font-bold">Unlimited</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-black/70">Tournaments:</span>
                                    <span class="text-green-700">✓</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <span class="text-black/70">Requirements:</span>
                                    <span class="text-black">Invitation</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- 9. Popular Games -->
    @if($popularGames && $popularGames->count() > 0)
        <section class="bg-gradient-to-br from-gray-900 to-black py-20">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16" data-aos="fade-up">
                    <h2 class="text-5xl font-gaming font-bold text-white mb-4">
                        🎮 <span class="text-transparent bg-clip-text bg-gradient-to-r from-cod-green to-blue-500">Featured Games</span>
                    </h2>
                    <p class="text-gray-400 text-xl">Most popular competitive titles on our platform</p>
                </div>
                
                <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
                    @foreach($popularGames as $index => $game)
                        <div class="group transform hover:scale-110 transition-all duration-300" data-aos="zoom-in" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="bg-gradient-to-br from-gray-800 to-gray-900 p-8 rounded-2xl border border-gray-700 hover:border-cod-green text-center hover:shadow-2xl hover:shadow-cod-green/20">
                                <div class="text-6xl mb-6 group-hover:animate-bounce">🎮</div>
                                <h3 class="text-lg font-bold text-white mb-3 group-hover:text-cod-green transition-colors">{{ $game->name }}</h3>
                                <div class="text-sm text-gray-400 mb-3">{{ $game->platform }}</div>
                                <div class="text-cod-green font-bold">{{ $game->challenges_count + $game->tournaments_count }} Active</div>
                                <div class="mt-4 h-2 bg-gray-700 rounded-full overflow-hidden">
                                    <div class="h-full bg-gradient-to-r from-cod-green to-yellow-500 transition-all duration-1000 group-hover:w-full" style="width: {{ min(($game->challenges_count + $game->tournaments_count) * 10, 100) }}%"></div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- 10. Recent Activity & News -->
    <section class="bg-black py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
                <!-- Recent Big Wins -->
                @if($recentBigWins && $recentBigWins->count() > 0)
                    <div data-aos="fade-right">
                        <h3 class="text-3xl font-gaming font-bold text-transparent bg-clip-text bg-gradient-to-r from-cod-green to-yellow-500 mb-8">💰 Recent Big Wins</h3>
                        <div class="space-y-6">
                            @foreach($recentBigWins as $index => $win)
                                <div class="bg-gradient-to-r from-gray-800 to-gray-900 rounded-2xl border border-gray-700 hover:border-green-500 p-6 transform hover:scale-105 transition-all duration-300" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                                    <div class="flex items-center space-x-4">
                                        <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-green-700 rounded-full flex items-center justify-center flex-shrink-0">
                                            <span class="text-white font-bold text-xl">💰</span>
                                        </div>
                                        <div class="flex-1">
                                            <div class="text-white font-bold text-lg">{{ $win->game->name }} Challenge</div>
                                            <div class="text-gray-400">{{ $win->created_at->diffForHumans() }}</div>
                                        </div>
                                        <div class="text-green-400 font-bold text-xl">₦{{ number_format($win->wager_amount * 2) }}</div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Latest Blog Posts -->
                @if($latestBlogPosts && $latestBlogPosts->count() > 0)
                    <div data-aos="fade-left">
                        <h3 class="text-3xl font-gaming font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-8">📰 Latest News</h3>
                        <div class="space-y-6">
                            @foreach($latestBlogPosts as $index => $post)
                                <div class="bg-gradient-to-r from-gray-800 to-gray-900 rounded-2xl border border-gray-700 hover:border-blue-500 p-6 transform hover:scale-105 transition-all duration-300" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                                    <h4 class="text-lg font-bold text-white mb-3 hover:text-blue-400 transition-colors">{{ $post->title }}</h4>
                                    <p class="text-gray-400 text-sm mb-4">{{ $post->excerpt }}</p>
                                    <div class="flex justify-between items-center">
                                        <span class="text-xs text-gray-500">{{ $post->published_at->diffForHumans() }}</span>
                                        <a href="{{ route('posts.show', $post->slug) }}" class="text-blue-400 hover:text-blue-300 transition-colors text-sm font-medium flex items-center space-x-1">
                                            <span>Read More</span>
                                            <span>→</span>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </section>
    </section>

    <!-- 12. Call to Action Section -->
    <section class="relative py-32 overflow-hidden">
        <!-- Animated Background -->
        <div class="absolute inset-0 bg-gradient-to-br from-black via-purple-900 to-black">
            <!-- Floating particles -->
            <div class="absolute inset-0">
                @for ($i = 0; $i < 30; $i++)
                    <div class="absolute w-1 h-1 bg-cod-green rounded-full opacity-70 animate-pulse" 
                         style="top: {{ random_int(10, 90) }}%; left: {{ random_int(10, 90) }}%; animation-delay: {{ random_int(0, 5000) }}ms; animation-duration: {{ random_int(2000, 4000) }}ms;"></div>
                @endfor
            </div>
            <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-transparent to-black/80"></div>
        </div>
        
        <div class="relative z-10 max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <div data-aos="zoom-in" data-aos-duration="1000">
                <h2 class="text-6xl md:text-8xl font-gaming font-bold text-white mb-8 leading-tight">
                    Ready to <span class="text-transparent bg-clip-text bg-gradient-to-r from-cod-green via-yellow-500 to-red-500 animate-pulse">Dominate?</span>
                </h2>
            </div>
            
            <div data-aos="fade-up" data-aos-delay="300">
                <p class="text-2xl md:text-3xl text-gray-200 mb-4 font-bold">
                    Join the Elite Gaming Revolution
                </p>
            </div>
            
            <div data-aos="fade-up" data-aos-delay="500">
                <p class="text-xl text-gray-300 mb-12 max-w-4xl mx-auto leading-relaxed">
                    Transform your gaming passion into profit. Compete with the best, win real money, and establish your legacy in the ultimate gaming arena.
                </p>
            </div>
            
            <div class="flex flex-col sm:flex-row gap-8 justify-center items-center" data-aos="fade-up" data-aos-delay="700">
                @guest
                    <a href="{{ route('register') }}" class="gaming-button text-2xl px-16 py-6 text-black font-bold transform hover:scale-110 transition-all duration-300 shadow-2xl hover:shadow-cod-green/50">
                        🚀 Start Your Journey
                    </a>
                    <a href="{{ route('challenges.index') }}" class="border-3 border-cod-green text-cod-green px-16 py-6 rounded-xl font-bold text-2xl hover:bg-cod-green hover:text-black transition-all duration-300 transform hover:scale-110 shadow-2xl hover:shadow-cod-green/50">
                        Browse Challenges
                    </a>
                @else
                    <div class="space-x-8">
                        @if(auth()->user()->canCreateChallenges())
                            <a href="{{ route('challenges.create') }}" class="gaming-button text-2xl px-16 py-6 text-black font-bold transform hover:scale-110 transition-all duration-300 shadow-2xl hover:shadow-cod-green/50">
                                ⚔️ Create Challenge
                            </a>
                        @endif
                        <a href="{{ route('leaderboards.index') }}" class="border-3 border-cod-green text-cod-green px-16 py-6 rounded-xl font-bold text-2xl hover:bg-cod-green hover:text-black transition-all duration-300 transform hover:scale-110 shadow-2xl hover:shadow-cod-green/50">
                            📊 View Leaderboards
                        </a>
                    </div>
                @endauth
            </div>
            
            <!-- Success Stats -->
            <div class="mt-16 grid grid-cols-3 gap-8 max-w-4xl mx-auto" data-aos="fade-up" data-aos-delay="900">
                <div class="text-center">
                    <div class="text-4xl font-bold text-cod-green mb-2">{{ number_format($platformStats['total_players']) }}+</div>
                    <div class="text-gray-400">Elite Players</div>
                </div>
                <div class="text-center">
                    <div class="text-4xl font-bold text-yellow-400 mb-2">₦{{ number_format($platformStats['total_prize_pool']) }}+</div>
                    <div class="text-gray-400">Won by Players</div>
                </div>
                <div class="text-center">
                    <div class="text-4xl font-bold text-purple-400 mb-2">{{ number_format($platformStats['total_challenges']) }}+</div>
                    <div class="text-gray-400">Battles Fought</div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection