@extends('layouts.app')

@section('title', 'Elite Gaming Challenge Platform')

@section('content')
<div class="relative">
    <!-- Enhanced Hero Section -->
    <div class="bg-gaming-gradient relative overflow-hidden">
        <div class="absolute inset-0 bg-black/50"></div>
        <!-- Gaming patterns background -->
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-10 left-10 w-20 h-20 border-2 border-cod-green rounded-xl rotate-45"></div>
            <div class="absolute top-32 right-20 w-16 h-16 border-2 border-cod-green rounded-full"></div>
            <div class="absolute bottom-20 left-1/4 w-12 h-12 border-2 border-cod-green rotate-45"></div>
            <div class="absolute bottom-40 right-1/3 w-8 h-8 bg-cod-green rounded-full"></div>
        </div>
        
        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-32">
            <div class="text-center">
                <h1 class="text-5xl md:text-7xl font-gaming font-bold text-white mb-6 gaming-text-glow">
                    Welcome to <span class="text-cod-green">Agamec</span>
                </h1>
                <p class="text-xl md:text-2xl text-gray-200 mb-4 max-w-4xl mx-auto font-medium">
                    The Ultimate Competitive Gaming Platform
                </p>
                <p class="text-lg text-gray-300 mb-10 max-w-3xl mx-auto">
                    Challenge elite players worldwide, compete in high-stakes tournaments, and transform your gaming skills into real rewards on Africa's premier gaming battleground.
                </p>
                
                @guest
                    <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                        <a href="{{ route('register') }}" class="gaming-button text-lg px-10 py-4 transform hover:scale-105">
                            🚀 Join the Elite
                        </a>
                        <a href="{{ route('login') }}" class="border-2 border-white text-white px-10 py-4 rounded-xl font-bold text-lg hover:bg-white hover:text-black transition-all transform hover:scale-105">
                            Login to Battle
                        </a>
                    </div>
                @else
                    <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                        <a href="{{ route('challenges.create') }}" class="gaming-button text-lg px-10 py-4">
                            ⚔️ Create Challenge
                        </a>
                        <a href="{{ route('tournaments.index') }}" class="btn-secondary px-10 py-4 text-lg">
                            🏆 Join Tournament
                        </a>
                    </div>
                @endguest
            </div>
        </div>
    </div>

    <!-- Platform Statistics -->
    <div class="bg-cod-dark py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-gaming font-bold text-cod-green mb-4">Platform Dominance</h2>
                <p class="text-gray-400 text-lg">Real numbers from real competitions</p>
            </div>
            
            <div class="grid grid-cols-2 md:grid-cols-5 gap-8">
                <div class="gaming-card text-center transform hover:scale-105 transition-all">
                    <div class="text-4xl font-gaming font-bold text-cod-green">{{ number_format($platformStats['total_players']) }}</div>
                    <div class="text-gray-400 mt-2 font-medium">Elite Players</div>
                </div>
                <div class="gaming-card text-center transform hover:scale-105 transition-all">
                    <div class="text-4xl font-gaming font-bold text-cod-green">{{ number_format($platformStats['total_challenges']) }}</div>
                    <div class="text-gray-400 mt-2 font-medium">Challenges Fought</div>
                </div>
                <div class="gaming-card text-center transform hover:scale-105 transition-all">
                    <div class="text-4xl font-gaming font-bold text-cod-green">{{ number_format($platformStats['total_tournaments']) }}</div>
                    <div class="text-gray-400 mt-2 font-medium">Tournaments Hosted</div>
                </div>
                <div class="gaming-card text-center transform hover:scale-105 transition-all">
                    <div class="text-4xl font-gaming font-bold text-cod-green">₦{{ number_format($platformStats['total_prize_pool'], 0) }}</div>
                    <div class="text-gray-400 mt-2 font-medium">Prize Pool Distributed</div>
                </div>
                <div class="gaming-card text-center transform hover:scale-105 transition-all">
                    <div class="text-4xl font-gaming font-bold text-cod-green">{{ number_format($platformStats['active_competitions']) }}</div>
                    <div class="text-gray-400 mt-2 font-medium">Live Competitions</div>
                </div>
            </div>
        </div>
    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- User Dashboard (for authenticated users) -->
    @auth
        @if(($pendingTournamentInvites && $pendingTournamentInvites->count() > 0) || ($pendingChallengeInvites && $pendingChallengeInvites->count() > 0) || ($pendingFriendRequests && $pendingFriendRequests->count() > 0))
        <div class="bg-cod-gray py-16">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                
                <!-- Challenge Invitations -->
                @if($pendingChallengeInvites && $pendingChallengeInvites->count() > 0)
                <div class="mb-8">
                    <h2 class="text-3xl font-gaming font-bold text-center mb-8 text-cod-green">
                        ⚔️ Challenge Invitations
                    </h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @foreach($pendingChallengeInvites as $invite)
                            <div class="bg-cod-dark rounded-lg p-6 border border-orange-500/30 hover:border-orange-500 transition-colors">
                                <!-- Challenge Info -->
                                <div class="mb-4">
                                    <h3 class="text-lg font-semibold text-orange-400 mb-2">{{ $invite->challenge->game->name }} Challenge</h3>
                                    <p class="text-gray-400 text-sm">Best of {{ $invite->challenge->best_of }}</p>
                                    <p class="text-gray-500 text-xs">Invited by {{ $invite->inviter->username }}</p>
                                </div>

                                <!-- Challenge Details -->
                                <div class="space-y-2 mb-4 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-400">Wager:</span>
                                        <span class="text-green-400">₦{{ number_format($invite->challenge->wager_amount) }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-400">Total Prize:</span>
                                        <span class="text-green-400">₦{{ number_format($invite->challenge->wager_amount * 2) }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-400">Created:</span>
                                        <span class="text-gray-300">{{ $invite->challenge->created_at->diffForHumans() }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-400">Expires:</span>
                                        <span class="text-yellow-400">{{ $invite->expires_at?->diffForHumans() ?? 'Soon' }}</span>
                                    </div>
                                </div>

                                @if($invite->message)
                                    <div class="bg-cod-light rounded p-3 mb-4">
                                        <p class="text-gray-300 text-sm italic">"{{ $invite->message }}"</p>
                                    </div>
                                @endif

                                <!-- Action Buttons -->
                                <div class="flex space-x-3">
                                    <form method="POST" action="{{ route('challenges.invite.accept', $invite) }}" class="flex-1">
                                        @csrf
                                        <button type="submit" class="w-full bg-cod-green text-black px-4 py-2 rounded font-semibold hover:bg-green-600 transition-colors">
                                            Accept
                                        </button>
                                    </form>
                                    <form method="POST" action="{{ route('challenges.invite.decline', $invite) }}" class="flex-1">
                                        @csrf
                                        <button type="submit" class="w-full bg-red-600 text-white px-4 py-2 rounded font-semibold hover:bg-red-700 transition-colors">
                                            Decline
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                @endif

                <!-- Tournament Invitations -->
                @if($pendingTournamentInvites && $pendingTournamentInvites->count() > 0)
                <div class="mb-8">
                    <h2 class="text-3xl font-gaming font-bold text-center mb-8 text-cod-green">
                        🎮 Tournament Invitations
                    </h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @foreach($pendingTournamentInvites as $invite)
                            <div class="bg-cod-dark rounded-lg p-6 border border-cod-green/30 hover:border-cod-green transition-colors">
                                <!-- Tournament Info -->
                                <div class="mb-4">
                                    <h3 class="text-lg font-semibold text-cod-green mb-2">{{ $invite->tournament->title }}</h3>
                                    <p class="text-gray-400 text-sm">{{ $invite->tournament->game->name }}</p>
                                    <p class="text-gray-500 text-xs">Invited by {{ $invite->inviter->username }}</p>
                                </div>

                                <!-- Tournament Details -->
                                <div class="space-y-2 mb-4 text-sm">
                                    <div class="flex justify-between">
                                        <span class="text-gray-400">Entry Fee:</span>
                                        <span class="text-green-400">₦{{ number_format($invite->tournament->entry_fee) }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-400">Prize Pool:</span>
                                        <span class="text-green-400">₦{{ number_format($invite->tournament->prize_pool) }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-400">Starts:</span>
                                        <span class="text-gray-300">{{ $invite->tournament->starts_at?->format('M j, g:i A') ?? 'TBD' }}</span>
                                    </div>
                                    <div class="flex justify-between">
                                        <span class="text-gray-400">Expires:</span>
                                        <span class="text-yellow-400">{{ $invite->expires_at?->diffForHumans() ?? 'Soon' }}</span>
                                    </div>
                                </div>

                                @if($invite->message)
                                    <div class="bg-cod-light rounded p-3 mb-4">
                                        <p class="text-gray-300 text-sm italic">"{{ $invite->message }}"</p>
                                    </div>
                                @endif

                                <!-- Action Buttons -->
                                <div class="flex space-x-3">
                                    <form method="POST" action="{{ route('tournaments.invite.accept', $invite) }}" class="flex-1">
                                        @csrf
                                        <button type="submit" class="w-full bg-cod-green text-black px-4 py-2 rounded font-semibold hover:bg-green-600 transition-colors">
                                            Accept
                                        </button>
                                    </form>
                                    <form method="POST" action="{{ route('tournaments.invite.decline', $invite) }}" class="flex-1">
                                        @csrf
                                        <button type="submit" class="w-full bg-red-600 text-white px-4 py-2 rounded font-semibold hover:bg-red-700 transition-colors">
                                            Decline
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                @endif

                <!-- Friend Requests -->
                @if($pendingFriendRequests && $pendingFriendRequests->count() > 0)
                <div>
                    <h2 class="text-3xl font-gaming font-bold text-center mb-8 text-cod-green">
                        👥 Friend Requests
                    </h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                        @foreach($pendingFriendRequests as $request)
                            <div class="bg-cod-dark rounded-lg p-6 border border-blue-500/30 hover:border-blue-500 transition-colors">
                                <div class="flex items-center space-x-3 mb-3">
                                    <div class="w-12 h-12 bg-cod-green rounded-full flex items-center justify-center">
                                        <span class="text-black font-bold">{{ substr($request->user->username, 0, 2) }}</span>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-gray-100">{{ $request->user->username }}</h3>
                                        <p class="text-sm text-gray-400">Level {{ $request->user->level }}</p>
                                    </div>
                                </div>
                                
                                @if($request->message)
                                    <div class="bg-cod-light rounded p-2 mb-3">
                                        <p class="text-gray-300 text-sm italic">"{{ $request->message }}"</p>
                                    </div>
                                @endif
                                
                                <div class="flex space-x-2">
                                    <form method="POST" action="{{ route('friends.accept', $request) }}" class="flex-1">
                                        @csrf
                                        <button type="submit" class="w-full bg-cod-green text-black px-3 py-2 rounded font-semibold hover:bg-green-600 transition-colors text-sm">
                                            Accept
                                        </button>
                                    </form>
                                    <form method="POST" action="{{ route('friends.decline', $request) }}" class="flex-1">
                                        @csrf
                                        <button type="submit" class="w-full bg-red-600 text-white px-3 py-2 rounded font-semibold hover:bg-red-700 transition-colors text-sm">
                                            Decline
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>
        @endif
    @endauth

    <!-- Featured Tournaments -->
    @if($featuredTournaments->count() > 0)
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <h2 class="text-3xl font-gaming font-bold text-center mb-12">Featured Tournaments</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($featuredTournaments as $tournament)
                <div class="bg-cod-gray rounded-lg overflow-hidden hover:gaming-glow transition-all duration-300">
                    <div class="p-6">
                        <div class="flex justify-between items-start mb-4">
                            <h3 class="text-xl font-semibold text-cod-green">{{ $tournament->title }}</h3>
                            <span class="bg-cod-green text-black px-2 py-1 rounded text-xs font-bold">
                                {{ strtoupper($tournament->type) }}
                            </span>
                        </div>
                        <p class="text-gray-400 mb-4">{{ $tournament->game->name }}</p>
                        <div class="flex justify-between items-center mb-4">
                            <span class="text-green-400 font-bold">₦{{ number_format($tournament->prize_pool) }} Prize</span>
                            <span class="text-gray-400">{{ $tournament->participants_count ?? 0 }} players</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-400 text-sm">Entry: ₦{{ number_format($tournament->entry_fee) }}</span>
                            <a href="{{ route('tournaments.show', $tournament) }}" class="bg-cod-green text-black px-4 py-2 rounded hover:bg-green-600 transition-colors">
                                View
                            </a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        <div class="text-center mt-8">
            <a href="{{ route('tournaments.index') }}" class="bg-cod-light text-cod-green px-6 py-3 rounded-lg hover:bg-cod-gray transition-colors">
                View All Tournaments
            </a>
        </div>
    </div>
    @endif

    <!-- Open Challenges -->
    @if($openChallenges->count() > 0)
    <div class="bg-cod-dark py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl font-gaming font-bold text-center mb-12">Open Challenges</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($openChallenges as $challenge)
                    <div class="bg-cod-gray rounded-lg p-6 hover:gaming-glow transition-all duration-300">
                        <div class="flex justify-between items-start mb-4">
                            <h4 class="font-semibold text-cod-green">{{ $challenge->game->name }}</h4>
                            <span class="text-green-400 font-bold">₦{{ number_format($challenge->wager_amount) }}</span>
                        </div>
                        <p class="text-gray-400 text-sm mb-4">by {{ $challenge->creator->username }}</p>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-400 text-xs">Best of {{ $challenge->best_of }}</span>
                            <a href="{{ route('challenges.show', $challenge) }}" class="bg-cod-green text-black px-3 py-1 rounded text-sm hover:bg-green-600 transition-colors">
                                Accept
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="text-center mt-8">
                <a href="{{ route('challenges.index') }}" class="bg-cod-light text-cod-green px-6 py-3 rounded-lg hover:bg-cod-gray transition-colors">
                    View All Challenges
                </a>
            </div>
        </div>
    </div>
    @endif

    <!-- Recent Activity -->
    @if($recentActivity->count() > 0)
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <h2 class="text-3xl font-gaming font-bold text-center mb-12">Recent Activity</h2>
        <div class="space-y-4">
            @foreach($recentActivity as $activity)
                <div class="bg-cod-gray rounded-lg p-4 flex items-center justify-between">
                    <div class="flex items-center space-x-4">
                        <div class="w-2 h-2 bg-cod-green rounded-full"></div>
                        <span class="text-gray-300">
                            <span class="text-cod-green font-semibold">{{ $activity->getWinner()?->username ?? 'Unknown' }}</span>
                            won against
                            <span class="text-gray-400">{{ $activity->result === 'creator_win' ? $activity->accepter->username : $activity->creator->username }}</span>
                            in {{ $activity->game->name }}
                        </span>
                    </div>
                    <div class="text-green-400 font-bold">₦{{ number_format($activity->wager_amount * 2) }}</div>
                </div>
            @endforeach
        </div>
    </div>
    @endif
</div>
@endsection