@extends('layouts.app')

@section('title', 'Friends')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-gaming font-bold text-cod-green">Friends</h1>
        <a href="{{ route('friends.suggestions') }}" class="bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
            Find Friends
        </a>
    </div>

    <!-- Pending Friend Requests -->
    @if($pendingRequests->count() > 0)
    <div class="bg-cod-gray rounded-lg p-6 mb-8">
        <h2 class="text-xl font-semibold text-cod-green mb-4">Pending Friend Requests ({{ $pendingRequests->count() }})</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @foreach($pendingRequests as $request)
                <div class="bg-cod-dark rounded-lg p-4 border border-yellow-500/30">
                    <div class="flex items-center space-x-3 mb-3">
                        <div class="w-12 h-12 bg-cod-green rounded-full flex items-center justify-center">
                            <span class="text-black font-bold">{{ substr($request->user->username, 0, 2) }}</span>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-100">{{ $request->user->username }}</h3>
                            <p class="text-sm text-gray-400">Level {{ $request->user->level }}</p>
                        </div>
                    </div>
                    
                    @if($request->message)
                        <div class="bg-cod-light rounded p-2 mb-3">
                            <p class="text-gray-300 text-sm italic">"{{ $request->message }}"</p>
                        </div>
                    @endif
                    
                    <div class="flex space-x-2">
                        <form method="POST" action="{{ route('friends.accept', $request) }}" class="flex-1">
                            @csrf
                            <button type="submit" class="w-full bg-cod-green text-black px-3 py-2 rounded font-semibold hover:bg-green-600 transition-colors text-sm">
                                Accept
                            </button>
                        </form>
                        <form method="POST" action="{{ route('friends.decline', $request) }}" class="flex-1">
                            @csrf
                            <button type="submit" class="w-full bg-red-600 text-white px-3 py-2 rounded font-semibold hover:bg-red-700 transition-colors text-sm">
                                Decline
                            </button>
                        </form>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Sent Friend Requests -->
    @if($sentRequests->count() > 0)
    <div class="bg-cod-gray rounded-lg p-6 mb-8">
        <h2 class="text-xl font-semibold text-gray-300 mb-4">Sent Requests ({{ $sentRequests->count() }})</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            @foreach($sentRequests as $request)
                <div class="bg-cod-dark rounded-lg p-4 border border-gray-600">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-gray-600 rounded-full flex items-center justify-center">
                            <span class="text-white font-bold text-sm">{{ substr($request->friend->username, 0, 2) }}</span>
                        </div>
                        <div>
                            <h3 class="font-semibold text-gray-100 text-sm">{{ $request->friend->username }}</h3>
                            <p class="text-xs text-gray-400">Pending...</p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Friends List -->
    <div class="bg-cod-gray rounded-lg p-6">
        <h2 class="text-xl font-semibold text-cod-green mb-4">My Friends ({{ $friends->total() }})</h2>
        
        @if($friends->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($friends as $friend)
                    <div class="bg-cod-dark rounded-lg p-6 hover:gaming-glow transition-all duration-300">
                        <div class="flex items-center space-x-4 mb-4">
                            <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center">
                                <span class="text-black font-bold text-lg">{{ substr($friend->username, 0, 2) }}</span>
                            </div>
                            <div>
                                <h3 class="text-lg font-semibold text-cod-green">{{ $friend->username }}</h3>
                                <p class="text-gray-400">Level {{ $friend->level }}</p>
                                <p class="text-gray-500 text-sm">{{ number_format($friend->xp) }} XP</p>
                            </div>
                        </div>

                        <!-- Friend Stats -->
                        <div class="space-y-2 mb-4 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-400">Challenges Won:</span>
                                <span class="text-green-400">{{ $friend->createdChallenges()->where('result', 'creator_win')->count() + $friend->acceptedChallenges()->where('result', 'accepter_win')->count() }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-400">Tournaments:</span>
                                <span class="text-gray-300">{{ $friend->tournamentParticipations()->count() }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-400">Friends since:</span>
                                <span class="text-gray-300">{{ $friend->pivot->created_at->format('M Y') }}</span>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="flex space-x-2">
                            <a href="{{ route('challenges.create') }}?opponent={{ $friend->id }}" class="flex-1 bg-cod-light text-center text-cod-green px-3 py-2 rounded hover:bg-cod-green hover:text-black transition-colors text-sm">
                                Challenge
                            </a>
                            <form method="POST" action="{{ route('friends.remove', $friend) }}" class="flex-1" onsubmit="return confirm('Remove {{ $friend->username }} from friends?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="w-full bg-red-600/20 text-red-400 px-3 py-2 rounded hover:bg-red-600 hover:text-white transition-colors text-sm">
                                    Remove
                                </button>
                            </form>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            @if($friends->hasPages())
                <div class="mt-8">
                    {{ $friends->links() }}
                </div>
            @endif
        @else
            <div class="text-center py-12">
                <div class="text-6xl mb-4">👥</div>
                <h3 class="text-xl font-semibold text-gray-400 mb-2">No Friends Yet</h3>
                <p class="text-gray-500 mb-4">Start playing and add people you've competed with!</p>
                <a href="{{ route('friends.suggestions') }}" class="inline-block bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Find Friends
                </a>
            </div>
        @endif
    </div>
</div>
@endsection