@extends('layouts.app')

@section('title', 'Find Friends')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-3xl font-gaming font-bold text-cod-green">Find Players</h1>
            <p class="text-gray-400 mt-2">
                @auth
                    Add players you've competed with as friends
                @else
                    Discover elite gamers on the platform
                @endauth
            </p>
        </div>
        @auth
            <a href="{{ route('friends.index') }}" class="gaming-button px-6 py-3">
                My Friends
            </a>
        @else
            <a href="{{ route('register') }}" class="gaming-button px-6 py-3">
                Join Community
            </a>
        @endauth
    </div>

    <!-- Friend Suggestions -->
    <div class="gaming-card">
        <h2 class="text-xl font-semibold text-cod-green mb-4">
            @auth
                Players You've Competed With
            @else
                Top Elite Players
            @endauth
        </h2>
        
        @if($suggestions->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($suggestions as $user)
                    <div class="bg-cod-dark rounded-lg p-6 hover:gaming-glow transition-all duration-300">
                        <div class="flex items-center space-x-4 mb-4">
                            <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center">
                                <span class="text-black font-bold text-lg">{{ substr($user->username, 0, 2) }}</span>
                            </div>
                            <div>
                                <h3 class="text-lg font-semibold text-cod-green">{{ $user->username }}</h3>
                                <p class="text-gray-400">Level {{ $user->level }}</p>
                                <p class="text-gray-500 text-sm">{{ number_format($user->xp) }} XP</p>
                            </div>
                        </div>

                        <!-- User Stats -->
                        <div class="space-y-2 mb-4 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-400">Challenges Won:</span>
                                <span class="text-green-400">{{ $user->createdChallenges()->where('result', 'creator_win')->count() + $user->acceptedChallenges()->where('result', 'accepter_win')->count() }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-400">Tournaments:</span>
                                <span class="text-gray-300">{{ $user->tournamentParticipations()->count() }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-400">Win Rate:</span>
                                <span class="text-gray-300">{{ $user->agreement_rate }}%</span>
                            </div>
                        </div>

                        <!-- Mutual Friends -->
                        @auth
                            @php
                                $mutualFriends = auth()->user()->getMutualFriends($user);
                            @endphp
                            @if($mutualFriends->count() > 0)
                                <div class="mb-4 p-3 bg-cod-light rounded">
                                    <p class="text-cod-green text-sm font-semibold mb-1">{{ $mutualFriends->count() }} mutual friend(s)</p>
                                    <p class="text-gray-300 text-xs">{{ $mutualFriends->pluck('username')->take(3)->implode(', ') }}{{ $mutualFriends->count() > 3 ? '...' : '' }}</p>
                                </div>
                            @endif

                            <!-- Send Friend Request Form -->
                            <form method="POST" action="{{ route('friends.send-request', $user) }}" class="space-y-3">
                                @csrf
                                <textarea 
                                    name="message" 
                                    placeholder="Optional message..." 
                                    class="w-full bg-cod-light text-gray-100 border border-cod-green/30 rounded px-3 py-2 text-sm resize-none"
                                    rows="2"
                                ></textarea>
                                <button type="submit" class="w-full bg-cod-green text-black px-4 py-2 rounded font-semibold hover:bg-green-600 transition-colors">
                                    Send Friend Request
                                </button>
                            </form>
                        @else
                            <!-- Guest user call-to-action -->
                            <div class="text-center py-4">
                                <p class="text-gray-400 mb-4">Sign up to connect with this player</p>
                                <a href="{{ route('register') }}" class="gaming-button px-6 py-2">
                                    Join Agamec
                                </a>
                            </div>
                        @endauth
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            @if($suggestions->hasPages())
                <div class="mt-8">
                    {{ $suggestions->links() }}
                </div>
            @endif
        @else
            <div class="text-center py-12">
                <div class="text-6xl mb-4">🎮</div>
                <h3 class="text-xl font-semibold text-gray-400 mb-2">No Suggestions Available</h3>
                <p class="text-gray-500 mb-4">Play some challenges or join tournaments to meet other players!</p>
                <div class="space-x-4">
                    <a href="{{ route('challenges.index') }}" class="inline-block bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                        Browse Challenges
                    </a>
                    <a href="{{ route('tournaments.index') }}" class="inline-block bg-cod-light text-cod-green px-6 py-3 rounded-lg font-semibold hover:bg-cod-green hover:text-black transition-colors">
                        View Tournaments
                    </a>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection