@extends('layouts.app')

@section('title', 'KYC Status')

@section('content')
<div class="kyc-status">
    <div class="container">
        <div class="status-header">
            <a href="{{ route('kyc.index') }}" class="back-link">← Back to KYC</a>
            <h1>🆔 KYC Verification Status</h1>
        </div>

        <div class="status-container">
            @if($user->kyc_status === 'verified')
                <div class="status-card verified">
                    <div class="status-animation">
                        <div class="status-icon">✅</div>
                        <div class="pulse-ring"></div>
                    </div>
                    <h2>Verification Complete!</h2>
                    <p>Your identity has been successfully verified. You now have access to all platform features.</p>
                    
                    <div class="verification-details">
                        <div class="detail-item">
                            <span class="label">Status:</span>
                            <span class="value verified">Verified</span>
                        </div>
                        <div class="detail-item">
                            <span class="label">Verified On:</span>
                            <span class="value">{{ $user->updated_at->format('M d, Y H:i') }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="label">Name:</span>
                            <span class="value">{{ $user->first_name }} {{ $user->last_name }}</span>
                        </div>
                    </div>

                    <div class="benefits-unlocked">
                        <h3>✨ Benefits Unlocked</h3>
                        <div class="benefits-list">
                            <div class="benefit">✅ Withdraw funds to your bank account</div>
                            <div class="benefit">✅ Higher challenge limits</div>
                            <div class="benefit">✅ Priority customer support</div>
                            <div class="benefit">✅ Enhanced account security</div>
                        </div>
                    </div>

                    <div class="action-buttons">
                        <a href="{{ route('wallet.index') }}" class="btn-primary">
                            <i class="icon">💰</i>
                            Go to Wallet
                        </a>
                        <a href="{{ route('dashboard') }}" class="btn-secondary">
                            <i class="icon">🏠</i>
                            Dashboard
                        </a>
                    </div>
                </div>

            @elseif($user->kyc_status === 'pending')
                <div class="status-card pending">
                    <div class="status-animation">
                        <div class="status-icon">⏳</div>
                        <div class="loading-spinner"></div>
                    </div>
                    <h2>Verification in Progress</h2>
                    <p>Your documents are being reviewed by our verification team. This process usually takes 24-48 hours.</p>
                    
                    <div class="verification-details">
                        <div class="detail-item">
                            <span class="label">Status:</span>
                            <span class="value pending">Under Review</span>
                        </div>
                        <div class="detail-item">
                            <span class="label">Submitted:</span>
                            <span class="value">{{ $user->updated_at->format('M d, Y H:i') }}</span>
                        </div>
                        <div class="detail-item">
                            <span class="label">Expected Completion:</span>
                            <span class="value">{{ $user->updated_at->addHours(48)->format('M d, Y H:i') }}</span>
                        </div>
                    </div>

                    <div class="progress-timeline">
                        <div class="timeline-item completed">
                            <div class="timeline-dot"></div>
                            <div class="timeline-content">
                                <h4>Documents Submitted</h4>
                                <p>{{ $user->updated_at->format('M d, Y H:i') }}</p>
                            </div>
                        </div>
                        <div class="timeline-item active">
                            <div class="timeline-dot"></div>
                            <div class="timeline-content">
                                <h4>Under Review</h4>
                                <p>Our team is verifying your documents</p>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-dot"></div>
                            <div class="timeline-content">
                                <h4>Verification Complete</h4>
                                <p>You'll be notified when complete</p>
                            </div>
                        </div>
                    </div>

                    <div class="action-buttons">
                        <button onclick="checkStatus()" class="btn-primary" id="check-status-btn">
                            <i class="icon">🔄</i>
                            Check Status
                        </button>
                        <a href="{{ route('dashboard') }}" class="btn-secondary">
                            <i class="icon">🏠</i>
                            Dashboard
                        </a>
                    </div>
                </div>

            @elseif($user->kyc_status === 'rejected')
                <div class="status-card rejected">
                    <div class="status-animation">
                        <div class="status-icon">❌</div>
                    </div>
                    <h2>Verification Rejected</h2>
                    <p>Unfortunately, your verification was not successful. Please review the reasons below and submit new documents.</p>
                    
                    <div class="verification-details">
                        <div class="detail-item">
                            <span class="label">Status:</span>
                            <span class="value rejected">Rejected</span>
                        </div>
                        <div class="detail-item">
                            <span class="label">Rejected On:</span>
                            <span class="value">{{ $user->updated_at->format('M d, Y H:i') }}</span>
                        </div>
                    </div>

                    <div class="rejection-reasons">
                        <h3>📋 Common Rejection Reasons</h3>
                        <ul class="reasons-list">
                            <li>Blurry or unclear document images</li>
                            <li>Document information doesn't match provided details</li>
                            <li>Expired or invalid identification documents</li>
                            <li>Selfie doesn't match ID document photo</li>
                            <li>Incomplete or missing information</li>
                        </ul>
                    </div>

                    <div class="action-buttons">
                        <a href="{{ route('kyc.index') }}" class="btn-primary">
                            <i class="icon">📄</i>
                            Submit New Documents
                        </a>
                        <a href="{{ route('dashboard') }}" class="btn-secondary">
                            <i class="icon">🏠</i>
                            Dashboard
                        </a>
                    </div>
                </div>

            @else
                <div class="status-card unverified">
                    <div class="status-animation">
                        <div class="status-icon">📄</div>
                    </div>
                    <h2>Verification Not Started</h2>
                    <p>Complete your KYC verification to unlock all platform features and secure your account.</p>
                    
                    <div class="action-buttons">
                        <a href="{{ route('kyc.index') }}" class="btn-primary">
                            <i class="icon">🚀</i>
                            Start Verification
                        </a>
                        <a href="{{ route('dashboard') }}" class="btn-secondary">
                            <i class="icon">🏠</i>
                            Dashboard
                        </a>
                    </div>
                </div>
            @endif
        </div>

        @if($user->kyc_status !== 'verified')
            <div class="help-section">
                <h3>❓ Need Help?</h3>
                <div class="help-cards">
                    <div class="help-card">
                        <div class="help-icon">📞</div>
                        <h4>Contact Support</h4>
                        <p>Get help from our verification team</p>
                        <a href="{{ route('contact-us') }}" class="help-link">Contact Us</a>
                    </div>
                    <div class="help-card">
                        <div class="help-icon">❓</div>
                        <h4>FAQ</h4>
                        <p>Find answers to common questions</p>
                        <a href="{{ route('faq') }}" class="help-link">View FAQ</a>
                    </div>
                    <div class="help-card">
                        <div class="help-icon">📚</div>
                        <h4>Requirements</h4>
                        <p>Learn what documents you need</p>
                        <a href="{{ route('kyc.index') }}" class="help-link">View Requirements</a>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>

<style>
.kyc-status {
    padding: 2rem 0;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    min-height: 100vh;
}

.status-header {
    margin-bottom: 3rem;
}

.back-link {
    color: #ff6600;
    text-decoration: none;
    font-weight: 600;
    margin-bottom: 1rem;
    display: inline-block;
}

.back-link:hover {
    color: #e55a00;
}

.status-header h1 {
    color: #e2e8f0;
    font-size: 2.5rem;
    margin: 0;
}

.status-card {
    background: rgba(255, 255, 255, 0.05);
    border-radius: 20px;
    padding: 3rem;
    text-align: center;
    border: 2px solid;
    margin-bottom: 3rem;
}

.status-card.verified {
    border-color: #22c55e;
    background: rgba(34, 197, 94, 0.05);
}

.status-card.pending {
    border-color: #f59e0b;
    background: rgba(245, 158, 11, 0.05);
}

.status-card.rejected {
    border-color: #ef4444;
    background: rgba(239, 68, 68, 0.05);
}

.status-card.unverified {
    border-color: #6b7280;
    background: rgba(107, 114, 128, 0.05);
}

.status-animation {
    position: relative;
    display: inline-block;
    margin-bottom: 2rem;
}

.status-icon {
    font-size: 5rem;
    position: relative;
    z-index: 2;
}

.pulse-ring {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 120px;
    height: 120px;
    border: 3px solid #22c55e;
    border-radius: 50%;
    animation: pulse 2s infinite;
}

.loading-spinner {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 120px;
    height: 120px;
    border: 3px solid rgba(245, 158, 11, 0.3);
    border-top: 3px solid #f59e0b;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes pulse {
    0% {
        transform: translate(-50%, -50%) scale(0.8);
        opacity: 1;
    }
    100% {
        transform: translate(-50%, -50%) scale(1.4);
        opacity: 0;
    }
}

@keyframes spin {
    0% { transform: translate(-50%, -50%) rotate(0deg); }
    100% { transform: translate(-50%, -50%) rotate(360deg); }
}

.status-card h2 {
    color: #e2e8f0;
    font-size: 2.2rem;
    margin: 0 0 1rem 0;
}

.status-card p {
    color: #94a3b8;
    font-size: 1.2rem;
    margin: 0 0 2rem 0;
    max-width: 600px;
    margin-left: auto;
    margin-right: auto;
}

.verification-details {
    background: rgba(255, 255, 255, 0.05);
    border-radius: 12px;
    padding: 2rem;
    margin: 2rem 0;
    text-align: left;
    max-width: 500px;
    margin-left: auto;
    margin-right: auto;
}

.detail-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.detail-item:last-child {
    border-bottom: none;
}

.label {
    color: #94a3b8;
    font-weight: 600;
}

.value {
    color: #e2e8f0;
    font-weight: 600;
}

.value.verified {
    color: #22c55e;
}

.value.pending {
    color: #f59e0b;
}

.value.rejected {
    color: #ef4444;
}

.benefits-unlocked {
    background: rgba(34, 197, 94, 0.1);
    border: 1px solid #22c55e;
    border-radius: 12px;
    padding: 2rem;
    margin: 2rem 0;
}

.benefits-unlocked h3 {
    color: #22c55e;
    margin: 0 0 1rem 0;
    font-size: 1.3rem;
}

.benefits-list {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    text-align: left;
}

.benefit {
    color: #e2e8f0;
    padding: 0.5rem 0;
    font-weight: 500;
}

.progress-timeline {
    max-width: 400px;
    margin: 2rem auto;
    text-align: left;
}

.timeline-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    margin-bottom: 2rem;
    position: relative;
}

.timeline-item::before {
    content: '';
    position: absolute;
    left: 15px;
    top: 30px;
    width: 2px;
    height: calc(100% + 1rem);
    background: rgba(255, 255, 255, 0.2);
}

.timeline-item:last-child::before {
    display: none;
}

.timeline-dot {
    width: 30px;
    height: 30px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.2);
    border: 3px solid rgba(255, 255, 255, 0.2);
    flex-shrink: 0;
}

.timeline-item.completed .timeline-dot {
    background: #22c55e;
    border-color: #22c55e;
}

.timeline-item.active .timeline-dot {
    background: #f59e0b;
    border-color: #f59e0b;
    animation: pulse-dot 2s infinite;
}

@keyframes pulse-dot {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.1); }
}

.timeline-content h4 {
    color: #e2e8f0;
    margin: 0 0 0.25rem 0;
    font-size: 1rem;
}

.timeline-content p {
    color: #94a3b8;
    margin: 0;
    font-size: 0.9rem;
}

.rejection-reasons {
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid #ef4444;
    border-radius: 12px;
    padding: 2rem;
    margin: 2rem 0;
    text-align: left;
}

.rejection-reasons h3 {
    color: #ef4444;
    margin: 0 0 1rem 0;
    font-size: 1.3rem;
    text-align: center;
}

.reasons-list {
    color: #e2e8f0;
    margin: 0;
    padding-left: 1.5rem;
}

.reasons-list li {
    margin-bottom: 0.5rem;
    line-height: 1.5;
}

.action-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
    margin-top: 2rem;
}

.btn-primary, .btn-secondary {
    padding: 1rem 2rem;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    border: 1px solid;
    cursor: pointer;
    font-size: 1rem;
}

.btn-primary {
    background: rgba(255, 102, 0, 0.2);
    color: #ff6600;
    border-color: #ff6600;
}

.btn-primary:hover {
    background: #ff6600;
    color: #1a1a2e;
    transform: translateY(-2px);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.1);
    color: #e2e8f0;
    border-color: #e2e8f0;
}

.btn-secondary:hover {
    background: #e2e8f0;
    color: #1a1a2e;
    transform: translateY(-2px);
}

.help-section {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 12px;
    padding: 2rem;
}

.help-section h3 {
    color: #ff6600;
    margin: 0 0 2rem 0;
    font-size: 1.5rem;
    text-align: center;
}

.help-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

.help-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    padding: 1.5rem;
    text-align: center;
    transition: all 0.3s ease;
}

.help-card:hover {
    border-color: #ff6600;
    transform: translateY(-2px);
}

.help-icon {
    font-size: 2.5rem;
    margin-bottom: 1rem;
}

.help-card h4 {
    color: #e2e8f0;
    margin: 0 0 0.5rem 0;
    font-size: 1.1rem;
}

.help-card p {
    color: #94a3b8;
    margin: 0 0 1rem 0;
    font-size: 0.9rem;
}

.help-link {
    color: #ff6600;
    text-decoration: none;
    font-weight: 600;
    font-size: 0.9rem;
}

.help-link:hover {
    text-decoration: underline;
}

@media (max-width: 768px) {
    .status-header h1 {
        font-size: 2rem;
    }
    
    .status-card {
        padding: 2rem 1rem;
    }
    
    .status-card h2 {
        font-size: 1.8rem;
    }
    
    .action-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .btn-primary, .btn-secondary {
        width: 100%;
        justify-content: center;
        max-width: 300px;
    }
    
    .benefits-list {
        grid-template-columns: 1fr;
    }
    
    .help-cards {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
async function checkStatus() {
    const button = document.getElementById('check-status-btn');
    const originalText = button.innerHTML;
    
    button.innerHTML = '<i class="icon">⏳</i> Checking...';
    button.disabled = true;
// Cooldown period in milliseconds (e.g., 10 seconds)
const CHECK_STATUS_COOLDOWN = 10000;
let checkStatusCooldownActive = false;

async function checkStatus() {
    const button = document.getElementById('check-status-btn');
    const originalText = button.innerHTML;

    if (checkStatusCooldownActive) {
        // Optionally, show a message or visual feedback
        button.innerHTML = '<i class="icon">⏳</i> Please wait...';
        setTimeout(() => {
            button.innerHTML = originalText;
        }, 1500);
        return;
    }

    checkStatusCooldownActive = true;
    button.innerHTML = '<i class="icon">⏳</i> Checking...';
    button.disabled = true;
    try {
        const response = await fetch('{{ route("kyc.check-status") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        });
        
        const data = await response.json();
        
        if (data.success) {
            if (data.status === 'verified') {
                window.location.reload();
            } else {
                button.innerHTML = '<i class="icon">✅</i> Status Updated';
                setTimeout(() => {
                    button.innerHTML = originalText;
                    button.disabled = false;
                }, 2000);
            }
        } else {
            button.innerHTML = '<i class="icon">❌</i> Check Failed';
            setTimeout(() => {
                button.innerHTML = originalText;
                button.disabled = false;
            }, 2000);
        }
    } catch (error) {
        button.innerHTML = '<i class="icon">❌</i> Error';
        setTimeout(() => {
            button.innerHTML = originalText;
            button.disabled = false;
        }, 2000);
    }
}
</script>
@endsection