<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Agamec') }} - @yield('title', 'Admin Panel')</title>

    <!-- Styles -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <style>
        /* Add smooth scrolling to the html */
        html {
            scroll-behavior: smooth;
        }
        
        /* Admin sidebar styles with enhanced animations */
        .admin-sidebar {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
        }
        .admin-sidebar.collapsed {
            transform: translateX(-100%);
        }
        
        /* Responsive sidebar behavior */
        @media (max-width: 1024px) {
            .admin-sidebar.collapsed {
                transform: translateX(-100%);
            }
            .admin-content.expanded {
                margin-left: 0;
            }
        }
        
        /* Enhanced content area with smooth transitions */
        .admin-content {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            min-height: 100vh;
            overflow-x: auto;
        }
        
        /* Enhanced custom scrollbar for sidebar */
        .custom-scrollbar {
            scrollbar-width: thin;
            scrollbar-color: rgba(101, 255, 149, 0.3) transparent;
        }
        .custom-scrollbar::-webkit-scrollbar {
            width: 6px;
        }
        .custom-scrollbar::-webkit-scrollbar-track {
            background: transparent;
        }
        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: rgba(101, 255, 149, 0.3);
            border-radius: 3px;
        }
        .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: rgba(101, 255, 149, 0.5);
        }
        
        /* Enhanced mega menu items with modern hover effects */
        .mega-menu-item {
            @apply flex items-center px-4 py-3 text-gray-300 hover:text-cod-green hover:bg-cod-gray/50 rounded-lg transition-all duration-300 group relative;
            transform: translateX(0);
            position: relative;
            overflow: hidden;
        }
        .mega-menu-item::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 0;
            background: linear-gradient(90deg, rgba(101, 255, 149, 0.1), transparent);
            transition: width 0.3s ease;
        }
        .mega-menu-item:hover::before {
            width: 100%;
        }
        .mega-menu-item:hover {
            transform: translateX(4px);
            box-shadow: 0 4px 12px rgba(101, 255, 149, 0.2);
            background: rgba(101, 255, 149, 0.08);
        }
        .mega-menu-item.active {
            @apply text-cod-green bg-cod-gray/70;
            border-left: 3px solid #65ff95;
            box-shadow: 0 4px 12px rgba(101, 255, 149, 0.3);
            background: rgba(101, 255, 149, 0.12);
        }
        .mega-menu-item.active::before {
            width: 100%;
            background: linear-gradient(90deg, rgba(101, 255, 149, 0.15), transparent);
        }
        
        /* Enhanced section headers */
        .section-header {
            position: relative;
            padding-left: 12px;
        }
        .section-header::before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 3px;
            height: 16px;
            background: linear-gradient(to bottom, #65ff95, #4ade80);
            border-radius: 2px;
        }
        
        /* Icon enhancements */
        .mega-menu-item svg {
            transition: all 0.3s ease;
        }
        .mega-menu-item:hover svg {
            color: #65ff95;
            transform: scale(1.1);
        }
        .mega-menu-item.active svg {
            color: #65ff95;
            filter: drop-shadow(0 0 4px rgba(101, 255, 149, 0.4));
        }
        
        /* Enhanced submenu styling */
        .mega-menu-submenu {
            @apply ml-6 mt-2 space-y-1;
        }
        .mega-menu-submenu a {
            @apply flex items-center px-3 py-2 text-sm text-gray-400 hover:text-cod-green hover:bg-cod-gray/30 rounded-md transition-all duration-300;
            transform: translateX(0);
        }
        .mega-menu-submenu a:hover {
            transform: translateX(2px);
        }
        .mega-menu-submenu a.active {
            @apply text-cod-green bg-cod-gray/50;
        }
        
        /* Enhanced table scrolling */
        .table-container {
            max-height: 70vh;
            overflow-y: auto;
            scrollbar-width: thin;
            scrollbar-color: #65ff95 #2d3748;
        }
        .table-container::-webkit-scrollbar {
            width: 8px;
        }
        .table-container::-webkit-scrollbar-track {
            background: #2d3748;
            border-radius: 4px;
        }
        .table-container::-webkit-scrollbar-thumb {
            background: #65ff95;
            border-radius: 4px;
        }
        .table-container::-webkit-scrollbar-thumb:hover {
            background: #4ade80;
        }
        
        /* Enhanced page content scrolling */
        .page-content {
            max-height: calc(100vh - 80px);
            overflow-y: auto;
            overflow-x: hidden;
            scrollbar-width: thin;
            scrollbar-color: #65ff95 #2d3748;
        }
        .page-content::-webkit-scrollbar {
            width: 8px;
        }
        .page-content::-webkit-scrollbar-track {
            background: #2d3748;
            border-radius: 4px;
        }
        .page-content::-webkit-scrollbar-thumb {
            background: #65ff95;
            border-radius: 4px;
        }
        .page-content::-webkit-scrollbar-thumb:hover {
            background: #4ade80;
        }
        
        /* Enhanced mobile menu toggle */
        .mobile-menu-toggle {
            transition: all 0.3s ease;
        }
        .mobile-menu-toggle:hover {
            transform: scale(1.1);
        }
        
        /* Enhanced gaming glow effect */
        .gaming-glow {
            box-shadow: 0 0 20px rgba(101, 255, 149, 0.1);
            transition: box-shadow 0.3s ease;
        }
        .gaming-glow:hover {
            box-shadow: 0 0 30px rgba(101, 255, 149, 0.2);
        }
        
        /* Enhanced form elements */
        .input-gaming {
            transition: all 0.3s ease;
        }
        .input-gaming:focus {
            box-shadow: 0 0 15px rgba(101, 255, 149, 0.3);
        }
        
        /* Enhanced buttons */
        .btn-gaming {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }
        .btn-gaming:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(101, 255, 149, 0.3);
        }
        
        /* Mobile responsive improvements */
        @media (max-width: 768px) {
            .admin-sidebar {
                width: 100%;
            }
            .mega-menu-item {
                padding: 12px 16px;
            }
            .table-container {
                max-height: 60vh;
            }
        }
        
        /* Enhanced loading states */
        .loading-overlay {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(4px);
            transition: all 0.3s ease;
        }
    </style>
</head>
<body class="bg-cod-darker text-gray-100 overflow-x-hidden">
    <!-- Admin Layout with Left Sidebar -->
    <div class="flex h-screen bg-gradient-to-br from-slate-950 via-purple-950 to-slate-900">
        
        <!-- Left Sidebar Navigation -->
        <div class="admin-sidebar fixed inset-y-0 left-0 z-50 w-80 bg-cod-dark/95 backdrop-blur-md border-r border-cod-green/20 transform transition-transform duration-300 ease-in-out lg:translate-x-0 -translate-x-full" id="adminSidebar">
            <!-- Sidebar Header -->
            <div class="flex items-center justify-between p-6 border-b border-cod-green/20">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-xl flex items-center justify-center">
                        <span class="text-lg font-bold text-black">A</span>
                    </div>
                    <div>
                        <h1 class="text-xl font-gaming font-bold text-cod-green">Admin Panel</h1>
                        <p class="text-xs text-gray-400">Advanced Control Center</p>
                    </div>
                </div>
                <button id="sidebarToggle" class="lg:hidden text-gray-300 hover:text-cod-green transition-colors">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>

            <!-- Admin User Info -->
            <div class="p-4 border-b border-cod-green/20">
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-gradient-to-br from-red-500 to-red-600 rounded-xl flex items-center justify-center border-2 border-red-400/50">
                        <span class="text-lg font-bold text-white">{{ auth()->check() ? substr(auth()->user()->username, 0, 1) : 'A' }}</span>
                    </div>
                    <div>
                        <div class="text-sm font-medium text-gray-100">{{ auth()->check() ? auth()->user()->username : 'Admin User' }}</div>
                        <div class="flex items-center space-x-2">
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                🛡️ Administrator
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Navigation Menu -->
            <nav class="flex-1 overflow-y-auto p-4 custom-scrollbar">
                <div class="space-y-1">
                    <!-- Main Dashboard -->
                    <div class="mb-6">
                        <a href="{{ route('admin.dashboard') }}" class="mega-menu-item {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                            <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                            <span class="font-medium">Dashboard</span>
                        </a>
                    </div>

                    <!-- User Management Section -->
                    <div class="mb-6">
                        <div class="text-xs font-bold text-cod-green uppercase tracking-wider mb-3 px-1 flex items-center">
                            <svg class="w-3 h-3 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0z"></path>
                            </svg>
                            User Management
                        </div>
                        <div class="space-y-1">
                            <a href="{{ route('admin.users.index') }}" class="mega-menu-item {{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                                <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <span>All Users</span>
                                @if(request()->routeIs('admin.users.*'))
                                <div class="w-2 h-2 bg-cod-green rounded-full ml-auto"></div>
                                @endif
                            </a>
                        </div>
                    </div>

                    <!-- Platform Management Section -->
                    <div class="mb-6">
                        <div class="text-xs font-bold text-cod-green uppercase tracking-wider mb-3 px-1 flex items-center">
                            <svg class="w-3 h-3 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                            </svg>
                            Gaming Platform
                        </div>
                        <div class="space-y-1">
                            <!-- Games -->
                            <a href="{{ route('admin.games.index') }}" class="mega-menu-item {{ request()->routeIs('admin.games.*') ? 'active' : '' }}">
                                <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                                </svg>
                                <span>Games</span>
                                @if(request()->routeIs('admin.games.*'))
                                <div class="w-2 h-2 bg-cod-green rounded-full ml-auto"></div>
                                @endif
                            </a>

                            <!-- Challenges -->
                            <a href="{{ route('admin.challenges.index') }}" class="mega-menu-item {{ request()->routeIs('admin.challenges.*') ? 'active' : '' }}">
                                <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span>Challenges</span>
                                @if(request()->routeIs('admin.challenges.*'))
                                <div class="w-2 h-2 bg-cod-green rounded-full ml-auto"></div>
                                @endif
                            </a>

                            <!-- Tournaments -->
                            <a href="{{ route('admin.tournaments.index') }}" class="mega-menu-item {{ request()->routeIs('admin.tournaments.*') ? 'active' : '' }}">
                                <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                                <span>Tournaments</span>
                                @if(request()->routeIs('admin.tournaments.*'))
                                <div class="w-2 h-2 bg-cod-green rounded-full ml-auto"></div>
                                @endif
                            </a>

                            <!-- Disputes -->
                            <a href="{{ route('admin.disputes.index') }}" class="mega-menu-item {{ request()->routeIs('admin.disputes.*') ? 'active' : '' }}">
                                <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                                </svg>
                                <span>Disputes</span>
                                @if(request()->routeIs('admin.disputes.*'))
                                <div class="w-2 h-2 bg-cod-green rounded-full ml-auto"></div>
                                @endif
                            </a>
                        </div>
                    </div>

                    <!-- Content Management Section -->
                    <div class="mb-6">
                        <div class="text-xs font-bold text-cod-green uppercase tracking-wider mb-3 px-1 flex items-center">
                            <svg class="w-3 h-3 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>
                            </svg>
                            Content & Media
                        </div>
                        <div class="space-y-1">
                            <!-- Posts/News -->
                            <a href="{{ route('admin.posts.index') }}" class="mega-menu-item {{ request()->routeIs('admin.posts.*') ? 'active' : '' }}">
                                <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"></path>
                                </svg>
                                <span>Posts & News</span>
                                @if(request()->routeIs('admin.posts.*'))
                                <div class="w-2 h-2 bg-cod-green rounded-full ml-auto"></div>
                                @endif
                            </a>

                            <!-- API Notifications -->
                            <a href="{{ route('admin.notifications.index') }}" class="mega-menu-item {{ request()->routeIs('admin.notifications.*') ? 'active' : '' }}">
                                <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-5 5v-5zM11 19H6a2 2 0 01-2-2V7a2 2 0 012-2h8a2 2 0 012 2v4m-5 9v-4a1 1 0 011-1h4"></path>
                                </svg>
                                <span>API Notifications</span>
                                @if(request()->routeIs('admin.notifications.*'))
                                <div class="w-2 h-2 bg-cod-green rounded-full ml-auto"></div>
                                @endif
                            </a>

                            <!-- Popup Messages -->
                            <a href="{{ route('admin.popup-notifications.index') }}" class="mega-menu-item {{ request()->routeIs('admin.popup-notifications.*') ? 'active' : '' }}">
                                <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"></path>
                                </svg>
                                <span>Popup Messages</span>
                                @if(request()->routeIs('admin.popup-notifications.*'))
                                <div class="w-2 h-2 bg-cod-green rounded-full ml-auto"></div>
                                @endif
                            </a>
                        </div>
                    </div>

                    <!-- System Administration Section -->
                    <div class="mb-4">
                        <div class="text-xs font-bold text-cod-green uppercase tracking-wider mb-3 px-1 flex items-center">
                            <svg class="w-3 h-3 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            System & Settings
                        </div>
                        <div class="space-y-1">
                            <!-- Settings -->
                            <a href="{{ route('admin.settings.index') }}" class="mega-menu-item {{ request()->routeIs('admin.settings.*') ? 'active' : '' }}">
                                <svg class="w-5 h-5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                <span>Settings</span>
                                @if(request()->routeIs('admin.settings.*'))
                                <div class="w-2 h-2 bg-cod-green rounded-full ml-auto"></div>
                                @endif
                            </a>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- Sidebar Footer -->
            <div class="p-4 border-t border-cod-green/20">
                <a href="{{ route('home') }}" class="flex items-center justify-center w-full px-4 py-3 text-gray-300 hover:text-cod-green hover:bg-cod-gray/50 rounded-lg transition-all duration-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    <span>Back to Site</span>
                </a>
            </div>
        </div>

        <!-- Main Content Area -->
        <div class="admin-content flex-1 flex flex-col lg:ml-80" id="adminContent">
            <!-- Top Header Bar -->
            <header class="bg-cod-dark/95 backdrop-blur-md border-b border-cod-green/20 px-6 py-4 flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <!-- Mobile menu toggle -->
                    <button id="mobileMenuToggle" class="lg:hidden mobile-menu-toggle text-gray-300 hover:text-cod-green transition-colors">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                    
                    <div>
                        <h1 class="text-2xl font-gaming font-bold text-cod-green">@yield('page-title', 'Admin Panel')</h1>
                        <p class="text-sm text-gray-400">@yield('page-subtitle', 'Administrative Control Center')</p>
                    </div>
                </div>

                <div class="flex items-center space-x-4">
                    <!-- Quick Stats -->
                    <div class="hidden md:flex items-center space-x-4 text-sm">
                        <div class="text-center">
                            <div class="text-xs text-gray-400">Total Users</div>
                            <div class="font-bold text-cod-green">{{ number_format($adminHeaderStats['total_users'] ?? 0) }}</div>
                        </div>
                        <div class="text-center">
                            <div class="text-xs text-gray-400">Active Challenges</div>
                            <div class="font-bold text-cod-green">{{ number_format($adminHeaderStats['active_challenges'] ?? 0) }}</div>
                        </div>
                    </div>

                    <!-- User Menu -->
                    <div class="relative group">
                        <button class="flex items-center space-x-2 text-gray-300 hover:text-cod-green px-3 py-2 rounded-xl transition-colors">
                            <div class="w-8 h-8 bg-gradient-to-br from-red-500 to-red-600 rounded-lg flex items-center justify-center">
                                <span class="text-sm font-bold text-white">{{ auth()->check() ? substr(auth()->user()->username, 0, 1) : 'A' }}</span>
                            </div>
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        
                        <div class="absolute right-0 mt-2 w-48 bg-cod-gray/95 backdrop-blur-md rounded-xl shadow-xl gaming-glow opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                            <div class="p-3">
                                <div class="px-3 py-2 border-b border-cod-light mb-2">
                                    <div class="text-sm font-medium text-gray-100">{{ auth()->check() ? auth()->user()->username : 'Admin User' }}</div>
                                    <div class="text-xs text-red-400">Administrator</div>
                                </div>
                                
                                <a href="{{ route('profile.index') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                    👤 My Profile
                                </a>
                                
                                <div class="border-t border-cod-light my-2"></div>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="block w-full text-left py-2 px-3 text-sm text-red-400 hover:text-red-300 hover:bg-cod-light rounded-lg transition-colors">
                                        🚪 Logout
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 page-content bg-gradient-to-br from-slate-950 via-purple-950 to-slate-900">
                @yield('content')
            </main>
        </div>
    </div>

    <!-- Mobile Overlay -->
    <div id="mobileOverlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden hidden"></div>

        <script>
        // Mobile menu functionality
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuToggle = document.getElementById('mobileMenuToggle');
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('adminSidebar');
            const content = document.getElementById('adminContent');
            const overlay = document.getElementById('mobileOverlay');

            function toggleMobileMenu() {
                if (window.innerWidth < 1024) {
                    sidebar.classList.toggle('-translate-x-full');
                    overlay.classList.toggle('hidden');
                }
            }

            mobileMenuToggle?.addEventListener('click', toggleMobileMenu);
            sidebarToggle?.addEventListener('click', toggleMobileMenu);
            overlay?.addEventListener('click', toggleMobileMenu);

            // Auto-close on mobile when clicking nav item
            document.querySelectorAll('.mega-menu-item').forEach(item => {
                item.addEventListener('click', () => {
                    if (window.innerWidth < 1024) {
                        toggleMobileMenu();
                    }
                });
            });

            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 1024) {
                    sidebar.classList.remove('-translate-x-full');
                    overlay.classList.add('hidden');
                } else {
                    sidebar.classList.add('-translate-x-full');
                    overlay.classList.add('hidden');
                }
            });
        });
        </script>
</body>
</html>