<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $platformSettings['platform_name'] }} - @yield('title', 'Gaming Challenge Platform')</title>

    <!-- Styles -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="bg-cod-darker text-gray-100">
    <div class="min-h-screen bg-dark-gradient">
        <!-- Modern Gaming Navigation -->
        <nav class="bg-cod-dark/95 backdrop-blur-md border-b border-cod-green/20 sticky top-0 z-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <!-- Mobile menu button -->
                        <button id="mobileMenuToggle" class="lg:hidden text-gray-300 hover:text-cod-green transition-colors mr-4">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                            </svg>
                        </button>
                        
                        <a href="{{ route('home') }}" class="flex items-center space-x-2">
                            @if($platformSettings['platform_logo'])
                                <img src="{{ $platformSettings['platform_logo'] }}" alt="{{ $platformSettings['platform_name'] }}" class="w-10 h-10 rounded-xl object-cover">
                            @else
                                <div class="w-10 h-10 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-xl flex items-center justify-center">
                                    <span class="text-lg font-bold text-black">{{ substr($platformSettings['platform_name'], 0, 1) }}</span>
                                </div>
                            @endif
                            <span class="font-gaming text-2xl font-bold text-cod-green gaming-text-glow">{{ $platformSettings['platform_name'] }}</span>
                        </a>
                        
                        <!-- Mega Menu Navigation -->
                        <div class="hidden lg:ml-8 lg:flex lg:space-x-1">
                            <!-- Home -->
                            <a href="{{ route('home') }}" class="advanced-menu-item {{ request()->routeIs('home') ? 'active' : '' }}">
                                🏠 Home
                            </a>
                            
                            @auth
                            <!-- Dashboard -->
                            <a href="{{ route('dashboard') }}" class="advanced-menu-item {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                                📊 Dashboard
                            </a>
                            @endauth
                            
                            <!-- Challenges Dropdown -->
                            <div class="relative group">
                                <button class="advanced-menu-item flex items-center space-x-1 {{ request()->routeIs('challenges.*') ? 'active' : '' }}">
                                    <span>⚔️ Challenges</span>
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                <div class="absolute left-0 mt-2 w-64 bg-cod-gray/95 backdrop-blur-md rounded-xl shadow-xl gaming-glow opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                                    <div class="p-4">
                                        <a href="{{ route('challenges.index') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            Browse Challenges
                                        </a>
                                        @auth
                                            <a href="{{ route('challenges.my') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                                ⚔️ My Challenges
                                            </a>
                                            @if(auth()->user()->role->canCreateContent())
                                                <a href="{{ route('challenges.create') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                                    Create Challenge
                                                </a>
                                            @endif
                                        @endauth
                                        <div class="border-t border-cod-light my-2"></div>
                                        <div class="text-xs text-gray-500 px-3 py-1">
                                            Compete for real money rewards
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Tournaments Dropdown -->
                            <div class="relative group">
                                <button class="advanced-menu-item flex items-center space-x-1 {{ request()->routeIs('tournaments.*') ? 'active' : '' }}">
                                    <span>🏆 Tournaments</span>
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                <div class="absolute left-0 mt-2 w-64 bg-cod-gray/95 backdrop-blur-md rounded-xl shadow-xl gaming-glow opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                                    <div class="p-4">
                                        <a href="{{ route('tournaments.index') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            Browse Tournaments
                                        </a>
                                        @auth
                                            <a href="{{ route('tournaments.my') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                                🏆 My Tournaments
                                            </a>
                                            @if(auth()->user()->canCreateTournaments())
                                                <a href="{{ route('tournaments.create') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                                    Create Tournament
                                                </a>
                                            @endif
                                        @endauth
                                        <div class="border-t border-cod-light my-2"></div>
                                        <div class="text-xs text-gray-500 px-3 py-1">
                                            Join competitive tournaments
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Community Dropdown -->
                            <div class="relative group">
                                <button class="advanced-menu-item flex items-center space-x-1 {{ request()->routeIs('friends.*', 'leaderboards.*') ? 'active' : '' }}">
                                    <span>👥 Community</span>
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                <div class="absolute left-0 mt-2 w-64 bg-cod-gray/95 backdrop-blur-md rounded-xl shadow-xl gaming-glow opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                                    <div class="p-4">
                                        <a href="{{ route('leaderboards.index') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            🏅 Leaderboards
                                        </a>
                                        <a href="{{ route('friends.suggestions') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            🤝 Find Players
                                        </a>
                                        @auth
                                            <a href="{{ route('friends.index') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors relative">
                                                👥 My Friends
                                                @if(auth()->user()->getFriendRequestsCount() > 0)
                                                    <span class="absolute right-2 top-2 bg-red-500 text-white text-xs rounded-full h-4 w-4 flex items-center justify-center">
                                                        {{ auth()->user()->getFriendRequestsCount() }}
                                                    </span>
                                                @endif
                                            </a>
                                        @endauth
                                        <div class="border-t border-cod-light my-2"></div>
                                        <div class="text-xs text-gray-500 px-3 py-1">
                                            Connect with gamers worldwide
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Content -->
                            <a href="{{ route('posts.index') }}" class="advanced-menu-item {{ request()->routeIs('posts.*') ? 'active' : '' }}">
                                📰 News
                            </a>

                            <!-- More Dropdown -->
                            <div class="relative group">
                                <button class="advanced-menu-item flex items-center space-x-1">
                                    <span>⋯ More</span>
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                <div class="absolute left-0 mt-2 w-64 bg-cod-gray/95 backdrop-blur-md rounded-xl shadow-xl gaming-glow opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                                    <div class="p-4">
                                        <a href="{{ route('about-us') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            About Us
                                        </a>
                                        <a href="{{ route('contact-us') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            Contact
                                        </a>
                                        <a href="{{ route('faq') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            FAQ
                                        </a>
                                        <div class="border-t border-cod-light my-2"></div>
                                        <a href="{{ route('privacy-policy') }}" class="block py-2 px-3 text-sm text-gray-400 hover:text-gray-300 hover:bg-cod-light rounded-lg transition-colors text-xs">
                                            Privacy Policy
                                        </a>
                                        <a href="{{ route('terms-of-service') }}" class="block py-2 px-3 text-sm text-gray-400 hover:text-gray-300 hover:bg-cod-light rounded-lg transition-colors text-xs">
                                            Terms of Service
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center space-x-4">
                        @auth
                            <!-- User XP and Level -->
                            <div class="hidden md:flex items-center space-x-3 bg-cod-gray/80 backdrop-blur-sm px-4 py-2 rounded-xl border border-cod-light
                                @if(auth()->user()->role->value === 'premium_user') border-yellow-400/50 ring-1 ring-yellow-400/20 @endif
                                @if(auth()->user()->role->value === 'creator') border-purple-400/50 ring-1 ring-purple-400/20 @endif
                                @if(auth()->user()->role->value === 'moderator') border-orange-400/50 ring-1 ring-orange-400/20 @endif
                                @if(auth()->user()->role->value === 'admin') border-red-400/50 ring-1 ring-red-400/20 @endif">
                                <div class="text-center">
                                    <div class="text-xs text-gray-400">Level</div>
                                    <div class="text-sm font-bold 
                                        @if(auth()->user()->role->value === 'premium_user') text-yellow-400 
                                        @elseif(auth()->user()->role->value === 'creator') text-purple-400
                                        @elseif(auth()->user()->role->value === 'moderator') text-orange-400
                                        @elseif(auth()->user()->role->value === 'admin') text-red-400
                                        @else text-cod-green @endif">{{ auth()->user()->level }}</div>
                                </div>
                                <div class="w-20 h-2 bg-gray-700 rounded-full overflow-hidden">
                                    @php
                                        $xpService = app(\App\Services\XPService::class);
                                        $progress = $xpService->getLevelProgress(auth()->user());
                                    @endphp
                                    <div class="h-full bg-gradient-to-r from-cod-green to-cod-green-dark transition-all duration-300" style="width: {{ min(100, max(0, $progress ?? 0)) }}%"></div>
                                </div>
                                <div class="text-center">
                                    <div class="text-xs text-gray-400">XP</div>
                                    <div class="text-sm font-bold text-cod-green">{{ number_format(auth()->user()->xp ?? 0) }}</div>
                                </div>
                            </div>

                            <!-- Wallet Balance -->
                            <a href="{{ route('wallet.index') }}" class="flex items-center space-x-2 bg-gradient-to-r from-green-600 to-green-700 hover:from-green-500 hover:to-green-600 px-4 py-2 rounded-xl transition-all duration-300 transform hover:scale-105">
                                <span class="text-white text-sm font-bold">₦{{ number_format(auth()->user()->wallet_balance ?? 0, 2) }}</span>
                                <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                                </svg>
                            </a>

                            <!-- User Menu -->
                            <div class="relative group">
                                <button class="flex items-center space-x-2 text-gray-300 hover:text-cod-green px-3 py-2 rounded-xl transition-colors">
                                    <div class="w-10 h-10 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-xl flex items-center justify-center border-2 border-transparent hover:border-cod-green transition-all">
                                        <span class="text-sm font-bold text-black">{{ substr(auth()->user()->username, 0, 1) }}</span>
                                    </div>
                                    <span class="hidden md:block font-medium">{{ auth()->user()->username }}</span>
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </button>
                                
                                <!-- Dropdown Menu -->
                                <div class="absolute right-0 mt-2 w-64 bg-cod-gray/95 backdrop-blur-md rounded-xl shadow-xl gaming-glow opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                                    <div class="p-4">
                                        <div class="px-3 py-2 border-b border-cod-light mb-3">
                                            <div class="flex items-center justify-between">
                                                <div>
                                                    <div class="text-sm font-medium text-gray-100">{{ auth()->user()->username }}</div>
                                                    <div class="text-xs text-gray-400">{{ auth()->user()->role->getDisplayName() }}</div>
                                                </div>
                                                <div class="flex flex-col items-end space-y-1">
                                                    @if(auth()->user()->role->value === 'premium_user')
                                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                                                            ⭐ Premium
                                                        </span>
                                                    @elseif(auth()->user()->role->value === 'creator')
                                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                                            ✨ Creator
                                                        </span>
                                                    @elseif(auth()->user()->role->value === 'moderator')
                                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800">
                                                            ⚖️ Moderator
                                                        </span>
                                                    @elseif(auth()->user()->role->value === 'admin')
                                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                            🛡️ Admin
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <a href="{{ route('profile.index') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            👤 My Profile
                                        </a>
                                        <a href="{{ route('wallet.index') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            💰 My Wallet
                                        </a>
                                        <a href="{{ route('notifications.index') }}" class="block py-2 px-3 text-sm text-gray-300 hover:text-cod-green hover:bg-cod-light rounded-lg transition-colors">
                                            🔔 Notifications
                                        </a>
                                        
                                        @if(auth()->user()->role->canCreateContent())
                                            <div class="border-t border-cod-light my-2"></div>
                                            <a href="{{ route('creator.blogs.index') }}" class="block py-2 px-3 text-sm text-blue-400 hover:text-blue-300 hover:bg-cod-light rounded-lg transition-colors">
                                                ✍️ My Blogs
                                            </a>
                                        @endif

                                        @if(auth()->user()->canManageDisputes())
                                            <div class="border-t border-cod-light my-2"></div>
                                            <a href="{{ route('moderator.dashboard') }}" class="block py-2 px-3 text-sm text-orange-400 hover:text-orange-300 hover:bg-cod-light rounded-lg transition-colors">
                                                ⚖️ Moderator Panel
                                            </a>
                                        @endif
                                        
                                        @if(auth()->user()->is_organizer)
                                            <div class="border-t border-cod-light my-2"></div>
                                            <a href="{{ route('admin.dashboard') }}" class="block py-2 px-3 text-sm text-yellow-400 hover:text-yellow-300 hover:bg-cod-light rounded-lg transition-colors">
                                                🛡️ Admin Dashboard
                                            </a>
                                        @endif
                                        
                                        <div class="border-t border-cod-light my-2"></div>
                                        <form method="POST" action="{{ route('logout') }}">
                                            @csrf
                                            <button type="submit" class="block w-full text-left py-2 px-3 text-sm text-red-400 hover:text-red-300 hover:bg-cod-light rounded-lg transition-colors">
                                                🚪 Logout
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        @else
                            <a href="{{ route('login') }}" class="text-gray-300 hover:text-cod-green px-4 py-2 text-sm font-medium transition-colors">
                                Login
                            </a>
                            <a href="{{ route('register') }}" class="gaming-button text-sm">
                                Sign Up
                            </a>
                        @endauth
                    </div>
                </div>
            </div>
            
            <!-- Mobile Navigation Menu -->
            <div id="mobileNavMenu" class="lg:hidden fixed inset-0 z-50 hidden">
                <div class="fixed inset-0 bg-black/50 backdrop-blur-sm" id="mobileNavOverlay"></div>
                <div class="fixed inset-y-0 left-0 w-80 bg-cod-dark/95 backdrop-blur-md border-r border-cod-green/20 transform -translate-x-full transition-transform duration-300 ease-in-out" id="mobileNavSlider">
                    <div class="flex items-center justify-between p-4 border-b border-cod-green/20">
                        <div class="flex items-center space-x-2">
                            @if($platformSettings['platform_logo'])
                                <img src="{{ $platformSettings['platform_logo'] }}" alt="{{ $platformSettings['platform_name'] }}" class="w-8 h-8 rounded-lg object-cover">
                            @else
                                <div class="w-8 h-8 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-lg flex items-center justify-center">
                                    <span class="text-sm font-bold text-black">{{ substr($platformSettings['platform_name'], 0, 1) }}</span>
                                </div>
                            @endif
                            <span class="font-gaming text-lg font-bold text-cod-green">{{ $platformSettings['platform_name'] }}</span>
                        </div>
                        <button id="mobileMenuClose" class="text-gray-300 hover:text-cod-green">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>
                    
                    <div class="p-4 space-y-2 overflow-y-auto max-h-screen pb-20">
                        <!-- Home -->
                        <a href="{{ route('home') }}" class="mobile-nav-item {{ request()->routeIs('home') ? 'active' : '' }}">
                            <div class="flex items-center space-x-3">
                                <span class="text-lg">🏠</span>
                                <span>Home</span>
                            </div>
                        </a>
                        
                        @auth
                        <!-- Dashboard -->
                        <a href="{{ route('dashboard') }}" class="mobile-nav-item {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                            <div class="flex items-center space-x-3">
                                <span class="text-lg">📊</span>
                                <span>Dashboard</span>
                            </div>
                        </a>
                        @endauth
                        
                        <!-- Challenges -->
                        <div class="mobile-nav-section">
                            <div class="mobile-nav-header">
                                <span class="text-lg">⚔️</span>
                                <span>Challenges</span>
                            </div>
                            <div class="ml-8 space-y-1">
                                <a href="{{ route('challenges.index') }}" class="mobile-nav-subitem">Browse Challenges</a>
                                @auth
                                    <a href="{{ route('challenges.my') }}" class="mobile-nav-subitem">My Challenges</a>
                                    @if(auth()->user()->role->canCreateContent())
                                        <a href="{{ route('challenges.create') }}" class="mobile-nav-subitem">Create Challenge</a>
                                    @endif
                                @endauth
                            </div>
                        </div>
                        
                        <!-- Tournaments -->
                        <div class="mobile-nav-section">
                            <div class="mobile-nav-header">
                                <span class="text-lg">🏆</span>
                                <span>Tournaments</span>
                            </div>
                            <div class="ml-8 space-y-1">
                                <a href="{{ route('tournaments.index') }}" class="mobile-nav-subitem">Browse Tournaments</a>
                                @auth
                                    <a href="{{ route('tournaments.my') }}" class="mobile-nav-subitem">My Tournaments</a>
                                    @if(auth()->user()->canCreateTournaments())
                                        <a href="{{ route('tournaments.create') }}" class="mobile-nav-subitem">Create Tournament</a>
                                    @endif
                                @endauth
                            </div>
                        </div>
                        
                        <!-- Community -->
                        <div class="mobile-nav-section">
                            <div class="mobile-nav-header">
                                <span class="text-lg">👥</span>
                                <span>Community</span>
                            </div>
                            <div class="ml-8 space-y-1">
                                <a href="{{ route('leaderboards.index') }}" class="mobile-nav-subitem">Leaderboards</a>
                                <a href="{{ route('friends.suggestions') }}" class="mobile-nav-subitem">Find Players</a>
                                @auth
                                    <a href="{{ route('friends.index') }}" class="mobile-nav-subitem relative">
                                        My Friends
                                        @if(auth()->user()->getFriendRequestsCount() > 0)
                                            <span class="absolute -right-2 -top-1 bg-red-500 text-white text-xs rounded-full h-4 w-4 flex items-center justify-center">
                                                {{ auth()->user()->getFriendRequestsCount() }}
                                            </span>
                                        @endif
                                    </a>
                                @endauth
                            </div>
                        </div>
                        
                        <!-- News -->
                        <a href="{{ route('posts.index') }}" class="mobile-nav-item {{ request()->routeIs('posts.*') ? 'active' : '' }}">
                            <div class="flex items-center space-x-3">
                                <span class="text-lg">📰</span>
                                <span>News</span>
                            </div>
                        </a>
                        
                        @auth
                        <!-- User Section -->
                        <div class="border-t border-cod-green/20 mt-4 pt-4">
                            <div class="flex items-center space-x-3 mb-4 p-3 bg-cod-green/10 rounded-lg">
                                <div class="w-10 h-10 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-xl flex items-center justify-center">
                                    <span class="text-sm font-bold text-black">{{ substr(auth()->user()->username, 0, 1) }}</span>
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-gray-100">{{ auth()->user()->username }}</div>
                                    <div class="text-xs text-gray-400">{{ auth()->user()->role->getDisplayName() }}</div>
                                </div>
                            </div>
                            
                            <div class="space-y-1">
                                <a href="{{ route('profile.index') }}" class="mobile-nav-subitem">👤 My Profile</a>
                                <a href="{{ route('wallet.index') }}" class="mobile-nav-subitem">💰 My Wallet</a>
                                <a href="{{ route('notifications.index') }}" class="mobile-nav-subitem">🔔 Notifications</a>
                                
                                @if(auth()->user()->role->canCreateContent())
                                    <a href="{{ route('creator.blogs.index') }}" class="mobile-nav-subitem">✍️ My Blogs</a>
                                @endif

                                @if(auth()->user()->canManageDisputes())
                                    <a href="{{ route('moderator.dashboard') }}" class="mobile-nav-subitem">⚖️ Moderator Panel</a>
                                @endif
                                
                                @if(auth()->user()->is_organizer)
                                    <a href="{{ route('admin.dashboard') }}" class="mobile-nav-subitem">🛡️ Admin Dashboard</a>
                                @endif
                                
                                <form method="POST" action="{{ route('logout') }}" class="mt-2">
                                    @csrf
                                    <button type="submit" class="w-full text-left mobile-nav-subitem text-red-400 hover:text-red-300">
                                        🚪 Logout
                                    </button>
                                </form>
                            </div>
                        </div>
                        @else
                        <!-- Guest Section -->
                        <div class="border-t border-cod-green/20 mt-4 pt-4 space-y-2">
                            <a href="{{ route('login') }}" class="block w-full text-center py-3 px-4 bg-cod-gray hover:bg-cod-light text-gray-100 rounded-lg transition-colors">
                                Login
                            </a>
                            <a href="{{ route('register') }}" class="block w-full text-center py-3 px-4 bg-gradient-to-r from-cod-green to-cod-green-dark text-black font-bold rounded-lg transition-all transform hover:scale-105">
                                Sign Up
                            </a>
                        </div>
                        @endauth
                    </div>
                </div>
            </div>
        </nav>

        <!-- Flash Messages -->
        @if(session('success'))
            <div class="bg-gradient-to-r from-green-600 to-green-700 text-white px-6 py-4 text-center border-b border-green-500">
                <div class="flex items-center justify-center space-x-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    <span>{{ session('success') }}</span>
                </div>
            </div>
        @endif

        @if(session('error'))
            <div class="bg-gradient-to-r from-red-600 to-red-700 text-white px-6 py-4 text-center border-b border-red-500">
                <div class="flex items-center justify-center space-x-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                    <span>{{ session('error') }}</span>
                </div>
            </div>
        @endif

        <!-- Main Content -->
        <main class="pb-20 lg:pb-0">
            @yield('content')
        </main>

        <!-- Mobile Bottom Navigation -->
        <div class="lg:hidden fixed bottom-0 left-0 right-0 bg-cod-dark/95 backdrop-blur-md border-t border-cod-green/20 z-40">
            <div class="grid grid-cols-5 h-16">
                <a href="{{ route('home') }}" class="bottom-nav-item {{ request()->routeIs('home') ? 'active' : '' }}">
                    <span class="text-lg">🏠</span>
                    <span class="text-xs">Home</span>
                </a>
                
                @auth
                <a href="{{ route('dashboard') }}" class="bottom-nav-item {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                    <span class="text-lg">📊</span>
                    <span class="text-xs">Dashboard</span>
                </a>
                @else
                <a href="{{ route('login') }}" class="bottom-nav-item">
                    <span class="text-lg">👤</span>
                    <span class="text-xs">Login</span>
                </a>
                @endauth
                
                <a href="{{ route('challenges.index') }}" class="bottom-nav-item {{ request()->routeIs('challenges.*') ? 'active' : '' }}">
                    <span class="text-lg">⚔️</span>
                    <span class="text-xs">Challenges</span>
                </a>
                
                <a href="{{ route('tournaments.index') }}" class="bottom-nav-item {{ request()->routeIs('tournaments.*') ? 'active' : '' }}">
                    <span class="text-lg">🏆</span>
                    <span class="text-xs">Tournaments</span>
                </a>
                
                <button id="mobileMenuButton" class="bottom-nav-item">
                    <span class="text-lg">⋯</span>
                    <span class="text-xs">More</span>
                </button>
            </div>
        </div>

        <!-- Enhanced Footer -->
        <footer class="bg-cod-dark/95 backdrop-blur-md border-t border-cod-green/20 mt-16">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                    <!-- Brand Section -->
                    <div class="md:col-span-1">
                        <div class="flex items-center space-x-2 mb-4">
                            @if($platformSettings['platform_logo'])
                                <img src="{{ $platformSettings['platform_logo'] }}" alt="{{ $platformSettings['platform_name'] }}" class="w-10 h-10 rounded-xl object-cover">
                            @else
                                <div class="w-10 h-10 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-xl flex items-center justify-center">
                                    <span class="text-lg font-bold text-black">{{ substr($platformSettings['platform_name'], 0, 1) }}</span>
                                </div>
                            @endif
                            <span class="font-gaming text-xl font-bold text-cod-green">{{ $platformSettings['platform_name'] }}</span>
                        </div>
                        <p class="text-gray-400 text-sm mb-4">
                            {{ $platformSettings['platform_description'] }}
                        </p>
                        <div class="flex space-x-3">
                            <div class="w-8 h-8 bg-cod-gray rounded-lg flex items-center justify-center hover:bg-cod-green hover:text-black transition-colors cursor-pointer">
                                <span class="text-sm">📱</span>
                            </div>
                            <div class="w-8 h-8 bg-cod-gray rounded-lg flex items-center justify-center hover:bg-cod-green hover:text-black transition-colors cursor-pointer">
                                <span class="text-sm">🐦</span>
                            </div>
                            <div class="w-8 h-8 bg-cod-gray rounded-lg flex items-center justify-center hover:bg-cod-green hover:text-black transition-colors cursor-pointer">
                                <span class="text-sm">📺</span>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Links -->
                    <div>
                        <h3 class="text-lg font-semibold text-cod-green mb-4">Quick Links</h3>
                        <ul class="space-y-2">
                            <li><a href="{{ route('challenges.index') }}" class="text-gray-400 hover:text-cod-green transition-colors">Browse Challenges</a></li>
                            <li><a href="{{ route('tournaments.index') }}" class="text-gray-400 hover:text-cod-green transition-colors">Tournaments</a></li>
                            <li><a href="{{ route('leaderboards.index') }}" class="text-gray-400 hover:text-cod-green transition-colors">Leaderboards</a></li>
                            <li><a href="{{ route('friends.suggestions') }}" class="text-gray-400 hover:text-cod-green transition-colors">Find Players</a></li>
                        </ul>
                    </div>

                    <!-- Support -->
                    <div>
                        <h3 class="text-lg font-semibold text-cod-green mb-4">Support</h3>
                        <ul class="space-y-2">
                            <li><a href="{{ route('faq') }}" class="text-gray-400 hover:text-cod-green transition-colors">FAQ</a></li>
                            <li><a href="{{ route('contact-us') }}" class="text-gray-400 hover:text-cod-green transition-colors">Contact Us</a></li>
                            <li><a href="{{ route('about-us') }}" class="text-gray-400 hover:text-cod-green transition-colors">About Us</a></li>
                            <li><a href="{{ route('posts.index') }}" class="text-gray-400 hover:text-cod-green transition-colors">News & Updates</a></li>
                        </ul>
                    </div>

                    <!-- Legal -->
                    <div>
                        <h3 class="text-lg font-semibold text-cod-green mb-4">Legal</h3>
                        <ul class="space-y-2">
                            <li><a href="{{ route('privacy-policy') }}" class="text-gray-400 hover:text-cod-green transition-colors">Privacy Policy</a></li>
                            <li><a href="{{ route('terms-of-service') }}" class="text-gray-400 hover:text-cod-green transition-colors">Terms of Service</a></li>
                        </ul>
                    </div>
                </div>
                
                <div class="border-t border-cod-green/20 mt-8 pt-8 text-center">
                    <p class="text-gray-400">&copy; {{ date('Y') }} {{ $platformSettings['platform_name'] }}. The ultimate gaming challenge platform.</p>
                </div>
            </div>
        </footer>
    </div>

    <!-- Mobile Navigation JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuToggle = document.getElementById('mobileMenuToggle');
            const mobileMenuButton = document.getElementById('mobileMenuButton');
            const mobileNavMenu = document.getElementById('mobileNavMenu');
            const mobileNavOverlay = document.getElementById('mobileNavOverlay');
            const mobileNavSlider = document.getElementById('mobileNavSlider');
            const mobileMenuClose = document.getElementById('mobileMenuClose');

            function openMobileMenu() {
                mobileNavMenu.classList.remove('hidden');
                setTimeout(() => {
                    mobileNavSlider.classList.remove('-translate-x-full');
                }, 10);
                document.body.style.overflow = 'hidden';
            }

            function closeMobileMenu() {
                mobileNavSlider.classList.add('-translate-x-full');
                setTimeout(() => {
                    mobileNavMenu.classList.add('hidden');
                    document.body.style.overflow = '';
                }, 300);
            }

            mobileMenuToggle?.addEventListener('click', openMobileMenu);
            mobileMenuButton?.addEventListener('click', openMobileMenu);
            mobileMenuClose?.addEventListener('click', closeMobileMenu);
            mobileNavOverlay?.addEventListener('click', closeMobileMenu);

            // Close mobile menu when clicking on navigation items
            document.querySelectorAll('.mobile-nav-item, .mobile-nav-subitem').forEach(item => {
                item.addEventListener('click', closeMobileMenu);
            });

            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth >= 1024) {
                    closeMobileMenu();
                }
            });
        });
    </script>

    <style>
        /* Mobile Navigation Styles */
        .mobile-nav-item {
            @apply block px-4 py-3 text-gray-300 hover:text-cod-green hover:bg-cod-green/10 rounded-lg transition-all duration-200 font-medium;
        }
        
        .mobile-nav-item.active {
            @apply text-cod-green bg-cod-green/20;
        }
        
        .mobile-nav-header {
            @apply flex items-center space-x-3 px-4 py-3 text-cod-green font-semibold;
        }
        
        .mobile-nav-section {
            @apply mb-2;
        }
        
        .mobile-nav-subitem {
            @apply block px-4 py-2 text-sm text-gray-400 hover:text-cod-green hover:bg-cod-green/5 rounded-lg transition-all duration-200;
        }
        
        /* Bottom Navigation Styles */
        .bottom-nav-item {
            @apply flex flex-col items-center justify-center text-gray-400 hover:text-cod-green transition-all duration-200 font-medium;
        }
        
        .bottom-nav-item.active {
            @apply text-cod-green;
        }
        
        .bottom-nav-item:hover {
            @apply transform scale-105;
        }
        
        /* Enhanced dropdown styles for better contrast */
        .advanced-menu-item {
            @apply text-gray-300 hover:text-cod-green px-4 py-2 text-sm font-medium transition-colors duration-200 block;
        }

        .advanced-menu-item.active {
            @apply text-cod-green bg-cod-green/10 rounded-lg;
        }
        
        /* Improve dropdown readability */
        .group:hover .group-hover\\:opacity-100 {
            backdrop-filter: blur(12px);
        }
        
        /* Better mobile responsive for user menu */
        @media (max-width: 768px) {
            .hidden.md\\:flex {
                display: none !important;
            }
        }

        /* Enhanced dropdown background for better readability */
        .group:hover .opacity-0.invisible {
            background-color: rgba(26, 26, 26, 0.98) !important;
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 102, 0, 0.3);
        }

        /* Fix any dropdown text contrast issues */
        .group:hover .opacity-0.invisible a,
        .group:hover .opacity-0.invisible span,
        .group:hover .opacity-0.invisible div {
            color: #f1f5f9 !important;
        }

        .group:hover .opacity-0.invisible a:hover {
            color: #ff6600 !important;
            background-color: rgba(255, 102, 0, 0.1) !important;
        }
    </style>
</body>
</html>