@extends('layouts.app')

@section('title', 'Dispute Details - Moderator')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="mb-8">
        <a href="{{ route('moderator.disputes.index') }}" class="inline-flex items-center text-blue-600 hover:text-blue-800 mb-4">
            ← Back to My Disputes
        </a>
        <h1 class="text-3xl font-bold text-gray-900">Dispute Details</h1>
        <p class="text-gray-600 mt-2">Review and resolve this dispute</p>
    </div>

    @if(session('success'))
        <div class="mb-6 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="mb-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
            {{ session('error') }}
        </div>
    @endif

    <!-- Dispute Overview -->
    <div class="bg-white rounded-lg shadow p-6 mb-8">
        <div class="flex justify-between items-start mb-6">
            <div>
                <h2 class="text-xl font-bold text-gray-900">{{ $dispute->challenge->game->name }} Challenge</h2>
                <p class="text-gray-600">₦{{ number_format($dispute->challenge->amount, 2) }} at stake</p>
            </div>
            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                @if($dispute->status === 'open') bg-yellow-100 text-yellow-800
                @else bg-green-100 text-green-800 @endif">
                {{ ucfirst($dispute->status) }}
            </span>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Challenge Details -->
            <div>
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Challenge Details</h3>
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Creator:</span>
                        <span class="font-medium">{{ $dispute->challenge->creator->username }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Accepter:</span>
                        <span class="font-medium">{{ $dispute->challenge->accepter->username }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Game:</span>
                        <span class="font-medium">{{ $dispute->challenge->game->name }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Amount:</span>
                        <span class="font-medium">₦{{ number_format($dispute->challenge->amount, 2) }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Challenge Created:</span>
                        <span class="font-medium">{{ $dispute->challenge->created_at->format('M j, Y H:i') }}</span>
                    </div>
                </div>
            </div>

            <!-- Dispute Details -->
            <div>
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Dispute Information</h3>
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Opened By:</span>
                        <span class="font-medium">{{ $dispute->openedBy->username }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Assigned To:</span>
                        <span class="font-medium">
                            @if($dispute->moderator)
                                {{ $dispute->moderator->username }}
                                @if($dispute->moderator_id === auth()->id())
                                    <span class="text-blue-600">(You)</span>
                                @endif
                            @else
                                <span class="text-gray-500">Unassigned</span>
                            @endif
                        </span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Dispute Created:</span>
                        <span class="font-medium">{{ $dispute->created_at->format('M j, Y H:i') }}</span>
                    </div>
                    @if($dispute->assigned_to_moderator_at)
                        <div class="flex justify-between">
                            <span class="text-gray-600">Assigned At:</span>
                            <span class="font-medium">{{ $dispute->assigned_to_moderator_at->format('M j, Y H:i') }}</span>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Dispute Reason -->
        <div class="mt-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-2">Dispute Reason</h3>
            <div class="bg-gray-50 rounded-lg p-4">
                <p class="text-gray-800">{{ $dispute->reason }}</p>
            </div>
        </div>
    </div>

    <!-- Evidence Section -->
    <div class="bg-white rounded-lg shadow p-6 mb-8">
        <h2 class="text-xl font-bold text-gray-900 mb-6">Evidence</h2>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Creator Evidence -->
            <div>
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Creator Evidence</h3>
                @if($dispute->hasCreatorEvidence())
                    <div class="border border-gray-200 rounded-lg p-4">
                        <a href="{{ Storage::url($dispute->creator_evidence_path) }}" target="_blank" 
                           class="text-blue-600 hover:text-blue-800 font-medium">
                            📎 View Creator Evidence
                        </a>
                        <p class="text-sm text-gray-500 mt-1">Click to view the evidence file</p>
                    </div>
                @else
                    <div class="border border-gray-200 rounded-lg p-4 text-center text-gray-500">
                        No evidence uploaded by creator
                    </div>
                @endif
            </div>

            <!-- Accepter Evidence -->
            <div>
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Accepter Evidence</h3>
                @if($dispute->hasAccepterEvidence())
                    <div class="border border-gray-200 rounded-lg p-4">
                        <a href="{{ Storage::url($dispute->accepter_evidence_path) }}" target="_blank" 
                           class="text-blue-600 hover:text-blue-800 font-medium">
                            📎 View Accepter Evidence
                        </a>
                        <p class="text-sm text-gray-500 mt-1">Click to view the evidence file</p>
                    </div>
                @else
                    <div class="border border-gray-200 rounded-lg p-4 text-center text-gray-500">
                        No evidence uploaded by accepter
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Match Proofs -->
    @if($dispute->challenge->matchProofs->count() > 0)
        <div class="bg-white rounded-lg shadow p-6 mb-8">
            <h2 class="text-xl font-bold text-gray-900 mb-6">Match Proofs</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @foreach($dispute->challenge->matchProofs as $proof)
                    <div class="border border-gray-200 rounded-lg p-4">
                        <div class="flex justify-between items-start mb-2">
                            <span class="font-medium text-gray-900">{{ $proof->user->username }}</span>
                            <span class="text-sm text-gray-500">{{ $proof->created_at->format('M j, H:i') }}</span>
                        </div>
                        @if($proof->image_path)
                            <a href="{{ Storage::url($proof->image_path) }}" target="_blank" 
                               class="text-blue-600 hover:text-blue-800 text-sm">
                                📷 View Screenshot
                            </a>
                        @endif
                        @if($proof->description)
                            <p class="text-sm text-gray-600 mt-2">{{ $proof->description }}</p>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    @endif

    <!-- Decision Form -->
    @if($dispute->status === 'open' && $dispute->moderator_id === auth()->id())
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-xl font-bold text-gray-900 mb-6">Make Decision</h2>
            
            <form method="POST" action="{{ route('moderator.disputes.decide', $dispute) }}" class="space-y-6">
                @csrf
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Decision</label>
                    <div class="space-y-2">
                        <label class="flex items-center">
                            <input type="radio" name="decision" value="creator_win" class="mr-2" required>
                            <span>{{ $dispute->challenge->creator->username }} Wins</span>
                        </label>
                        <label class="flex items-center">
                            <input type="radio" name="decision" value="accepter_win" class="mr-2" required>
                            <span>{{ $dispute->challenge->accepter->username }} Wins</span>
                        </label>
                        <label class="flex items-center">
                            <input type="radio" name="decision" value="refund" class="mr-2" required>
                            <span>Refund Both Players</span>
                        </label>
                    </div>
                </div>

                <div>
                    <label for="resolution" class="block text-sm font-medium text-gray-700 mb-2">Resolution Explanation</label>
                    <textarea name="resolution" id="resolution" rows="4" 
                              class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                              placeholder="Explain your decision and reasoning..." required></textarea>
                </div>

                <div class="flex space-x-4">
                    <button type="submit" 
                            class="px-6 py-3 bg-green-600 text-white font-bold rounded-lg hover:bg-green-700 transition-colors">
                        ⚖️ Resolve Dispute
                    </button>
                    <a href="{{ route('moderator.disputes.index') }}" 
                       class="px-6 py-3 bg-gray-600 text-white font-bold rounded-lg hover:bg-gray-700 transition-colors">
                        Cancel
                    </a>
                </div>
            </form>
        </div>
    @elseif($dispute->status === 'resolved')
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-xl font-bold text-gray-900 mb-4">Resolution</h2>
            <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                <p class="text-green-800 font-medium mb-2">This dispute has been resolved.</p>
                <p class="text-gray-700"><strong>Resolution:</strong> {{ $dispute->resolution }}</p>
                @if($dispute->admin)
                    <p class="text-sm text-gray-500 mt-2">
                        Resolved by {{ $dispute->admin->username }} on {{ $dispute->updated_at->format('M j, Y H:i') }}
                    </p>
                @endif
            </div>
        </div>
    @else
        <div class="bg-white rounded-lg shadow p-6">
            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                <p class="text-yellow-800">
                    @if(!$dispute->moderator_id)
                        This dispute is not assigned to anyone yet.
                    @else
                        This dispute is assigned to {{ $dispute->moderator->username }}.
                    @endif
                </p>
            </div>
        </div>
    @endif
</div>
@endsection