@extends('layouts.app')

@section('title', $post->title)

@section('content')
<div class="post-detail">
    <div class="container">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="{{ route('posts.index') }}">News & Updates</a>
            <span>›</span>
            <a href="{{ route('posts.index', ['type' => $post->type]) }}">{{ ucfirst($post->type) }}</a>
            <span>›</span>
            <span>{{ $post->title }}</span>
        </nav>

        <!-- Post Header -->
        <header class="post-header">
            <div class="post-meta">
                <span class="post-type type-{{ $post->type }}">
                    @switch($post->type)
                        @case('blog')
                            📖 Blog Post
                            @break
                        @case('news')
                            📰 News
                            @break
                        @case('highlight')
                            🏆 Tournament Highlight
                            @break
                        @case('tournament')
                            🎮 Tournament
                            @break
                        @case('update')
                            🔄 Platform Update
                            @break
                    @endswitch
                </span>
                <span class="post-date">{{ $post->published_at->format('F j, Y') }}</span>
            </div>

            <h1 class="post-title">{{ $post->title }}</h1>

            <div class="post-info">
                <div class="author-info">
                    <div class="author-avatar">
                        {{ substr($post->author->username, 0, 1) }}
                    </div>
                    <div class="author-details">
                        <span class="author-name">{{ $post->author->username }}</span>
                        <span class="author-title">Content Creator</span>
                    </div>
                </div>

                <div class="post-stats">
                    <span class="views">👁️ {{ number_format($post->views) }} views</span>
                    <span class="reading-time">📖 {{ $post->reading_time }} min read</span>
                </div>
            </div>
        </header>

        <!-- Featured Image -->
        @if($post->featured_image)
            <div class="featured-image">
                <img src="{{ asset('storage/' . $post->featured_image) }}" alt="{{ $post->title }}">
            </div>
        @endif

        <!-- Post Content -->
        <article class="post-content">
            <div class="content-wrapper">
                {!! nl2br(e($post->content)) !!}
            </div>

            <!-- Post Metadata -->
            @if($post->metadata && count($post->metadata) > 0)
                <div class="post-metadata">
                    <h3>📋 Additional Information</h3>
                    <div class="metadata-grid">
                        @foreach($post->metadata as $key => $value)
                            @if($value)
                                <div class="metadata-item">
                                    <span class="metadata-label">{{ ucwords(str_replace('_', ' ', $key)) }}:</span>
                                    <span class="metadata-value">{{ $value }}</span>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            @endif
        </article>

        <!-- Related Posts -->
        @if($relatedPosts->count() > 0)
            <section class="related-posts">
                <h2>🔗 Related {{ ucfirst($post->type) }} Posts</h2>
                <div class="related-grid">
                    @foreach($relatedPosts as $relatedPost)
                        <article class="related-card">
                            @if($relatedPost->featured_image)
                                <div class="related-image">
                                    <img src="{{ asset('storage/' . $relatedPost->featured_image) }}" alt="{{ $relatedPost->title }}">
                                </div>
                            @endif
                            <div class="related-content">
                                <div class="related-meta">
                                    <span class="related-date">{{ $relatedPost->published_at->format('M j, Y') }}</span>
                                </div>
                                <h3 class="related-title">
                                    <a href="{{ route('posts.show', $relatedPost->slug) }}">{{ $relatedPost->title }}</a>
                                </h3>
                                <p class="related-excerpt">{{ Str::limit($relatedPost->excerpt, 80) }}</p>
                            </div>
                        </article>
                    @endforeach
                </div>
            </section>
        @endif

        <!-- Navigation -->
        <div class="post-navigation">
            <a href="{{ route('posts.index') }}" class="btn-secondary">
                ← Back to All Posts
            </a>
            <a href="{{ route('posts.index', ['type' => $post->type]) }}" class="btn-primary">
                More {{ ucfirst($post->type) }} Posts →
            </a>
        </div>
    </div>
</div>

<style>
.post-detail {
    padding: 2rem 0 4rem;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    min-height: 100vh;
    color: #e2e8f0;
}

.breadcrumb {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 2rem;
    color: #94a3b8;
    font-size: 0.9rem;
}

.breadcrumb a {
    color: #94a3b8;
    text-decoration: none;
    transition: color 0.3s ease;
}

.breadcrumb a:hover {
    color: #39FF14;
}

.breadcrumb span:last-child {
    color: #e2e8f0;
    font-weight: 500;
}

.post-header {
    margin-bottom: 3rem;
    text-align: center;
}

.post-meta {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 1.5rem;
    margin-bottom: 1.5rem;
    flex-wrap: wrap;
}

.post-type {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 600;
}

.type-blog { background: rgba(59, 130, 246, 0.2); color: #3b82f6; }
.type-news { background: rgba(16, 185, 129, 0.2); color: #10b981; }
.type-highlight { background: rgba(245, 158, 11, 0.2); color: #f59e0b; }
.type-tournament { background: rgba(139, 92, 246, 0.2); color: #8b5cf6; }
.type-update { background: rgba(236, 72, 153, 0.2); color: #ec4899; }

.post-date {
    color: #94a3b8;
    font-weight: 500;
}

.post-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #e2e8f0;
    margin: 0 0 2rem 0;
    line-height: 1.2;
    max-width: 800px;
    margin-left: auto;
    margin-right: auto;
}

.post-info {
    display: flex;
    justify-content: space-between;
    align-items: center;
    max-width: 600px;
    margin: 0 auto;
    padding: 1.5rem;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
}

.author-info {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.author-avatar {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #ff6600, #cc5500);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 700;
    font-size: 1.2rem;
}

.author-details {
    display: flex;
    flex-direction: column;
}

.author-name {
    color: #e2e8f0;
    font-weight: 600;
    font-size: 1.1rem;
}

.author-title {
    color: #94a3b8;
    font-size: 0.9rem;
}

.post-stats {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
    text-align: right;
    color: #94a3b8;
    font-size: 0.9rem;
}

.featured-image {
    margin-bottom: 3rem;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
}

.featured-image img {
    width: 100%;
    height: auto;
    display: block;
}

.post-content {
    max-width: 800px;
    margin: 0 auto 4rem auto;
}

.content-wrapper {
    background: rgba(255, 255, 255, 0.03);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 16px;
    padding: 3rem;
    font-size: 1.1rem;
    line-height: 1.8;
    color: #e2e8f0;
}

.content-wrapper p {
    margin-bottom: 1.5rem;
}

.post-metadata {
    margin-top: 3rem;
    padding: 2rem;
    background: rgba(255, 102, 0, 0.05);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 12px;
}

.post-metadata h3 {
    color: #ff6600;
    margin-bottom: 1.5rem;
    font-size: 1.3rem;
}

.metadata-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1rem;
}

.metadata-item {
    display: flex;
    justify-content: space-between;
    padding: 0.75rem 1rem;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
}

.metadata-label {
    color: #94a3b8;
    font-weight: 500;
}

.metadata-value {
    color: #e2e8f0;
    font-weight: 600;
}

.related-posts {
    margin-bottom: 4rem;
}

.related-posts h2 {
    color: #ff6600;
    margin-bottom: 2rem;
    font-size: 1.8rem;
    text-align: center;
}

.related-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
}

.related-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    overflow: hidden;
    transition: all 0.3s ease;
}

.related-card:hover {
    transform: translateY(-5px);
    border-color: rgba(255, 102, 0, 0.3);
}

.related-image {
    aspect-ratio: 16/9;
    overflow: hidden;
}

.related-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
}

.related-card:hover .related-image img {
    transform: scale(1.05);
}

.related-content {
    padding: 1.5rem;
}

.related-meta {
    margin-bottom: 1rem;
}

.related-date {
    color: #94a3b8;
    font-size: 0.9rem;
}

.related-title {
    margin: 0 0 1rem 0;
}

.related-title a {
    color: #e2e8f0;
    text-decoration: none;
    font-size: 1.1rem;
    font-weight: 600;
    transition: color 0.3s ease;
}

.related-title a:hover {
    color: #ff6600;
}

.related-excerpt {
    color: #94a3b8;
    line-height: 1.6;
    margin: 0;
}

.post-navigation {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 2rem;
    max-width: 600px;
    margin: 0 auto;
}

.btn-secondary,
.btn-primary {
    padding: 0.75rem 2rem;
    border-radius: 25px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.1);
    color: #e2e8f0;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
}

.btn-primary {
    background: linear-gradient(135deg, #ff6600, #cc5500);
    color: white;
    border: none;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 102, 0, 0.3);
}

@media (max-width: 768px) {
    .post-title {
        font-size: 2rem;
    }
    
    .post-info {
        flex-direction: column;
        gap: 1.5rem;
        text-align: center;
    }
    
    .post-stats {
        text-align: center;
    }
    
    .content-wrapper {
        padding: 2rem 1.5rem;
        font-size: 1rem;
    }
    
    .post-navigation {
        flex-direction: column;
    }
    
    .metadata-grid {
        grid-template-columns: 1fr;
    }
    
    .related-grid {
        grid-template-columns: 1fr;
    }
}
</style>
@endsection