@extends('layouts.app')

@section('title', 'My Profile')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Success Message -->
    @if(session('success'))
        <div class="bg-green-500/20 border border-green-500 text-green-400 px-4 py-3 rounded mb-6">
            {{ session('success') }}
        </div>
    @endif

    <!-- Profile Header -->
    <div class="bg-cod-gray rounded-lg p-8 mb-8 gaming-glow">
        <div class="flex flex-col md:flex-row md:items-center md:space-x-8">
            <!-- Avatar -->
            <div class="text-center md:text-left mb-6 md:mb-0">
                <form id="avatar-form" enctype="multipart/form-data">
                    @csrf
                    <div class="relative">
                        @if(auth()->user()->avatar_url)
                            <img src="{{ Storage::url(auth()->user()->avatar_url) }}" 
                                 alt="Avatar" 
                                 class="w-32 h-32 rounded-full object-cover mx-auto md:mx-0 mb-4 gaming-glow">
                        @else
                            <div class="w-32 h-32 bg-cod-green rounded-full flex items-center justify-center mx-auto md:mx-0 mb-4 gaming-glow">
                                <span class="text-5xl font-bold text-black">{{ substr(auth()->user()->username, 0, 1) }}</span>
                            </div>
                        @endif
                        <input type="file" id="avatar-input" name="avatar" accept="image/*" class="hidden">
                    </div>
                </form>
                <button onclick="document.getElementById('avatar-input').click()" 
                        class="text-cod-green hover:text-green-400 text-sm font-medium">
                    Change Avatar
                </button>
            </div>

            <!-- Profile Info -->
            <div class="flex-1">
                <h1 class="text-3xl font-gaming font-bold text-cod-green mb-2">{{ auth()->user()->username }}</h1>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-center md:text-left">
                    <div>
                        <div class="text-2xl font-bold text-gray-100">{{ auth()->user()->level }}</div>
                        <div class="text-sm text-gray-400">Level</div>
                    </div>
                    <div>
                        <div class="text-2xl font-bold text-cod-green">{{ number_format(auth()->user()->xp) }}</div>
                        <div class="text-sm text-gray-400">XP</div>
                    </div>
                    <div>
                        <div class="text-2xl font-bold text-green-400">{{ auth()->user()->createdChallenges()->where('result', 'creator_win')->count() + auth()->user()->acceptedChallenges()->where('result', 'accepter_win')->count() }}</div>
                        <div class="text-sm text-gray-400">Wins</div>
                    </div>
                    <div>
                        <div class="text-2xl font-bold text-gray-100">{{ number_format(auth()->user()->agreement_rate * 100, 1) }}%</div>
                        <div class="text-sm text-gray-400">Agreement Rate</div>
                    </div>
                </div>

                <!-- XP Progress -->
                @php
                    $currentLevel = auth()->user()->getCurrentLevel();
                    $nextLevel = auth()->user()->getNextLevel();
                @endphp
                @if($nextLevel)
                    <div class="mt-4">
                        <div class="flex justify-between text-sm text-gray-400 mb-1">
                            <span>{{ $currentLevel->name ?? 'Unknown' }}</span>
                            <span>{{ $nextLevel->name }} ({{ number_format($nextLevel->min_xp - auth()->user()->xp) }} XP needed)</span>
                        </div>
                        <div class="w-full bg-gray-700 rounded-full h-2">
                            @php
                                $progress = $currentLevel ? 
                                    (auth()->user()->xp - $currentLevel->min_xp) / ($nextLevel->min_xp - $currentLevel->min_xp) * 100 : 0;
                            @endphp
                            <div class="bg-cod-green h-2 rounded-full" style="width: {{ min(100, max(0, $progress)) }}%"></div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Account Settings -->
        <div class="bg-cod-gray rounded-xl p-6 border border-cod-green/20">
            <h2 class="text-xl font-semibold text-cod-green mb-6 flex items-center space-x-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                </svg>
                <span>Account Settings</span>
            </h2>
            
            <form method="POST" action="{{ route('profile.update') }}" class="space-y-6">
                @csrf
                @method('PUT')
                
                <!-- Username with Floating Label -->
                <div class="floating-label-group">
                    <input type="text" 
                           id="username" 
                           name="username"
                           value="{{ old('username', auth()->user()->username) }}"
                           required
                           placeholder="Your username"
                           class="floating-label-input {{ $errors->has('username') ? 'form-error' : '' }}">
                    <label for="username" class="floating-label">Username *</label>
                    @error('username')
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>{{ $message }}</span>
                        </div>
                    @enderror
                </div>

                <!-- Email with Floating Label -->
                <div class="floating-label-group">
                    <input type="email" 
                           id="email" 
                           name="email"
                           value="{{ old('email', auth()->user()->email) }}"
                           required
                           placeholder="your.email@example.com"
                           class="floating-label-input {{ $errors->has('email') ? 'form-error' : '' }}">
                    <label for="email" class="floating-label">Email Address *</label>
                    @error('email')
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>{{ $message }}</span>
                        </div>
                    @enderror
                </div>

                <!-- Phone with Floating Label -->
                <div class="floating-label-group">
                    <input type="tel" 
                           id="phone" 
                           name="phone"
                           value="{{ old('phone', auth()->user()->phone) }}"
                           placeholder="+234 801 234 5678"
                           class="floating-label-input {{ $errors->has('phone') ? 'form-error' : '' }}">
                    <label for="phone" class="floating-label">Phone Number</label>
                    @error('phone')
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>{{ $message }}</span>
                        </div>
                    @enderror
                    <div class="text-xs text-gray-400 mt-1">
                        Used for account verification and security
                    </div>
                </div>

                <!-- Save Button -->
                <button type="submit" class="btn-primary-modern w-full">
                    <span class="flex items-center justify-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        <span>Update Profile</span>
                    </span>
                </button>
            </form>
        </div>
                    <label for="phone" class="block text-sm font-medium text-gray-300 mb-2">Phone Number</label>
                    <input type="tel" 
                           id="phone" 
                           name="phone"
                           value="{{ old('phone', auth()->user()->phone) }}"
                           placeholder="+1 234 567 8900"
                           class="w-full px-4 py-3 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
                    @error('phone')
                        <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="kyc_status" class="block text-sm font-medium text-gray-300 mb-2">KYC Status</label>
                    <div class="flex items-center space-x-2">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                            @if(auth()->user()->kyc_status === 'verified') bg-green-500/20 text-green-400
                            @elseif(auth()->user()->kyc_status === 'pending') bg-yellow-500/20 text-yellow-400
                            @else bg-red-500/20 text-red-400 @endif">
                            {{ ucfirst(auth()->user()->kyc_status) }}
                        </span>
                        @if(auth()->user()->kyc_status !== 'verified')
                            <button type="button" class="text-cod-green hover:text-green-400 text-sm font-medium">
                                Verify Now
                            </button>
                        @endif
                    </div>
                </div>

                <div class="pt-4">
                    <button type="submit" class="w-full bg-cod-green text-black px-4 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                        Update Profile
                    </button>
                </div>
            </form>
        </div>

        <!-- Recent Activity -->
        <div class="bg-cod-gray rounded-lg p-6">
            <h2 class="text-xl font-semibold text-cod-green mb-6">Recent Activity</h2>
            
            @php
                $recentChallenges = auth()->user()->createdChallenges()
                    ->orWhere(function($query) {
                        $query->where('accepter_id', auth()->id());
                    })
                    ->latest()
                    ->limit(5)
                    ->get();
            @endphp

            @if($recentChallenges->count() > 0)
                <div class="space-y-4">
                    @foreach($recentChallenges as $challenge)
                        <div class="bg-cod-dark rounded-lg p-4">
                            <div class="flex items-center justify-between">
                                <div>
                                    <h3 class="font-semibold text-gray-100">{{ $challenge->game->name }}</h3>
                                    <div class="text-sm text-gray-400">
                                        vs {{ $challenge->creator_id === auth()->id() ? ($challenge->accepter->username ?? 'Waiting...') : $challenge->creator->username }}
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="text-sm font-semibold 
                                        @if($challenge->status === 'completed' && $challenge->getWinner()?->id === auth()->id()) text-green-400
                                        @elseif($challenge->status === 'completed') text-red-400
                                        @elseif($challenge->status === 'disputed') text-yellow-400
                                        @else text-gray-400 @endif">
                                        @if($challenge->status === 'completed' && $challenge->getWinner()?->id === auth()->id())
                                            Won
                                        @elseif($challenge->status === 'completed')
                                            Lost
                                        @else
                                            {{ ucfirst($challenge->status) }}
                                        @endif
                                    </div>
                                    <div class="text-xs text-gray-500">{{ $challenge->created_at->diffForHumans() }}</div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-8">
                    <div class="text-4xl mb-2">🎮</div>
                    <p class="text-gray-400">No recent activity</p>
                    <a href="{{ route('challenges.index') }}" class="inline-block mt-4 text-cod-green hover:text-green-400 font-medium">
                        Start Your First Challenge
                    </a>
                </div>
            @endif
        </div>
    </div>

    <!-- Security Settings -->
    <div class="bg-cod-gray rounded-xl p-6 mt-8 border border-cod-green/20">
        <h2 class="text-xl font-semibold text-cod-green mb-6 flex items-center space-x-2">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
            </svg>
            <span>Security Settings</span>
        </h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div>
                <h3 class="font-medium text-gray-300 mb-4 flex items-center space-x-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"></path>
                    </svg>
                    <span>Change Password</span>
                </h3>
                <form method="POST" action="{{ route('profile.password') }}" class="space-y-4">
                    @csrf
                    @method('PUT')
                    
                    <!-- Current Password -->
                    <div class="floating-label-group">
                        <input type="password" 
                               id="current_password"
                               name="current_password"
                               required
                               placeholder="Enter your current password"
                               class="floating-label-input {{ $errors->has('current_password') ? 'form-error' : '' }}">
                        <label for="current_password" class="floating-label">Current Password *</label>
                        @error('current_password')
                            <div class="error-message">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span>{{ $message }}</span>
                            </div>
                        @enderror
                    </div>
                    
                    <!-- New Password -->
                    <div class="floating-label-group">
                        <input type="password" 
                               id="new_password"
                               name="password"
                               required
                               placeholder="Create a new strong password"
                               class="floating-label-input {{ $errors->has('password') ? 'form-error' : '' }}">
                        <label for="new_password" class="floating-label">New Password *</label>
                        @error('password')
                            <div class="error-message">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span>{{ $message }}</span>
                            </div>
                        @enderror
                        <div class="text-xs text-gray-400 mt-1">
                            Minimum 8 characters with letters and numbers
                        </div>
                    </div>
                    
                    <!-- Confirm Password -->
                    <div class="floating-label-group">
                        <input type="password" 
                               id="password_confirmation"
                               name="password_confirmation"
                               required
                               placeholder="Confirm your new password"
                               class="floating-label-input">
                        <label for="password_confirmation" class="floating-label">Confirm New Password *</label>
                    </div>
                    
                    <button type="submit" class="btn-secondary-modern w-full">
                        <span class="flex items-center justify-center space-x-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"></path>
                            </svg>
                            <span>Update Password</span>
                        </span>
                    </button>
                </form>
            </div>
            <div>
                <h3 class="font-medium text-gray-300 mb-4 flex items-center space-x-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    <span>Account Actions</span>
                </h3>
                <div class="space-y-4">
                    <button onclick="downloadUserData()" class="w-full btn-secondary-modern text-left">
                        <span class="flex items-center space-x-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <span>Download My Data</span>
                        </span>
                    </button>
                    
                    <button onclick="confirmDeactivation()" class="w-full bg-red-600 hover:bg-red-700 text-white font-medium py-3 px-4 rounded-lg transition-all duration-200 flex items-center justify-center space-x-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                        </svg>
                        <span>Deactivate Account</span>
                    </button>
                    
                    <div class="bg-cod-dark/50 rounded-lg p-3 border border-cod-green/10">
                        <div class="text-xs text-gray-400">
                            <div class="font-medium text-cod-green mb-1">🛡️ Account Security</div>
                            <div>• Change your password regularly</div>
                            <div>• Use a strong, unique password</div>
                            <div>• Download your data before deactivating</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Avatar upload handling
document.getElementById('avatar-input').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const formData = new FormData();
        formData.append('avatar', file);
        formData.append('_token', '{{ csrf_token() }}');

        fetch('{{ route('profile.avatar') }}', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error uploading avatar');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error uploading avatar');
        });
    }
});

// Enhanced form validation
document.addEventListener('DOMContentLoaded', function() {
    const forms = document.querySelectorAll('form');
    
    forms.forEach(form => {
        const inputs = form.querySelectorAll('input[type="text"], input[type="email"], input[type="password"], input[type="tel"]');
        const passwordInput = form.querySelector('input[name="password"]');
        const confirmPasswordInput = form.querySelector('input[name="password_confirmation"]');

        inputs.forEach(input => {
            input.addEventListener('blur', function() {
                validateField(this);
            });

            input.addEventListener('input', function() {
                if (this.classList.contains('form-error')) {
                    validateField(this);
                }
                
                // Real-time password confirmation check
                if (this === confirmPasswordInput && passwordInput && passwordInput.value) {
                    validatePasswordMatch();
                }
            });
        });

        function validateField(field) {
            const value = field.value.trim();
            const isRequired = field.hasAttribute('required');

            // Remove existing validation classes
            field.classList.remove('form-error', 'form-success');

            if (isRequired && !value) {
                field.classList.add('form-error');
            } else if (value) {
                // Specific validation rules
                if (field.type === 'email' && !isValidEmail(value)) {
                    field.classList.add('form-error');
                } else if (field.name === 'password' && value.length < 8) {
                    field.classList.add('form-error');
                } else {
                    field.classList.add('form-success');
                }
            }
        }

        function validatePasswordMatch() {
            if (passwordInput && confirmPasswordInput && passwordInput.value !== confirmPasswordInput.value) {
                confirmPasswordInput.classList.remove('form-success');
                confirmPasswordInput.classList.add('form-error');
            } else if (confirmPasswordInput) {
                confirmPasswordInput.classList.remove('form-error');
                confirmPasswordInput.classList.add('form-success');
            }
        }

        function isValidEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }
    });
});

// Account actions
function downloadUserData() {
    if (confirm('This will prepare your data for download. You will receive an email when it\'s ready. Continue?')) {
        // Implement data download request
        fetch('{{ route('profile.download-data') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Data download request submitted. You will receive an email when it\'s ready.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error processing request');
        });
    }
}

function confirmDeactivation() {
    if (confirm('⚠️ WARNING: This will permanently deactivate your account!\n\nAll your challenges, tournaments, and data will be removed.\n\nThis action cannot be undone. Are you absolutely sure?')) {
        if (confirm('Final confirmation: Type "DELETE" to proceed with account deactivation.')) {
            const confirmation = prompt('Type "DELETE" to confirm:');
            if (confirmation === 'DELETE') {
                // Implement account deactivation
                window.location.href = '{{ route('profile.deactivate') }}';
            } else {
                alert('Account deactivation cancelled.');
            }
        }
    }
}
</script>
@endsection