@extends('layouts.app')

@section('title', 'About Us - ' . ($platformSettings['platform_name'] ?? 'Gaming Platform'))

@section('content')
<div class="static-page about-us">
    <div class="container">
        <!-- Hero Section -->
        <div class="hero-section">
            <div class="hero-content">
                <h1>🎮 About {{ $platformSettings['platform_name'] ?? 'Agamec' }}</h1>
                <p class="hero-subtitle">The Ultimate Competitive Gaming Platform</p>
                <p class="hero-description">
                    Where skill meets opportunity. Challenge players worldwide, compete in tournaments, 
                    and turn your gaming expertise into real rewards through our innovative gaming ecosystem.
                </p>
            </div>
            <div class="hero-stats">
                <div class="stat-item">
                    <h3>10,000+</h3>
                    <p>Active Players</p>
                </div>
                <div class="stat-item">
                    <h3>₦50M+</h3>
                    <p>Prize Pool Distributed</p>
                </div>
                <div class="stat-item">
                    <h3>4</h3>
                    <p>Payment Gateways</p>
                </div>
                <div class="stat-item">
                    <h3>24/7</h3>
                    <p>Multi-Channel Support</p>
                </div>
                <div class="stat-item">
                    <h3>100%</h3>
                    <p>Mobile Optimized</p>
                </div>
            </div>
        </div>

        <!-- Mission Section -->
        <div class="content-section">
            <div class="section-grid">
                <div class="section-content">
                    <h2>🎯 Our Mission</h2>
                    <p>
                        To create the most trusted and exciting competitive gaming platform where players 
                        can showcase their skills, build their reputation, and earn real rewards through 
                        fair and transparent competitions.
                    </p>
                    <p>
                        We believe that gaming is more than entertainment—it's a skill, an art, and a 
                        pathway to achievement. Our platform empowers gamers to monetize their talents 
                        while fostering a vibrant community of competitive players.
                    </p>
                    <p>
                        With our recent platform overhaul, we've introduced cutting-edge mobile navigation, 
                        multiple payment gateways, dynamic branding capabilities, and comprehensive notification 
                        systems to deliver the ultimate gaming experience.
                    </p>
                </div>
                <div class="section-image">
                    <div class="mission-icon">🏆</div>
                </div>
            </div>
        </div>

        <!-- Platform Features Section -->
        <div class="features-section">
            <h2>🚀 Platform Innovations</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">📱</div>
                    <h3>Mobile-First Experience</h3>
                    <p>Advanced mobile navigation with hamburger menu, bottom navigation bar, and touch-optimized interface for seamless gaming on the go.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">💳</div>
                    <h3>4 Payment Gateways</h3>
                    <p>Complete integration with Paystack, Flutterwave, PayPal, and Stripe for secure deposits, withdrawals, and instant payouts worldwide.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">✨</div>
                    <h3>Floating Label Forms</h3>
                    <p>Modern form design with floating labels, real-time validation, quick selection buttons, and enhanced user experience across all interactions.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🔔</div>
                    <h3>Smart Notifications</h3>
                    <p>Complete notification system with email (SMTP, SendGrid, Mailgun) and SMS (Termii, Twilio, Nexmo) for tournament invites and updates.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🎨</div>
                    <h3>Dynamic Branding</h3>
                    <p>Complete white-label solution allowing custom platform names, logos, and branding throughout the entire user experience.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🛡️</div>
                    <h3>Enhanced Security</h3>
                    <p>Role-based access control with enum-based permissions, secure API endpoints, and comprehensive user verification systems.</p>
                </div>
            </div>
        </div>

        <!-- Features Section -->
        <div class="features-section">
            <h2>⚡ What Makes Us Different</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">🔒</div>
                    <h3>Secure Transactions</h3>
                    <p>Advanced security measures and escrow system with 4 payment gateways ensure safe handling of all funds and disputes.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">⚖️</div>
                    <h3>Fair Play System</h3>
                    <p>Sophisticated anti-cheat detection and dispute resolution system with role-based access control maintains competitive integrity.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🌍</div>
                    <h3>Global Community</h3>
                    <p>Connect with players worldwide across multiple games and skill levels with multi-channel notification support.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">💰</div>
                    <h3>Real Rewards</h3>
                    <p>Earn actual money through challenges and tournaments with instant payouts via Paystack, Flutterwave, PayPal, and Stripe.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">📊</div>
                    <h3>Performance Tracking</h3>
                    <p>Detailed statistics and leaderboards with animated dashboard cards help you track your progress and ranking.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🎖️</div>
                    <h3>Achievement System</h3>
                    <p>Unlock badges, titles, and recognition as you climb the competitive ladder with our enhanced user experience.</p>
                </div>
            </div>
        </div>

        <!-- Values Section -->
        <div class="values-section">
            <h2>💎 Our Core Values</h2>
            <div class="values-grid">
                <div class="value-item">
                    <div class="value-icon">🛡️</div>
                    <h3>Integrity</h3>
                    <p>We maintain the highest standards of fairness and transparency in all competitions.</p>
                </div>
                <div class="value-item">
                    <div class="value-icon">🚀</div>
                    <h3>Innovation</h3>
                    <p>Continuously evolving our platform with cutting-edge features and technologies.</p>
                </div>
                <div class="value-item">
                    <div class="value-icon">🤝</div>
                    <h3>Community</h3>
                    <p>Building strong relationships and fostering a supportive competitive environment.</p>
                </div>
                <div class="value-item">
                    <div class="value-icon">🎯</div>
                    <h3>Excellence</h3>
                    <p>Striving for perfection in every aspect of the gaming experience we provide.</p>
                </div>
            </div>
        </div>

        <!-- Team Section -->
        <div class="team-section">
            <h2>👥 Leadership Team</h2>
            <div class="team-grid">
                <div class="team-member">
                    <div class="member-avatar">🎮</div>
                    <h3>Alex Johnson</h3>
                    <p class="member-title">CEO & Founder</p>
                    <p class="member-bio">
                        Former professional esports player with 10+ years in competitive gaming and platform development.
                    </p>
                </div>
                <div class="team-member">
                    <div class="member-avatar">💻</div>
                    <h3>Sarah Chen</h3>
                    <p class="member-title">CTO</p>
                    <p class="member-bio">
                        Technology leader with expertise in scalable gaming platforms and anti-cheat systems.
                    </p>
                </div>
                <div class="team-member">
                    <div class="member-avatar">📊</div>
                    <h3>Marcus Williams</h3>
                    <p class="member-title">Head of Operations</p>
                    <p class="member-bio">
                        Operations expert focused on community management and tournament organization.
                    </p>
                </div>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="cta-section">
            <div class="cta-content">
                <h2>🚀 Ready to Start Your Journey?</h2>
                <p>Join thousands of gamers who are already earning through competitive play.</p>
                <div class="cta-buttons">
                    <a href="{{ route('register') }}" class="btn-primary">Get Started Today</a>
                    <a href="{{ route('contact-us') }}" class="btn-secondary">Contact Us</a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.static-page {
    padding: 2rem 0;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    min-height: 100vh;
}

.hero-section {
    text-align: center;
    padding: 4rem 0;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 20px;
    margin-bottom: 4rem;
    border: 1px solid rgba(255, 102, 0, 0.2);
}

.hero-content h1 {
    font-size: 3.5rem;
    color: #ff6600;
    margin: 0 0 1rem 0;
    font-weight: 700;
}

.hero-subtitle {
    font-size: 1.5rem;
    color: #e2e8f0;
    margin: 0 0 2rem 0;
    font-weight: 600;
}

.hero-description {
    font-size: 1.2rem;
    color: #94a3b8;
    max-width: 800px;
    margin: 0 auto 3rem auto;
    line-height: 1.6;
}

.hero-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 2rem;
    max-width: 800px;
    margin: 0 auto;
}

.stat-item {
    background: rgba(255, 102, 0, 0.1);
    border: 1px solid rgba(255, 102, 0, 0.3);
    border-radius: 15px;
    padding: 2rem;
}

.stat-item h3 {
    font-size: 2.5rem;
    color: #ff6600;
    margin: 0 0 0.5rem 0;
    font-weight: 700;
}

.stat-item p {
    color: #e2e8f0;
    margin: 0;
    font-weight: 600;
}

.content-section {
    margin-bottom: 4rem;
}

.section-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 3rem;
    align-items: center;
}

.section-content h2 {
    font-size: 2.5rem;
    color: #ff6600;
    margin: 0 0 2rem 0;
    font-weight: 700;
}

.section-content p {
    font-size: 1.1rem;
    color: #94a3b8;
    line-height: 1.8;
    margin-bottom: 1.5rem;
}

.section-image {
    display: flex;
    justify-content: center;
    align-items: center;
}

.mission-icon {
    font-size: 8rem;
    background: linear-gradient(135deg, #ff6600, #e55a00);
    border-radius: 50%;
    width: 200px;
    height: 200px;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 20px 60px rgba(255, 102, 0, 0.3);
}

.features-section {
    margin-bottom: 4rem;
}

.features-section h2 {
    font-size: 2.5rem;
    color: #ff6600;
    text-align: center;
    margin: 0 0 3rem 0;
    font-weight: 700;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
}

.feature-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 15px;
    padding: 2rem;
    text-align: center;
    transition: all 0.3s ease;
}

.feature-card:hover {
    border-color: #ff6600;
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(255, 102, 0, 0.2);
}

.feature-icon {
    font-size: 3rem;
    margin-bottom: 1rem;
}

.feature-card h3 {
    color: #e2e8f0;
    font-size: 1.3rem;
    margin: 0 0 1rem 0;
    font-weight: 600;
}

.feature-card p {
    color: #94a3b8;
    line-height: 1.6;
    margin: 0;
}

.values-section {
    margin-bottom: 4rem;
}

.values-section h2 {
    font-size: 2.5rem;
    color: #ff6600;
    text-align: center;
    margin: 0 0 3rem 0;
    font-weight: 700;
}

.values-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
}

.value-item {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 15px;
    padding: 2rem;
    text-align: center;
    transition: all 0.3s ease;
}

.value-item:hover {
    border-color: #ff6600;
    transform: translateY(-3px);
}

.value-icon {
    font-size: 3rem;
    margin-bottom: 1rem;
}

.value-item h3 {
    color: #e2e8f0;
    font-size: 1.2rem;
    margin: 0 0 1rem 0;
    font-weight: 600;
}

.value-item p {
    color: #94a3b8;
    line-height: 1.6;
    margin: 0;
}

.team-section {
    margin-bottom: 4rem;
}

.team-section h2 {
    font-size: 2.5rem;
    color: #ff6600;
    text-align: center;
    margin: 0 0 3rem 0;
    font-weight: 700;
}

.team-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
}

.team-member {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 15px;
    padding: 2rem;
    text-align: center;
    transition: all 0.3s ease;
}

.team-member:hover {
    border-color: #ff6600;
    transform: translateY(-5px);
}

.member-avatar {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #ff6600, #e55a00);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    margin: 0 auto 1rem auto;
}

.team-member h3 {
    color: #e2e8f0;
    font-size: 1.3rem;
    margin: 0 0 0.5rem 0;
    font-weight: 600;
}

.member-title {
    color: #ff6600;
    font-weight: 600;
    margin: 0 0 1rem 0;
    font-size: 1rem;
}

.member-bio {
    color: #94a3b8;
    line-height: 1.6;
    margin: 0;
}

.cta-section {
    background: rgba(255, 102, 0, 0.1);
    border: 1px solid rgba(255, 102, 0, 0.3);
    border-radius: 20px;
    padding: 4rem 2rem;
    text-align: center;
}

.cta-content h2 {
    font-size: 2.5rem;
    color: #ff6600;
    margin: 0 0 1rem 0;
    font-weight: 700;
}

.cta-content p {
    font-size: 1.2rem;
    color: #94a3b8;
    margin: 0 0 2rem 0;
}

.cta-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-primary, .btn-secondary {
    padding: 1rem 2rem;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    font-size: 1.1rem;
    transition: all 0.3s ease;
    border: 1px solid;
}

.btn-primary {
    background: linear-gradient(135deg, #ff6600, #e55a00);
    color: #ffffff;
    border-color: transparent;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 102, 0, 0.4);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.1);
    color: #e2e8f0;
    border-color: #e2e8f0;
}

.btn-secondary:hover {
    background: #e2e8f0;
    color: #1a1a2e;
    transform: translateY(-2px);
}

@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }
    
    .hero-subtitle {
        font-size: 1.2rem;
    }
    
    .hero-description {
        font-size: 1rem;
    }
    
    .section-grid {
        grid-template-columns: 1fr;
        text-align: center;
    }
    
    .mission-icon {
        font-size: 6rem;
        width: 150px;
        height: 150px;
    }
    
    .hero-stats {
        grid-template-columns: 1fr;
    }
    
    .features-grid {
        grid-template-columns: 1fr;
    }
    
    .values-grid {
        grid-template-columns: 1fr;
    }
    
    .team-grid {
        grid-template-columns: 1fr;
    }
    
    .cta-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .btn-primary, .btn-secondary {
        width: 100%;
        max-width: 300px;
    }
}
</style>
@endsection