@extends('layouts.app')

@section('title', 'Contact Us - ' . ($platformSettings['platform_name'] ?? 'Gaming Platform'))

@section('content')
<div class="static-page contact-us">
    <div class="container">
        <!-- Header Section -->
        <div class="page-header">
            <h1>📞 Contact {{ $platformSettings['platform_name'] ?? 'Us' }}</h1>
            <p>Get in touch with our team. We're here to help with our mobile-optimized platform, payment solutions, and gaming features!</p>
        </div>

        @if(session('success'))
            <div class="alert alert-success">
                <i class="icon">✅</i>
                {{ session('success') }}
            </div>
        @endif

        @if($errors->any())
            <div class="alert alert-error">
                <i class="icon">❌</i>
                Please correct the errors below and try again.
            </div>
        @endif

        <div class="contact-grid">
            <!-- Contact Form -->
            <div class="contact-form-section">
                <div class="form-header">
                    <h2>💬 Send us a Message</h2>
                    <p>Fill out our modern floating label form below and we'll get back to you through our multi-channel notification system.</p>
                </div>

                <form method="POST" action="{{ route('contact-us.submit') }}" class="contact-form floating-labels">
                    @csrf
                    
                    <div class="form-row">
                        <div class="form-group floating-label">
                            <input type="text" name="name" id="name" value="{{ old('name') }}" required placeholder=" ">
                            <label for="name">Full Name *</label>
                            @error('name')
                                <span class="error-text">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group floating-label">
                            <input type="email" name="email" id="email" value="{{ old('email') }}" required placeholder=" ">
                            <label for="email">Email Address *</label>
                            @error('email')
                                <span class="error-text">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group floating-label">
                        <select name="subject" id="subject" required>
                            <option value="">Select a subject</option>
                            <option value="General Inquiry" {{ old('subject') === 'General Inquiry' ? 'selected' : '' }}>General Inquiry</option>
                            <option value="Technical Support" {{ old('subject') === 'Technical Support' ? 'selected' : '' }}>Technical Support</option>
                            <option value="Account Issues" {{ old('subject') === 'Account Issues' ? 'selected' : '' }}>Account Issues</option>
                            <option value="Payment/Wallet" {{ old('subject') === 'Payment/Wallet' ? 'selected' : '' }}>Payment/Wallet Issues</option>
                            <option value="Mobile App" {{ old('subject') === 'Mobile App' ? 'selected' : '' }}>Mobile Navigation Issues</option>
                            <option value="Payment Gateways" {{ old('subject') === 'Payment Gateways' ? 'selected' : '' }}>Payment Gateway Support</option>
                            <option value="Notifications" {{ old('subject') === 'Notifications' ? 'selected' : '' }}>Notification Settings</option>
                            <option value="KYC Verification" {{ old('subject') === 'KYC Verification' ? 'selected' : '' }}>KYC Verification</option>
                            <option value="Dispute Resolution" {{ old('subject') === 'Dispute Resolution' ? 'selected' : '' }}>Dispute Resolution</option>
                            <option value="White Label" {{ old('subject') === 'White Label' ? 'selected' : '' }}>White Label Solutions</option>
                            <option value="Partnership" {{ old('subject') === 'Partnership' ? 'selected' : '' }}>Partnership</option>
                            <option value="Media/Press" {{ old('subject') === 'Media/Press' ? 'selected' : '' }}>Media/Press</option>
                            <option value="Other" {{ old('subject') === 'Other' ? 'selected' : '' }}>Other</option>
                        </select>
                        <label for="subject">Subject *</label>
                        @error('subject')
                            <span class="error-text">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group floating-label">
                        <textarea name="message" id="message" rows="6" placeholder=" " required>{{ old('message') }}</textarea>
                        <label for="message">Message *</label>
                        @error('message')
                            <span class="error-text">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn-submit">
                            <i class="icon">📧</i>
                            Send Message
                        </button>
                        <p class="form-note">
                            We respond through our multi-channel notification system within 24 hours.
                        </p>
                    </div>
                </form>
            </div>

            <!-- Contact Information -->
            <div class="contact-info-section">
                <div class="info-card">
                    <h3>🏢 Contact Information</h3>
                    
                    <div class="info-item">
                        <div class="info-icon">📧</div>
                        <div class="info-content">
                            <h4>Email Support</h4>
                            <p>support@{{ strtolower($platformSettings['platform_name'] ?? 'agamec') }}.com</p>
                            <small>SMTP, SendGrid & Mailgun Integration</small>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-icon">📱</div>
                        <div class="info-content">
                            <h4>SMS Notifications</h4>
                            <p>Termii, Twilio & Nexmo</p>
                            <small>Global SMS Support Available</small>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-icon">💳</div>
                        <div class="info-content">
                            <h4>Payment Support</h4>
                            <p>Paystack, Flutterwave, PayPal, Stripe</p>
                            <small>4 Secure Payment Gateways</small>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-icon">🌍</div>
                        <div class="info-content">
                            <h4>Global Reach</h4>
                            <p>Mobile-Optimized Worldwide</p>
                            <small>Cross-Platform Gaming Experience</small>
                        </div>
                    </div>
                </div>

                <div class="info-card">
                    <h3>⚡ Quick Help</h3>
                    
                    <div class="quick-links">
                        <a href="{{ route('faq') }}" class="quick-link">
                            <div class="link-icon">❓</div>
                            <div class="link-content">
                                <h4>FAQ</h4>
                                <p>Find quick answers about new features</p>
                            </div>
                        </a>

                        <a href="{{ route('kyc.index') }}" class="quick-link">
                            <div class="link-icon">🆔</div>
                            <div class="link-content">
                                <h4>KYC Help</h4>
                                <p>Enhanced verification system</p>
                            </div>
                        </a>

                        <a href="{{ route('wallet.index') }}" class="quick-link">
                            <div class="link-icon">💰</div>
                            <div class="link-content">
                                <h4>Wallet Support</h4>
                                <p>Payment issues</p>
                            </div>
                        </a>

                        <a href="{{ route('challenges.index') }}" class="quick-link">
                            <div class="link-icon">⚔️</div>
                            <div class="link-content">
                                <h4>Challenge Help</h4>
                                <p>Gaming support</p>
                            </div>
                        </a>
                    </div>
                </div>

                <div class="info-card">
                    <h3>🕒 Response Times</h3>
                    
                    <div class="response-times">
                        <div class="response-item">
                            <div class="priority high">🔴</div>
                            <div class="response-info">
                                <h4>Critical Issues</h4>
                                <p>Within 2 hours</p>
                                <small>Security, payment, account access</small>
                            </div>
                        </div>

                        <div class="response-item">
                            <div class="priority medium">🟡</div>
                            <div class="response-info">
                                <h4>General Support</h4>
                                <p>Within 24 hours</p>
                                <small>Technical help, features, disputes</small>
                            </div>
                        </div>

                        <div class="response-item">
                            <div class="priority low">🟢</div>
                            <div class="response-info">
                                <h4>General Inquiries</h4>
                                <p>Within 48 hours</p>
                                <small>Questions, feedback, partnerships</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Resources -->
        <div class="resources-section">
            <h2>📚 Additional Resources</h2>
            <div class="resources-grid">
                <div class="resource-card">
                    <div class="resource-icon">📖</div>
                    <h3>User Guide</h3>
                    <p>Complete guide to using our platform effectively</p>
                    <a href="#" class="resource-link">View Guide →</a>
                </div>

                <div class="resource-card">
                    <div class="resource-icon">🛡️</div>
                    <h3>Security Center</h3>
                    <p>Learn about our security measures and best practices</p>
                    <a href="#" class="resource-link">Learn More →</a>
                </div>

                <div class="resource-card">
                    <div class="resource-icon">📊</div>
                    <h3>Platform Status</h3>
                    <p>Real-time status of our services and maintenance</p>
                    <a href="#" class="resource-link">Check Status →</a>
                </div>

                <div class="resource-card">
                    <div class="resource-icon">🎮</div>
                    <h3>Gaming Tips</h3>
                    <p>Strategies and tips to improve your competitive play</p>
                    <a href="#" class="resource-link">Get Tips →</a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.static-page {
    padding: 2rem 0;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    min-height: 100vh;
}

.page-header {
    text-align: center;
    margin-bottom: 3rem;
}

.page-header h1 {
    font-size: 3rem;
    color: #ff6600;
    margin: 0 0 1rem 0;
    font-weight: 700;
}

.page-header p {
    font-size: 1.2rem;
    color: #94a3b8;
    margin: 0;
}

.alert {
    padding: 1rem 1.5rem;
    border-radius: 8px;
    margin-bottom: 2rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    border: 1px solid;
}

.alert-success {
    background: rgba(34, 197, 94, 0.1);
    color: #22c55e;
    border-color: #22c55e;
}

.alert-error {
    background: rgba(239, 68, 68, 0.1);
    color: #ef4444;
    border-color: #ef4444;
}

.contact-grid {
    display: grid;
    grid-template-columns: 1fr 400px;
    gap: 3rem;
    margin-bottom: 4rem;
}

.contact-form-section {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 15px;
    padding: 2rem;
}

.form-header {
    margin-bottom: 2rem;
}

.form-header h2 {
    color: #ff6600;
    font-size: 1.8rem;
    margin: 0 0 0.5rem 0;
    font-weight: 600;
}

.form-header p {
    color: #94a3b8;
    margin: 0;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    display: block;
    color: #e2e8f0;
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.form-group input,
.form-group select,
.form-group textarea {
    width: 100%;
    padding: 0.75rem;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 6px;
    color: #e2e8f0;
    font-size: 1rem;
    transition: border-color 0.3s ease;
}

.form-group input:focus,
.form-group select:focus,
.form-group textarea:focus {
    outline: none;
    border-color: #ff6600;
    box-shadow: 0 0 0 2px rgba(255, 102, 0, 0.2);
}

.form-group select option {
    background: #1a1a2e;
    color: #e2e8f0;
}

.form-group textarea {
    resize: vertical;
    min-height: 120px;
}

.error-text {
    color: #ef4444;
    font-size: 0.8rem;
    display: block;
    margin-top: 0.25rem;
}

.form-actions {
    text-align: center;
    margin-top: 2rem;
}

.btn-submit {
    background: linear-gradient(135deg, #ff6600, #e55a00);
    color: #ffffff;
    border: none;
    padding: 1rem 3rem;
    border-radius: 8px;
    font-size: 1.1rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0 auto 1rem auto;
}

.btn-submit:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 102, 0, 0.3);
}

.form-note {
    color: #94a3b8;
    font-size: 0.9rem;
    margin: 0;
}

.contact-info-section {
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

.info-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 1.5rem;
}

.info-card h3 {
    color: #ff6600;
    font-size: 1.3rem;
    margin: 0 0 1.5rem 0;
    font-weight: 600;
}

.info-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.info-item:last-child {
    margin-bottom: 0;
}

.info-icon {
    font-size: 1.5rem;
    width: 40px;
    text-align: center;
    flex-shrink: 0;
}

.info-content h4 {
    color: #e2e8f0;
    margin: 0 0 0.25rem 0;
    font-size: 1rem;
    font-weight: 600;
}

.info-content p {
    color: #94a3b8;
    margin: 0 0 0.25rem 0;
}

.info-content small {
    color: #64748b;
    font-size: 0.8rem;
}

.quick-links {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.quick-link {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    text-decoration: none;
    transition: all 0.3s ease;
}

.quick-link:hover {
    border-color: #ff6600;
    background: rgba(255, 102, 0, 0.1);
}

.link-icon {
    font-size: 1.5rem;
    width: 40px;
    text-align: center;
}

.link-content h4 {
    color: #e2e8f0;
    margin: 0 0 0.25rem 0;
    font-size: 0.9rem;
    font-weight: 600;
}

.link-content p {
    color: #94a3b8;
    margin: 0;
    font-size: 0.8rem;
}

.response-times {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.response-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
}

.priority {
    width: 20px;
    height: 20px;
    border-radius: 50%;
    flex-shrink: 0;
    margin-top: 0.2rem;
}

.response-info h4 {
    color: #e2e8f0;
    margin: 0 0 0.25rem 0;
    font-size: 0.9rem;
    font-weight: 600;
}

.response-info p {
    color: #ff6600;
    margin: 0 0 0.25rem 0;
    font-size: 0.9rem;
    font-weight: 600;
}

.response-info small {
    color: #64748b;
    font-size: 0.8rem;
}

.resources-section {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 15px;
    padding: 2rem;
}

.resources-section h2 {
    color: #ff6600;
    font-size: 2rem;
    text-align: center;
    margin: 0 0 2rem 0;
    font-weight: 600;
}

.resources-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

.resource-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 1.5rem;
    text-align: center;
    transition: all 0.3s ease;
}

.resource-card:hover {
    border-color: #ff6600;
    transform: translateY(-3px);
}

.resource-icon {
    font-size: 2.5rem;
    margin-bottom: 1rem;
}

.resource-card h3 {
    color: #e2e8f0;
    margin: 0 0 1rem 0;
    font-size: 1.1rem;
    font-weight: 600;
}

.resource-card p {
    color: #94a3b8;
    margin: 0 0 1rem 0;
    line-height: 1.5;
}

.resource-link {
    color: #ff6600;
    text-decoration: none;
    font-weight: 600;
    font-size: 0.9rem;
}

.resource-link:hover {
    text-decoration: underline;
}

@media (max-width: 768px) {
    .page-header h1 {
        font-size: 2rem;
    }
    
    .contact-grid {
        grid-template-columns: 1fr;
        gap: 2rem;
    }
    
    .form-row {
        grid-template-columns: 1fr;
    }
    
    .btn-submit {
        width: 100%;
        justify-content: center;
    }
    
    .resources-grid {
        grid-template-columns: 1fr;
    }
}
</style>
@endsection