@extends('layouts.app')

@section('title', 'FAQ - ' . ($platformSettings['platform_name'] ?? 'Gaming Platform'))

@section('content')
<div class="static-page faq-page">
    <div class="container">
        <!-- Header Section -->
        <div class="page-header">
            <h1>❓ Frequently Asked Questions</h1>
            <p>Find answers to common questions about {{ $platformSettings['platform_name'] ?? 'our gaming platform' }}, mobile features, and payment systems</p>
        </div>

        <!-- Search Box -->
        <div class="faq-search">
            <div class="search-box">
                <input type="text" id="faq-search" placeholder="Search FAQs..." onkeyup="searchFAQs()">
                <div class="search-icon">🔍</div>
            </div>
        </div>

        <!-- FAQ Categories -->
        <div class="faq-categories">
            <button class="category-btn active" onclick="filterFAQs('all')">All</button>
            <button class="category-btn" onclick="filterFAQs('account')">Account</button>
            <button class="category-btn" onclick="filterFAQs('mobile')">Mobile</button>
            <button class="category-btn" onclick="filterFAQs('payments')">Payments</button>
            <button class="category-btn" onclick="filterFAQs('challenges')">Challenges</button>
            <button class="category-btn" onclick="filterFAQs('notifications')">Notifications</button>
            <button class="category-btn" onclick="filterFAQs('wallet')">Wallet</button>
            <button class="category-btn" onclick="filterFAQs('kyc')">KYC</button>
            <button class="category-btn" onclick="filterFAQs('security')">Security</button>
            <button class="category-btn" onclick="filterFAQs('technical')">Technical</button>
        </div>

        <!-- FAQ Items -->
        <div class="faq-container">
            <!-- Mobile FAQs -->
            <div class="faq-item" data-category="mobile">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How do I use the mobile navigation features?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>Our mobile-first design includes several navigation features:</p>
                    <ul>
                        <li><strong>Hamburger Menu:</strong> Tap the three lines (☰) in the top corner for slide-out navigation</li>
                        <li><strong>Bottom Navigation:</strong> Quick access to core features at the bottom of your screen</li>
                        <li><strong>Touch Optimization:</strong> All buttons and links are optimized for mobile touch</li>
                        <li><strong>Auto-Close:</strong> Menus automatically close when you tap outside them</li>
                    </ul>
                    <p>The interface adapts seamlessly to your device size for the best gaming experience!</p>
                </div>
            </div>

            <div class="faq-item" data-category="mobile">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>What are floating label forms?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>Our modern form system includes:</p>
                    <ul>
                        <li><strong>Floating Labels:</strong> Labels that move up when you start typing</li>
                        <li><strong>Real-time Validation:</strong> Instant feedback on form errors</li>
                        <li><strong>Quick Selection:</strong> Pre-filled buttons for common values (like wager amounts)</li>
                        <li><strong>Enhanced UX:</strong> Better accessibility and visual feedback</li>
                    </ul>
                    <p>This makes form filling faster and more intuitive across all devices!</p>
                </div>
            </div>

            <!-- Payment Gateway FAQs -->
            <div class="faq-item" data-category="payments">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>What payment methods do you support?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>We support 4 major payment gateways for maximum convenience:</p>
                    <ul>
                        <li><strong>Paystack:</strong> Popular in Nigeria and Africa with bank transfers and cards</li>
                        <li><strong>Flutterwave:</strong> Multi-currency support across Africa and beyond</li>
                        <li><strong>PayPal:</strong> Global payments and instant international transfers</li>
                        <li><strong>Stripe:</strong> Worldwide coverage with advanced fraud protection</li>
                    </ul>
                    <p>Choose the payment method that works best for your location and preferences!</p>
                </div>
            </div>

            <div class="faq-item" data-category="payments">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How fast are withdrawals?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>Withdrawal times vary by payment gateway:</p>
                    <ul>
                        <li><strong>Paystack:</strong> 24-48 hours to Nigerian banks</li>
                        <li><strong>Flutterwave:</strong> 1-3 business days depending on country</li>
                        <li><strong>PayPal:</strong> Instant to PayPal balance, 1-2 days to bank</li>
                        <li><strong>Stripe:</strong> 2-7 business days depending on location</li>
                    </ul>
                    <p>All transactions are processed securely with full tracking available in your wallet!</p>
                </div>
            </div>

            <!-- Notification FAQs -->
            <div class="faq-item" data-category="notifications">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How do I receive notifications?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>Our multi-channel notification system includes:</p>
                    <ul>
                        <li><strong>Email Notifications:</strong> SMTP, SendGrid, and Mailgun integration</li>
                        <li><strong>SMS Notifications:</strong> Termii, Twilio, and Nexmo support</li>
                        <li><strong>In-App Notifications:</strong> Real-time updates within the platform</li>
                        <li><strong>Push Notifications:</strong> Mobile alerts for important events</li>
                    </ul>
                    <p>You can customize your notification preferences in your account settings!</p>
                </div>
            </div>

            <div class="faq-item" data-category="notifications">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>What notifications will I receive?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>You'll receive notifications for:</p>
                    <ul>
                        <li>Challenge invitations and acceptances</li>
                        <li>Tournament invitations and updates</li>
                        <li>Payment confirmations and withdrawals</li>
                        <li>Account verification reminders</li>
                        <li>Security alerts and login notifications</li>
                        <li>Competition results and winnings</li>
                    </ul>
                    <p>Stay informed about all your gaming activities with our comprehensive notification system!</p>
                </div>
            </div>

            <!-- Account FAQs -->
            <div class="faq-item" data-category="account">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How do I create an account?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>Creating an account with our modern registration system is simple:</p>
                    <ol>
                        <li>Click the "Register" button on the homepage</li>
                        <li>Fill in the floating label form with your username, email, and password</li>
                        <li>Verify your email address through our notification system</li>
                        <li>Complete your profile setup with enhanced security features</li>
                    </ol>
                    <p>Once registered, you can start participating in challenges immediately using our mobile-optimized interface!</p>
                </div>
            </div>

            <div class="faq-item" data-category="account">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>What are the different user roles?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>Our enhanced role-based access control system includes:</p>
                    <ul>
                        <li><strong>Basic User:</strong> New players starting their journey (up to ₦500 challenges)</li>
                        <li><strong>Premium User:</strong> Experienced players (up to ₦20,000 challenges)</li>
                        <li><strong>Creator:</strong> Content creators and tournament organizers (up to ₦200,000)</li>
                        <li><strong>Admin:</strong> Platform administrators with full access</li>
                    </ul>
                    <p>Roles are assigned based on activity, performance, and contributions to the community with our secure enum-based permission system.</p>
                </div>
            </div>

            <div class="faq-item" data-category="account">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How do I change my password?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>To change your password:</p>
                    <ol>
                        <li>Go to your Profile settings</li>
                        <li>Click on "Change Password"</li>
                        <li>Enter your current password</li>
                        <li>Enter and confirm your new password</li>
                        <li>Click "Update Password"</li>
                    </ol>
                </div>
            </div>

            <!-- Challenges FAQs -->
            <div class="faq-item" data-category="challenges">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How do challenges work?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>Challenges are competitive matches between players:</p>
                    <ol>
                        <li>A player creates a challenge with a wager amount</li>
                        <li>Another player accepts the challenge</li>
                        <li>Both players compete in the specified game</li>
                        <li>Players submit proof of their results</li>
                        <li>If both agree on the winner, funds are distributed</li>
                        <li>If there's disagreement, a dispute is raised for admin review</li>
                    </ol>
                </div>
            </div>

            <div class="faq-item" data-category="challenges">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>What happens if someone doesn't show up?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>If a player doesn't show up for a challenge:</p>
                    <ul>
                        <li>Wait for the agreed time plus a 15-minute grace period</li>
                        <li>Submit proof of the opponent's absence</li>
                        <li>The challenge will be marked as won by forfeit</li>
                        <li>Repeated no-shows result in account penalties</li>
                    </ul>
                </div>
            </div>

            <div class="faq-item" data-category="challenges">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How do I report cheating?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>To report suspected cheating:</p>
                    <ol>
                        <li>Click "Dispute" on the challenge</li>
                        <li>Select "Cheating/Unfair Play" as the reason</li>
                        <li>Provide detailed evidence (screenshots, videos)</li>
                        <li>Submit additional context in the description</li>
                    </ol>
                    <p>Our team will investigate and take appropriate action.</p>
                </div>
            </div>

            <!-- Wallet FAQs -->
            <div class="faq-item" data-category="wallet">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How do I add money to my wallet?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>To deposit funds:</p>
                    <ol>
                        <li>Go to your Wallet</li>
                        <li>Click "Deposit"</li>
                        <li>Choose your payment method (Paystack, Flutterwave, etc.)</li>
                        <li>Enter the amount to deposit</li>
                        <li>Complete the payment process</li>
                    </ol>
                    <p>Deposits are usually processed instantly.</p>
                </div>
            </div>

            <div class="faq-item" data-category="wallet">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How do I withdraw my winnings?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>To withdraw funds:</p>
                    <ol>
                        <li>Complete KYC verification (required)</li>
                        <li>Go to your Wallet and click "Withdraw"</li>
                        <li>Enter your bank account details</li>
                        <li>Specify the withdrawal amount</li>
                        <li>Enter your transaction PIN</li>
                    </ol>
                    <p>Withdrawals are processed within 24-48 hours.</p>
                </div>
            </div>

            <div class="faq-item" data-category="wallet">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>Are there withdrawal limits?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>Withdrawal limits depend on your verification status:</p>
                    <ul>
                        <li><strong>Unverified accounts:</strong> No withdrawals allowed</li>
                        <li><strong>KYC verified accounts:</strong> ₦1,000 - ₦1,000,000 per transaction</li>
                        <li><strong>Higher tier users:</strong> Increased limits available</li>
                    </ul>
                </div>
            </div>

            <!-- KYC FAQs -->
            <div class="faq-item" data-category="kyc">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>What is KYC verification?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>KYC (Know Your Customer) is an identity verification process required to:</p>
                    <ul>
                        <li>Withdraw funds from your wallet</li>
                        <li>Access higher-tier features</li>
                        <li>Ensure platform security and compliance</li>
                        <li>Prevent fraud and money laundering</li>
                    </ul>
                </div>
            </div>

            <div class="faq-item" data-category="kyc">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>What documents do I need for KYC?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>You'll need to provide:</p>
                    <ul>
                        <li>A valid government-issued ID (NIN, BVN, Driver's License, or Passport)</li>
                        <li>A clear selfie photo</li>
                        <li>Personal information (name, date of birth, address)</li>
                    </ul>
                    <p>All documents must be clear, valid, and match your account information.</p>
                </div>
            </div>

            <div class="faq-item" data-category="kyc">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How long does KYC verification take?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>KYC verification typically takes:</p>
                    <ul>
                        <li><strong>Automatic verification:</strong> Within minutes (if documents are clear)</li>
                        <li><strong>Manual review:</strong> 24-48 hours during business days</li>
                        <li><strong>Complex cases:</strong> Up to 5 business days</li>
                    </ul>
                    <p>You'll receive email notifications about your verification status.</p>
                </div>
            </div>

            <!-- Security FAQs -->
            <div class="faq-item" data-category="security">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>How secure is my money on the platform?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>We use multiple security measures:</p>
                    <ul>
                        <li>Bank-level encryption for all transactions</li>
                        <li>Secure escrow system for challenge funds</li>
                        <li>Two-factor authentication (2FA) available</li>
                        <li>Regular security audits and monitoring</li>
                        <li>Transaction PINs for sensitive operations</li>
                    </ul>
                </div>
            </div>

            <div class="faq-item" data-category="security">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>What should I do if my account is compromised?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>If you suspect unauthorized access:</p>
                    <ol>
                        <li>Change your password immediately</li>
                        <li>Check your transaction history</li>
                        <li>Contact support immediately</li>
                        <li>Enable 2FA if not already active</li>
                        <li>Review and update your security settings</li>
                    </ol>
                </div>
            </div>

            <!-- Technical FAQs -->
            <div class="faq-item" data-category="technical">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>What games are supported?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>We support challenges for popular games including:</p>
                    <ul>
                        <li>FIFA series</li>
                        <li>Call of Duty</li>
                        <li>Fortnite</li>
                        <li>PUBG Mobile</li>
                        <li>Chess</li>
                        <li>And many more!</li>
                    </ul>
                    <p>New games are added regularly based on community demand.</p>
                </div>
            </div>

            <div class="faq-item" data-category="technical">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>Do you have a mobile app?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>Currently, we offer a mobile-optimized website that works great on all devices. 
                    Native mobile apps for iOS and Android are in development and will be available soon!</p>
                    <p>You can bookmark our site on your mobile device for quick access.</p>
                </div>
            </div>

            <div class="faq-item" data-category="technical">
                <div class="faq-question" onclick="toggleFAQ(this)">
                    <h3>I'm having technical issues. What should I do?</h3>
                    <span class="toggle-icon">+</span>
                </div>
                <div class="faq-answer">
                    <p>For technical issues:</p>
                    <ol>
                        <li>Try refreshing the page</li>
                        <li>Clear your browser cache and cookies</li>
                        <li>Try a different browser or device</li>
                        <li>Check your internet connection</li>
                        <li>Contact support with details about the issue</li>
                    </ol>
                </div>
            </div>
        </div>

        <!-- Contact Section -->
        <div class="faq-contact">
            <div class="contact-box">
                <h3>Didn't find what you're looking for?</h3>
                <p>Our support team is here to help you with any questions or concerns.</p>
                <div class="contact-buttons">
                    <a href="{{ route('contact-us') }}" class="btn-primary">Contact Support</a>
                    <a href="#" class="btn-secondary">Live Chat</a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.static-page {
    padding: 2rem 0;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    min-height: 100vh;
}

.page-header {
    text-align: center;
    margin-bottom: 3rem;
}

.page-header h1 {
    font-size: 3rem;
    color: #ff6600;
    margin: 0 0 1rem 0;
    font-weight: 700;
}

.page-header p {
    font-size: 1.2rem;
    color: #94a3b8;
    margin: 0;
}

.faq-search {
    margin-bottom: 2rem;
    display: flex;
    justify-content: center;
}

.search-box {
    position: relative;
    max-width: 500px;
    width: 100%;
}

.search-box input {
    width: 100%;
    padding: 1rem 1rem 1rem 3rem;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 25px;
    color: #e2e8f0;
    font-size: 1rem;
    transition: border-color 0.3s ease;
}

.search-box input:focus {
    outline: none;
    border-color: #ff6600;
    box-shadow: 0 0 0 2px rgba(255, 102, 0, 0.2);
}

.search-icon {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    font-size: 1.2rem;
    color: #94a3b8;
}

.faq-categories {
    display: flex;
    justify-content: center;
    gap: 1rem;
    margin-bottom: 3rem;
    flex-wrap: wrap;
}

.category-btn {
    padding: 0.75rem 1.5rem;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 25px;
    color: #94a3b8;
    cursor: pointer;
    transition: all 0.3s ease;
    font-weight: 600;
}

.category-btn:hover,
.category-btn.active {
    background: rgba(255, 102, 0, 0.2);
    border-color: #ff6600;
    color: #ff6600;
}

.faq-container {
    max-width: 800px;
    margin: 0 auto;
}

.faq-item {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    margin-bottom: 1rem;
    overflow: hidden;
    transition: all 0.3s ease;
}

.faq-item:hover {
    border-color: rgba(255, 102, 0, 0.3);
}

.faq-question {
    padding: 1.5rem;
    cursor: pointer;
    display: flex;
    justify-content: space-between;
    align-items: center;
    transition: background-color 0.3s ease;
}

.faq-question:hover {
    background: rgba(255, 102, 0, 0.05);
}

.faq-question h3 {
    color: #e2e8f0;
    margin: 0;
    font-size: 1.1rem;
    font-weight: 600;
}

.toggle-icon {
    color: #ff6600;
    font-size: 1.5rem;
    font-weight: bold;
    transition: transform 0.3s ease;
}

.faq-answer {
    padding: 0 1.5rem;
    max-height: 0;
    overflow: hidden;
    transition: all 0.3s ease;
}

.faq-answer.active {
    padding: 0 1.5rem 1.5rem;
    max-height: 1000px;
}

.faq-answer p {
    color: #94a3b8;
    line-height: 1.6;
    margin-bottom: 1rem;
}

.faq-answer ol,
.faq-answer ul {
    color: #94a3b8;
    line-height: 1.6;
    margin: 1rem 0;
    padding-left: 1.5rem;
}

.faq-answer li {
    margin-bottom: 0.5rem;
}

.faq-answer strong {
    color: #e2e8f0;
}

.faq-contact {
    margin-top: 4rem;
    display: flex;
    justify-content: center;
}

.contact-box {
    background: rgba(255, 102, 0, 0.1);
    border: 1px solid rgba(255, 102, 0, 0.3);
    border-radius: 15px;
    padding: 3rem;
    text-align: center;
    max-width: 600px;
    width: 100%;
}

.contact-box h3 {
    color: #ff6600;
    margin: 0 0 1rem 0;
    font-size: 1.5rem;
    font-weight: 600;
}

.contact-box p {
    color: #94a3b8;
    margin: 0 0 2rem 0;
    font-size: 1.1rem;
}

.contact-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-primary, .btn-secondary {
    padding: 1rem 2rem;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
    border: 1px solid;
}

.btn-primary {
    background: linear-gradient(135deg, #ff6600, #e55a00);
    color: #ffffff;
    border-color: transparent;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 102, 0, 0.4);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.1);
    color: #e2e8f0;
    border-color: #e2e8f0;
}

.btn-secondary:hover {
    background: #e2e8f0;
    color: #1a1a2e;
    transform: translateY(-2px);
}

.faq-item.hidden {
    display: none;
}

@media (max-width: 768px) {
    .page-header h1 {
        font-size: 2rem;
    }
    
    .faq-categories {
        gap: 0.5rem;
    }
    
    .category-btn {
        padding: 0.5rem 1rem;
        font-size: 0.9rem;
    }
    
    .faq-question {
        padding: 1rem;
    }
    
    .faq-question h3 {
        font-size: 1rem;
    }
    
    .contact-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .btn-primary, .btn-secondary {
        width: 100%;
        max-width: 250px;
    }
}
</style>

<script>
function toggleFAQ(element) {
    const answer = element.nextElementSibling;
    const icon = element.querySelector('.toggle-icon');
    
    // Close all other FAQs
    document.querySelectorAll('.faq-answer.active').forEach(other => {
        if (other !== answer) {
            other.classList.remove('active');
            other.previousElementSibling.querySelector('.toggle-icon').textContent = '+';
        }
    });
    
    // Toggle current FAQ
    answer.classList.toggle('active');
    icon.textContent = answer.classList.contains('active') ? '−' : '+';
}

function filterFAQs(category) {
    const items = document.querySelectorAll('.faq-item');
    const buttons = document.querySelectorAll('.category-btn');
    
    // Update active button
    buttons.forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
    
    // Filter items
    items.forEach(item => {
        if (category === 'all' || item.dataset.category === category) {
            item.classList.remove('hidden');
        } else {
            item.classList.add('hidden');
        }
    });
}

function searchFAQs() {
    const query = document.getElementById('faq-search').value.toLowerCase();
    const items = document.querySelectorAll('.faq-item');
    
    items.forEach(item => {
        const question = item.querySelector('.faq-question h3').textContent.toLowerCase();
        const answer = item.querySelector('.faq-answer').textContent.toLowerCase();
        
        if (question.includes(query) || answer.includes(query)) {
            item.classList.remove('hidden');
        } else {
            item.classList.add('hidden');
        }
    });
    
    // If searching, reset category filter
    if (query) {
        document.querySelectorAll('.category-btn').forEach(btn => btn.classList.remove('active'));
    }
}
</script>
@endsection