@extends('layouts.app')

@section('title', 'Privacy Policy - ' . ($platformSettings['platform_name'] ?? 'Gaming Platform'))

@section('content')
<div class="static-page legal-page">
    <div class="container">
        <!-- Header Section -->
        <div class="page-header">
            <h1>🔒 Privacy Policy</h1>
            <p class="last-updated">Last updated: {{ date('F j, Y') }}</p>
        </div>

        <div class="legal-content">
            <div class="intro-section">
                <p class="intro-text">
                    At {{ $platformSettings['platform_name'] ?? 'Agamec' }}, we are committed to protecting your privacy and ensuring the security of your personal information across our mobile-optimized platform, multiple payment gateways, and comprehensive notification systems. 
                    This Privacy Policy explains how we collect, use, store, and protect your data when you use our gaming platform.
                </p>
            </div>

            <div class="content-sections">
                <!-- Table of Contents -->
                <div class="toc-section">
                    <h2>Table of Contents</h2>
                    <ul class="toc-list">
                        <li><a href="#information-collection">1. Information We Collect</a></li>
                        <li><a href="#mobile-data">2. Mobile Device and Usage Data</a></li>
                        <li><a href="#payment-data">3. Payment Gateway Information</a></li>
                        <li><a href="#notification-data">4. Notification Preferences</a></li>
                        <li><a href="#how-we-use">5. How We Use Your Information</a></li>
                        <li><a href="#information-sharing">6. Information Sharing</a></li>
                        <li><a href="#data-security">7. Data Security</a></li>
                        <li><a href="#kyc-verification">8. KYC Verification</a></li>
                        <li><a href="#cookies">9. Cookies and Tracking</a></li>
                        <li><a href="#your-rights">10. Your Rights</a></li>
                        <li><a href="#data-retention">11. Data Retention</a></li>
                        <li><a href="#third-party-services">12. Third-Party Services</a></li>
                        <li><a href="#children-privacy">13. Children's Privacy</a></li>
                        <li><a href="#changes">14. Changes to This Policy</a></li>
                        <li><a href="#contact">15. Contact Us</a></li>
                    </ul>
                </div>

                <!-- Content Sections -->
                <section id="information-collection" class="policy-section">
                    <h2>1. Information We Collect</h2>
                    
                    <h3>Personal Information</h3>
                    <p>We collect personal information that you provide directly to us through our floating label forms and enhanced user interface, including:</p>
                    <ul>
                        <li>Username and email address</li>
                        <li>Phone number for SMS notifications (optional)</li>
                        <li>Full name, date of birth, and address (for KYC verification)</li>
                        <li>Government-issued identification documents</li>
                        <li>Bank account information (for withdrawals)</li>
                        <li>Profile information and preferences</li>
                    </ul>

                    <h3>Automatically Collected Information</h3>
                    <p>We automatically collect certain information when you use our platform:</p>
                    <ul>
                        <li>IP address and location data</li>
                        <li>Device information (browser, operating system)</li>
                        <li>Usage patterns and platform interactions</li>
                        <li>Challenge and tournament participation data</li>
                        <li>Transaction and wallet activity</li>
                        <li>Performance statistics and game results</li>
                    </ul>
                </section>

                <section id="mobile-data" class="policy-section">
                    <h2>2. Mobile Device and Usage Data</h2>
                    
                    <p>Our mobile-first platform collects additional information to enhance your mobile experience:</p>
                    
                    <h3>Mobile Device Information</h3>
                    <ul>
                        <li>Device type, model, and operating system version</li>
                        <li>Screen resolution and touch interaction patterns</li>
                        <li>Mobile network information and connection quality</li>
                        <li>App usage patterns and navigation preferences</li>
                        <li>Mobile push notification preferences and tokens</li>
                    </ul>

                    <h3>Mobile Navigation Data</h3>
                    <ul>
                        <li>Hamburger menu usage and preferences</li>
                        <li>Bottom navigation interaction patterns</li>
                        <li>Touch gesture data and interface optimization</li>
                        <li>Mobile form completion and floating label interactions</li>
                    </ul>
                </section>

                <section id="payment-data" class="policy-section">
                    <h2>3. Payment Gateway Information</h2>
                    
                    <p>We securely process payments through four integrated payment gateways:</p>
                    
                    <h3>Payment Gateway Data</h3>
                    <ul>
                        <li><strong>Paystack:</strong> Transaction IDs, payment references, and bank information</li>
                        <li><strong>Flutterwave:</strong> Transaction references, payment methods, and currency data</li>
                        <li><strong>PayPal:</strong> PayPal account information, transaction IDs, and payout batch details</li>
                        <li><strong>Stripe:</strong> Payment intent IDs, card metadata (not full card numbers), and express account information</li>
                    </ul>

                    <h3>Financial Security</h3>
                    <ul>
                        <li>We never store complete credit card or bank account numbers</li>
                        <li>All payment data is encrypted and processed through secure gateways</li>
                        <li>Transaction history is maintained for security and compliance purposes</li>
                        <li>All payment gateways comply with PCI DSS standards</li>
                    </ul>
                </section>

                <section id="notification-data" class="policy-section">
                    <h2>4. Notification Preferences</h2>
                    
                    <p>Our comprehensive notification system handles multiple communication channels:</p>
                    
                    <h3>Email Notification Data</h3>
                    <ul>
                        <li>Email addresses for account communications</li>
                        <li>Email preferences and frequency settings</li>
                        <li>Delivery status and engagement tracking</li>
                        <li>SMTP, SendGrid, and Mailgun delivery metrics</li>
                    </ul>

                    <h3>SMS Notification Data</h3>
                    <ul>
                        <li>Phone numbers for SMS notifications</li>
                        <li>SMS delivery preferences and timing</li>
                        <li>Termii, Twilio, and Nexmo delivery tracking</li>
                        <li>International SMS routing and compliance data</li>
                    </ul>

                    <h3>In-App Notifications</h3>
                    <ul>
                        <li>Push notification tokens and device registration</li>
                        <li>Notification interaction and engagement data</li>
                        <li>Real-time notification delivery status</li>
                        <li>Notification preferences and customization settings</li>
                    </ul>
                </section>

                <section id="how-we-use" class="policy-section">
                    <h2>5. How We Use Your Information</h2>
                    
                    <p>We use your information for the following purposes:</p>
                    
                    <h3>Service Provision</h3>
                    <ul>
                        <li>Creating and managing your account</li>
                        <li>Processing challenges, tournaments, and competitions</li>
                        <li>Handling deposits, withdrawals, and transactions</li>
                        <li>Providing customer support</li>
                        <li>Maintaining leaderboards and statistics</li>
                    </ul>

                    <h3>Security and Compliance</h3>
                    <ul>
                        <li>Verifying your identity (KYC/AML compliance)</li>
                        <li>Preventing fraud and suspicious activities</li>
                        <li>Ensuring fair play and detecting cheating</li>
                        <li>Complying with legal and regulatory requirements</li>
                    </ul>

                    <h3>Platform Improvement</h3>
                    <ul>
                        <li>Analyzing usage patterns to improve our services</li>
                        <li>Developing new features and functionalities</li>
                        <li>Personalizing your gaming experience</li>
                        <li>Conducting research and analytics</li>
                    </ul>
                </section>

                <section id="information-sharing" class="policy-section">
                    <h2>3. Information Sharing</h2>
                    
                    <p>We do not sell your personal information. We may share your information only in the following circumstances:</p>
                    
                    <h3>Service Providers</h3>
                    <p>We share information with trusted third-party service providers who help us operate our platform:</p>
                    <ul>
                        <li>Payment processors (Paystack, Flutterwave)</li>
                        <li>KYC verification services (QoreID)</li>
                        <li>Cloud hosting and storage providers</li>
                        <li>Analytics and monitoring services</li>
                        <li>Customer support platforms</li>
                    </ul>

                    <h3>Legal Requirements</h3>
                    <p>We may disclose your information when required by law or to:</p>
                    <ul>
                        <li>Comply with legal processes or government requests</li>
                        <li>Enforce our Terms of Service</li>
                        <li>Protect our rights, property, or safety</li>
                        <li>Investigate fraud or security issues</li>
                    </ul>

                    <h3>Business Transfers</h3>
                    <p>In the event of a merger, acquisition, or sale of assets, your information may be transferred as part of the transaction.</p>
                </section>

                <section id="data-security" class="policy-section">
                    <h2>4. Data Security</h2>
                    
                    <p>We implement comprehensive security measures to protect your information:</p>
                    
                    <h3>Technical Safeguards</h3>
                    <ul>
                        <li>SSL/TLS encryption for all data transmissions</li>
                        <li>AES-256 encryption for stored sensitive data</li>
                        <li>Secure database storage with access controls</li>
                        <li>Regular security audits and penetration testing</li>
                        <li>Multi-factor authentication for admin access</li>
                    </ul>

                    <h3>Operational Security</h3>
                    <ul>
                        <li>Strict access controls and employee training</li>
                        <li>Regular security monitoring and incident response</li>
                        <li>Secure development practices</li>
                        <li>Regular backups and disaster recovery procedures</li>
                    </ul>
                </section>

                <section id="kyc-verification" class="policy-section">
                    <h2>5. KYC Verification</h2>
                    
                    <p>To comply with financial regulations and ensure platform security, we require identity verification:</p>
                    
                    <h3>KYC Process</h3>
                    <ul>
                        <li>Collection of identity documents and personal information</li>
                        <li>Verification through our trusted partner QoreID</li>
                        <li>Ongoing monitoring for suspicious activities</li>
                        <li>Secure storage of verification data</li>
                    </ul>

                    <h3>Data Handling</h3>
                    <ul>
                        <li>KYC data is encrypted and stored securely</li>
                        <li>Access is limited to authorized personnel only</li>
                        <li>Data is retained as required by law</li>
                        <li>You can request deletion after account closure</li>
                    </ul>
                </section>

                <section id="cookies" class="policy-section">
                    <h2>6. Cookies and Tracking</h2>
                    
                    <p>We use cookies and similar technologies to enhance your experience:</p>
                    
                    <h3>Types of Cookies</h3>
                    <ul>
                        <li><strong>Essential cookies:</strong> Required for platform functionality</li>
                        <li><strong>Performance cookies:</strong> Help us analyze usage and improve performance</li>
                        <li><strong>Preference cookies:</strong> Remember your settings and preferences</li>
                        <li><strong>Marketing cookies:</strong> Used for targeted advertising (with your consent)</li>
                    </ul>

                    <h3>Managing Cookies</h3>
                    <p>You can control cookies through your browser settings, but note that disabling certain cookies may affect platform functionality.</p>
                </section>

                <section id="your-rights" class="policy-section">
                    <h2>7. Your Rights</h2>
                    
                    <p>You have the following rights regarding your personal information:</p>
                    
                    <h3>Access and Portability</h3>
                    <ul>
                        <li>Request a copy of your personal data</li>
                        <li>Export your data in a machine-readable format</li>
                        <li>View your data processing activities</li>
                    </ul>

                    <h3>Correction and Deletion</h3>
                    <ul>
                        <li>Update or correct inaccurate information</li>
                        <li>Request deletion of your account and data</li>
                        <li>Withdraw consent for optional data processing</li>
                    </ul>

                    <h3>Control and Objection</h3>
                    <ul>
                        <li>Object to certain data processing activities</li>
                        <li>Request restriction of processing</li>
                        <li>Opt-out of marketing communications</li>
                    </ul>

                    <p>To exercise these rights, contact us at <a href="mailto:privacy@agamec.com">privacy@agamec.com</a></p>
                </section>

                <section id="data-retention" class="policy-section">
                    <h2>8. Data Retention</h2>
                    
                    <p>We retain your information for different periods based on the type of data and legal requirements:</p>
                    
                    <ul>
                        <li><strong>Account data:</strong> Until account deletion + 30 days</li>
                        <li><strong>Transaction records:</strong> 7 years (regulatory requirement)</li>
                        <li><strong>KYC documents:</strong> 5 years after account closure</li>
                        <li><strong>Marketing data:</strong> Until you withdraw consent</li>
                        <li><strong>Support communications:</strong> 3 years</li>
                    </ul>
                </section>

                <section id="third-party-services" class="policy-section">
                    <h2>9. Third-Party Services</h2>
                    
                    <p>Our platform integrates with third-party services that have their own privacy policies:</p>
                    
                    <ul>
                        <li><strong>Payment Processors:</strong> Paystack, Flutterwave, PayPal, Stripe</li>
                        <li><strong>Identity Verification:</strong> QoreID</li>
                        <li><strong>Analytics:</strong> Google Analytics (anonymized data)</li>
                        <li><strong>Support:</strong> Customer service platforms</li>
                    </ul>

                    <p>We encourage you to review the privacy policies of these third-party services.</p>
                </section>

                <section id="children-privacy" class="policy-section">
                    <h2>10. Children's Privacy</h2>
                    
                    <p>Our platform is not intended for users under 18 years of age. We do not knowingly collect personal information from minors. If you believe a minor has provided us with personal information, please contact us immediately.</p>
                </section>

                <section id="changes" class="policy-section">
                    <h2>11. Changes to This Policy</h2>
                    
                    <p>We may update this Privacy Policy from time to time. We will notify you of any material changes by:</p>
                    <ul>
                        <li>Posting a notice on our platform</li>
                        <li>Sending an email notification</li>
                        <li>Updating the "Last updated" date</li>
                    </ul>
                    
                    <p>Your continued use of our platform after changes become effective constitutes acceptance of the updated policy.</p>
                </section>

                <section id="contact" class="policy-section">
                    <h2>12. Contact Us</h2>
                    
                    <p>If you have questions about this Privacy Policy or our data practices, contact us:</p>
                    
                    <div class="contact-info">
                        <div class="contact-item">
                            <strong>Email:</strong> <a href="mailto:privacy@agamec.com">privacy@agamec.com</a>
                        </div>
                        <div class="contact-item">
                            <strong>Support:</strong> <a href="{{ route('contact-us') }}">Contact Form</a>
                        </div>
                        <div class="contact-item">
                            <strong>Response Time:</strong> Within 30 days of receipt
                        </div>
                    </div>
                </section>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="quick-actions">
            <h3>Quick Actions</h3>
            <div class="action-buttons">
                <a href="{{ route('profile.index') }}" class="action-btn">
                    <i class="icon">⚙️</i>
                    Manage Privacy Settings
                </a>
                <a href="{{ route('contact-us') }}" class="action-btn">
                    <i class="icon">💬</i>
                    Contact Support
                </a>
                <a href="{{ route('terms-of-service') }}" class="action-btn">
                    <i class="icon">📋</i>
                    Terms of Service
                </a>
            </div>
        </div>
    </div>
</div>

<style>
.static-page {
    padding: 2rem 0;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    min-height: 100vh;
}

.page-header {
    text-align: center;
    margin-bottom: 3rem;
}

.page-header h1 {
    font-size: 3rem;
    color: #ff6600;
    margin: 0 0 1rem 0;
    font-weight: 700;
}

.last-updated {
    color: #94a3b8;
    font-style: italic;
    margin: 0;
}

.legal-content {
    max-width: 900px;
    margin: 0 auto;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 15px;
    padding: 3rem;
    margin-bottom: 3rem;
}

.intro-text {
    font-size: 1.2rem;
    color: #94a3b8;
    line-height: 1.8;
    margin-bottom: 3rem;
    text-align: center;
    padding: 2rem;
    background: rgba(255, 102, 0, 0.1);
    border-radius: 12px;
    border: 1px solid rgba(255, 102, 0, 0.2);
}

.toc-section {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 2rem;
    margin-bottom: 3rem;
}

.toc-section h2 {
    color: #ff6600;
    margin: 0 0 1.5rem 0;
    font-size: 1.5rem;
}

.toc-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.toc-list li {
    margin-bottom: 0.5rem;
}

.toc-list a {
    color: #94a3b8;
    text-decoration: none;
    transition: color 0.3s ease;
    display: block;
    padding: 0.5rem 0;
}

.toc-list a:hover {
    color: #ff6600;
}

.policy-section {
    margin-bottom: 3rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.policy-section:last-child {
    border-bottom: none;
    margin-bottom: 0;
}

.policy-section h2 {
    color: #ff6600;
    font-size: 1.8rem;
    margin: 0 0 1.5rem 0;
    font-weight: 600;
}

.policy-section h3 {
    color: #e2e8f0;
    font-size: 1.3rem;
    margin: 2rem 0 1rem 0;
    font-weight: 600;
}

.policy-section p {
    color: #94a3b8;
    line-height: 1.8;
    margin-bottom: 1.5rem;
}

.policy-section ul {
    color: #94a3b8;
    line-height: 1.8;
    margin: 1rem 0;
    padding-left: 1.5rem;
}

.policy-section li {
    margin-bottom: 0.5rem;
}

.policy-section strong {
    color: #e2e8f0;
}

.policy-section a {
    color: #ff6600;
    text-decoration: none;
}

.policy-section a:hover {
    text-decoration: underline;
}

.contact-info {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    padding: 1.5rem;
    margin-top: 1rem;
}

.contact-item {
    margin-bottom: 1rem;
    color: #94a3b8;
}

.contact-item:last-child {
    margin-bottom: 0;
}

.contact-item strong {
    color: #e2e8f0;
}

.contact-item a {
    color: #ff6600;
    text-decoration: none;
}

.contact-item a:hover {
    text-decoration: underline;
}

.quick-actions {
    max-width: 900px;
    margin: 0 auto;
    background: rgba(255, 102, 0, 0.1);
    border: 1px solid rgba(255, 102, 0, 0.3);
    border-radius: 15px;
    padding: 2rem;
    text-align: center;
}

.quick-actions h3 {
    color: #ff6600;
    margin: 0 0 2rem 0;
    font-size: 1.5rem;
}

.action-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.action-btn {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem 1.5rem;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    color: #e2e8f0;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.action-btn:hover {
    border-color: #ff6600;
    color: #ff6600;
    transform: translateY(-2px);
}

@media (max-width: 768px) {
    .page-header h1 {
        font-size: 2rem;
    }
    
    .legal-content {
        padding: 2rem 1.5rem;
    }
    
    .intro-text {
        font-size: 1rem;
        padding: 1.5rem;
    }
    
    .toc-section {
        padding: 1.5rem;
    }
    
    .policy-section h2 {
        font-size: 1.5rem;
    }
    
    .policy-section h3 {
        font-size: 1.2rem;
    }
    
    .action-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .action-btn {
        width: 100%;
        max-width: 250px;
        justify-content: center;
    }
}
</style>
@endsection