@extends('layouts.app')

@section('title', 'Terms of Service - ' . ($platformSettings['platform_name'] ?? 'Gaming Platform'))

@section('content')
<div class="static-page legal-page">
    <div class="container">
        <!-- Header Section -->
        <div class="page-header">
            <h1>📋 Terms of Service</h1>
            <p class="last-updated">Last updated: {{ date('F j, Y') }}</p>
        </div>

        <div class="legal-content">
            <div class="intro-section">
                <p class="intro-text">
                    Welcome to {{ $platformSettings['platform_name'] ?? config('app.name') }}! These Terms of Service ("Terms") govern your use of our competitive gaming platform with mobile-first design, multiple payment gateways, and advanced notification systems. 
                    By accessing or using our services, you agree to be bound by these Terms. Please read them carefully.
                </p>
            </div>

            <div class="content-sections">
                <!-- Table of Contents -->
                <div class="toc-section">
                    <h2>Table of Contents</h2>
                    <ul class="toc-list">
                        <li><a href="#acceptance">1. Acceptance of Terms</a></li>
                        <li><a href="#eligibility">2. Eligibility</a></li>
                        <li><a href="#account">3. Account Registration and Security</a></li>
                        <li><a href="#platform-features">4. Platform Features and Mobile Experience</a></li>
                        <li><a href="#platform-rules">5. Platform Rules and Conduct</a></li>
                        <li><a href="#challenges">6. Challenges and Competitions</a></li>
                        <li><a href="#payments">7. Payments, Wallet, and Payment Gateways</a></li>
                        <li><a href="#notifications">8. Notification Systems</a></li>
                        <li><a href="#kyc">9. KYC and Verification</a></li>
                        <li><a href="#intellectual-property">10. Intellectual Property</a></li>
                        <li><a href="#prohibited-conduct">11. Prohibited Conduct</a></li>
                        <li><a href="#termination">12. Account Termination</a></li>
                        <li><a href="#disclaimers">13. Disclaimers and Limitations</a></li>
                        <li><a href="#indemnification">14. Indemnification</a></li>
                        <li><a href="#dispute-resolution">15. Dispute Resolution</a></li>
                        <li><a href="#governing-law">16. Governing Law</a></li>
                        <li><a href="#changes">17. Changes to Terms</a></li>
                        <li><a href="#contact">18. Contact Information</a></li>
                    </ul>
                </div>

                <!-- Content Sections -->
                <section id="acceptance" class="policy-section">
                    <h2>1. Acceptance of Terms</h2>
                    <p>By creating an account or using our platform, you acknowledge that you have read, understood, and agree to be bound by these Terms and our Privacy Policy. If you do not agree to these Terms, you must not use our services.</p>
                    <p>These Terms constitute a legally binding agreement between you and {{ $platformSettings['platform_name'] ?? 'Agamec' }}.</p>
                </section>

                <section id="eligibility" class="policy-section">
                    <h2>2. Eligibility</h2>
                    <h3>Age Requirements</h3>
                    <ul>
                        <li>You must be at least 18 years old to use our platform</li>
                        <li>You must have the legal capacity to enter into contracts</li>
                        <li>You must not be prohibited from using our services under applicable law</li>
                    </ul>

                    <h3>Geographic Restrictions</h3>
                    <p>Our services may not be available in all jurisdictions. You are responsible for complying with local laws and regulations in your jurisdiction.</p>
                </section>

                <section id="account" class="policy-section">
                    <h2>3. Account Registration and Security</h2>
                    
                    <h3>Account Creation</h3>
                    <ul>
                        <li>You must provide accurate and complete information during registration</li>
                        <li>You are responsible for maintaining the accuracy of your account information</li>
                        <li>You may only create and maintain one account</li>
                        <li>Duplicate or multiple accounts are strictly prohibited</li>
                    </ul>

                    <h3>Account Security</h3>
                    <ul>
                        <li>You are responsible for maintaining the confidentiality of your login credentials</li>
                        <li>You must notify us immediately of any unauthorized access to your account</li>
                        <li>You are liable for all activities that occur under your account</li>
                        <li>We recommend enabling two-factor authentication for enhanced security</li>
                    </ul>
                </section>

                <section id="platform-rules" class="policy-section">
                    <h2>4. Platform Rules and Conduct</h2>
                    
                    <h3>Fair Play</h3>
                    <ul>
                        <li>All competitions must be conducted fairly and honestly</li>
                        <li>Cheating, hacking, or using unauthorized software is strictly prohibited</li>
                        <li>Match-fixing or any form of collusion is forbidden</li>
                        <li>You must compete to the best of your ability in all challenges</li>
                    </ul>

                    <h3>Community Standards</h3>
                    <ul>
                        <li>Treat all users with respect and courtesy</li>
                        <li>No harassment, discrimination, or abusive behavior</li>
                        <li>No spam, advertising, or promotional content without permission</li>
                        <li>Respect intellectual property rights of others</li>
                    </ul>
                </section>

                <section id="challenges" class="policy-section">
                    <h2>5. Challenges and Competitions</h2>
                    
                    <h3>Challenge Rules</h3>
                    <ul>
                        <li>All challenge details must be clearly specified before acceptance</li>
                        <li>Both parties must agree to the terms before the challenge begins</li>
                        <li>Results must be reported honestly and with evidence when required</li>
                        <li>Disputes will be resolved according to our dispute resolution process</li>
                    </ul>

                    <h3>Wager Limits</h3>
                    <p>Challenge wager limits are determined by your user role:</p>
                    <ul>
                        <li><strong>Level 1 Users:</strong> Up to ₦20,000 per challenge</li>
                        <li><strong>Level 2 Users:</strong> Up to ₦200,000 per challenge</li>
                        <li><strong>Highest Level Users:</strong> No wager limits</li>
                        <li><strong>Creator Users:</strong> No wager limits</li>
                    </ul>

                    <h3>Tournament Participation</h3>
                    <ul>
                        <li>Tournament access is restricted to Highest Level and Creator users</li>
                        <li>Tournament rules and prize structures are specified for each event</li>
                        <li>Participants must comply with all tournament-specific rules</li>
                    </ul>
                </section>

                <section id="payments" class="policy-section">
                    <h2>6. Payments and Wallet</h2>
                    
                    <h3>Wallet System</h3>
                    <ul>
                        <li>All funds are held in your platform wallet</li>
                        <li>We use secure third-party payment processors</li>
                        <li>Transaction fees may apply to deposits and withdrawals</li>
                        <li>Funds are held in escrow during active challenges</li>
                    </ul>

                    <h3>Deposits</h3>
                    <ul>
                        <li>Minimum and maximum deposit limits apply</li>
                        <li>We accept payments through approved payment methods only</li>
                        <li>Deposits are typically processed instantly</li>
                        <li>You are responsible for any payment processing fees</li>
                    </ul>

                    <h3>Withdrawals</h3>
                    <ul>
                        <li>KYC verification is required for all withdrawals</li>
                        <li>Minimum and maximum withdrawal limits apply</li>
                        <li>Withdrawals are processed within 24-48 hours</li>
                        <li>We reserve the right to request additional verification</li>
                    </ul>

                    <h3>Platform Commission</h3>
                    <p>We charge a commission on completed challenges as outlined in our fee schedule. This fee is automatically deducted from winnings.</p>
                </section>

                <section id="kyc" class="policy-section">
                    <h2>7. KYC and Verification</h2>
                    
                    <h3>Verification Requirements</h3>
                    <ul>
                        <li>Identity verification is required for withdrawals</li>
                        <li>You must provide accurate and up-to-date documentation</li>
                        <li>We use third-party services for identity verification</li>
                        <li>Additional verification may be required for large transactions</li>
                    </ul>

                    <h3>Document Requirements</h3>
                    <ul>
                        <li>Government-issued photo identification</li>
                        <li>Proof of address (utility bill, bank statement)</li>
                        <li>Selfie photograph for identity confirmation</li>
                        <li>Additional documents may be requested as needed</li>
                    </ul>
                </section>

                <section id="intellectual-property" class="policy-section">
                    <h2>8. Intellectual Property</h2>
                    
                    <h3>Platform Content</h3>
                    <ul>
                        <li>All platform content, including text, graphics, logos, and software, is our property</li>
                        <li>You may not copy, modify, or distribute our content without permission</li>
                        <li>Trademarks and service marks are protected intellectual property</li>
                    </ul>

                    <h3>User Content</h3>
                    <ul>
                        <li>You retain ownership of content you create and submit</li>
                        <li>You grant us a license to use your content for platform operations</li>
                        <li>You are responsible for ensuring you have rights to any content you submit</li>
                        <li>We may remove content that violates these Terms</li>
                    </ul>
                </section>

                <section id="prohibited-conduct" class="policy-section">
                    <h2>9. Prohibited Conduct</h2>
                    
                    <p>The following activities are strictly prohibited:</p>
                    
                    <h3>Gaming Violations</h3>
                    <ul>
                        <li>Cheating, hacking, or using unauthorized software</li>
                        <li>Creating multiple accounts to gain unfair advantages</li>
                        <li>Colluding with other players to manipulate outcomes</li>
                        <li>Attempting to exploit platform vulnerabilities</li>
                    </ul>

                    <h3>Financial Violations</h3>
                    <ul>
                        <li>Money laundering or other illegal financial activities</li>
                        <li>Using stolen payment methods or fraudulent funds</li>
                        <li>Attempting to manipulate the wallet or payment system</li>
                        <li>Chargebacks or payment disputes without valid reason</li>
                    </ul>

                    <h3>Platform Abuse</h3>
                    <ul>
                        <li>Harassment, threats, or abusive behavior toward other users</li>
                        <li>Spam, advertising, or promotional content</li>
                        <li>Attempting to reverse engineer or hack the platform</li>
                        <li>Violating any applicable laws or regulations</li>
                    </ul>
                </section>

                <section id="termination" class="policy-section">
                    <h2>10. Account Termination</h2>
                    
                    <h3>Termination by You</h3>
                    <ul>
                        <li>You may terminate your account at any time</li>
                        <li>You must withdraw all funds before account closure</li>
                        <li>Some data may be retained for legal and compliance purposes</li>
                    </ul>

                    <h3>Termination by Us</h3>
                    <p>We may suspend or terminate your account for:</p>
                    <ul>
                        <li>Violation of these Terms of Service</li>
                        <li>Suspicious or fraudulent activity</li>
                        <li>Legal or regulatory requirements</li>
                        <li>Risk management purposes</li>
                    </ul>

                    <h3>Effect of Termination</h3>
                    <ul>
                        <li>You will lose access to your account and platform features</li>
                        <li>Pending challenges may be cancelled or resolved</li>
                        <li>Funds may be held pending resolution of any disputes</li>
                        <li>You remain liable for any outstanding obligations</li>
                    </ul>
                </section>

                <section id="disclaimers" class="policy-section">
                    <h2>11. Disclaimers and Limitations</h2>
                    
                    <h3>Service Availability</h3>
                    <ul>
                        <li>We provide our services on an "as is" and "as available" basis</li>
                        <li>We do not guarantee uninterrupted or error-free service</li>
                        <li>Scheduled maintenance may result in temporary service interruptions</li>
                        <li>We are not responsible for third-party service outages</li>
                    </ul>

                    <h3>Limitation of Liability</h3>
                    <p>To the maximum extent permitted by law:</p>
                    <ul>
                        <li>We are not liable for indirect, incidental, or consequential damages</li>
                        <li>Our total liability is limited to the amount in your account balance</li>
                        <li>We are not responsible for losses due to user error or negligence</li>
                        <li>We are not liable for damages caused by force majeure events</li>
                    </ul>
                </section>

                <section id="indemnification" class="policy-section">
                    <h2>12. Indemnification</h2>
                    
                    <p>You agree to indemnify and hold harmless Agamec and its officers, directors, employees, and agents from any claims, damages, losses, or expenses arising from:</p>
                    <ul>
                        <li>Your violation of these Terms of Service</li>
                        <li>Your use of the platform</li>
                        <li>Your violation of any third-party rights</li>
                        <li>Any content you submit to the platform</li>
                    </ul>
                </section>

                <section id="dispute-resolution" class="policy-section">
                    <h2>13. Dispute Resolution</h2>
                    
                    <h3>Internal Disputes</h3>
                    <ul>
                        <li>Challenge disputes are resolved through our internal process</li>
                        <li>Our support team reviews evidence and makes final decisions</li>
                        <li>Users must provide evidence to support their claims</li>
                        <li>Decisions are typically made within 48-72 hours</li>
                    </ul>

                    <h3>Legal Disputes</h3>
                    <ul>
                        <li>Disputes with the platform should first be addressed through customer support</li>
                        <li>Unresolved disputes may be subject to binding arbitration</li>
                        <li>You waive the right to participate in class action lawsuits</li>
                        <li>Disputes must be filed within one year of the incident</li>
                    </ul>
                </section>

                <section id="governing-law" class="policy-section">
                    <h2>14. Governing Law</h2>
                    
                    <p>These Terms are governed by and construed in accordance with the laws of Nigeria. Any legal proceedings shall be conducted in the appropriate courts of Nigeria.</p>
                </section>

                <section id="changes" class="policy-section">
                    <h2>15. Changes to Terms</h2>
                    
                    <p>We may update these Terms from time to time. We will notify you of material changes by:</p>
                    <ul>
                        <li>Posting a notice on our platform</li>
                        <li>Sending an email notification</li>
                        <li>Updating the "Last updated" date</li>
                    </ul>
                    
                    <p>Your continued use of our platform after changes become effective constitutes acceptance of the updated Terms.</p>
                </section>

                <section id="contact" class="policy-section">
                    <h2>16. Contact Information</h2>
                    
                    <p>If you have questions about these Terms of Service, contact us:</p>
                    
                    <div class="contact-info">
                        <div class="contact-item">
                            <strong>Email:</strong> <a href="mailto:legal@agamec.com">legal@agamec.com</a>
                        </div>
                        <div class="contact-item">
                            <strong>Support:</strong> <a href="{{ route('contact-us') }}">Contact Form</a>
                        </div>
                        <div class="contact-item">
                            <strong>Business Address:</strong> Lagos, Nigeria
                        </div>
                    </div>
                </section>
            </div>
        </div>

        <!-- Agreement Notice -->
        <div class="agreement-notice">
            <h3>⚖️ Legal Agreement</h3>
            <p>
                By using our platform, you acknowledge that you have read, understood, and agree to be bound by these Terms of Service. 
                These Terms constitute the entire agreement between you and Agamec regarding your use of our services.
            </p>
            <div class="agreement-buttons">
                <a href="{{ route('register') }}" class="action-btn primary">
                    <i class="icon">✅</i>
                    Accept & Register
                </a>
                <a href="{{ route('contact-us') }}" class="action-btn secondary">
                    <i class="icon">💬</i>
                    Questions?
                </a>
            </div>
        </div>
    </div>
</div>

<style>
.static-page {
    padding: 2rem 0;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    min-height: 100vh;
}

.page-header {
    text-align: center;
    margin-bottom: 3rem;
}

.page-header h1 {
    font-size: 3rem;
    color: #ff6600;
    margin: 0 0 1rem 0;
    font-weight: 700;
}

.last-updated {
    color: #94a3b8;
    font-style: italic;
    margin: 0;
}

.legal-content {
    max-width: 900px;
    margin: 0 auto;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 15px;
    padding: 3rem;
    margin-bottom: 3rem;
}

.intro-text {
    font-size: 1.2rem;
    color: #94a3b8;
    line-height: 1.8;
    margin-bottom: 3rem;
    text-align: center;
    padding: 2rem;
    background: rgba(255, 102, 0, 0.1);
    border-radius: 12px;
    border: 1px solid rgba(255, 102, 0, 0.2);
}

.toc-section {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 2rem;
    margin-bottom: 3rem;
}

.toc-section h2 {
    color: #ff6600;
    margin: 0 0 1.5rem 0;
    font-size: 1.5rem;
}

.toc-list {
    list-style: none;
    padding: 0;
    margin: 0;
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 0.5rem;
}

.toc-list li {
    margin-bottom: 0.5rem;
}

.toc-list a {
    color: #94a3b8;
    text-decoration: none;
    transition: color 0.3s ease;
    display: block;
    padding: 0.5rem 0;
}

.toc-list a:hover {
    color: #ff6600;
}

.policy-section {
    margin-bottom: 3rem;
    padding-bottom: 2rem;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.policy-section:last-child {
    border-bottom: none;
    margin-bottom: 0;
}

.policy-section h2 {
    color: #ff6600;
    font-size: 1.8rem;
    margin: 0 0 1.5rem 0;
    font-weight: 600;
}

.policy-section h3 {
    color: #e2e8f0;
    font-size: 1.3rem;
    margin: 2rem 0 1rem 0;
    font-weight: 600;
}

.policy-section p {
    color: #94a3b8;
    line-height: 1.8;
    margin-bottom: 1.5rem;
}

.policy-section ul {
    color: #94a3b8;
    line-height: 1.8;
    margin: 1rem 0;
    padding-left: 1.5rem;
}

.policy-section li {
    margin-bottom: 0.5rem;
}

.policy-section strong {
    color: #e2e8f0;
}

.policy-section a {
    color: #ff6600;
    text-decoration: none;
}

.policy-section a:hover {
    text-decoration: underline;
}

.contact-info {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    padding: 1.5rem;
    margin-top: 1rem;
}

.contact-item {
    margin-bottom: 1rem;
    color: #94a3b8;
}

.contact-item:last-child {
    margin-bottom: 0;
}

.contact-item strong {
    color: #e2e8f0;
}

.contact-item a {
    color: #ff6600;
    text-decoration: none;
}

.contact-item a:hover {
    text-decoration: underline;
}

.agreement-notice {
    max-width: 900px;
    margin: 0 auto;
    background: rgba(255, 102, 0, 0.1);
    border: 1px solid rgba(255, 102, 0, 0.3);
    border-radius: 15px;
    padding: 3rem;
    text-align: center;
}

.agreement-notice h3 {
    color: #ff6600;
    margin: 0 0 1.5rem 0;
    font-size: 1.8rem;
}

.agreement-notice p {
    color: #94a3b8;
    line-height: 1.8;
    margin: 0 0 2rem 0;
    font-size: 1.1rem;
}

.agreement-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
}

.action-btn {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem 2rem;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
    border: 1px solid;
}

.action-btn.primary {
    background: linear-gradient(135deg, #ff6600, #e55a00);
    color: #ffffff;
    border-color: transparent;
}

.action-btn.primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 102, 0, 0.4);
}

.action-btn.secondary {
    background: rgba(255, 255, 255, 0.1);
    color: #e2e8f0;
    border-color: #e2e8f0;
}

.action-btn.secondary:hover {
    background: #e2e8f0;
    color: #1a1a2e;
    transform: translateY(-2px);
}

@media (max-width: 768px) {
    .page-header h1 {
        font-size: 2rem;
    }
    
    .legal-content {
        padding: 2rem 1.5rem;
    }
    
    .intro-text {
        font-size: 1rem;
        padding: 1.5rem;
    }
    
    .toc-section {
        padding: 1.5rem;
    }
    
    .toc-list {
        grid-template-columns: 1fr;
    }
    
    .policy-section h2 {
        font-size: 1.5rem;
    }
    
    .policy-section h3 {
        font-size: 1.2rem;
    }
    
    .agreement-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .action-btn {
        width: 100%;
        max-width: 250px;
        justify-content: center;
    }
}
</style>
@endsection