@extends('layouts.app')

@section('title', 'Invite Players - ' . $tournament->title)

@section('content')
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-8">
            <a href="{{ route('tournaments.show', $tournament) }}" class="text-cod-green hover:text-green-400 transition-colors">
                ← Back to Tournament
            </a>
            <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow mt-2">Invite Players</h1>
            <p class="text-gray-400 mt-2">{{ $tournament->title }}</p>
        </div>

        <!-- Tournament Info -->
        <div class="gaming-card rounded-lg p-6 mb-8">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-center">
                <div>
                    <div class="text-lg font-bold text-cod-green">{{ $tournament->participants->count() }}</div>
                    <div class="text-sm text-gray-400">Current Participants</div>
                </div>
                <div>
                    <div class="text-lg font-bold text-cod-green">{{ $tournament->pendingInvites->count() }}</div>
                    <div class="text-sm text-gray-400">Pending Invites</div>
                </div>
                <div>
                    <div class="text-lg font-bold text-cod-green">{{ $tournament->getMaxParticipants() }}</div>
                    <div class="text-sm text-gray-400">Max Participants</div>
                </div>
                <div>
                    <div class="text-lg font-bold text-cod-green">
                        {{ $tournament->getMaxParticipants() - $tournament->participants->count() - $tournament->pendingInvites->count() }}
                    </div>
                    <div class="text-sm text-gray-400">Spots Available</div>
                </div>
            </div>
        </div>

        @if($tournament->hasParticipantLimit())
            <div class="bg-yellow-500/20 border border-yellow-500 rounded-lg p-4 mb-6">
                <div class="flex items-center">
                    <span class="text-yellow-400">⚠️</span>
                    <span class="text-yellow-400 ml-2">Tournament has reached the maximum participant limit.</span>
                </div>
            </div>
        @endif

        <!-- Invite Form -->
        @if(!$tournament->hasParticipantLimit() && $availableUsers->count() > 0)
            <div class="gaming-card rounded-lg p-6 mb-8">
                <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">Send Invitations</h2>
                
                <form method="POST" action="{{ route('tournaments.invite.send', $tournament) }}">
                    @csrf
                    
                    <!-- Available Users -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-cod-green mb-3">Select Players to Invite</label>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-3 max-h-64 overflow-y-auto p-4 bg-cod-light rounded-lg">
                            @foreach($availableUsers as $user)
                                <label class="flex items-center space-x-3 p-3 bg-cod-gray rounded-lg hover:bg-cod-darker transition-colors cursor-pointer">
                                    <input type="checkbox" name="user_ids[]" value="{{ $user->id }}" 
                                           class="gaming-checkbox">
                                    <div class="flex-1">
                                        <div class="text-gray-300 font-medium">{{ $user->username }}</div>
                                        <div class="text-sm text-gray-400">
                                            Level {{ $user->level }} • ₦{{ number_format($user->wallet_balance) }} balance
                                        </div>
                                    </div>
                                </label>
                            @endforeach
                        </div>
                    </div>

                    <!-- Optional Message -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-cod-green mb-2">Invitation Message (Optional)</label>
                        <textarea name="message" rows="3" 
                                  class="gaming-textarea w-full" 
                                  placeholder="Add a personal message to your invitation...">{{ old('message') }}</textarea>
                    </div>

                    <!-- Submit Button -->
                    <div class="flex justify-end space-x-3">
                        <a href="{{ route('tournaments.show', $tournament) }}" 
                           class="btn-secondary px-6 py-3">Cancel</a>
                        <button type="submit" class="gaming-button px-6 py-3 rounded-lg">
                            Send Invitations
                        </button>
                    </div>
                </form>
            </div>
        @elseif($availableUsers->count() === 0)
            <div class="gaming-card rounded-lg p-6 text-center">
                <div class="text-6xl mb-4">👥</div>
                <h3 class="text-xl font-semibold text-gray-400 mb-2">No Available Users</h3>
                <p class="text-gray-500">All eligible users have already been invited or are participating in the tournament.</p>
            </div>
        @endif

        <!-- Pending Invites List -->
        @if($tournament->pendingInvites->count() > 0)
            <div class="gaming-card rounded-lg p-6">
                <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">Pending Invitations</h2>
                <div class="space-y-3">
                    @foreach($tournament->pendingInvites as $invite)
                        <div class="flex items-center justify-between p-4 bg-cod-light rounded-lg">
                            <div>
                                <div class="text-gray-300 font-medium">{{ $invite->invitee->username }}</div>
                                <div class="text-sm text-gray-400">
                                    Invited {{ $invite->created_at->diffForHumans() }}
                                    @if($invite->expires_at)
                                        • Expires {{ $invite->expires_at->diffForHumans() }}
                                    @endif
                                </div>
                                @if($invite->message)
                                    <div class="text-sm text-gray-400 mt-1">
                                        "{{ $invite->message }}"
                                    </div>
                                @endif
                            </div>
                            <div class="text-right">
                                <span class="text-yellow-400 text-sm">⏳ Pending</span>
                                <div class="text-xs text-gray-500 mt-1">
                                    Level {{ $invite->invitee->level }}
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
// Select all functionality
document.addEventListener('DOMContentLoaded', function() {
    const selectAllBtn = document.createElement('button');
    selectAllBtn.type = 'button';
    selectAllBtn.className = 'text-cod-green text-sm hover:text-green-400 transition-colors mb-2';
    selectAllBtn.textContent = 'Select All';
    
    const userGrid = document.querySelector('.grid');
    if (userGrid) {
        userGrid.parentNode.insertBefore(selectAllBtn, userGrid);
        
        selectAllBtn.addEventListener('click', function() {
            const checkboxes = userGrid.querySelectorAll('input[type="checkbox"]');
            const allChecked = Array.from(checkboxes).every(cb => cb.checked);
            
            checkboxes.forEach(cb => cb.checked = !allChecked);
            selectAllBtn.textContent = allChecked ? 'Select All' : 'Deselect All';
        });
    }
});
</script>
@endpush
@endsection