{{-- Tournament Bracket Display --}}
<div class="bracket-view">
    @if(isset($bracket['matches']) && count($bracket['matches']) > 0)
        @php
            $rounds = $bracket['rounds'];
            $matchesByRound = collect($bracket['matches'])->groupBy('round');
        @endphp
        
        <div class="flex overflow-x-auto min-w-max space-x-8 py-4">
            @for($round = 1; $round <= $rounds; $round++)
                <div class="flex flex-col justify-center space-y-4">
                    <!-- Round Header -->
                    <div class="text-center mb-4">
                        <h3 class="text-lg font-semibold text-cod-green">
                            @if($round == 1)
                                Round 1
                            @elseif($round == $rounds)
                                Final
                            @elseif($round == $rounds - 1)
                                Semi-Final
                            @else
                                Round {{ $round }}
                            @endif
                        </h3>
                    </div>
                    
                    <!-- Matches for this round -->
                    @if(isset($matchesByRound[$round]))
                        @foreach($matchesByRound[$round] as $match)
                            <div class="bg-cod-light rounded-lg p-4 min-w-[240px] border border-cod-gray">
                                <!-- Player A -->
                                <div class="flex items-center justify-between mb-2 p-2 rounded 
                                    {{ ($match['winner'] ?? null) === ($match['player_a']['id'] ?? null) ? 'bg-green-600/20 border border-green-500' : 'bg-cod-gray' }}">
                                    <span class="text-gray-300 font-medium">
                                        {{ $match['player_a']['username'] ?? 'TBD' }}
                                    </span>
                                    @if(($match['winner'] ?? null) === ($match['player_a']['id'] ?? null))
                                        <span class="text-green-400">✓</span>
                                    @endif
                                </div>
                                
                                <!-- VS Divider -->
                                <div class="text-center text-gray-400 text-sm mb-2">VS</div>
                                
                                <!-- Player B -->
                                <div class="flex items-center justify-between p-2 rounded 
                                    {{ ($match['winner'] ?? null) === ($match['player_b']['id'] ?? null) ? 'bg-green-600/20 border border-green-500' : 'bg-cod-gray' }}">
                                    <span class="text-gray-300 font-medium">
                                        {{ $match['player_b']['username'] ?? 'TBD' }}
                                    </span>
                                    @if(($match['winner'] ?? null) === ($match['player_b']['id'] ?? null))
                                        <span class="text-green-400">✓</span>
                                    @endif
                                </div>
                                
                                <!-- Match Status -->
                                <div class="text-center mt-2">
                                    @if($match['status'] === 'completed')
                                        <span class="text-green-400 text-xs">✓ Completed</span>
                                    @elseif($match['status'] === 'pending')
                                        <span class="text-yellow-400 text-xs">⏳ In Progress</span>
                                    @else
                                        <span class="text-gray-400 text-xs">⏸ Waiting</span>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                
                {{-- Connection lines between rounds --}}
                @if($round < $rounds)
                    <div class="flex flex-col justify-center">
                        <div class="w-8 h-px bg-cod-green"></div>
                    </div>
                @endif
            @endfor
        </div>
        
        {{-- Tournament Winner --}}
        @if($rounds > 0 && isset($matchesByRound[$rounds]))
            @php
                $finalMatch = $matchesByRound[$rounds]->first();
                $winner = null;
                if (($finalMatch['winner'] ?? null) === ($finalMatch['player_a']['id'] ?? null)) {
                    $winner = $finalMatch['player_a'];
                } elseif (($finalMatch['winner'] ?? null) === ($finalMatch['player_b']['id'] ?? null)) {
                    $winner = $finalMatch['player_b'];
                }
            @endphp
            
            @if($winner)
                <div class="text-center mt-8">
                    <div class="inline-block bg-gradient-to-r from-yellow-400 to-yellow-600 rounded-lg p-6 text-black">
                        <div class="text-2xl mb-2">🏆</div>
                        <div class="text-xl font-bold">Tournament Champion</div>
                        <div class="text-lg font-semibold">{{ $winner['username'] }}</div>
                    </div>
                </div>
            @endif
        @endif
    @else
        <div class="text-center py-8">
            <div class="text-gray-400">Bracket will be generated when tournament starts</div>
        </div>
    @endif
</div>

<style>
.bracket-view {
    font-family: 'Orbitron', monospace;
}

.bracket-view .bg-cod-light {
    transition: all 0.3s ease;
}

.bracket-view .bg-cod-light:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 255, 136, 0.2);
}
</style>