@extends('layouts.app')

@section('title', $tournament->title)

@section('content')
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Tournament Header -->
        <div class="gaming-card rounded-lg p-6 mb-8">
            <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center mb-6">
                <div>
                    <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow mb-2">{{ $tournament->title }}</h1>
                    <div class="flex items-center space-x-4 text-gray-400">
                        <span>{{ $tournament->game->name }}</span>
                        <span>•</span>
                        <span>{{ ucfirst($tournament->type) }} Tournament</span>
                        <span>•</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                            @if($tournament->status === 'upcoming') bg-yellow-100 text-yellow-800
                            @elseif($tournament->status === 'ongoing') bg-green-100 text-green-800
                            @else bg-gray-100 text-gray-800
                            @endif">
                            {{ ucfirst($tournament->status) }}
                        </span>
                    </div>
                </div>

                <div class="flex space-x-3 mt-4 lg:mt-0">
                    @auth
                        @if($tournament->host_id === auth()->id())
                            <!-- Tournament Host Actions -->
                            @if($tournament->isUpcoming())
                                <a href="{{ route('tournaments.invite', $tournament) }}" class="btn-secondary px-4 py-2 rounded-lg">
                                    Invite Players
                                </a>
                                @if($tournament->canStart())
                                    <form method="POST" action="{{ route('tournaments.start', $tournament) }}" class="inline">
                                        @csrf
                                        <button type="submit" class="gaming-button px-4 py-2 rounded-lg" 
                                                onclick="return confirm('Are you sure you want to start this tournament?')">
                                            Start Tournament
                                        </button>
                                    </form>
                                @else
                                    <span class="text-gray-400 text-sm px-4 py-2">
                                        Need {{ $tournament->requiresEvenParticipants() ? 'power of 2' : 'more' }} participants to start
                                    </span>
                                @endif
                            @endif
                        @else
                            <!-- Participant Actions -->
                            @if($tournament->canBeJoinedBy(auth()->user()))
                                <form method="POST" action="{{ route('tournaments.join', $tournament) }}" class="inline">
                                    @csrf
                                    <button type="submit" class="gaming-button px-4 py-2 rounded-lg">
                                        Join Tournament (₦{{ number_format($tournament->entry_fee) }})
                                    </button>
                                </form>
                            @elseif($tournament->users->contains(auth()->user()))
                                <span class="text-green-400 px-4 py-2 bg-green-600/20 rounded-lg">
                                    ✓ You're participating
                                </span>
                            @endif
                        @endif
                    @endauth
                </div>
            </div>

            <!-- Tournament Stats -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green">₦{{ number_format($tournament->prize_pool) }}</div>
                    <div class="text-sm text-gray-400">Prize Pool</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green">{{ $tournament->participants->count() }}</div>
                    <div class="text-sm text-gray-400">Participants</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green">₦{{ number_format($tournament->entry_fee) }}</div>
                    <div class="text-sm text-gray-400">Entry Fee</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green">{{ $tournament->host->username }}</div>
                    <div class="text-sm text-gray-400">Host</div>
                </div>
            </div>

            @if($tournament->description)
                <div class="mt-6 p-4 bg-cod-light rounded-lg">
                    <h3 class="text-lg font-semibold text-cod-green mb-2">Description</h3>
                    <p class="text-gray-300">{{ $tournament->description }}</p>
                </div>
            @endif
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Tournament Bracket -->
            @if($tournament->type === 'knockout' && $tournament->bracket_json)
                <div class="lg:col-span-2">
                    <div class="gaming-card rounded-lg p-6">
                        <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">Tournament Bracket</h2>
                        <div class="bracket-container overflow-x-auto">
                            @include('tournaments.partials.bracket', ['bracket' => $tournament->bracket_json])
                        </div>
                    </div>
                </div>
            @endif

            <!-- Participants & Pending Invites -->
            <div class="{{ $tournament->bracket_json ? '' : 'lg:col-span-3' }}">
                <!-- Participants -->
                <div class="gaming-card rounded-lg p-6 mb-6">
                    <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">
                        Participants ({{ $tournament->participants->count() }})
                    </h2>
                    <div class="space-y-3">
                        @forelse($tournament->participants as $participant)
                            <div class="flex items-center justify-between p-3 bg-cod-light rounded-lg">
                                <div class="flex items-center space-x-3">
                                    <div class="w-8 h-8 bg-cod-green rounded-full flex items-center justify-center text-black font-bold">
                                        {{ $participant->seed ?? '#' }}
                                    </div>
                                    <span class="text-gray-300">{{ $participant->user->username }}</span>
                                    @if($participant->result === 'winner')
                                        <span class="text-yellow-400">👑</span>
                                    @elseif($participant->result === 'runner_up')
                                        <span class="text-gray-400">🥈</span>
                                    @endif
                                </div>
                                <div class="text-sm text-gray-400">
                                    Level {{ $participant->user->level }}
                                </div>
                            </div>
                        @empty
                            <p class="text-gray-400 text-center py-4">No participants yet</p>
                        @endforelse
                    </div>
                </div>

                <!-- Pending Invites (for tournament host) -->
                @if(auth()->check() && $tournament->host_id === auth()->id() && $tournament->pendingInvites->count() > 0)
                    <div class="gaming-card rounded-lg p-6">
                        <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">
                            Pending Invites ({{ $tournament->pendingInvites->count() }})
                        </h2>
                        <div class="space-y-3">
                            @foreach($tournament->pendingInvites as $invite)
                                <div class="flex items-center justify-between p-3 bg-cod-light rounded-lg">
                                    <div>
                                        <span class="text-gray-300">{{ $invite->invitee->username }}</span>
                                        <div class="text-sm text-gray-400">
                                            Invited {{ $invite->created_at->diffForHumans() }}
                                        </div>
                                    </div>
                                    <span class="text-yellow-400 text-sm">⏳ Pending</span>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Tournament Matches -->
        @if($tournament->matches->count() > 0)
            <div class="gaming-card rounded-lg p-6 mt-8">
                <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">Matches</h2>
                <div class="space-y-4">
                    @foreach($tournament->matches->groupBy('round') as $round => $roundMatches)
                        <div>
                            <h3 class="text-lg font-semibold text-gray-300 mb-3">Round {{ $round }}</h3>
                            <div class="grid gap-4">
                                @foreach($roundMatches as $match)
                                    <div class="flex items-center justify-between p-4 bg-cod-light rounded-lg">
                                        <div class="flex items-center space-x-4">
                                            <span class="text-gray-300">{{ $match->playerA->username }}</span>
                                            <span class="text-gray-400">vs</span>
                                            <span class="text-gray-300">{{ $match->playerB->username }}</span>
                                        </div>
                                        <div class="text-sm">
                                            @if($match->result === 'none')
                                                <span class="text-yellow-400">Pending</span>
                                            @elseif($match->result === 'player_a_win')
                                                <span class="text-green-400">{{ $match->playerA->username }} Won</span>
                                            @else
                                                <span class="text-green-400">{{ $match->playerB->username }} Won</span>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>
@endsection