@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="min-h-screen bg-cod-darker">
    <!-- Enhanced Dashboard Header -->
    <div class="bg-gradient-to-br from-cod-green to-yellow-600 py-12 relative overflow-hidden">
        <!-- Background Pattern -->
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-10 left-10 w-20 h-20 border-2 border-black rounded-xl rotate-45 animate-pulse"></div>
            <div class="absolute top-32 right-20 w-16 h-16 border-2 border-black rounded-full animate-bounce-slow"></div>
            <div class="absolute bottom-20 left-1/4 w-12 h-12 border-2 border-black rotate-45 animate-ping-slow"></div>
        </div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
            <div class="text-center">
                <div class="animate-float">
                    <h1 class="text-5xl font-gaming font-bold text-black mb-4 gaming-text-glow">🎯 Your Gaming Dashboard</h1>
                    <p class="text-black/80 text-xl mb-6">Welcome back, <span class="font-bold">{{ auth()->user()->username }}</span>!</p>
                </div>
                
                <!-- Quick Stats Bar -->
                <div class="flex flex-wrap justify-center gap-4 mt-8">
                    <div class="bg-black/20 backdrop-blur-sm rounded-lg px-4 py-2 border border-black/30">
                        <div class="text-sm text-black/70">Level</div>
                        <div class="text-lg font-bold text-black">{{ auth()->user()->level }}</div>
                    </div>
                    <div class="bg-black/20 backdrop-blur-sm rounded-lg px-4 py-2 border border-black/30">
                        <div class="text-sm text-black/70">XP</div>
                        <div class="text-lg font-bold text-black">{{ number_format(auth()->user()->xp ?? 0) }}</div>
                    </div>
                    <div class="bg-black/20 backdrop-blur-sm rounded-lg px-4 py-2 border border-black/30">
                        <div class="text-sm text-black/70">Wallet</div>
                        <div class="text-lg font-bold text-black">₦{{ number_format(auth()->user()->wallet_balance ?? 0, 2) }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- User Stats Section -->
    @if($userStats)
        <section class="py-12">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="text-3xl font-gaming font-bold text-cod-green mb-8 text-center">Your Gaming Stats</h2>
                
                <div class="responsive-grid mb-12">
                    <div class="card-hover bg-black/20 backdrop-blur-sm rounded-2xl p-6 text-center border border-cod-green/30 group">
                        <div class="text-4xl font-bold text-cod-green mb-3 group-hover:animate-pulse">{{ $userStats['total_challenges'] }}</div>
                        <div class="text-gray-300 font-medium mb-2">Battles Fought</div>
                        <div class="w-full bg-gray-700 rounded-full h-2">
                            <div class="bg-cod-green h-2 rounded-full transition-all duration-1000" style="width: {{ min(100, ($userStats['total_challenges'] / 10) * 100) }}%"></div>
                        </div>
                    </div>
                    
                    <div class="card-hover bg-black/20 backdrop-blur-sm rounded-2xl p-6 text-center border border-purple-500/30 group">
                        <div class="text-4xl font-bold text-purple-400 mb-3 group-hover:animate-pulse">{{ $userStats['wins'] }}</div>
                        <div class="text-gray-300 font-medium mb-2">Victories</div>
                        <div class="w-full bg-gray-700 rounded-full h-2">
                            @php $winRate = $userStats['total_challenges'] > 0 ? ($userStats['wins'] / $userStats['total_challenges']) * 100 : 0; @endphp
                            <div class="bg-purple-400 h-2 rounded-full transition-all duration-1000" style="width: {{ $winRate }}%"></div>
                        </div>
                        <div class="text-xs text-gray-400 mt-1">{{ number_format($winRate, 1) }}% Win Rate</div>
                    </div>
                    
                    <div class="card-hover bg-black/20 backdrop-blur-sm rounded-2xl p-6 text-center border border-yellow-500/30 group 
                        @if($userStats['is_premium']) ring-2 ring-yellow-400/50 @endif">
                        <div class="text-4xl font-bold text-yellow-400 mb-3 group-hover:animate-pulse">₦{{ number_format($userStats['total_earnings']) }}</div>
                        <div class="text-gray-300 font-medium mb-2">Total Earnings</div>
                        @if($userStats['is_premium'])
                            <div class="mt-3">
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800 animate-pulse">
                                    ⭐ Premium Boost Active
                                </span>
                            </div>
                        @endif
                        <div class="w-full bg-gray-700 rounded-full h-2 mt-2">
                            <div class="bg-yellow-400 h-2 rounded-full transition-all duration-1000" style="width: {{ min(100, ($userStats['total_earnings'] / 10000) * 100) }}%"></div>
                        </div>
                    </div>
                    
                    <div class="card-hover bg-black/20 backdrop-blur-sm rounded-2xl p-6 text-center border border-blue-500/30 group">
                        <div class="text-2xl font-bold text-blue-400 mb-3 group-hover:animate-pulse">{{ $userStats['role_display'] }}</div>
                        <div class="text-gray-300 font-medium mb-2">Current Role</div>
                        <div class="flex justify-center items-center space-x-1">
                            @for($i = 1; $i <= 5; $i++)
                                <div class="w-2 h-2 rounded-full {{ $i <= auth()->user()->level ? 'bg-blue-400' : 'bg-gray-600' }} transition-all duration-300"></div>
                            @endfor
                        </div>
                    </div>
                </div>

                <!-- Role-specific stats for moderators -->
                @if($moderatorStats)
                    <div class="mb-8">
                        <h3 class="text-2xl font-gaming font-bold text-orange-500 mb-6 text-center">Moderator Dashboard</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div class="bg-black/20 backdrop-blur-sm rounded-xl p-4 text-center border border-orange-500/30">
                                <div class="text-2xl font-bold text-orange-400 mb-1">{{ $moderatorStats['pending_disputes'] }}</div>
                                <div class="text-gray-300 text-sm">Pending Disputes</div>
                            </div>
                            <div class="bg-black/20 backdrop-blur-sm rounded-xl p-4 text-center border border-green-500/30">
                                <div class="text-2xl font-bold text-green-400 mb-1">{{ $moderatorStats['resolved_disputes'] }}</div>
                                <div class="text-gray-300 text-sm">Resolved</div>
                            </div>
                            <div class="bg-black/20 backdrop-blur-sm rounded-xl p-4 text-center border border-red-500/30">
                                <div class="text-2xl font-bold text-red-400 mb-1">{{ $moderatorStats['unassigned_disputes'] }}</div>
                                <div class="text-gray-300 text-sm">Unassigned</div>
                            </div>
                        </div>
                        <div class="text-center mt-6">
                            <a href="{{ route('moderator.dashboard') }}" 
                               class="btn-primary-modern inline-flex items-center">
                                ⚖️ Go to Moderator Panel
                            </a>
                        </div>
                    </div>
                @endif
            </div>
        </section>
    @endif

    <!-- Quick Actions Section -->
    <section class="py-12 bg-cod-dark/30">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-gaming font-bold text-cod-green mb-4">Quick Actions</h2>
                <p class="text-gray-400">Jump into action with these popular features</p>
            </div>
            
            <div class="responsive-grid">
                <!-- Create Challenge -->
                @if(auth()->user()->role->canCreateContent())
                <div class="card-hover bg-cod-gray rounded-xl p-6 border border-cod-green/30 group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-xl mx-auto mb-4 flex items-center justify-center group-hover:animate-bounce">
                            <span class="text-2xl">⚔️</span>
                        </div>
                        <h3 class="text-xl font-bold text-cod-green mb-2">Create Challenge</h3>
                        <p class="text-gray-400 text-sm mb-4">Challenge other players to 1v1 matches</p>
                        <a href="{{ route('challenges.create') }}" class="btn-primary-modern w-full">
                            Start Challenge
                        </a>
                    </div>
                </div>
                @endif

                <!-- Browse Challenges -->
                <div class="card-hover bg-cod-gray rounded-xl p-6 border border-purple-500/30 group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-purple-500 to-purple-600 rounded-xl mx-auto mb-4 flex items-center justify-center group-hover:animate-bounce">
                            <span class="text-2xl">🔍</span>
                        </div>
                        <h3 class="text-xl font-bold text-purple-400 mb-2">Browse Challenges</h3>
                        <p class="text-gray-400 text-sm mb-4">Find and accept challenges from other players</p>
                        <a href="{{ route('challenges.index') }}" class="btn-secondary-modern w-full">
                            Explore Challenges
                        </a>
                    </div>
                </div>

                <!-- Join Tournament -->
                <div class="card-hover bg-cod-gray rounded-xl p-6 border border-yellow-500/30 group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-yellow-500 to-yellow-600 rounded-xl mx-auto mb-4 flex items-center justify-center group-hover:animate-bounce">
                            <span class="text-2xl">🏆</span>
                        </div>
                        <h3 class="text-xl font-bold text-yellow-400 mb-2">Tournaments</h3>
                        <p class="text-gray-400 text-sm mb-4">Compete in organized tournaments</p>
                        <a href="{{ route('tournaments.index') }}" class="btn-secondary-modern w-full">
                            View Tournaments
                        </a>
                    </div>
                </div>

                <!-- Wallet -->
                <div class="card-hover bg-cod-gray rounded-xl p-6 border border-green-500/30 group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-green-500 to-green-600 rounded-xl mx-auto mb-4 flex items-center justify-center group-hover:animate-bounce">
                            <span class="text-2xl">💰</span>
                        </div>
                        <h3 class="text-xl font-bold text-green-400 mb-2">My Wallet</h3>
                        <p class="text-gray-400 text-sm mb-4">Manage your funds and transactions</p>
                        <a href="{{ route('wallet.index') }}" class="btn-secondary-modern w-full">
                            Manage Wallet
                        </a>
                    </div>
                </div>

                <!-- Leaderboards -->
                <div class="card-hover bg-cod-gray rounded-xl p-6 border border-blue-500/30 group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-600 rounded-xl mx-auto mb-4 flex items-center justify-center group-hover:animate-bounce">
                            <span class="text-2xl">🏅</span>
                        </div>
                        <h3 class="text-xl font-bold text-blue-400 mb-2">Leaderboards</h3>
                        <p class="text-gray-400 text-sm mb-4">See how you rank against other players</p>
                        <a href="{{ route('leaderboards.index') }}" class="btn-secondary-modern w-full">
                            View Rankings
                        </a>
                    </div>
                </div>

                <!-- Friends -->
                <div class="card-hover bg-cod-gray rounded-xl p-6 border border-pink-500/30 group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-pink-500 to-pink-600 rounded-xl mx-auto mb-4 flex items-center justify-center group-hover:animate-bounce">
                            <span class="text-2xl">👥</span>
                        </div>
                        <h3 class="text-xl font-bold text-pink-400 mb-2">Friends</h3>
                        <p class="text-gray-400 text-sm mb-4">Connect with other gamers</p>
                        <a href="{{ route('friends.index') }}" class="btn-secondary-modern w-full">
                            My Friends
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Pending Invites and Requests -->
    <section class="py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-8">
                <h2 class="text-3xl font-gaming font-bold text-cod-green mb-4">Quick Actions</h2>
            </div>
            
            <div class="flex flex-col sm:flex-row gap-6 justify-center items-center">
                @if(auth()->user()->canCreateChallenges())
                    <a href="{{ route('challenges.create') }}" class="gaming-button text-xl px-12 py-6 text-black font-bold transform hover:scale-110 transition-all duration-300 shadow-2xl hover:shadow-cod-green/50">
                        ⚔️ Create Challenge
                    </a>
                @endif
                <a href="{{ route('challenges.index') }}" class="border-2 border-cod-green text-cod-green px-12 py-6 rounded-xl font-bold text-xl hover:bg-cod-green hover:text-black transition-all duration-300 transform hover:scale-110">
                    Browse Challenges
                </a>
                <a href="{{ route('tournaments.index') }}" class="border-2 border-purple-500 text-purple-400 px-12 py-6 rounded-xl font-bold text-xl hover:bg-purple-500 hover:text-black transition-all duration-300 transform hover:scale-110">
                    🏆 Join Tournament
                </a>
            </div>

            <!-- My Content Quick Access -->
            <div class="mt-8 text-center">
                <h3 class="text-xl font-gaming font-bold text-gray-300 mb-4">My Content</h3>
                <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                    <a href="{{ route('challenges.my') }}" class="border-2 border-cod-green/60 text-cod-green/80 px-8 py-4 rounded-xl font-semibold text-lg hover:bg-cod-green/20 hover:border-cod-green hover:text-cod-green transition-all duration-300 transform hover:scale-105">
                        ⚔️ My Challenges
                    </a>
                    <a href="{{ route('tournaments.my') }}" class="border-2 border-purple-500/60 text-purple-400/80 px-8 py-4 rounded-xl font-semibold text-lg hover:bg-purple-500/20 hover:border-purple-500 hover:text-purple-400 transition-all duration-300 transform hover:scale-105">
                        🏆 My Tournaments
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Pending Invites and Requests -->
    @if($pendingTournamentInvites->count() > 0 || $pendingChallengeInvites->count() > 0 || $pendingFriendRequests->count() > 0)
        <section class="py-8">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="text-2xl font-gaming font-bold text-cod-green mb-6">Pending Notifications</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <!-- Tournament Invites -->
                    @if($pendingTournamentInvites->count() > 0)
                        <div class="bg-cod-gray rounded-lg p-6 border border-cod-green/30">
                            <h3 class="text-lg font-bold text-purple-400 mb-4">🏆 Tournament Invites</h3>
                            @foreach($pendingTournamentInvites as $invite)
                                <div class="bg-cod-dark rounded p-3 mb-3">
                                    <div class="text-sm text-gray-300">{{ $invite->tournament->name }}</div>
                                    <div class="text-xs text-gray-400">by {{ $invite->inviter->name }}</div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <!-- Challenge Invites -->
                    @if($pendingChallengeInvites->count() > 0)
                        <div class="bg-cod-gray rounded-lg p-6 border border-yellow-500/30">
                            <h3 class="text-lg font-bold text-yellow-400 mb-4">⚔️ Challenge Invites</h3>
                            @foreach($pendingChallengeInvites as $invite)
                                <div class="bg-cod-dark rounded p-3 mb-3">
                                    <div class="text-sm text-gray-300">{{ $invite->challenge->title }}</div>
                                    <div class="text-xs text-gray-400">by {{ $invite->inviter->name }}</div>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <!-- Friend Requests -->
                    @if($pendingFriendRequests->count() > 0)
                        <div class="bg-cod-gray rounded-lg p-6 border border-blue-500/30">
                            <h3 class="text-lg font-bold text-blue-400 mb-4">👥 Friend Requests</h3>
                            @foreach($pendingFriendRequests as $request)
                                <div class="bg-cod-dark rounded p-3 mb-3">
                                    <div class="text-sm text-gray-300">{{ $request->user->name }}</div>
                                    <div class="text-xs text-gray-400">wants to be friends</div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </section>
    @endif

    <!-- Active Challenges and Tournaments -->
    @if($userChallenges->count() > 0 || $userTournaments->count() > 0)
        <section class="py-8">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="text-2xl font-gaming font-bold text-cod-green mb-6">Your Active Competitions</h2>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Active Challenges -->
                    @if($userChallenges->count() > 0)
                        <div class="bg-cod-gray rounded-lg p-6 border border-cod-green/30">
                            <h3 class="text-lg font-bold text-cod-green mb-4">⚔️ Active Challenges</h3>
                            @foreach($userChallenges as $challenge)
                                <div class="bg-cod-dark rounded p-4 mb-3">
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <div class="text-sm font-medium text-gray-200">{{ $challenge->title }}</div>
                                            <div class="text-xs text-gray-400">{{ $challenge->game->name ?? 'Game' }}</div>
                                            <div class="text-xs text-cod-green">₦{{ number_format($challenge->wager_amount) }}</div>
                                        </div>
                                        <span class="px-2 py-1 text-xs bg-yellow-500/20 text-yellow-400 rounded">{{ ucfirst($challenge->status) }}</span>
                                    </div>
                                </div>
                            @endforeach
                            <a href="{{ route('challenges.index') }}" class="text-cod-green text-sm hover:underline">View all challenges →</a>
                        </div>
                    @endif

                    <!-- Upcoming Tournaments -->
                    @if($userTournaments->count() > 0)
                        <div class="bg-cod-gray rounded-lg p-6 border border-purple-500/30">
                            <h3 class="text-lg font-bold text-purple-400 mb-4">🏆 Upcoming Tournaments</h3>
                            @foreach($userTournaments as $tournament)
                                <div class="bg-cod-dark rounded p-4 mb-3">
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <div class="text-sm font-medium text-gray-200">{{ $tournament->name }}</div>
                                            <div class="text-xs text-gray-400">{{ $tournament->game->name ?? 'Game' }}</div>
                                            <div class="text-xs text-purple-400">₦{{ number_format($tournament->prize_pool) }}</div>
                                        </div>
                                        <span class="px-2 py-1 text-xs bg-purple-500/20 text-purple-400 rounded">{{ ucfirst($tournament->status) }}</span>
                                    </div>
                                </div>
                            @endforeach
                            <a href="{{ route('tournaments.index') }}" class="text-purple-400 text-sm hover:underline">View all tournaments →</a>
                        </div>
                    @endif
                </div>
            </div>
        </section>
    @endif

    <!-- Recent Activity -->
    @if($recentActivity->count() > 0)
        <section class="py-8">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <h2 class="text-2xl font-gaming font-bold text-cod-green mb-6">Recent Activity</h2>
                
                <div class="bg-cod-gray rounded-lg p-6 border border-cod-green/30">
                    @foreach($recentActivity as $activity)
                        <div class="flex items-center justify-between py-3 border-b border-cod-light/20 last:border-b-0">
                            <div class="flex items-center space-x-4">
                                <div class="w-10 h-10 bg-cod-green rounded-full flex items-center justify-center">
                                    <span class="text-black font-bold">⚔️</span>
                                </div>
                                <div>
                                    <div class="text-sm text-gray-200">
                                        Challenge: {{ $activity->title }}
                                    </div>
                                    <div class="text-xs text-gray-400">
                                        vs {{ $activity->creator_id === auth()->id() ? $activity->accepter?->name : $activity->creator?->name }}
                                    </div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="text-sm text-cod-green">₦{{ number_format($activity->wager_amount) }}</div>
                                <div class="text-xs text-gray-400">{{ $activity->updated_at->diffForHumans() }}</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif
</div>
@endsection