@extends('layouts.app')

@section('title', 'Deposit Funds')

@section('content')
<div class="min-h-screen bg-cod-black text-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Header -->
        <div class="text-center mb-8">
            <h1 class="text-4xl font-gaming font-bold text-cod-green gaming-text-glow mb-4">Deposit Funds</h1>
            <p class="text-gray-400">Add funds to your gaming wallet securely</p>
        </div>

        <div class="gaming-card rounded-lg p-8">
            <form action="{{ route('wallet.deposit.store') }}" method="POST" class="space-y-6">
                @csrf

                <!-- Amount Input -->
                <div>
                    <label for="amount" class="block text-sm font-medium text-gray-300 mb-2">
                        Amount to Deposit
                    </label>
                    <div class="relative">
                        <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 text-lg">₦</span>
                        <input type="number" 
                               id="amount" 
                               name="amount" 
                               min="10" 
                               max="100000"
                               step="0.01"
                               value="{{ old('amount') }}"
                               class="w-full pl-10 pr-4 py-3 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                               placeholder="Enter amount"
                               required>
                    </div>
                    <p class="text-sm text-gray-400 mt-1">Minimum: ₦10, Maximum: ₦100,000</p>
                    @error('amount')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Payment Provider Selection -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-4">
                        Select Payment Method
                    </label>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Paystack -->
                        <label class="relative cursor-pointer">
                            <input type="radio" name="provider" value="paystack" class="sr-only peer" required>
                            <div class="border-2 border-gray-600 peer-checked:border-cod-green rounded-lg p-4 transition-all duration-200 peer-checked:bg-cod-green/10">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-lg">P</span>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-white">Paystack</h3>
                                        <p class="text-sm text-gray-400">Cards, Bank Transfer, USSD</p>
                                    </div>
                                </div>
                            </div>
                        </label>

                        <!-- Flutterwave -->
                        <label class="relative cursor-pointer">
                            <input type="radio" name="provider" value="flutterwave" class="sr-only peer" required>
                            <div class="border-2 border-gray-600 peer-checked:border-cod-green rounded-lg p-4 transition-all duration-200 peer-checked:bg-cod-green/10">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 bg-orange-600 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-lg">F</span>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-white">Flutterwave</h3>
                                        <p class="text-sm text-gray-400">Cards, Mobile Money, Bank</p>
                                    </div>
                                </div>
                            </div>
                        </label>

                        <!-- PayPal -->
                        <label class="relative cursor-pointer">
                            <input type="radio" name="provider" value="paypal" class="sr-only peer" required>
                            <div class="border-2 border-gray-600 peer-checked:border-cod-green rounded-lg p-4 transition-all duration-200 peer-checked:bg-cod-green/10">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 bg-blue-700 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-lg">PP</span>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-white">PayPal</h3>
                                        <p class="text-sm text-gray-400">Global payment platform</p>
                                    </div>
                                </div>
                            </div>
                        </label>

                        <!-- Stripe -->
                        <label class="relative cursor-pointer">
                            <input type="radio" name="provider" value="stripe" class="sr-only peer" required>
                            <div class="border-2 border-gray-600 peer-checked:border-cod-green rounded-lg p-4 transition-all duration-200 peer-checked:bg-cod-green/10">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-lg">S</span>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-white">Stripe</h3>
                                        <p class="text-sm text-gray-400">Secure card processing</p>
                                    </div>
                                </div>
                            </div>
                        </label>
                    </div>
                    @error('provider')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Security Notice -->
                <div class="bg-cod-green/10 border border-cod-green/30 rounded-lg p-4">
                    <div class="flex items-center space-x-2">
                        <svg class="w-5 h-5 text-cod-green" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                        <div>
                            <h4 class="font-medium text-cod-green">Secure Payment</h4>
                            <p class="text-sm text-gray-300">Your payment information is processed securely. We never store your card details.</p>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center justify-between pt-6 border-t border-cod-green/20">
                    <a href="{{ route('wallet.index') }}" class="btn-secondary px-6 py-3">
                        ← Back to Wallet
                    </a>
                    <button type="submit" class="btn-primary px-6 py-3">
                        💳 Proceed to Payment
                    </button>
                </div>
            </form>
        </div>

        <!-- Information Cards -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-8">
            <div class="gaming-card rounded-lg p-6">
                <div class="text-center">
                    <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-white mb-2">Instant Processing</h3>
                    <p class="text-sm text-gray-400">Funds are added to your wallet immediately after successful payment</p>
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <div class="text-center">
                    <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-white mb-2">Secure Transactions</h3>
                    <p class="text-sm text-gray-400">All payments are encrypted and processed through trusted payment gateways</p>
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <div class="text-center">
                    <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192L5.636 18.364M12 12h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-white mb-2">24/7 Support</h3>
                    <p class="text-sm text-gray-400">Our support team is available round the clock to assist you</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection