@extends('layouts.app')

@section('title', 'My Wallet')

@section('content')
<div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Wallet Header -->
    <div class="text-center mb-8">
        <h1 class="text-4xl font-gaming font-bold text-cod-green gaming-text-glow mb-4">My Wallet</h1>
        <p class="text-gray-400">Manage your gaming funds and transaction history</p>
    </div>

    <!-- Wallet Overview -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <!-- Available Balance -->
        <div class="bg-cod-gray rounded-lg p-6 gaming-glow">
            <div class="text-center">
                <div class="w-16 h-16 bg-green-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-gray-300 mb-2">Available Balance</h3>
                <div class="text-3xl font-bold text-green-400">₦{{ number_format(auth()->user()->wallet_balance) }}</div>
                <div class="text-sm text-gray-400 mt-1">Ready to use</div>
            </div>
        </div>

        <!-- Locked Balance -->
        <div class="bg-cod-gray rounded-lg p-6">
            <div class="text-center">
                <div class="w-16 h-16 bg-yellow-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-gray-300 mb-2">Locked in Challenges</h3>
                <div class="text-3xl font-bold text-yellow-400">₦{{ number_format(auth()->user()->locked_balance) }}</div>
                <div class="text-sm text-gray-400 mt-1">In active challenges</div>
            </div>
        </div>

        <!-- Total Value -->
        <div class="bg-cod-gray rounded-lg p-6">
            <div class="text-center">
                <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-gray-300 mb-2">Total Value</h3>
                <div class="text-3xl font-bold text-cod-green">₦{{ number_format(auth()->user()->wallet_balance + auth()->user()->locked_balance) }}</div>
                <div class="text-sm text-gray-400 mt-1">Combined balance</div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-cod-gray rounded-lg p-6 mb-8">
        <h2 class="text-xl font-semibold text-cod-green mb-4">Quick Actions</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <a href="{{ route('wallet.deposit') }}" class="bg-cod-green text-black text-center px-6 py-4 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                <div class="flex items-center justify-center space-x-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    <span>Add Funds</span>
                </div>
            </a>
            <a href="{{ route('wallet.withdraw') }}" class="bg-cod-light text-cod-green text-center px-6 py-4 rounded-lg font-semibold hover:bg-cod-gray transition-colors">
                <div class="flex items-center justify-center space-x-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4m16 0l-4 4m4-4l-4-4"></path>
                    </svg>
                    <span>Withdraw Funds</span>
                </div>
            </a>
            @if(auth()->user()->hasTransactionPin())
                <a href="{{ route('wallet.transfer') }}" class="bg-blue-600 text-white text-center px-6 py-4 rounded-lg font-semibold hover:bg-blue-700 transition-colors">
                    <div class="flex items-center justify-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                        </svg>
                        <span>Transfer Credits</span>
                    </div>
                </a>
            @else
                <a href="{{ route('wallet.pin-setup') }}" class="bg-yellow-600 text-white text-center px-6 py-4 rounded-lg font-semibold hover:bg-yellow-700 transition-colors">
                    <div class="flex items-center justify-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                        <span>Set PIN</span>
                    </div>
                </a>
            @endif
        </div>
        
        @if(auth()->user()->hasTransactionPin())
            <!-- Transfer & PIN Management Links -->
            <div class="mt-4 pt-4 border-t border-cod-light flex justify-center space-x-6 text-sm">
                <a href="{{ route('wallet.transfer.history') }}" class="text-cod-green hover:text-green-400 font-medium">
                    Transfer History
                </a>
                <span class="text-gray-500">•</span>
                <a href="{{ route('wallet.pin-change') }}" class="text-cod-green hover:text-green-400 font-medium">
                    Change PIN
                </a>
            </div>
        @else
            <!-- PIN Setup Notice -->
            <div class="mt-4 pt-4 border-t border-cod-light">
                <div class="bg-yellow-500/10 border border-yellow-500/20 rounded-lg p-4">
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-yellow-400 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                        </svg>
                        <div>
                            <h4 class="text-yellow-400 font-medium mb-1">Enable Credit Transfers</h4>
                            <p class="text-sm text-yellow-300">Set up a 4-digit PIN to start transferring credits to other players.</p>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>

    <!-- Transaction History -->
    <div class="bg-cod-gray rounded-lg p-6">
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-xl font-semibold text-cod-green">Transaction History</h2>
            <div class="flex space-x-2">
                <select class="bg-cod-dark text-gray-100 border border-cod-light rounded px-3 py-1 text-sm">
                    <option>All Types</option>
                    <option>Deposits</option>
                    <option>Withdrawals</option>
                    <option>Transfers</option>
                    <option>Challenges</option>
                    <option>Prizes</option>
                </select>
                <select class="bg-cod-dark text-gray-100 border border-cod-light rounded px-3 py-1 text-sm">
                    <option>Last 30 days</option>
                    <option>Last 7 days</option>
                    <option>This month</option>
                    <option>All time</option>
                </select>
            </div>
        </div>

        @if(auth()->user()->walletTransactions()->latest()->take(20)->get()->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-cod-light">
                            <th class="text-left py-3 px-4 text-gray-300 font-semibold">Date</th>
                            <th class="text-left py-3 px-4 text-gray-300 font-semibold">Type</th>
                            <th class="text-left py-3 px-4 text-gray-300 font-semibold">Description</th>
                            <th class="text-right py-3 px-4 text-gray-300 font-semibold">Amount</th>
                            <th class="text-center py-3 px-4 text-gray-300 font-semibold">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach(auth()->user()->walletTransactions()->latest()->take(20)->get() as $transaction)
                            <tr class="border-b border-cod-dark hover:bg-cod-dark transition-colors">
                                <td class="py-3 px-4 text-gray-100">
                                    {{ $transaction->created_at->format('M j, Y') }}
                                    <div class="text-xs text-gray-400">{{ $transaction->created_at->format('H:i') }}</div>
                                </td>
                                <td class="py-3 px-4">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                        @if($transaction->type === 'deposit') bg-green-500/20 text-green-400
                                        @elseif($transaction->type === 'withdraw') bg-red-500/20 text-red-400
                                        @elseif($transaction->type === 'prize') bg-yellow-500/20 text-yellow-400
                                        @elseif($transaction->type === 'wager') bg-blue-500/20 text-blue-400
                                        @elseif($transaction->type === 'fee') bg-gray-500/20 text-gray-400
                                        @elseif($transaction->type === 'transfer') bg-red-500/20 text-red-400
                                        @elseif($transaction->type === 'transfer_received') bg-green-500/20 text-green-400
                                        @else bg-cod-green/20 text-cod-green @endif">
                                        @if($transaction->type === 'transfer')
                                            Transfer Sent
                                        @elseif($transaction->type === 'transfer_received')
                                            Transfer Received
                                        @else
                                            {{ ucfirst($transaction->type) }}
                                        @endif
                                    </span>
                                </td>
                                <td class="py-3 px-4 text-gray-100">{{ $transaction->description ?? 'No description' }}</td>
                                <td class="py-3 px-4 text-right">
                                    <span class="font-semibold {{ $transaction->amount > 0 ? 'text-green-400' : 'text-red-400' }}">
                                        {{ $transaction->amount > 0 ? '+' : '' }}₦{{ number_format(abs($transaction->amount)) }}
                                    </span>
                                </td>
                                <td class="py-3 px-4 text-center">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                        @if($transaction->status === 'completed') bg-green-500/20 text-green-400
                                        @elseif($transaction->status === 'pending') bg-yellow-500/20 text-yellow-400
                                        @elseif($transaction->status === 'failed') bg-red-500/20 text-red-400
                                        @else bg-gray-500/20 text-gray-400 @endif">
                                        {{ ucfirst($transaction->status) }}
                                    </span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mt-6 text-center">
                <a href="#" class="text-cod-green hover:text-green-400 font-medium">View All Transactions</a>
            </div>
        @else
            <div class="text-center py-16">
                <div class="text-6xl mb-4">💳</div>
                <h3 class="text-xl font-semibold text-gray-400 mb-2">No Transactions Yet</h3>
                <p class="text-gray-500">Your transaction history will appear here</p>
                <a href="{{ route('wallet.deposit') }}" class="inline-block mt-4 bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Make First Deposit
                </a>
            </div>
        @endif
    </div>
</div>
@endsection