@extends('layouts.app')

@section('title', 'Change Transaction PIN')

@section('content')
<div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="text-center mb-8">
        <h1 class="text-4xl font-gaming font-bold text-cod-green gaming-text-glow mb-4">Change Transaction PIN</h1>
        <p class="text-gray-400">Update your 4-digit security PIN for credit transfers</p>
    </div>

    <!-- PIN Change Form -->
    <div class="bg-cod-gray rounded-lg p-8 gaming-glow">
        <div class="mb-6">
            <div class="flex items-center justify-center mb-4">
                <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center">
                    <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m0 0a2 2 0 012 2m-2-2v10m6 0H3a2 2 0 01-2-2V9a2 2 0 012-2h1M9 7V5a2 2 0 012-2h2a2 2 0 012 2v2m-6 2h6"></path>
                    </svg>
                </div>
            </div>
            <h2 class="text-xl font-semibold text-cod-green text-center mb-2">Update Security PIN</h2>
            <p class="text-gray-400 text-center">Enter your current PIN and set a new one.</p>
        </div>

        <form action="{{ route('wallet.pin-change.store') }}" method="POST" class="space-y-6">
            @csrf

            <!-- Password Verification -->
            <div>
                <label for="password" class="block text-sm font-medium text-gray-300 mb-2">Current Password</label>
                <input type="password" 
                       id="password" 
                       name="password" 
                       required
                       class="w-full px-4 py-3 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-transparent @error('password') border-red-500 @enderror"
                       placeholder="Enter your current password">
                @error('password')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Current PIN -->
            <div>
                <label for="current_pin" class="block text-sm font-medium text-gray-300 mb-2">Current PIN</label>
                <input type="password" 
                       id="current_pin" 
                       name="current_pin" 
                       maxlength="4"
                       pattern="[0-9]{4}"
                       required
                       class="w-full px-4 py-3 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-transparent text-center text-2xl tracking-widest @error('current_pin') border-red-500 @enderror"
                       placeholder="••••">
                @error('current_pin')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- New PIN -->
            <div>
                <label for="new_pin" class="block text-sm font-medium text-gray-300 mb-2">New PIN</label>
                <input type="password" 
                       id="new_pin" 
                       name="new_pin" 
                       maxlength="4"
                       pattern="[0-9]{4}"
                       required
                       class="w-full px-4 py-3 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-transparent text-center text-2xl tracking-widest @error('new_pin') border-red-500 @enderror"
                       placeholder="••••">
                @error('new_pin')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-sm text-gray-400">Enter a new 4-digit PIN (numbers only)</p>
            </div>

            <!-- New PIN Confirmation -->
            <div>
                <label for="new_pin_confirmation" class="block text-sm font-medium text-gray-300 mb-2">Confirm New PIN</label>
                <input type="password" 
                       id="new_pin_confirmation" 
                       name="new_pin_confirmation" 
                       maxlength="4"
                       pattern="[0-9]{4}"
                       required
                       class="w-full px-4 py-3 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-transparent text-center text-2xl tracking-widest @error('new_pin_confirmation') border-red-500 @enderror"
                       placeholder="••••">
                @error('new_pin_confirmation')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Security Notice -->
            <div class="bg-blue-500/10 border border-blue-500/20 rounded-lg p-4">
                <div class="flex items-start">
                    <svg class="w-5 h-5 text-blue-400 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <div>
                        <h4 class="text-blue-400 font-medium mb-1">PIN Security Tips</h4>
                        <ul class="text-sm text-blue-300 space-y-1">
                            <li>• Choose a PIN that's easy for you to remember but hard for others to guess</li>
                            <li>• Avoid using obvious patterns like 1234 or 0000</li>
                            <li>• Don't use your birth year or phone number</li>
                            <li>• Keep your new PIN private and secure</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex space-x-4">
                <a href="{{ route('wallet.index') }}" 
                   class="flex-1 bg-cod-light text-cod-green text-center px-6 py-3 rounded-lg font-semibold hover:bg-cod-dark transition-colors">
                    Cancel
                </a>
                <button type="submit" 
                        class="flex-1 bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Update PIN
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Auto-format PIN inputs
document.addEventListener('DOMContentLoaded', function() {
    const pinInputs = document.querySelectorAll('input[name="current_pin"], input[name="new_pin"], input[name="new_pin_confirmation"]');
    
    pinInputs.forEach(input => {
        input.addEventListener('input', function(e) {
            // Only allow numbers
            this.value = this.value.replace(/[^0-9]/g, '');
            
            // Limit to 4 digits
            if (this.value.length > 4) {
                this.value = this.value.slice(0, 4);
            }
        });
        
        input.addEventListener('keypress', function(e) {
            // Only allow numbers
            if (!/[0-9]/.test(e.key) && !['Backspace', 'Delete', 'Tab', 'Enter'].includes(e.key)) {
                e.preventDefault();
            }
        });
    });
});
</script>
@endsection