@extends('layouts.app')

@section('title', 'Set Transaction PIN')

@section('content')
<div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="text-center mb-8">
        <h1 class="text-4xl font-gaming font-bold text-cod-green gaming-text-glow mb-4">Set Transaction PIN</h1>
        <p class="text-gray-400">Secure your wallet with a 4-digit PIN for credit transfers</p>
    </div>

    <!-- PIN Setup Form -->
    <div class="bg-cod-gray rounded-lg p-8 gaming-glow">
        <div class="mb-6">
            <div class="flex items-center justify-center mb-4">
                <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center">
                    <svg class="w-8 h-8 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                </div>
            </div>
            <h2 class="text-xl font-semibold text-cod-green text-center mb-2">Secure Your Wallet</h2>
            <p class="text-gray-400 text-center">Your PIN will be required for all credit transfers to keep your funds safe.</p>
        </div>

        <form action="{{ route('wallet.pin-setup.store') }}" method="POST" class="space-y-6">
            @csrf

            <!-- Password Verification -->
            <div>
                <label for="password" class="block text-sm font-medium text-gray-300 mb-2">Current Password</label>
                <input type="password" 
                       id="password" 
                       name="password" 
                       required
                       class="w-full px-4 py-3 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-transparent @error('password') border-red-500 @enderror"
                       placeholder="Enter your current password">
                @error('password')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- PIN Input -->
            <div>
                <label for="pin" class="block text-sm font-medium text-gray-300 mb-2">Transaction PIN</label>
                <input type="password" 
                       id="pin" 
                       name="pin" 
                       maxlength="4"
                       pattern="[0-9]{4}"
                       required
                       class="w-full px-4 py-3 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-transparent text-center text-2xl tracking-widest @error('pin') border-red-500 @enderror"
                       placeholder="••••">
                @error('pin')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-sm text-gray-400">Enter a 4-digit PIN (numbers only)</p>
            </div>

            <!-- PIN Confirmation -->
            <div>
                <label for="pin_confirmation" class="block text-sm font-medium text-gray-300 mb-2">Confirm PIN</label>
                <input type="password" 
                       id="pin_confirmation" 
                       name="pin_confirmation" 
                       maxlength="4"
                       pattern="[0-9]{4}"
                       required
                       class="w-full px-4 py-3 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-transparent text-center text-2xl tracking-widest @error('pin_confirmation') border-red-500 @enderror"
                       placeholder="••••">
                @error('pin_confirmation')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Security Notice -->
            <div class="bg-yellow-500/10 border border-yellow-500/20 rounded-lg p-4">
                <div class="flex items-start">
                    <svg class="w-5 h-5 text-yellow-400 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                    </svg>
                    <div>
                        <h4 class="text-yellow-400 font-medium mb-1">Important Security Information</h4>
                        <ul class="text-sm text-yellow-300 space-y-1">
                            <li>• Keep your PIN secret and never share it with anyone</li>
                            <li>• Your PIN is required for all credit transfers</li>
                            <li>• You can change your PIN anytime from wallet settings</li>
                            <li>• Contact support if you forget your PIN</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex space-x-4">
                <a href="{{ route('wallet.index') }}" 
                   class="flex-1 bg-cod-light text-cod-green text-center px-6 py-3 rounded-lg font-semibold hover:bg-cod-dark transition-colors">
                    Cancel
                </a>
                <button type="submit" 
                        class="flex-1 bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Set PIN
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Auto-format PIN inputs
document.addEventListener('DOMContentLoaded', function() {
    const pinInputs = document.querySelectorAll('input[name="pin"], input[name="pin_confirmation"]');
    
    pinInputs.forEach(input => {
        input.addEventListener('input', function(e) {
            // Only allow numbers
            this.value = this.value.replace(/[^0-9]/g, '');
            
            // Limit to 4 digits
            if (this.value.length > 4) {
                this.value = this.value.slice(0, 4);
            }
        });
        
        input.addEventListener('keypress', function(e) {
            // Only allow numbers
            if (!/[0-9]/.test(e.key) && !['Backspace', 'Delete', 'Tab', 'Enter'].includes(e.key)) {
                e.preventDefault();
            }
        });
    });
});
</script>
@endsection