@extends('layouts.app')

@section('title', 'Transfer Details')

@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="text-center mb-8">
        <h1 class="text-4xl font-gaming font-bold text-cod-green gaming-text-glow mb-4">Transfer Details</h1>
        <p class="text-gray-400">Complete transfer information</p>
    </div>

    <!-- Transfer Status -->
    <div class="bg-cod-gray rounded-lg p-8 mb-8 gaming-glow">
        <div class="text-center mb-6">
            @if($transfer->isCompleted())
                <div class="w-20 h-20 bg-green-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>
                <h2 class="text-2xl font-bold text-green-400 mb-2">Transfer Completed</h2>
                <p class="text-gray-300">Your credit transfer was successful</p>
            @elseif($transfer->isPending())
                <div class="w-20 h-20 bg-yellow-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h2 class="text-2xl font-bold text-yellow-400 mb-2">Transfer Pending</h2>
                <p class="text-gray-300">Your transfer is being processed</p>
            @elseif($transfer->isFailed())
                <div class="w-20 h-20 bg-red-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </div>
                <h2 class="text-2xl font-bold text-red-400 mb-2">Transfer Failed</h2>
                <p class="text-gray-300">The transfer could not be completed</p>
            @else
                <div class="w-20 h-20 bg-gray-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728L5.636 5.636m12.728 12.728L18.364 5.636M5.636 18.364l12.728-12.728"></path>
                    </svg>
                </div>
                <h2 class="text-2xl font-bold text-gray-400 mb-2">Transfer Cancelled</h2>
                <p class="text-gray-300">This transfer was cancelled</p>
            @endif
        </div>

        <!-- Transfer Amount -->
        <div class="text-center mb-8">
            <div class="text-5xl font-bold text-cod-green mb-2">₦{{ number_format($transfer->amount) }}</div>
            <div class="text-gray-400">Transfer Amount</div>
        </div>

        <!-- Transfer Details -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Sender Information -->
            <div class="bg-cod-dark rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-300 mb-4 flex items-center">
                    <svg class="w-5 h-5 text-blue-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                    From
                </h3>
                <div class="space-y-3">
                    <div>
                        <span class="text-gray-400 text-sm">Username</span>
                        <div class="text-white font-medium">{{ $transfer->sender->username }}</div>
                    </div>
                    @if($transfer->sender->id === auth()->id())
                        <div class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-cod-green/20 text-cod-green">
                            You (Sender)
                        </div>
                    @endif
                </div>
            </div>

            <!-- Recipient Information -->
            <div class="bg-cod-dark rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-300 mb-4 flex items-center">
                    <svg class="w-5 h-5 text-green-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                    To
                </h3>
                <div class="space-y-3">
                    <div>
                        <span class="text-gray-400 text-sm">Username</span>
                        <div class="text-white font-medium">{{ $transfer->recipient->username }}</div>
                    </div>
                    @if($transfer->recipient->id === auth()->id())
                        <div class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-500/20 text-green-400">
                            You (Recipient)
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Transfer Note -->
        @if($transfer->note)
            <div class="mt-6 bg-cod-dark rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-300 mb-3 flex items-center">
                    <svg class="w-5 h-5 text-yellow-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"></path>
                    </svg>
                    Message
                </h3>
                <p class="text-gray-100 bg-cod-gray p-4 rounded border-l-4 border-cod-green">
                    "{{ $transfer->note }}"
                </p>
            </div>
        @endif

        <!-- Transaction Details -->
        <div class="mt-6 bg-cod-dark rounded-lg p-6">
            <h3 class="text-lg font-semibold text-gray-300 mb-4 flex items-center">
                <svg class="w-5 h-5 text-purple-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Transaction Information
            </h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="space-y-3">
                    <div>
                        <span class="text-gray-400 text-sm">Reference</span>
                        <div class="text-white font-mono text-sm">{{ $transfer->reference }}</div>
                    </div>
                    <div>
                        <span class="text-gray-400 text-sm">Status</span>
                        <div>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                @if($transfer->isCompleted()) bg-green-500/20 text-green-400
                                @elseif($transfer->isPending()) bg-yellow-500/20 text-yellow-400
                                @elseif($transfer->isFailed()) bg-red-500/20 text-red-400
                                @else bg-gray-500/20 text-gray-400 @endif">
                                {{ ucfirst($transfer->status) }}
                            </span>
                        </div>
                    </div>
                </div>
                <div class="space-y-3">
                    <div>
                        <span class="text-gray-400 text-sm">Initiated</span>
                        <div class="text-white">{{ $transfer->created_at->format('M j, Y \at H:i') }}</div>
                    </div>
                    @if($transfer->completed_at)
                        <div>
                            <span class="text-gray-400 text-sm">Completed</span>
                            <div class="text-white">{{ $transfer->completed_at->format('M j, Y \at H:i') }}</div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="flex justify-center space-x-4">
        <a href="{{ route('wallet.index') }}" 
           class="bg-cod-light text-cod-green px-6 py-3 rounded-lg font-semibold hover:bg-cod-dark transition-colors">
            Back to Wallet
        </a>
        <a href="{{ route('wallet.transfer.history') }}" 
           class="bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
            Transfer History
        </a>
        @if($transfer->isCompleted())
            <a href="{{ route('wallet.transfer') }}" 
               class="bg-blue-600 text-white px-6 py-3 rounded-lg font-semibold hover:bg-blue-700 transition-colors">
                Send Another Transfer
            </a>
        @endif
    </div>

    <!-- Support Information -->
    <div class="mt-8 bg-cod-gray rounded-lg p-6">
        <div class="text-center">
            <h3 class="text-lg font-semibold text-gray-300 mb-2">Need Help?</h3>
            <p class="text-gray-400 mb-4">If you have any questions about this transfer, our support team is here to help.</p>
            <div class="flex justify-center space-x-4">
                <a href="#" class="text-cod-green hover:text-green-400 text-sm font-medium">Contact Support</a>
                <span class="text-gray-500">•</span>
                <a href="#" class="text-cod-green hover:text-green-400 text-sm font-medium">Transfer FAQ</a>
            </div>
        </div>
    </div>
</div>
@endsection