@extends('layouts.app')

@section('title', 'Transfer History')

@section('content')
<div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="text-center mb-8">
        <h1 class="text-4xl font-gaming font-bold text-cod-green gaming-text-glow mb-4">Transfer History</h1>
        <p class="text-gray-400">View all your credit transfers</p>
    </div>

    <!-- Statistics Overview -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <!-- Total Sent -->
        <div class="bg-cod-gray rounded-lg p-6">
            <div class="text-center">
                <div class="w-12 h-12 bg-red-500 rounded-full flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
                <h3 class="text-sm font-medium text-gray-300 mb-1">Total Sent</h3>
                <div class="text-xl font-bold text-red-400">₦{{ number_format($stats['total_sent']) }}</div>
            </div>
        </div>

        <!-- Total Received -->
        <div class="bg-cod-gray rounded-lg p-6">
            <div class="text-center">
                <div class="w-12 h-12 bg-green-500 rounded-full flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                </div>
                <h3 class="text-sm font-medium text-gray-300 mb-1">Total Received</h3>
                <div class="text-xl font-bold text-green-400">₦{{ number_format($stats['total_received']) }}</div>
            </div>
        </div>

        <!-- Total Transfers -->
        <div class="bg-cod-gray rounded-lg p-6">
            <div class="text-center">
                <div class="w-12 h-12 bg-blue-500 rounded-full flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                    </svg>
                </div>
                <h3 class="text-sm font-medium text-gray-300 mb-1">Total Transfers</h3>
                <div class="text-xl font-bold text-blue-400">{{ $stats['total_transfers'] }}</div>
            </div>
        </div>

        <!-- Net Transfer -->
        <div class="bg-cod-gray rounded-lg p-6">
            <div class="text-center">
                <div class="w-12 h-12 bg-cod-green rounded-full flex items-center justify-center mx-auto mb-3">
                    <svg class="w-6 h-6 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <h3 class="text-sm font-medium text-gray-300 mb-1">Net Transfer</h3>
                <div class="text-xl font-bold {{ $stats['net_transfer'] >= 0 ? 'text-green-400' : 'text-red-400' }}">
                    {{ $stats['net_transfer'] >= 0 ? '+' : '' }}₦{{ number_format(abs($stats['net_transfer'])) }}
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-cod-gray rounded-lg p-6 mb-8">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold text-cod-green">Quick Actions</h2>
            <div class="flex space-x-4">
                <a href="{{ route('wallet.transfer') }}" 
                   class="bg-cod-green text-black px-4 py-2 rounded-lg font-semibold hover:bg-green-600 transition-colors text-sm">
                    New Transfer
                </a>
                <a href="{{ route('wallet.index') }}" 
                   class="bg-cod-light text-cod-green px-4 py-2 rounded-lg font-semibold hover:bg-cod-dark transition-colors text-sm">
                    Back to Wallet
                </a>
            </div>
        </div>
    </div>

    <!-- Transfer History -->
    <div class="bg-cod-gray rounded-lg p-6">
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-xl font-semibold text-cod-green">All Transfers</h2>
            <div class="flex space-x-2">
                <select class="bg-cod-dark text-gray-100 border border-cod-light rounded px-3 py-1 text-sm" id="statusFilter">
                    <option value="">All Status</option>
                    <option value="completed">Completed</option>
                    <option value="pending">Pending</option>
                    <option value="failed">Failed</option>
                    <option value="cancelled">Cancelled</option>
                </select>
                <select class="bg-cod-dark text-gray-100 border border-cod-light rounded px-3 py-1 text-sm" id="typeFilter">
                    <option value="">All Types</option>
                    <option value="sent">Sent</option>
                    <option value="received">Received</option>
                </select>
            </div>
        </div>

        @if($transfers->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-cod-light">
                            <th class="text-left py-3 px-4 text-gray-300 font-semibold">Date</th>
                            <th class="text-left py-3 px-4 text-gray-300 font-semibold">Type</th>
                            <th class="text-left py-3 px-4 text-gray-300 font-semibold">User</th>
                            <th class="text-left py-3 px-4 text-gray-300 font-semibold">Note</th>
                            <th class="text-right py-3 px-4 text-gray-300 font-semibold">Amount</th>
                            <th class="text-center py-3 px-4 text-gray-300 font-semibold">Status</th>
                            <th class="text-center py-3 px-4 text-gray-300 font-semibold">Action</th>
                        </tr>
                    </thead>
                    <tbody id="transfersTable">
                        @foreach($transfers as $transfer)
                            @php
                                $isSender = $transfer->sender_id === auth()->id();
                                $otherUser = $isSender ? $transfer->recipient : $transfer->sender;
                                $transferType = $isSender ? 'sent' : 'received';
                            @endphp
                            <tr class="border-b border-cod-dark hover:bg-cod-dark transition-colors transfer-row" 
                                data-status="{{ $transfer->status }}" 
                                data-type="{{ $transferType }}">
                                <td class="py-3 px-4 text-gray-100">
                                    {{ $transfer->created_at->format('M j, Y') }}
                                    <div class="text-xs text-gray-400">{{ $transfer->created_at->format('H:i') }}</div>
                                </td>
                                <td class="py-3 px-4">
                                    @if($isSender)
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-500/20 text-red-400">
                                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                                            </svg>
                                            Sent
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-500/20 text-green-400">
                                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                            </svg>
                                            Received
                                        </span>
                                    @endif
                                </td>
                                <td class="py-3 px-4">
                                    <div class="text-gray-100 font-medium">{{ $otherUser->username }}</div>
                                    <div class="text-xs text-gray-400">
                                        {{ $isSender ? 'To' : 'From' }} {{ $otherUser->username }}
                                    </div>
                                </td>
                                <td class="py-3 px-4 text-gray-100 max-w-xs">
                                    @if($transfer->note)
                                        <div class="truncate" title="{{ $transfer->note }}">
                                            {{ $transfer->note }}
                                        </div>
                                    @else
                                        <span class="text-gray-400 text-sm">No note</span>
                                    @endif
                                </td>
                                <td class="py-3 px-4 text-right">
                                    <span class="font-semibold {{ $isSender ? 'text-red-400' : 'text-green-400' }}">
                                        {{ $isSender ? '-' : '+' }}₦{{ number_format($transfer->amount) }}
                                    </span>
                                </td>
                                <td class="py-3 px-4 text-center">
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                                        @if($transfer->isCompleted()) bg-green-500/20 text-green-400
                                        @elseif($transfer->isPending()) bg-yellow-500/20 text-yellow-400
                                        @elseif($transfer->isFailed()) bg-red-500/20 text-red-400
                                        @else bg-gray-500/20 text-gray-400 @endif">
                                        {{ ucfirst($transfer->status) }}
                                    </span>
                                </td>
                                <td class="py-3 px-4 text-center">
                                    <a href="{{ route('wallet.transfer.show', $transfer) }}" 
                                       class="text-cod-green hover:text-green-400 text-sm font-medium">
                                        View Details
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-6">
                {{ $transfers->links() }}
            </div>
        @else
            <div class="text-center py-16">
                <div class="text-6xl mb-4">💸</div>
                <h3 class="text-xl font-semibold text-gray-400 mb-2">No Transfers Yet</h3>
                <p class="text-gray-500 mb-6">You haven't made or received any credit transfers</p>
                <a href="{{ route('wallet.transfer') }}" 
                   class="inline-block bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Send Your First Transfer
                </a>
            </div>
        @endif
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusFilter = document.getElementById('statusFilter');
    const typeFilter = document.getElementById('typeFilter');
    const transferRows = document.querySelectorAll('.transfer-row');

    function filterTransfers() {
        const statusValue = statusFilter.value;
        const typeValue = typeFilter.value;

        transferRows.forEach(row => {
            const rowStatus = row.dataset.status;
            const rowType = row.dataset.type;

            const statusMatch = !statusValue || rowStatus === statusValue;
            const typeMatch = !typeValue || rowType === typeValue;

            if (statusMatch && typeMatch) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    }

    statusFilter.addEventListener('change', filterTransfers);
    typeFilter.addEventListener('change', filterTransfers);
});
</script>
@endsection