@extends('layouts.app')

@section('title', 'Withdraw Funds')

@section('content')
<div class="min-h-screen bg-cod-black text-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Header -->
        <div class="text-center mb-8">
            <h1 class="text-4xl font-gaming font-bold text-cod-green gaming-text-glow mb-4">Withdraw Funds</h1>
            <p class="text-gray-400">Transfer funds from your gaming wallet to your bank account</p>
        </div>

        <div class="gaming-card rounded-lg p-8">
            <form action="{{ route('wallet.withdraw.store') }}" method="POST" class="space-y-6">
                @csrf

                <!-- Available Balance Display -->
                <div class="bg-cod-green/10 border border-cod-green/30 rounded-lg p-4 mb-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <h3 class="font-semibold text-cod-green">Available Balance</h3>
                            <p class="text-sm text-gray-300">Amount available for withdrawal</p>
                        </div>
                        <div class="text-2xl font-bold text-cod-green">
                            ₦{{ number_format(auth()->user()->wallet_balance) }}
                        </div>
                    </div>
                </div>

                <!-- Amount Input -->
                <div>
                    <label for="amount" class="block text-sm font-medium text-gray-300 mb-2">
                        Amount to Withdraw
                    </label>
                    <div class="relative">
                        <span class="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400 text-lg">₦</span>
                        <input type="number" 
                               id="amount" 
                               name="amount" 
                               min="50" 
                               max="{{ auth()->user()->wallet_balance }}"
                               step="0.01"
                               value="{{ old('amount') }}"
                               class="w-full pl-10 pr-4 py-3 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                               placeholder="Enter amount"
                               required>
                    </div>
                    <p class="text-sm text-gray-400 mt-1">Minimum: ₦50, Maximum: ₦{{ number_format(auth()->user()->wallet_balance) }}</p>
                    @error('amount')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Payment Provider Selection -->
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-4">
                        Select Withdrawal Method
                    </label>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Paystack -->
                        <label class="relative cursor-pointer">
                            <input type="radio" name="provider" value="paystack" class="sr-only peer" required>
                            <div class="border-2 border-gray-600 peer-checked:border-cod-green rounded-lg p-4 transition-all duration-200 peer-checked:bg-cod-green/10">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-lg">P</span>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-white">Paystack</h3>
                                        <p class="text-sm text-gray-400">Bank Transfer (Nigeria)</p>
                                    </div>
                                </div>
                            </div>
                        </label>

                        <!-- Flutterwave -->
                        <label class="relative cursor-pointer">
                            <input type="radio" name="provider" value="flutterwave" class="sr-only peer" required>
                            <div class="border-2 border-gray-600 peer-checked:border-cod-green rounded-lg p-4 transition-all duration-200 peer-checked:bg-cod-green/10">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 bg-orange-600 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-lg">F</span>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-white">Flutterwave</h3>
                                        <p class="text-sm text-gray-400">Bank Transfer (Multi-country)</p>
                                    </div>
                                </div>
                            </div>
                        </label>

                        <!-- PayPal -->
                        <label class="relative cursor-pointer">
                            <input type="radio" name="provider" value="paypal" class="sr-only peer" required>
                            <div class="border-2 border-gray-600 peer-checked:border-cod-green rounded-lg p-4 transition-all duration-200 peer-checked:bg-cod-green/10">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 bg-blue-700 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-lg">PP</span>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-white">PayPal</h3>
                                        <p class="text-sm text-gray-400">PayPal Account</p>
                                    </div>
                                </div>
                            </div>
                        </label>

                        <!-- Stripe -->
                        <label class="relative cursor-pointer">
                            <input type="radio" name="provider" value="stripe" class="sr-only peer" required>
                            <div class="border-2 border-gray-600 peer-checked:border-cod-green rounded-lg p-4 transition-all duration-200 peer-checked:bg-cod-green/10">
                                <div class="flex items-center space-x-3">
                                    <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-lg">S</span>
                                    </div>
                                    <div>
                                        <h3 class="font-semibold text-white">Stripe</h3>
                                        <p class="text-sm text-gray-400">Bank Account</p>
                                    </div>
                                </div>
                            </div>
                        </label>
                    </div>
                    @error('provider')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Account Details -->
                <div>
                    <label for="account_details" class="block text-sm font-medium text-gray-300 mb-2">
                        Account Details
                    </label>
                    <textarea id="account_details" 
                              name="account_details" 
                              rows="4"
                              class="w-full px-4 py-3 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                              placeholder="Enter your account details:&#10;- Account Number&#10;- Account Name&#10;- Bank Name&#10;- Sort Code (if applicable)"
                              required>{{ old('account_details') }}</textarea>
                    <p class="text-sm text-gray-400 mt-1">Provide complete account information for successful withdrawal</p>
                    @error('account_details')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- KYC Verification Notice -->
                @if(auth()->user()->kyc_status !== 'verified')
                <div class="bg-yellow-600/10 border border-yellow-600/30 rounded-lg p-4">
                    <div class="flex items-center space-x-2">
                        <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.732-.833-2.5 0L4.732 15.5c-.77.833.192 2.5 1.732 2.5z"></path>
                        </svg>
                        <div>
                            <h4 class="font-medium text-yellow-400">KYC Verification Required</h4>
                            <p class="text-sm text-gray-300">You need to complete identity verification for withdrawals. Visit your profile to complete KYC.</p>
                        </div>
                    </div>
                </div>
                @endif

                <!-- Processing Information -->
                <div class="bg-blue-600/10 border border-blue-600/30 rounded-lg p-4">
                    <div class="flex items-center space-x-2">
                        <svg class="w-5 h-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <div>
                            <h4 class="font-medium text-blue-400">Withdrawal Processing</h4>
                            <p class="text-sm text-gray-300">Withdrawals are processed within 24 hours. You'll receive a confirmation email once processed.</p>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center justify-between pt-6 border-t border-cod-green/20">
                    <a href="{{ route('wallet.index') }}" class="btn-secondary px-6 py-3">
                        ← Back to Wallet
                    </a>
                    <button type="submit" 
                            class="btn-primary px-6 py-3"
                            @if(auth()->user()->kyc_status !== 'verified') disabled @endif>
                        💸 Request Withdrawal
                    </button>
                </div>
            </form>
        </div>

        <!-- Information Cards -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-8">
            <div class="gaming-card rounded-lg p-6">
                <div class="text-center">
                    <div class="w-12 h-12 bg-green-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-white mb-2">Fast Processing</h3>
                    <p class="text-sm text-gray-400">Most withdrawals are processed within 24 hours</p>
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <div class="text-center">
                    <div class="w-12 h-12 bg-blue-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-white mb-2">Secure & Verified</h3>
                    <p class="text-sm text-gray-400">All withdrawals require KYC verification for security</p>
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <div class="text-center">
                    <div class="w-12 h-12 bg-purple-600 rounded-lg flex items-center justify-center mx-auto mb-3">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <h3 class="font-semibold text-white mb-2">Email Updates</h3>
                    <p class="text-sm text-gray-400">Get notified at every step of the withdrawal process</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection