<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ChallengeController;
use App\Http\Controllers\TournamentController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\LeaderboardController;

Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    // Challenge API routes
    Route::prefix('challenges')->group(function () {
        Route::get('/', [ChallengeController::class, 'index']);
        Route::post('/', [ChallengeController::class, 'store']);
        Route::get('/{challenge}', [ChallengeController::class, 'show']);
        Route::post('/{challenge}/accept', [ChallengeController::class, 'accept']);
        Route::post('/{challenge}/submit-proof', [ChallengeController::class, 'submitProof']);
        Route::post('/{challenge}/agree-result', [ChallengeController::class, 'agreeResult']);
        Route::post('/{challenge}/dispute', [ChallengeController::class, 'dispute']);
    });

    // Tournament API routes
    Route::prefix('tournaments')->group(function () {
        Route::get('/', [TournamentController::class, 'index']);
        Route::post('/', [TournamentController::class, 'store']);
        Route::get('/{tournament}', [TournamentController::class, 'show']);
        Route::post('/{tournament}/join', [TournamentController::class, 'join']);
        Route::post('/{tournament}/report-match', [TournamentController::class, 'reportMatch']);
    });

    // Wallet API routes
    Route::prefix('wallet')->group(function () {
        Route::get('/', [WalletController::class, 'index']);
        Route::post('/deposit', [WalletController::class, 'processDeposit']);
        Route::post('/withdraw', [WalletController::class, 'withdraw']);
    });
});

// Public API routes
Route::get('/challenges', [ChallengeController::class, 'index']);
Route::get('/tournaments', [TournamentController::class, 'index']);
Route::get('/leaderboards', [LeaderboardController::class, 'index']);