<?php

use App\Http\Controllers\Admin\ChallengeController as AdminChallengeController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\DisputeController as AdminDisputeController;
use App\Http\Controllers\Admin\GameController as AdminGameController;
use App\Http\Controllers\Admin\PostController as AdminPostController;
use App\Http\Controllers\Admin\PopupNotificationController as AdminPopupNotificationController;
use App\Http\Controllers\Admin\TournamentController as AdminTournamentController;
use App\Http\Controllers\Admin\UserController as AdminUserController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\ChallengeController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LeaderboardController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\TournamentController;
use App\Http\Controllers\WalletController;
use Illuminate\Support\Facades\Route;

// Guest routes
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/challenges', [ChallengeController::class, 'index'])->name('challenges.index');
Route::get('/tournaments', [TournamentController::class, 'index'])->name('tournaments.index');
Route::get('/leaderboards', [LeaderboardController::class, 'index'])->name('leaderboards.index');

// Public content routes
Route::prefix('blog')->name('posts.')->group(function () {
    Route::get('/', [PostController::class, 'index'])->name('index');
    Route::get('/type/{type}', [PostController::class, 'byType'])->name('type');
    Route::get('/{slug}', [PostController::class, 'show'])->name('show');
});

// Public friend suggestions - anyone can access
Route::get('/friends/suggestions', [\App\Http\Controllers\FriendController::class, 'suggestions'])->name('friends.suggestions');

// KYC webhook (public for external services)
Route::post('/kyc/webhook', [\App\Http\Controllers\KycController::class, 'webhook'])->name('kyc.webhook');

// Static pages
Route::get('/about-us', [\App\Http\Controllers\StaticPageController::class, 'aboutUs'])->name('about-us');
Route::get('/contact-us', [\App\Http\Controllers\StaticPageController::class, 'contactUs'])->name('contact-us');
Route::post('/contact-us', [\App\Http\Controllers\StaticPageController::class, 'submitContactForm'])->name('contact-us.submit');
Route::get('/privacy-policy', [\App\Http\Controllers\StaticPageController::class, 'privacyPolicy'])->name('privacy-policy');
Route::get('/terms-of-service', [\App\Http\Controllers\StaticPageController::class, 'termsOfService'])->name('terms-of-service');
Route::get('/faq', [\App\Http\Controllers\StaticPageController::class, 'faq'])->name('faq');

// Auth routes
Route::middleware('guest')->group(function () {
    Route::get('login', [AuthenticatedSessionController::class, 'create'])->name('login');
    Route::post('login', [AuthenticatedSessionController::class, 'store']);
    Route::get('register', [RegisteredUserController::class, 'create'])->name('register');
    Route::post('register', [RegisteredUserController::class, 'store']);
});

Route::middleware('auth')->group(function () {
    Route::post('logout', [AuthenticatedSessionController::class, 'destroy'])->name('logout');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // KYC routes
    Route::prefix('kyc')->name('kyc.')->group(function () {
        Route::get('/', [\App\Http\Controllers\KycController::class, 'index'])->name('index');
        Route::post('/submit', [\App\Http\Controllers\KycController::class, 'submit'])->name('submit');
        Route::get('/status', [\App\Http\Controllers\KycController::class, 'status'])->name('status');
        Route::post('/check-status', [\App\Http\Controllers\KycController::class, 'checkStatus'])->name('check-status');
    });

    // Challenge routes
    Route::prefix('challenges')->name('challenges.')->group(function () {
        Route::get('/my', [ChallengeController::class, 'myChallenges'])->name('my');
        Route::get('/create', [ChallengeController::class, 'create'])->name('create')
            ->middleware('check.level:create_challenges');
        Route::post('/', [ChallengeController::class, 'store'])->name('store')
            ->middleware('check.level:create_challenges');
        Route::get('/{challenge}', [ChallengeController::class, 'show'])->name('show');
        Route::post('/{challenge}/accept', [ChallengeController::class, 'accept'])->name('accept');
        Route::post('/{challenge}/submit-proof', [ChallengeController::class, 'submitProof'])->name('submit-proof');
        Route::post('/{challenge}/claim-result', [ChallengeController::class, 'claimResult'])->name('claim-result');
        Route::post('/{challenge}/upload-evidence', [ChallengeController::class, 'uploadEvidence'])->name('upload-evidence');
        Route::post('/{challenge}/agree-result', [ChallengeController::class, 'agreeResult'])->name('agree-result'); // Keep for backward compatibility
        Route::post('/{challenge}/dispute', [ChallengeController::class, 'dispute'])->name('dispute');
        
        // Challenge invitation routes
        Route::get('/{challenge}/invite', [ChallengeController::class, 'inviteForm'])->name('invite');
        Route::post('/{challenge}/invite', [ChallengeController::class, 'sendInvites'])->name('invite.send');
        Route::post('/invites/{invite}/accept', [ChallengeController::class, 'acceptInvite'])->name('invite.accept');
        Route::post('/invites/{invite}/decline', [ChallengeController::class, 'declineInvite'])->name('invite.decline');
    });

    // Tournament routes
    Route::prefix('tournaments')->name('tournaments.')->group(function () {
        Route::get('/my', [TournamentController::class, 'myTournaments'])->name('my');
        Route::get('/create', [TournamentController::class, 'create'])->name('create')
            ->middleware('check.level:host_free_tournaments');
        Route::post('/', [TournamentController::class, 'store'])->name('store')
            ->middleware('check.level:host_free_tournaments');
        Route::get('/{tournament}', [TournamentController::class, 'show'])->name('show');
        Route::post('/{tournament}/join', [TournamentController::class, 'join'])->name('join');
        Route::post('/{tournament}/report-match', [TournamentController::class, 'reportMatch'])->name('report-match');
        
        // Tournament invitation routes
        Route::get('/{tournament}/invite', [TournamentController::class, 'inviteForm'])->name('invite');
        Route::post('/{tournament}/invite', [TournamentController::class, 'sendInvites'])->name('invite.send');
        Route::post('/invites/{invite}/accept', [TournamentController::class, 'acceptInvite'])->name('invite.accept');
        Route::post('/invites/{invite}/decline', [TournamentController::class, 'declineInvite'])->name('invite.decline');
        Route::post('/{tournament}/start', [TournamentController::class, 'start'])->name('start');
    });

    // Wallet routes
    Route::prefix('wallet')->name('wallet.')->group(function () {
        Route::get('/', [WalletController::class, 'index'])->name('index');
        Route::get('/deposit', [WalletController::class, 'showDeposit'])->name('deposit');
        Route::post('/deposit', [WalletController::class, 'deposit'])->name('deposit.store');
        Route::get('/withdraw', [WalletController::class, 'showWithdraw'])->name('withdraw');
        Route::post('/withdraw', [WalletController::class, 'withdraw'])->name('withdraw.store');
        Route::get('/transactions/{transaction}', [WalletController::class, 'showTransaction'])->name('transaction');
        
        // PIN management routes
        Route::get('/pin-setup', [WalletController::class, 'showPinSetup'])->name('pin-setup');
        Route::post('/pin-setup', [WalletController::class, 'setupPin'])->name('pin-setup.store');
        Route::get('/pin-change', [WalletController::class, 'showPinChange'])->name('pin-change');
        Route::post('/pin-change', [WalletController::class, 'changePin'])->name('pin-change.store');
        
        // Credit transfer routes
        Route::get('/transfer', [WalletController::class, 'showTransfer'])->name('transfer');
        Route::post('/transfer', [WalletController::class, 'transfer'])->name('transfer.store');
        Route::get('/transfer/{transfer}', [WalletController::class, 'showTransferDetails'])->name('transfer.show');
        Route::get('/transfers/history', [WalletController::class, 'transferHistory'])->name('transfer.history');
        
        // Payment callback routes
        Route::get('/callback/paystack', [WalletController::class, 'handleCallback'])->name('callback.paystack')->defaults('provider', 'paystack');
        Route::get('/callback/flutterwave', [WalletController::class, 'handleCallback'])->name('callback.flutterwave')->defaults('provider', 'flutterwave');
        Route::get('/callback/paypal', [WalletController::class, 'handleCallback'])->name('callback.paypal')->defaults('provider', 'paypal');
        Route::get('/callback/stripe', [WalletController::class, 'handleCallback'])->name('callback.stripe')->defaults('provider', 'stripe');
    });

    // Profile routes
    Route::get('/profile', [App\Http\Controllers\ProfileController::class, 'index'])->name('profile.index');
    Route::put('/profile', [App\Http\Controllers\ProfileController::class, 'update'])->name('profile.update');
    Route::put('/profile/password', [App\Http\Controllers\ProfileController::class, 'updatePassword'])->name('profile.password');
    Route::post('/profile/avatar', [App\Http\Controllers\ProfileController::class, 'uploadAvatar'])->name('profile.avatar');

    // Notification routes
    Route::prefix('notifications')->name('notifications.')->group(function () {
        Route::get('/', [NotificationController::class, 'index'])->name('index');
        Route::get('/popups', [NotificationController::class, 'getPopups'])->name('popups');
        Route::post('/popups/{popupNotification}/seen', [NotificationController::class, 'markPopupSeen'])->name('popup.seen');
        Route::post('/{notification}/read', [NotificationController::class, 'markAsRead'])->name('read');
        Route::get('/count', [NotificationController::class, 'getUnreadCount'])->name('count');
        Route::post('/mark-all-read', [NotificationController::class, 'markAllAsRead'])->name('mark-all-read');
    });

    // Friend routes (authenticated)
    Route::prefix('friends')->name('friends.')->group(function () {
        Route::get('/', [\App\Http\Controllers\FriendController::class, 'index'])->name('index');
        Route::post('/{user}/send-request', [\App\Http\Controllers\FriendController::class, 'sendRequest'])->name('send-request');
        Route::post('/{friend}/accept', [\App\Http\Controllers\FriendController::class, 'accept'])->name('accept');
        Route::post('/{friend}/decline', [\App\Http\Controllers\FriendController::class, 'decline'])->name('decline');
        Route::post('/{friend}/block', [\App\Http\Controllers\FriendController::class, 'block'])->name('block');
        Route::delete('/{user}/remove', [\App\Http\Controllers\FriendController::class, 'remove'])->name('remove');
    });

    // Creator routes (for creator-level users)
    Route::middleware('auth')->prefix('creator')->name('creator.')->group(function () {
        Route::resource('blogs', \App\Http\Controllers\Creator\BlogController::class);
    });

    // Moderator routes
    Route::middleware(['auth', 'role:moderator,admin'])->prefix('moderator')->name('moderator.')->group(function () {
        Route::get('/dashboard', [\App\Http\Controllers\Moderator\DisputeController::class, 'dashboard'])->name('dashboard');
        
        Route::prefix('disputes')->name('disputes.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Moderator\DisputeController::class, 'index'])->name('index');
            Route::get('/all', [\App\Http\Controllers\Moderator\DisputeController::class, 'all'])->name('all');
            Route::get('/{dispute}', [\App\Http\Controllers\Moderator\DisputeController::class, 'show'])->name('show');
            Route::post('/{dispute}/claim', [\App\Http\Controllers\Moderator\DisputeController::class, 'claim'])->name('claim');
            Route::post('/{dispute}/decide', [\App\Http\Controllers\Moderator\DisputeController::class, 'decide'])->name('decide');
        });
    });

    // Admin routes
    Route::middleware('admin')->prefix('admin')->name('admin.')->group(function () {
        Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
        
        Route::prefix('disputes')->name('disputes.')->group(function () {
            Route::get('/', [AdminDisputeController::class, 'index'])->name('index');
            Route::get('/{dispute}', [AdminDisputeController::class, 'show'])->name('show');
            Route::post('/{dispute}/decide', [AdminDisputeController::class, 'decide'])->name('decide');
        });

        Route::prefix('users')->name('users.')->group(function () {
            Route::get('/', [AdminUserController::class, 'index'])->name('index');
            Route::get('/{user}', [AdminUserController::class, 'show'])->name('show');
            Route::post('/{user}/ban', [AdminUserController::class, 'ban'])->name('ban');
            Route::post('/{user}/unban', [AdminUserController::class, 'unban'])->name('unban');
            Route::post('/{user}/toggle-organizer', [AdminUserController::class, 'toggleOrganizer'])->name('toggle-organizer');
            Route::post('/{user}/update-role', [AdminUserController::class, 'updateRole'])->name('update-role');
            Route::post('/{user}/update-kyc-status', [AdminUserController::class, 'updateKycStatus'])->name('update-kyc-status');
            Route::post('/{user}/assign-level', [AdminUserController::class, 'assignLevel'])->name('assign-level');
            Route::post('/{user}/credit-wallet', [AdminUserController::class, 'creditWallet'])->name('credit-wallet');
            Route::post('/{user}/debit-wallet', [AdminUserController::class, 'debitWallet'])->name('debit-wallet');
        });

        Route::prefix('games')->name('games.')->group(function () {
            Route::get('/', [AdminGameController::class, 'index'])->name('index');
            Route::get('/create', [AdminGameController::class, 'create'])->name('create');
            Route::post('/', [AdminGameController::class, 'store'])->name('store');
            Route::get('/{game}', [AdminGameController::class, 'show'])->name('show');
            Route::get('/{game}/edit', [AdminGameController::class, 'edit'])->name('edit');
            Route::put('/{game}', [AdminGameController::class, 'update'])->name('update');
            Route::delete('/{game}', [AdminGameController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('tournaments')->name('tournaments.')->group(function () {
            Route::get('/', [AdminTournamentController::class, 'index'])->name('index');
            Route::get('/create', [AdminTournamentController::class, 'create'])->name('create');
            Route::post('/', [AdminTournamentController::class, 'store'])->name('store');
            Route::get('/{tournament}', [AdminTournamentController::class, 'show'])->name('show');
            Route::get('/{tournament}/edit', [AdminTournamentController::class, 'edit'])->name('edit');
            Route::put('/{tournament}', [AdminTournamentController::class, 'update'])->name('update');
            Route::delete('/{tournament}', [AdminTournamentController::class, 'destroy'])->name('destroy');
            Route::get('/{tournament}/participants', [AdminTournamentController::class, 'participants'])->name('participants');
            Route::post('/{tournament}/participants', [AdminTournamentController::class, 'addParticipant'])->name('participants.add');
            Route::delete('/{tournament}/participants/{participant}', [AdminTournamentController::class, 'removeParticipant'])->name('participants.remove');
            Route::post('/{tournament}/start', [AdminTournamentController::class, 'startTournament'])->name('start');
            Route::post('/{tournament}/complete', [AdminTournamentController::class, 'completeTournament'])->name('complete');
        });

        Route::prefix('challenges')->name('challenges.')->group(function () {
            Route::get('/', [AdminChallengeController::class, 'index'])->name('index');
            Route::get('/create', [AdminChallengeController::class, 'create'])->name('create');
            Route::post('/', [AdminChallengeController::class, 'store'])->name('store');
            Route::get('/{challenge}', [AdminChallengeController::class, 'show'])->name('show');
            Route::post('/hook-users', [AdminChallengeController::class, 'hookUsers'])->name('hook-users');
            Route::post('/{challenge}/resolve', [AdminChallengeController::class, 'resolveChallenge'])->name('resolve');
            Route::post('/{challenge}/cancel', [AdminChallengeController::class, 'cancelChallenge'])->name('cancel');
        });

        Route::prefix('notifications')->name('notifications.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\NotificationController::class, 'index'])->name('index');
            Route::get('/providers/create', [\App\Http\Controllers\Admin\NotificationController::class, 'createProvider'])->name('providers.create');
            Route::post('/providers', [\App\Http\Controllers\Admin\NotificationController::class, 'storeProvider'])->name('providers.store');
            Route::get('/providers/{provider}/edit', [\App\Http\Controllers\Admin\NotificationController::class, 'editProvider'])->name('providers.edit');
            Route::put('/providers/{provider}', [\App\Http\Controllers\Admin\NotificationController::class, 'updateProvider'])->name('providers.update');
            Route::post('/providers/{provider}/test', [\App\Http\Controllers\Admin\NotificationController::class, 'testProvider'])->name('providers.test');
            Route::post('/providers/{provider}/toggle', [\App\Http\Controllers\Admin\NotificationController::class, 'toggleProvider'])->name('providers.toggle');
            Route::post('/providers/{provider}/default', [\App\Http\Controllers\Admin\NotificationController::class, 'setDefault'])->name('providers.default');
            Route::delete('/providers/{provider}', [\App\Http\Controllers\Admin\NotificationController::class, 'deleteProvider'])->name('providers.delete');
            Route::post('/settings', [\App\Http\Controllers\Admin\NotificationController::class, 'updateSettings'])->name('settings.update');
        });

        Route::prefix('posts')->name('posts.')->group(function () {
            Route::get('/', [AdminPostController::class, 'index'])->name('index');
            Route::get('/pending', [AdminPostController::class, 'pending'])->name('pending');
            Route::get('/create', [AdminPostController::class, 'create'])->name('create');
            Route::post('/', [AdminPostController::class, 'store'])->name('store');
            Route::get('/{post}', [AdminPostController::class, 'show'])->name('show');
            Route::get('/{post}/edit', [AdminPostController::class, 'edit'])->name('edit');
            Route::put('/{post}', [AdminPostController::class, 'update'])->name('update');
            Route::delete('/{post}', [AdminPostController::class, 'destroy'])->name('destroy');
            Route::post('/{post}/approve', [AdminPostController::class, 'approve'])->name('approve');
            Route::post('/{post}/reject', [AdminPostController::class, 'reject'])->name('reject');
        });

        Route::prefix('popup-notifications')->name('popup-notifications.')->group(function () {
            Route::get('/', [AdminPopupNotificationController::class, 'index'])->name('index');
            Route::get('/create', [AdminPopupNotificationController::class, 'create'])->name('create');
            Route::post('/', [AdminPopupNotificationController::class, 'store'])->name('store');
            Route::get('/{popupNotification}', [AdminPopupNotificationController::class, 'show'])->name('show');
            Route::get('/{popupNotification}/edit', [AdminPopupNotificationController::class, 'edit'])->name('edit');
            Route::put('/{popupNotification}', [AdminPopupNotificationController::class, 'update'])->name('update');
            Route::delete('/{popupNotification}', [AdminPopupNotificationController::class, 'destroy'])->name('destroy');
            Route::post('/{popupNotification}/toggle', [AdminPopupNotificationController::class, 'toggle'])->name('toggle');
        });

        Route::prefix('settings')->name('settings.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('index');
            Route::get('/{group}', [\App\Http\Controllers\Admin\SettingsController::class, 'group'])->name('group');
            Route::put('/{group}', [\App\Http\Controllers\Admin\SettingsController::class, 'updateGroup'])->name('group.update');
            Route::post('/test', [\App\Http\Controllers\Admin\SettingsController::class, 'test'])->name('test');
            Route::post('/clear-cache', [\App\Http\Controllers\Admin\SettingsController::class, 'clearCache'])->name('clear-cache');
        });
    });
});

// TEST ROUTES - PROTECTED WITH ADMIN AUTHENTICATION
Route::middleware(['auth', 'admin'])->group(function () {
    Route::prefix('admin-test')->group(function () {
        // Test admin users page
        Route::get('/users', function () {
            $users = \App\Models\User::with('currentLevel')->paginate(20);
            $levels = \App\Models\Level::all();
            
            // Simulate admin header stats
            $adminHeaderStats = [
                'total_users' => \App\Models\User::count(),
                'active_challenges' => 0
            ];
            
            return view('admin.users.index', compact('users', 'levels'));
        })->name('admin.test.users');

        // Test admin challenges page
        Route::get('/challenges', function () {
            $challenges = \App\Models\Challenge::with(['creator', 'accepter', 'game'])->paginate(20);
            $games = \App\Models\Game::all();
            
            return view('admin.challenges.index', compact('challenges', 'games'));
        })->name('admin.test.challenges');

        // Test admin layout
        Route::get('/layout', function () {
            $adminHeaderStats = [
                'total_users' => \App\Models\User::count(),
                'active_challenges' => 0
            ];
            
            return view('layouts.admin');
        })->name('admin.test.layout');

        // API test route for enum fixes
        Route::get('/enum', function () {
            $users = \App\Models\User::limit(5)->get();
            $result = [];
            foreach ($users as $user) {
                $result[] = [
                    'username' => $user->username,
                    'role_value' => $user->role->value,
                    'role_display' => $user->role->getDisplayName(),
                    'role_class' => get_class($user->role)
                ];
            }
            return response()->json($result);
        })->name('admin.test.enum');
    });
});