<?php $__env->startSection('title', 'User Management'); ?>
<?php $__env->startSection('page-title', 'User Management'); ?>
<?php $__env->startSection('page-subtitle', 'Manage user accounts, levels, and permissions'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6">
    <div class="max-w-7xl mx-auto">
        <!-- Header Section -->
        <div class="mb-8">
            <div class="bg-cod-gray/95 backdrop-blur-lg rounded-2xl p-6 border border-cod-light gaming-glow">
                <div class="flex items-center justify-between mb-6">
                    <div>
                        <h1 class="text-3xl font-bold text-cod-green mb-2">👥 User Management</h1>
                        <p class="text-gray-300">Manage user accounts, levels, and permissions</p>
                    </div>
                    <div class="text-right">
                        <div class="text-2xl font-bold text-cod-green"><?php echo e(number_format($users->total())); ?></div>
                        <div class="text-sm text-gray-300">Total Users</div>
                    </div>
                </div>

                <!-- Enhanced Search and Filters -->
                <form method="GET" action="<?php echo e(route('admin.users.index')); ?>" class="grid grid-cols-1 md:grid-cols-6 gap-4">
                    <!-- Search -->
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-cod-green mb-2">Search Users</label>
                        <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                               placeholder="Username or email..." 
                               class="w-full px-4 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:ring-2 focus:ring-cod-green focus:border-cod-green transition-all duration-200 input-gaming">
                    </div>

                    <!-- Status Filter -->
                    <div>
                        <label class="block text-sm font-medium text-cod-green mb-2">Status</label>
                        <select name="status" class="w-full px-4 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-cod-green transition-all duration-200 input-gaming">
                            <option value="" class="bg-cod-dark text-gray-100">All Status</option>
                            <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?> class="bg-cod-dark text-gray-100">Active</option>
                            <option value="banned" <?php echo e(request('status') === 'banned' ? 'selected' : ''); ?> class="bg-cod-dark text-gray-100">Banned</option>
                        </select>
                    </div>

                    <!-- Level Filter -->
                    <div>
                        <label class="block text-sm font-medium text-cod-green mb-2">Level</label>
                        <select name="level" class="w-full px-4 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-cod-green transition-all duration-200 input-gaming">
                            <option value="" class="bg-cod-dark text-gray-100">All Levels</option>
                            <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($level->id); ?>" <?php echo e(request('level') == $level->id ? 'selected' : ''); ?> class="bg-cod-dark text-gray-100">
                                    <?php echo e($level->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Role Filter -->
                    <div>
                        <label class="block text-sm font-medium text-cod-green mb-2">Role</label>
                        <select name="role" class="w-full px-4 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 focus:ring-2 focus:ring-cod-green focus:border-cod-green transition-all duration-200 input-gaming">
                            <option value="" class="bg-cod-dark text-gray-100">All Roles</option>
                            <option value="basic_user" <?php echo e(request('role') === 'basic_user' ? 'selected' : ''); ?> class="bg-cod-dark text-gray-100">Basic User</option>
                            <option value="premium_user" <?php echo e(request('role') === 'premium_user' ? 'selected' : ''); ?> class="bg-cod-dark text-gray-100">Premium User</option>
                            <option value="creator" <?php echo e(request('role') === 'creator' ? 'selected' : ''); ?> class="bg-cod-dark text-gray-100">Creator</option>
                            <option value="moderator" <?php echo e(request('role') === 'moderator' ? 'selected' : ''); ?> class="bg-cod-dark text-gray-100">Moderator</option>
                            <option value="admin" <?php echo e(request('role') === 'admin' ? 'selected' : ''); ?> class="bg-cod-dark text-gray-100">Admin</option>
                        </select>
                    </div>

                    <!-- Filter Buttons -->
                    <div class="flex gap-2">
                        <button type="submit" class="px-6 py-2 bg-cod-green hover:bg-cod-green-dark text-black font-bold rounded-lg transition-all duration-200 btn-gaming">
                            🔍 Filter
                        </button>
                        <?php if(request()->hasAny(['search', 'status', 'level', 'role'])): ?>
                            <a href="<?php echo e(route('admin.users.index')); ?>" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-all duration-200">
                                Clear
                            </a>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>

        <!-- Sort Options -->
        <div class="mb-6">
            <div class="bg-cod-gray/95 backdrop-blur-lg rounded-xl p-4 border border-cod-light gaming-glow">
                <div class="flex flex-wrap gap-2">
                    <span class="text-cod-green mr-4">Sort by:</span>
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'username', 'sort_direction' => 'asc'])); ?>" 
                       class="px-3 py-1 bg-cod-dark hover:bg-cod-light text-gray-100 rounded-lg text-sm transition-all duration-200 border border-cod-light">
                        Username ↑
                    </a>
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'level', 'sort_direction' => 'desc'])); ?>" 
                       class="px-3 py-1 bg-cod-dark hover:bg-cod-light text-gray-100 rounded-lg text-sm transition-all duration-200 border border-cod-light">
                        Level ↓
                    </a>
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'wallet_balance', 'sort_direction' => 'desc'])); ?>" 
                       class="px-3 py-1 bg-cod-dark hover:bg-cod-light text-gray-100 rounded-lg text-sm transition-all duration-200 border border-cod-light">
                        Balance ↓
                    </a>
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'xp', 'sort_direction' => 'desc'])); ?>" 
                       class="px-3 py-1 bg-cod-dark hover:bg-cod-light text-gray-100 rounded-lg text-sm transition-all duration-200 border border-cod-light">
                        XP ↓
                    </a>
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'created_at', 'sort_direction' => 'desc'])); ?>" 
                       class="px-3 py-1 bg-cod-dark hover:bg-cod-light text-gray-100 rounded-lg text-sm transition-all duration-200 border border-cod-light">
                        Newest
                    </a>
                </div>
            </div>
        </div>

        <!-- Users Table -->
        <div class="bg-cod-gray/95 backdrop-blur-lg rounded-2xl border border-cod-light gaming-glow overflow-hidden">
            <div class="table-container">
                <table class="w-full">
                    <thead class="bg-cod-dark sticky top-0 z-10">
                        <tr>
                            <th class="px-6 py-4 text-left text-sm font-semibold text-cod-green uppercase tracking-wider">User</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold text-cod-green uppercase tracking-wider">Level</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold text-cod-green uppercase tracking-wider">Status</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold text-cod-green uppercase tracking-wider">Wallet</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold text-cod-green uppercase tracking-wider">XP</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold text-cod-green uppercase tracking-wider">Joined</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold text-cod-green uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-cod-light/30">
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-cod-dark/50 transition-all duration-200 border-b border-cod-light/20">
                                <td class="px-6 py-4">
                                    <div class="flex items-center space-x-4">
                                        <div class="w-12 h-12 bg-gradient-to-br from-yellow-400 to-orange-500 rounded-full flex items-center justify-center text-black font-bold text-lg">
                                            <?php echo e(strtoupper(substr($user->username, 0, 1))); ?>

                                        </div>
                                        <div>
                                            <div class="text-white font-medium"><?php echo e($user->username); ?></div>
                                            <div class="text-gray-400 text-sm"><?php echo e($user->email); ?></div>
                                            <?php if($user->is_organizer): ?>
                                                <span class="inline-flex items-center px-2 py-1 text-xs font-medium bg-red-500/20 text-red-400 rounded-full mt-1">
                                                    🛡️ Admin
                                                </span>
                                            <?php endif; ?>
                                            <?php if($user->role !== \App\Enums\UserRole::BASIC_USER): ?>
                                                <span class="inline-flex items-center px-2 py-1 text-xs font-medium bg-purple-500/20 text-purple-400 rounded-full mt-1">
                                                    <?php echo e($user->role->getDisplayName()); ?>

                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <?php
                                        $level = $levels->find($user->level);
                                        $levelName = $level ? $level->name : "Level {$user->level}";
                                    ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-500/20 text-blue-400">
                                        <?php echo e($levelName); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4">
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                                        <?php echo e($user->status === 'active' ? 'bg-green-500/20 text-green-400' : 'bg-red-500/20 text-red-400'); ?>">
                                        <?php echo e(ucfirst($user->status)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-white font-medium">₦<?php echo e(number_format($user->wallet_balance, 2)); ?></div>
                                    <?php if($user->locked_balance > 0): ?>
                                        <div class="text-yellow-400 text-sm">₦<?php echo e(number_format($user->locked_balance, 2)); ?> locked</div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-white font-medium"><?php echo e(number_format($user->xp)); ?></div>
                                    <?php if(isset($user->games_played)): ?>
                                        <div class="text-gray-400 text-sm"><?php echo e($user->games_played); ?> games</div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-gray-300"><?php echo e($user->created_at->format('M j, Y')); ?></div>
                                    <div class="text-gray-500 text-sm"><?php echo e($user->created_at->diffForHumans()); ?></div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex flex-wrap gap-2">
                                        <a href="<?php echo e(route('admin.users.show', $user)); ?>" 
                                           class="inline-flex items-center px-3 py-1 bg-blue-500 hover:bg-blue-600 text-white text-sm rounded-lg transition-colors">
                                            👁️ View
                                        </a>
                                        
                                        <?php if($user->status === 'active'): ?>
                                            <form method="POST" action="<?php echo e(route('admin.users.ban', $user)); ?>" style="display: inline;">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="inline-flex items-center px-3 py-1 bg-red-500 hover:bg-red-600 text-white text-sm rounded-lg transition-colors"
                                                        onclick="return confirm('Are you sure you want to ban this user?')">
                                                    🚫 Ban
                                                </button>
                                            </form>
                                        <?php else: ?>
                                            <form method="POST" action="<?php echo e(route('admin.users.unban', $user)); ?>" style="display: inline;">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="inline-flex items-center px-3 py-1 bg-green-500 hover:bg-green-600 text-white text-sm rounded-lg transition-colors">
                                                    ✅ Unban
                                                </button>
                                            </form>
                                        <?php endif; ?>

                                        <form method="POST" action="<?php echo e(route('admin.users.toggle-organizer', $user)); ?>" style="display: inline;">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="inline-flex items-center px-3 py-1 bg-purple-500 hover:bg-purple-600 text-white text-sm rounded-lg transition-colors">
                                                <?php echo e($user->is_organizer ? '⬇️ Remove Admin' : '⬆️ Make Admin'); ?>

                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="px-6 py-12 text-center">
                                    <div class="text-gray-400">
                                        <div class="text-4xl mb-4">👥</div>
                                        <p class="text-lg">No users found matching your criteria.</p>
                                        <p class="text-sm mt-2">Try adjusting your search filters.</p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Pagination -->
        <?php if($users->hasPages()): ?>
            <div class="mt-8">
                <div class="bg-cod-gray/95 backdrop-blur-lg rounded-xl p-4 border border-cod-light gaming-glow">
                    <?php echo e($users->appends(request()->query())->links()); ?>

                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
/* Custom pagination styles */
.pagination {
    @apply flex justify-center space-x-2;
}

.pagination .page-link {
    @apply px-4 py-2 bg-cod-dark text-gray-100 border border-cod-light rounded-lg hover:bg-cod-light transition-all duration-200;
}

.pagination .page-item.active .page-link {
    @apply bg-cod-green text-black border-cod-green font-bold;
}

.pagination .page-item.disabled .page-link {
    @apply opacity-50 cursor-not-allowed;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\OneDrive\Desktop\Script\Personal_Project\Agamec-main\resources\views/admin/users/index.blade.php ENDPATH**/ ?>