<?php $__env->startSection('title', 'Tournament Management'); ?>
<?php $__env->startSection('page-title', 'Tournament Management'); ?>
<?php $__env->startSection('page-subtitle', 'Manage tournaments and competitive events'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6">
    <div class="max-w-7xl mx-auto">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">Tournament Management</h1>
                <p class="text-gray-400 mt-2">Manage tournaments and competitions</p>
            </div>
            <a href="<?php echo e(route('admin.tournaments.create')); ?>" class="gaming-button px-6 py-3 rounded-lg">
                Create Tournament
            </a>
        </div>

        <div class="gaming-card rounded-lg p-6">
            <div class="overflow-x-auto">
                <table class="gaming-table w-full">
                    <thead>
                        <tr>
                            <th class="text-left">Tournament</th>
                            <th class="text-left">Game</th>
                            <th class="text-left">Host</th>
                            <th class="text-center">Entry Fee</th>
                            <th class="text-center">Participants</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $tournaments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tournament): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div>
                                        <div class="font-medium text-white"><?php echo e($tournament->title); ?></div>
                                        <div class="text-sm text-gray-400"><?php echo e($tournament->type); ?></div>
                                    </div>
                                </td>
                                <td>
                                    <div class="flex items-center space-x-2">
                                        <div class="w-8 h-8 bg-cod-green rounded-lg flex items-center justify-center">
                                            <span class="text-xs font-bold text-black"><?php echo e(substr($tournament->game->name, 0, 1)); ?></span>
                                        </div>
                                        <span class="text-white"><?php echo e($tournament->game->name); ?></span>
                                    </div>
                                </td>
                                <td class="text-white"><?php echo e($tournament->host->username); ?></td>
                                <td class="text-center text-cod-green">₦<?php echo e(number_format($tournament->entry_fee, 2)); ?></td>
                                <td class="text-center text-cod-green"><?php echo e($tournament->participants_count); ?></td>
                                <td class="text-center">
                                    <span class="status-badge status-<?php echo e($tournament->status); ?>"><?php echo e(ucfirst($tournament->status)); ?></span>
                                </td>
                                <td class="text-center">
                                    <div class="flex justify-center space-x-2">
                                        <a href="<?php echo e(route('admin.tournaments.show', $tournament)); ?>" class="btn-secondary px-3 py-1 text-xs">
                                            View
                                        </a>
                                        <a href="<?php echo e(route('admin.tournaments.edit', $tournament)); ?>" class="btn-secondary px-3 py-1 text-xs">
                                            Edit
                                        </a>
                                        <a href="<?php echo e(route('admin.tournaments.participants', $tournament)); ?>" class="btn-secondary px-3 py-1 text-xs">
                                            Participants
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-8">
                                    <div class="text-gray-400">
                                        <svg class="w-12 h-12 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                                        </svg>
                                        <p>No tournaments found. Create your first tournament!</p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if($tournaments->hasPages()): ?>
                <div class="mt-6">
                    <?php echo e($tournaments->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\OneDrive\Desktop\Script\Personal_Project\Agamec-main\resources\views/admin/tournaments/index.blade.php ENDPATH**/ ?>