<?php $__env->startSection('title', $tournament->title); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Tournament Header -->
        <div class="gaming-card rounded-lg p-6 mb-8">
            <div class="flex flex-col lg:flex-row justify-between items-start lg:items-center mb-6">
                <div>
                    <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow mb-2"><?php echo e($tournament->title); ?></h1>
                    <div class="flex items-center space-x-4 text-gray-400">
                        <span><?php echo e($tournament->game->name); ?></span>
                        <span>•</span>
                        <span><?php echo e(ucfirst($tournament->type)); ?> Tournament</span>
                        <span>•</span>
                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium
                            <?php if($tournament->status === 'upcoming'): ?> bg-yellow-100 text-yellow-800
                            <?php elseif($tournament->status === 'ongoing'): ?> bg-green-100 text-green-800
                            <?php else: ?> bg-gray-100 text-gray-800
                            <?php endif; ?>">
                            <?php echo e(ucfirst($tournament->status)); ?>

                        </span>
                    </div>
                </div>

                <div class="flex space-x-3 mt-4 lg:mt-0">
                    <?php if(auth()->guard()->check()): ?>
                        <?php if($tournament->host_id === auth()->id()): ?>
                            <!-- Tournament Host Actions -->
                            <?php if($tournament->isUpcoming()): ?>
                                <a href="<?php echo e(route('tournaments.invite', $tournament)); ?>" class="btn-secondary px-4 py-2 rounded-lg">
                                    Invite Players
                                </a>
                                <?php if($tournament->canStart()): ?>
                                    <form method="POST" action="<?php echo e(route('tournaments.start', $tournament)); ?>" class="inline">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="gaming-button px-4 py-2 rounded-lg" 
                                                onclick="return confirm('Are you sure you want to start this tournament?')">
                                            Start Tournament
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <span class="text-gray-400 text-sm px-4 py-2">
                                        Need <?php echo e($tournament->requiresEvenParticipants() ? 'power of 2' : 'more'); ?> participants to start
                                    </span>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php else: ?>
                            <!-- Participant Actions -->
                            <?php if($tournament->canBeJoinedBy(auth()->user())): ?>
                                <form method="POST" action="<?php echo e(route('tournaments.join', $tournament)); ?>" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="gaming-button px-4 py-2 rounded-lg">
                                        Join Tournament (₦<?php echo e(number_format($tournament->entry_fee)); ?>)
                                    </button>
                                </form>
                            <?php elseif($tournament->users->contains(auth()->user())): ?>
                                <span class="text-green-400 px-4 py-2 bg-green-600/20 rounded-lg">
                                    ✓ You're participating
                                </span>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Tournament Stats -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green">₦<?php echo e(number_format($tournament->prize_pool)); ?></div>
                    <div class="text-sm text-gray-400">Prize Pool</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green"><?php echo e($tournament->participants->count()); ?></div>
                    <div class="text-sm text-gray-400">Participants</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green">₦<?php echo e(number_format($tournament->entry_fee)); ?></div>
                    <div class="text-sm text-gray-400">Entry Fee</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green"><?php echo e($tournament->host->username); ?></div>
                    <div class="text-sm text-gray-400">Host</div>
                </div>
            </div>

            <?php if($tournament->description): ?>
                <div class="mt-6 p-4 bg-cod-light rounded-lg">
                    <h3 class="text-lg font-semibold text-cod-green mb-2">Description</h3>
                    <p class="text-gray-300"><?php echo e($tournament->description); ?></p>
                </div>
            <?php endif; ?>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Tournament Bracket -->
            <?php if($tournament->type === 'knockout' && $tournament->bracket_json): ?>
                <div class="lg:col-span-2">
                    <div class="gaming-card rounded-lg p-6">
                        <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">Tournament Bracket</h2>
                        <div class="bracket-container overflow-x-auto">
                            <?php echo $__env->make('tournaments.partials.bracket', ['bracket' => $tournament->bracket_json], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Participants & Pending Invites -->
            <div class="<?php echo e($tournament->bracket_json ? '' : 'lg:col-span-3'); ?>">
                <!-- Participants -->
                <div class="gaming-card rounded-lg p-6 mb-6">
                    <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">
                        Participants (<?php echo e($tournament->participants->count()); ?>)
                    </h2>
                    <div class="space-y-3">
                        <?php $__empty_1 = true; $__currentLoopData = $tournament->participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="flex items-center justify-between p-3 bg-cod-light rounded-lg">
                                <div class="flex items-center space-x-3">
                                    <div class="w-8 h-8 bg-cod-green rounded-full flex items-center justify-center text-black font-bold">
                                        <?php echo e($participant->seed ?? '#'); ?>

                                    </div>
                                    <span class="text-gray-300"><?php echo e($participant->user->username); ?></span>
                                    <?php if($participant->result === 'winner'): ?>
                                        <span class="text-yellow-400">👑</span>
                                    <?php elseif($participant->result === 'runner_up'): ?>
                                        <span class="text-gray-400">🥈</span>
                                    <?php endif; ?>
                                </div>
                                <div class="text-sm text-gray-400">
                                    Level <?php echo e($participant->user->level); ?>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-gray-400 text-center py-4">No participants yet</p>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Pending Invites (for tournament host) -->
                <?php if(auth()->check() && $tournament->host_id === auth()->id() && $tournament->pendingInvites->count() > 0): ?>
                    <div class="gaming-card rounded-lg p-6">
                        <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">
                            Pending Invites (<?php echo e($tournament->pendingInvites->count()); ?>)
                        </h2>
                        <div class="space-y-3">
                            <?php $__currentLoopData = $tournament->pendingInvites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-center justify-between p-3 bg-cod-light rounded-lg">
                                    <div>
                                        <span class="text-gray-300"><?php echo e($invite->invitee->username); ?></span>
                                        <div class="text-sm text-gray-400">
                                            Invited <?php echo e($invite->created_at->diffForHumans()); ?>

                                        </div>
                                    </div>
                                    <span class="text-yellow-400 text-sm">⏳ Pending</span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Tournament Matches -->
        <?php if($tournament->matches->count() > 0): ?>
            <div class="gaming-card rounded-lg p-6 mt-8">
                <h2 class="text-xl font-gaming font-bold text-cod-green mb-4">Matches</h2>
                <div class="space-y-4">
                    <?php $__currentLoopData = $tournament->matches->groupBy('round'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $round => $roundMatches): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-300 mb-3">Round <?php echo e($round); ?></h3>
                            <div class="grid gap-4">
                                <?php $__currentLoopData = $roundMatches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $match): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-center justify-between p-4 bg-cod-light rounded-lg">
                                        <div class="flex items-center space-x-4">
                                            <span class="text-gray-300"><?php echo e($match->playerA->username); ?></span>
                                            <span class="text-gray-400">vs</span>
                                            <span class="text-gray-300"><?php echo e($match->playerB->username); ?></span>
                                        </div>
                                        <div class="text-sm">
                                            <?php if($match->result === 'none'): ?>
                                                <span class="text-yellow-400">Pending</span>
                                            <?php elseif($match->result === 'player_a_win'): ?>
                                                <span class="text-green-400"><?php echo e($match->playerA->username); ?> Won</span>
                                            <?php else: ?>
                                                <span class="text-green-400"><?php echo e($match->playerB->username); ?> Won</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\OneDrive\Desktop\Script\Personal_Project\Agamec-main\resources\views/tournaments/show.blade.php ENDPATH**/ ?>