<?php $__env->startSection('title', 'Login'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full space-y-8">
        <div class="text-center">
            <div class="animate-float">
                <div class="w-20 h-20 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-2xl mx-auto mb-6 flex items-center justify-center">
                    <span class="text-3xl font-bold text-black">A</span>
                </div>
                <h2 class="text-4xl font-gaming font-extrabold text-cod-green gaming-text-glow">
                    Welcome Back
                </h2>
                <p class="mt-2 text-sm text-gray-400">
                    Sign in to your gaming account
                </p>
            </div>
        </div>
        
        <form class="mt-8 space-y-8 bg-cod-gray p-8 rounded-xl gaming-glow border border-cod-green/20" method="POST" action="<?php echo e(route('login')); ?>">
            <?php echo csrf_field(); ?>
            
            <!-- Session Status -->
            <?php if(session('status')): ?>
                <div class="bg-green-500/20 border border-green-500/50 text-green-400 px-4 py-3 rounded-lg mb-4 flex items-center space-x-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    <span><?php echo e(session('status')); ?></span>
                </div>
            <?php endif; ?>

            <div class="space-y-6">
                <!-- Email or Username with Floating Label -->
                <div class="floating-label-group">
                    <input id="login" 
                           name="login" 
                           type="text" 
                           autocomplete="username" 
                           required
                           value="<?php echo e(old('login')); ?>"
                           placeholder="Enter your email or username"
                           class="floating-label-input <?php echo e($errors->has('login') || $errors->has('email') ? 'form-error' : ''); ?>">
                    <label for="login" class="floating-label">Email or Username *</label>
                    <?php $__errorArgs = ['login'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span><?php echo e($message); ?></span>
                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span><?php echo e($message); ?></span>
                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Password with Floating Label -->
                <div class="floating-label-group">
                    <input id="password" 
                           name="password" 
                           type="password" 
                           autocomplete="current-password" 
                           required
                           placeholder="Enter your password"
                           class="floating-label-input <?php echo e($errors->has('password') ? 'form-error' : ''); ?>">
                    <label for="password" class="floating-label">Password *</label>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span><?php echo e($message); ?></span>
                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Remember Me -->
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <input id="remember" 
                               name="remember" 
                               type="checkbox" 
                               class="h-4 w-4 bg-cod-dark border border-cod-light rounded focus:ring-cod-green focus:ring-2 text-cod-green transition-colors">
                        <label for="remember" class="ml-2 block text-sm text-gray-300">
                            Remember me
                        </label>
                    </div>

                    <?php if(Route::has('password.request')): ?>
                        <div class="text-sm">
                            <a href="<?php echo e(route('password.request')); ?>" class="text-cod-green hover:text-green-400 transition-colors">
                                Forgot password?
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Login Button -->
            <div>
                <button type="submit" class="btn-primary-modern w-full">
                    <span class="flex items-center justify-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path>
                        </svg>
                        <span>Sign In</span>
                    </span>
                </button>
            </div>

            <!-- Social Login Options (if needed) -->
            <div class="mt-6">
                <div class="relative">
                    <div class="absolute inset-0 flex items-center">
                        <div class="w-full border-t border-cod-light"></div>
                    </div>
                    <div class="relative flex justify-center text-sm">
                        <span class="px-2 bg-cod-gray text-gray-400">Or continue with</span>
                    </div>
                </div>

                <div class="mt-6 text-center">
                    <p class="text-sm text-gray-400">
                        Don't have an account?
                        <a href="<?php echo e(route('register')); ?>" class="text-cod-green hover:text-green-400 font-medium transition-colors">
                            Sign up here
                        </a>
                    </p>
                </div>
            </div>
        </form>

        <!-- Additional Info -->
        <div class="text-center">
            <div class="bg-cod-dark/50 rounded-lg p-4 border border-cod-green/10">
                <h4 class="text-sm font-bold text-cod-green mb-2">🎮 Ready to Game?</h4>
                <p class="text-xs text-gray-400">
                    Join thousands of gamers competing for real money prizes!
                </p>
            </div>
        </div>
    </div>
</div>

<script>
    // Form validation enhancements
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('form');
        const inputs = form.querySelectorAll('input[type="text"], input[type="password"]');

        inputs.forEach(input => {
            input.addEventListener('blur', function() {
                validateField(this);
            });

            input.addEventListener('input', function() {
                if (this.classList.contains('form-error')) {
                    validateField(this);
                }
            });
        });

        function validateField(field) {
            const value = field.value.trim();
            const isRequired = field.hasAttribute('required');

            // Remove existing validation classes
            field.classList.remove('form-error', 'form-success');

            if (isRequired && !value) {
                field.classList.add('form-error');
            } else if (value) {
                field.classList.add('form-success');
            }
        }
    });
</script>

            <div class="text-center">
                <p class="text-gray-400">
                    Don't have an account?
                    <a href="<?php echo e(route('register')); ?>" class="font-medium text-cod-green hover:text-green-400 transition-colors">
                        Join the battle
                    </a>
                </p>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\OneDrive\Desktop\Script\Personal_Project\Agamec-main\resources\views/auth/login.blade.php ENDPATH**/ ?>