<?php $__env->startSection('title', 'My Tournaments'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-gaming font-bold text-cod-green">🏆 My Tournaments</h1>
        <?php if(auth()->user()->canHostFreeTournaments()): ?>
            <a href="<?php echo e(route('tournaments.create')); ?>" class="bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                Host New Tournament
            </a>
        <?php endif; ?>
    </div>

    <!-- Status Filter Tabs -->
    <div class="flex space-x-1 mb-6">
        <a href="<?php echo e(route('tournaments.my', ['filter' => 'all'] + request()->except('filter'))); ?>" 
           class="px-6 py-3 rounded-lg font-semibold transition-colors <?php echo e(($filter ?? 'all') === 'all' ? 'bg-cod-green text-black' : 'bg-cod-gray text-gray-300 hover:bg-cod-light'); ?>">
            📊 All Tournaments
        </a>
        <a href="<?php echo e(route('tournaments.my', ['filter' => 'ongoing'] + request()->except('filter'))); ?>" 
           class="px-6 py-3 rounded-lg font-semibold transition-colors <?php echo e(($filter ?? 'all') === 'ongoing' ? 'bg-cod-green text-black' : 'bg-cod-gray text-gray-300 hover:bg-cod-light'); ?>">
            🔥 Ongoing
        </a>
        <a href="<?php echo e(route('tournaments.my', ['filter' => 'past'] + request()->except('filter'))); ?>" 
           class="px-6 py-3 rounded-lg font-semibold transition-colors <?php echo e(($filter ?? 'all') === 'past' ? 'bg-cod-green text-black' : 'bg-cod-gray text-gray-300 hover:bg-cod-light'); ?>">
            📚 Past Tournaments
        </a>
    </div>

    <!-- Enhanced Filters -->
    <div class="bg-cod-gray rounded-lg p-6 mb-8">
        <form method="GET" action="<?php echo e(route('tournaments.my')); ?>">
            <input type="hidden" name="filter" value="<?php echo e($filter ?? 'all'); ?>">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <select name="game_id" class="bg-cod-dark text-gray-100 border border-cod-light rounded-lg px-4 py-2">
                    <option value="">All Games</option>
                    <?php $__currentLoopData = $games; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $game): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($game->id); ?>" <?php echo e(request('game_id') == $game->id ? 'selected' : ''); ?>>
                            <?php echo e($game->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                
                <button type="submit" class="bg-cod-green text-black px-6 py-2 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    🔍 Filter
                </button>
                
                <a href="<?php echo e(route('tournaments.my')); ?>" class="bg-cod-gray text-gray-300 px-6 py-2 rounded-lg font-semibold hover:bg-cod-light transition-colors text-center">
                    Clear Filters
                </a>
            </div>
        </form>
    </div>

    <!-- Tournaments Grid -->
    <?php if($tournaments->count() > 0): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php $__currentLoopData = $tournaments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tournament): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-cod-gray rounded-lg p-6 border-l-4 <?php echo e(in_array($tournament->status, ['completed', 'cancelled']) ? 'border-blue-500' : 
                    ($tournament->status === 'ongoing' ? 'border-yellow-500' : 'border-purple-500')); ?> hover:bg-cod-light transition-colors">
                    <!-- Tournament Header -->
                    <div class="flex justify-between items-start mb-4">
                        <div class="flex items-center space-x-2">
                            <img src="<?php echo e($tournament->game->icon_url ?? asset('images/default-game.png')); ?>" 
                                 alt="<?php echo e($tournament->game->name); ?>" 
                                 class="w-10 h-10 rounded-lg object-cover">
                            <div>
                                <h3 class="font-bold text-gray-100"><?php echo e($tournament->title); ?></h3>
                                <div class="text-sm text-gray-400"><?php echo e($tournament->game->name); ?></div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="text-purple-400 font-bold text-lg">
                                <?php if($tournament->entry_fee > 0): ?>
                                    ₦<?php echo e(number_format($tournament->entry_fee)); ?>

                                <?php else: ?>
                                    FREE
                                <?php endif; ?>
                            </div>
                            <div class="text-xs <?php echo e(in_array($tournament->status, ['completed', 'cancelled']) ? 'text-blue-400' : 
                                ($tournament->status === 'ongoing' ? 'text-yellow-400' : 'text-purple-400')); ?>">
                                <?php echo e(ucfirst($tournament->status)); ?>

                            </div>
                        </div>
                    </div>

                    <!-- Tournament Details -->
                    <div class="mb-4">
                        <div class="flex justify-between items-center text-sm mb-2">
                            <span class="text-gray-400">Host:</span>
                            <span class="text-gray-200 <?php echo e($tournament->host_id === auth()->id() ? 'font-bold text-purple-400' : ''); ?>">
                                <?php echo e($tournament->host->username); ?>

                                <?php if($tournament->host_id === auth()->id()): ?>
                                    (You)
                                <?php endif; ?>
                            </span>
                        </div>
                        
                        <div class="flex justify-between items-center text-sm mb-2">
                            <span class="text-gray-400">Participants:</span>
                            <span class="text-gray-200"><?php echo e($tournament->participants->count()); ?></span>
                        </div>

                        <?php if($tournament->prize_pool > 0): ?>
                            <div class="flex justify-between items-center text-sm mb-2">
                                <span class="text-gray-400">Prize Pool:</span>
                                <span class="text-green-400 font-semibold">₦<?php echo e(number_format($tournament->prize_pool)); ?></span>
                            </div>
                        <?php endif; ?>

                        <?php if($tournament->starts_at): ?>
                            <div class="flex justify-between items-center text-sm">
                                <span class="text-gray-400">
                                    <?php if($tournament->status === 'upcoming'): ?>
                                        Starts:
                                    <?php elseif($tournament->status === 'ongoing'): ?>
                                        Started:
                                    <?php else: ?>
                                        Started:
                                    <?php endif; ?>
                                </span>
                                <span class="text-gray-200"><?php echo e($tournament->starts_at->format('M j, Y g:i A')); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Tournament Type -->
                    <div class="mb-4">
                        <span class="inline-block px-3 py-1 text-xs bg-purple-500/20 text-purple-400 rounded-full">
                            <?php echo e(ucfirst($tournament->type)); ?> Tournament
                        </span>
                        
                        <!-- User's Role in Tournament -->
                        <?php if($tournament->host_id === auth()->id()): ?>
                            <span class="inline-block px-3 py-1 text-xs bg-yellow-500/20 text-yellow-400 rounded-full ml-2">
                                Host
                            </span>
                        <?php else: ?>
                            <span class="inline-block px-3 py-1 text-xs bg-blue-500/20 text-blue-400 rounded-full ml-2">
                                Participant
                            </span>
                        <?php endif; ?>
                    </div>

                    <!-- Action Button -->
                    <div class="mt-4">
                        <a href="<?php echo e(route('tournaments.show', $tournament)); ?>" 
                           class="block text-center bg-purple-600 text-white py-2 px-4 rounded-lg font-semibold hover:bg-purple-700 transition-colors">
                            View Tournament
                        </a>
                    </div>

                    <!-- Timestamp -->
                    <div class="mt-3 text-xs text-gray-500 text-center">
                        <?php echo e($tournament->created_at->diffForHumans()); ?>

                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Pagination -->
        <div class="mt-8">
            <?php echo e($tournaments->appends(request()->query())->links()); ?>

        </div>
    <?php else: ?>
        <!-- Empty State -->
        <div class="text-center py-16">
            <div class="w-24 h-24 bg-cod-gray rounded-full flex items-center justify-center mx-auto mb-6">
                <span class="text-4xl">🏆</span>
            </div>
            <h3 class="text-xl font-bold text-gray-300 mb-2">
                <?php if(($filter ?? 'all') === 'ongoing'): ?>
                    No Ongoing Tournaments
                <?php elseif(($filter ?? 'all') === 'past'): ?>
                    No Past Tournaments
                <?php else: ?>
                    No Tournaments Yet
                <?php endif; ?>
            </h3>
            <p class="text-gray-400 mb-6">
                <?php if(($filter ?? 'all') === 'ongoing'): ?>
                    You don't have any ongoing tournaments at the moment.
                <?php elseif(($filter ?? 'all') === 'past'): ?>
                    You haven't participated in any completed tournaments yet.
                <?php else: ?>
                    You haven't participated in any tournaments yet.
                <?php endif; ?>
            </p>
            <?php if(auth()->user()->canHostFreeTournaments()): ?>
                <a href="<?php echo e(route('tournaments.create')); ?>" class="bg-purple-600 text-white px-6 py-3 rounded-lg font-semibold hover:bg-purple-700 transition-colors">
                    Host Your First Tournament
                </a>
            <?php else: ?>
                <a href="<?php echo e(route('tournaments.index')); ?>" class="bg-purple-600 text-white px-6 py-3 rounded-lg font-semibold hover:bg-purple-700 transition-colors">
                    Browse Tournaments
                </a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\OneDrive\Desktop\Script\Personal_Project\Agamec-main\resources\views/tournaments/my.blade.php ENDPATH**/ ?>