<?php $__env->startSection('title', 'Create Tournament'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-8">
            <a href="<?php echo e(route('tournaments.index')); ?>" class="inline-flex items-center text-cod-green hover:text-green-400 transition-colors mb-4">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Back to Tournaments
            </a>
            <h1 class="text-4xl font-gaming font-bold text-cod-green gaming-text-glow mb-2">Create Tournament</h1>
            <p class="text-gray-400">Set up your own tournament and invite players to compete</p>
        </div>

        <!-- Tournament Creation Form -->
        <div class="bg-cod-gray rounded-xl p-8 gaming-glow border border-cod-green/20">
            <form method="POST" action="<?php echo e(route('tournaments.store')); ?>" class="space-y-8">
                <?php echo csrf_field(); ?>
                
                <!-- Basic Information Section -->
                <div class="space-y-6">
                    <h3 class="text-xl font-bold text-cod-green mb-4">Tournament Details</h3>
                    
                    <!-- Tournament Title with Floating Label -->
                    <div class="floating-label-group">
                        <input type="text" 
                               id="title" 
                               name="title" 
                               value="<?php echo e(old('title')); ?>" 
                               required
                               class="floating-label-input <?php echo e($errors->has('title') ? 'form-error' : ''); ?>"
                               placeholder="e.g., FIFA 24 Champions Cup">
                        <label for="title" class="floating-label">Tournament Title *</label>
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span><?php echo e($message); ?></span>
                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Game Selection -->
                    <div class="space-y-2">
                        <label for="game_id" class="block text-sm font-medium text-cod-green">Game *</label>
                        <select id="game_id" name="game_id" required class="gaming-select focus-ring <?php echo e($errors->has('game_id') ? 'form-error' : ''); ?>">
                            <option value="">Select a game</option>
                            <?php $__currentLoopData = $games; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $game): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($game->id); ?>" <?php echo e(old('game_id') == $game->id ? 'selected' : ''); ?>>
                                    <?php echo e($game->name); ?> (<?php echo e(ucfirst($game->platform)); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['game_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span><?php echo e($message); ?></span>
                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Tournament Type -->
                    <div class="space-y-2">
                        <label for="type" class="block text-sm font-medium text-cod-green">Tournament Type *</label>
                        <select id="type" name="type" required class="gaming-select focus-ring <?php echo e($errors->has('type') ? 'form-error' : ''); ?>" onchange="updateTypeInfo()">
                            <option value="">Select tournament type</option>
                            <option value="knockout" <?php echo e(old('type') == 'knockout' ? 'selected' : ''); ?>>
                                Knockout (Single Elimination)
                            </option>
                            <option value="round_robin" <?php echo e(old('type') == 'round_robin' ? 'selected' : ''); ?>>
                                Round Robin (Everyone vs Everyone)
                            </option>
                        </select>
                        <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span><?php echo e($message); ?></span>
                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        
                        <!-- Type Information -->
                        <div id="knockout-info" class="hidden mt-2 p-4 bg-blue-500/20 border border-blue-500/50 rounded-lg text-sm">
                            <div class="flex items-start space-x-2">
                                <span class="text-blue-400">🏆</span>
                                <div>
                                    <strong class="text-blue-300">Knockout Tournament:</strong>
                                    <p class="text-gray-300 mt-1">Single elimination format. Requires a power of 2 number of participants (2, 4, 8, 16, etc.). Perfect for competitive, high-stakes matches.</p>
                                </div>
                            </div>
                        </div>
                        <div id="roundrobin-info" class="hidden mt-2 p-4 bg-green-500/20 border border-green-500/50 rounded-lg text-sm">
                            <div class="flex items-start space-x-2">
                                <span class="text-green-400">🔄</span>
                                <div>
                                    <strong class="text-green-300">Round Robin Tournament:</strong>
                                    <p class="text-gray-300 mt-1">Every player plays against every other player. More games for everyone, fair ranking system.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Configuration Section -->
                <div class="space-y-6 border-t border-cod-green/20 pt-6">
                    <h3 class="text-xl font-bold text-cod-green mb-4">Tournament Configuration</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Entry Fee -->
                        <div class="space-y-2">
                            <label for="entry_fee" class="block text-sm font-medium text-cod-green">Entry Fee (₦) *</label>
                            <div class="input-with-icon">
                                <div class="input-icon">
                                    <span class="text-lg">₦</span>
                                </div>
                                <input type="number" 
                                       id="entry_fee" 
                                       name="entry_fee" 
                                       value="<?php echo e(old('entry_fee', 0)); ?>" 
                                       min="0" 
                                       step="0.01"
                                       class="gaming-input focus-ring <?php echo e($errors->has('entry_fee') ? 'form-error' : ''); ?>"
                                       placeholder="0.00">
                            </div>
                            <?php if(!auth()->user()->canHostPaidTournaments()): ?>
                                <div class="text-yellow-400 text-sm flex items-center space-x-1">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                                    </svg>
                                    <span>You need Level 4+ and KYC verification to host paid tournaments</span>
                                </div>
                            <?php endif; ?>
                            <?php $__errorArgs = ['entry_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <span><?php echo e($message); ?></span>
                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Max Participants -->
                        <div class="floating-label-group">
                            <input type="number" 
                                   id="max_participants" 
                                   name="max_participants" 
                                   value="<?php echo e(old('max_participants', 8)); ?>" 
                                   min="2" 
                                   max="64"
                                   required
                                   class="floating-label-input <?php echo e($errors->has('max_participants') ? 'form-error' : ''); ?>"
                                   placeholder="8">
                            <label for="max_participants" class="floating-label">Max Participants *</label>
                            <?php $__errorArgs = ['max_participants'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <span><?php echo e($message); ?></span>
                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <!-- Start Date -->
                    <div class="space-y-2">
                        <label for="starts_at" class="block text-sm font-medium text-cod-green">Start Date & Time *</label>
                        <input type="datetime-local" 
                               id="starts_at" 
                               name="starts_at" 
                               value="<?php echo e(old('starts_at')); ?>" 
                               min="<?php echo e(now()->format('Y-m-d\TH:i')); ?>"
                               required
                               class="gaming-input focus-ring <?php echo e($errors->has('starts_at') ? 'form-error' : ''); ?>">
                        <?php $__errorArgs = ['starts_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span><?php echo e($message); ?></span>
                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Description -->
                    <div class="floating-label-group">
                        <textarea id="description" 
                                  name="description" 
                                  rows="4"
                                  class="floating-label-input resize-none <?php echo e($errors->has('description') ? 'form-error' : ''); ?>"
                                  placeholder="Describe tournament rules, format, and any special requirements..."><?php echo e(old('description')); ?></textarea>
                        <label for="description" class="floating-label">Tournament Description</label>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span><?php echo e($message); ?></span>
                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex flex-col sm:flex-row gap-4 pt-6 border-t border-cod-green/20">
                    <button type="submit" class="btn-primary-modern flex-1 order-2 sm:order-1">
                        <span class="flex items-center justify-center space-x-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                            <span>Create Tournament</span>
                        </span>
                    </button>
                    <a href="<?php echo e(route('tournaments.index')); ?>" class="btn-secondary-modern flex-1 text-center order-1 sm:order-2">
                        Cancel
                    </a>
                </div>
            </form>
        </div>

        <!-- Tournament Tips -->
        <div class="mt-8 bg-cod-dark/50 rounded-xl p-6 border border-cod-green/10">
            <h4 class="text-lg font-bold text-cod-green mb-4">🎯 Tournament Tips</h4>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm text-gray-400">
                <div class="flex items-start space-x-2">
                    <span class="text-cod-green">✓</span>
                    <span>Set realistic entry fees to attract more participants</span>
                </div>
                <div class="flex items-start space-x-2">
                    <span class="text-cod-green">✓</span>
                    <span>Choose power of 2 participants for knockout tournaments</span>
                </div>
                <div class="flex items-start space-x-2">
                    <span class="text-cod-green">✓</span>
                    <span>Schedule tournaments at peak gaming hours</span>
                </div>
                <div class="flex items-start space-x-2">
                    <span class="text-cod-green">✓</span>
                    <span>Provide clear rules and match format details</span>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function updateTypeInfo() {
        const type = document.getElementById('type').value;
        const knockoutInfo = document.getElementById('knockout-info');
        const roundrobinInfo = document.getElementById('roundrobin-info');
        
        // Hide both info boxes
        knockoutInfo.classList.add('hidden');
        roundrobinInfo.classList.add('hidden');
        
        // Show relevant info box
        if (type === 'knockout') {
            knockoutInfo.classList.remove('hidden');
        } else if (type === 'round_robin') {
            roundrobinInfo.classList.remove('hidden');
        }
    }

    // Form validation enhancements
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('form');
        const inputs = form.querySelectorAll('input, select, textarea');

        inputs.forEach(input => {
            input.addEventListener('blur', function() {
                validateField(this);
            });

            input.addEventListener('input', function() {
                if (this.classList.contains('form-error')) {
                    validateField(this);
                }
            });
        });

        function validateField(field) {
            const value = field.value.trim();
            const isRequired = field.hasAttribute('required');

            // Remove existing validation classes
            field.classList.remove('form-error', 'form-success');

            if (isRequired && !value) {
                field.classList.add('form-error');
            } else if (value) {
                field.classList.add('form-success');
            }
        }

        // Initialize type info display
        updateTypeInfo();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\OneDrive\Desktop\Script\Personal_Project\Agamec-main\resources\views/tournaments/create.blade.php ENDPATH**/ ?>