<?php $__env->startSection('title', 'Tournaments'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-gaming font-bold text-cod-green">Gaming Tournaments</h1>
        <?php if(auth()->guard()->check()): ?>
            <?php if(auth()->user()->canHostFreeTournaments()): ?>
                <a href="<?php echo e(route('tournaments.create')); ?>" class="bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Host Tournament
                </a>
            <?php else: ?>
                <span class="text-gray-400 text-sm">Reach Level 3 to host tournaments</span>
            <?php endif; ?>
        <?php else: ?>
            <a href="<?php echo e(route('login')); ?>" class="bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                Login to Host
            </a>
        <?php endif; ?>
    </div>

    <!-- Global/Friends Tabs -->
    <?php if(auth()->guard()->check()): ?>
    <div class="flex space-x-1 mb-6">
        <a href="<?php echo e(route('tournaments.index', ['filter' => 'global'] + request()->except('filter'))); ?>" 
           class="px-6 py-3 rounded-lg font-semibold transition-colors <?php echo e(($filter ?? 'global') === 'global' ? 'bg-cod-green text-black' : 'bg-cod-gray text-gray-300 hover:bg-cod-light'); ?>">
            🌍 Global Tournaments
        </a>
        <a href="<?php echo e(route('tournaments.index', ['filter' => 'friends'] + request()->except('filter'))); ?>" 
           class="px-6 py-3 rounded-lg font-semibold transition-colors <?php echo e(($filter ?? 'global') === 'friends' ? 'bg-cod-green text-black' : 'bg-cod-gray text-gray-300 hover:bg-cod-light'); ?>">
            👥 Friends Only
        </a>
    </div>
    <?php endif; ?>

    <!-- Enhanced Filters -->
    <div class="bg-cod-gray rounded-lg p-6 mb-8">
        <form method="GET" action="<?php echo e(route('tournaments.index')); ?>">
            <input type="hidden" name="filter" value="<?php echo e($filter ?? 'global'); ?>">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <select name="game_id" class="bg-cod-dark text-gray-100 border border-cod-light rounded-lg px-4 py-2">
                    <option value="">All Games</option>
                    <?php $__currentLoopData = $games; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $game): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($game->id); ?>" <?php echo e(request('game_id') == $game->id ? 'selected' : ''); ?>>
                            <?php echo e($game->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <select name="status" class="bg-cod-dark text-gray-100 border border-cod-light rounded-lg px-4 py-2">
                    <option value="upcoming,ongoing" <?php echo e(request('status') === 'upcoming,ongoing' ? 'selected' : ''); ?>>Active Tournaments</option>
                    <option value="upcoming" <?php echo e(request('status') === 'upcoming' ? 'selected' : ''); ?>>Upcoming Only</option>
                    <option value="ongoing" <?php echo e(request('status') === 'ongoing' ? 'selected' : ''); ?>>Live Tournaments</option>
                    <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                </select>
                <select name="type" class="bg-cod-dark text-gray-100 border border-cod-light rounded-lg px-4 py-2">
                    <option value="">All Types</option>
                    <option value="knockout" <?php echo e(request('type') === 'knockout' ? 'selected' : ''); ?>>Knockout</option>
                    <option value="league" <?php echo e(request('type') === 'league' ? 'selected' : ''); ?>>League</option>
                </select>
                <button type="submit" class="bg-cod-green text-black px-4 py-2 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Apply Filters
                </button>
            </div>
        </form>
    </div>

    <!-- Results Info -->
    <?php if(auth()->guard()->check()): ?>
        <?php if(($filter ?? 'global') === 'friends'): ?>
            <div class="bg-blue-900/20 border border-blue-500/30 rounded-lg p-4 mb-6">
                <div class="flex items-center space-x-2">
                    <span class="text-blue-400">👥</span>
                    <span class="text-blue-300 font-semibold">Showing tournaments hosted by your friends only</span>
                </div>
                <p class="text-blue-200 text-sm mt-1">Switch to Global to see all tournaments, or <a href="<?php echo e(route('friends.suggestions')); ?>" class="text-blue-400 hover:text-blue-300 underline">find more friends</a>.</p>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Tournament Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-8">
        <?php $__empty_1 = true; $__currentLoopData = $tournaments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tournament): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-cod-gray rounded-lg overflow-hidden hover:gaming-glow transition-all duration-300">
                <!-- Tournament Header -->
                <div class="bg-gaming-gradient p-6 text-white">
                    <div class="flex justify-between items-start mb-4">
                        <div>
                            <h3 class="text-xl font-bold"><?php echo e($tournament->title); ?></h3>
                            <p class="text-orange-100"><?php echo e($tournament->game->name); ?></p>
                            <div class="flex items-center space-x-2 mt-1">
                                <span class="text-orange-200 text-sm">by <?php echo e($tournament->host->username); ?></span>
                                <?php if(auth()->guard()->check()): ?>
                                    <?php if(auth()->user()->isFriendsWith($tournament->host)): ?>
                                        <span class="bg-blue-500/30 text-blue-200 px-2 py-1 rounded text-xs">Friend</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <span class="bg-white/20 px-3 py-1 rounded-full text-sm font-semibold">
                            <?php echo e(strtoupper($tournament->type)); ?>

                        </span>
                    </div>
                    
                    <div class="flex justify-between items-center">
                        <div>
                            <div class="text-2xl font-bold">₦<?php echo e(number_format($tournament->prize_pool)); ?></div>
                            <div class="text-sm text-orange-100">Prize Pool</div>
                        </div>
                        <div class="text-right">
                            <div class="text-lg font-semibold"><?php echo e($tournament->participants->count()); ?></div>
                            <div class="text-sm text-orange-100">Players</div>
                        </div>
                    </div>
                </div>

                <div class="p-6">
                    <!-- Tournament Info -->
                    <div class="space-y-3 mb-6">
                        <div class="flex justify-between">
                            <span class="text-gray-400">Entry Fee:</span>
                            <span class="text-green-400 font-semibold">₦<?php echo e(number_format($tournament->entry_fee)); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-400">Status:</span>
                            <span class="text-cod-green font-semibold capitalize"><?php echo e($tournament->status); ?></span>
                        </div>
                        <?php if($tournament->starts_at): ?>
                            <div class="flex justify-between">
                                <span class="text-gray-400">Starts:</span>
                                <span class="text-gray-100"><?php echo e($tournament->starts_at->format('M j, Y g:i A')); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="flex justify-between">
                            <span class="text-gray-400">Created:</span>
                            <span class="text-gray-300"><?php echo e($tournament->created_at->diffForHumans()); ?></span>
                        </div>
                    </div>

                    <!-- Description -->
                    <?php if($tournament->description): ?>
                        <div class="mb-6">
                            <h4 class="text-sm font-semibold text-gray-300 mb-2">Description:</h4>
                            <p class="text-gray-400 text-sm"><?php echo e(Str::limit($tournament->description, 150)); ?></p>
                        </div>
                    <?php endif; ?>

                    <!-- Actions -->
                    <div class="space-y-3">
                        <a href="<?php echo e(route('tournaments.show', $tournament)); ?>" class="block w-full bg-cod-light text-center text-cod-green px-4 py-3 rounded hover:bg-cod-green hover:text-black transition-colors">
                            View Tournament
                        </a>
                        
                        <?php if(auth()->guard()->check()): ?>
                            <?php if($tournament->canBeJoinedBy(auth()->user())): ?>
                                <form method="POST" action="<?php echo e(route('tournaments.join', $tournament)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="w-full bg-cod-green text-black px-4 py-3 rounded font-semibold hover:bg-green-600 transition-colors">
                                        Join Tournament (₦<?php echo e(number_format($tournament->entry_fee)); ?>)
                                    </button>
                                </form>
                            <?php elseif($tournament->users->contains(auth()->user())): ?>
                                <div class="text-center py-3 bg-green-600/20 text-green-400 rounded">
                                    ✓ You're participating in this tournament
                                </div>
                            <?php else: ?>
                                <div class="text-center py-3 bg-gray-600/20 text-gray-400 rounded">
                                    Tournament not available
                                </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>" class="block w-full bg-cod-green text-center text-black px-4 py-3 rounded font-semibold hover:bg-green-600 transition-colors">
                                Login to Join
                            </a>
                        <?php endif; ?>
                    </div>

                    <!-- Friend Action -->
                    <?php if(auth()->guard()->check()): ?>
                        <?php if($tournament->host_id !== auth()->id() && auth()->user()->hasPlayedWith($tournament->host) && !auth()->user()->isFriendsWith($tournament->host) && !auth()->user()->hasPendingRequestWith($tournament->host)): ?>
                            <div class="mt-3 pt-3 border-t border-cod-light">
                                <form method="POST" action="<?php echo e(route('friends.send-request', $tournament->host)); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="w-full bg-blue-600/20 text-blue-400 px-3 py-2 rounded text-sm hover:bg-blue-600 hover:text-white transition-colors">
                                        Add <?php echo e($tournament->host->username); ?> as Friend
                                    </button>
                                </form>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <!-- Livestream Link -->
                    <?php if($tournament->livestream_link): ?>
                        <div class="mt-4 pt-4 border-t border-cod-light">
                            <a href="<?php echo e($tournament->livestream_link); ?>" target="_blank" class="flex items-center justify-center space-x-2 text-red-400 hover:text-red-300 transition-colors">
                                <span class="text-sm">🔴 Watch Live</span>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-full text-center py-16">
                <div class="text-6xl mb-4">🏆</div>
                <?php if(auth()->guard()->check()): ?>
                    <?php if(($filter ?? 'global') === 'friends'): ?>
                        <h3 class="text-xl font-semibold text-gray-400 mb-2">No Friend Tournaments</h3>
                        <p class="text-gray-500 mb-4">Your friends haven't hosted any tournaments yet.</p>
                        <div class="space-x-4">
                            <a href="<?php echo e(route('tournaments.index', ['filter' => 'global'])); ?>" class="inline-block bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                                View Global Tournaments
                            </a>
                            <a href="<?php echo e(route('friends.suggestions')); ?>" class="inline-block bg-cod-light text-cod-green px-6 py-3 rounded-lg font-semibold hover:bg-cod-green hover:text-black transition-colors">
                                Find Friends
                            </a>
                        </div>
                    <?php else: ?>
                        <h3 class="text-xl font-semibold text-gray-400 mb-2">No Active Tournaments</h3>
                        <p class="text-gray-500">Check back later or create your own tournament!</p>
                        <?php if(auth()->user()->canHostFreeTournaments()): ?>
                            <a href="<?php echo e(route('tournaments.create')); ?>" class="inline-block mt-4 bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                                Host First Tournament
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php else: ?>
                    <h3 class="text-xl font-semibold text-gray-400 mb-2">No Active Tournaments</h3>
                    <p class="text-gray-500">Check back later or create your own tournament!</p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if($tournaments->hasPages()): ?>
        <div class="mt-8">
            <?php echo e($tournaments->appends(request()->query())->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\OneDrive\Desktop\Script\Personal_Project\Agamec-main\resources\views/tournaments/index.blade.php ENDPATH**/ ?>