/** @type {import('tailwindcss').Config} */
export default {
  content: [
    "./resources/**/*.blade.php",
    "./resources/**/*.js",
    "./resources/**/*.vue",
  ],
  theme: {
    extend: {
      colors: {
        'cod-darker': '#0a0a0a',
        'cod-dark': '#121212',
        'cod-gray': '#1a1a1a',
        'cod-light': '#2a2a2a',
        'cod-green': '#ff6600', // Changed from green to orange
        'cod-green-dark': '#e55a00', // Changed from green to darker orange
        'cod-orange': '#ff6600', // New orange color
        'cod-orange-dark': '#e55a00', // New darker orange color
      },
      fontFamily: {
        'gaming': ['Orbitron', 'monospace'],
      },
      animation: {
        'pulse-orange': 'pulse-orange 2s cubic-bezier(0.4, 0, 0.6, 1) infinite',
        'glow': 'glow 2s ease-in-out infinite alternate',
        'float': 'float 6s ease-in-out infinite',
        'bounce-slow': 'bounce 3s infinite',
        'ping-slow': 'ping 4s cubic-bezier(0, 0, 0.2, 1) infinite',
        'spin-slow': 'spin 20s linear infinite',
        'gradient-shift': 'gradientShift 3s ease-in-out infinite',
        'scroll-bounce': 'scrollBounce 2s infinite',
      },
      keyframes: {
        'pulse-orange': {
          '0%, 100%': {
            opacity: '1',
          },
          '50%': {
            opacity: '0.5',
          },
        },
        'glow': {
          'from': {
            'text-shadow': '0 0 10px #ff6600, 0 0 20px #ff6600, 0 0 30px #ff6600',
          },
          'to': {
            'text-shadow': '0 0 20px #ff6600, 0 0 30px #ff6600, 0 0 40px #ff6600',
          },
        },
        'float': {
          '0%, 100%': {
            transform: 'translateY(0px)',
          },
          '50%': {
            transform: 'translateY(-20px)',
          },
        },
        'gradientShift': {
          '0%, 100%': {
            'background-position': '0% 50%',
          },
          '50%': {
            'background-position': '100% 50%',
          },
        },
        'scrollBounce': {
          '0%, 20%, 50%, 80%, 100%': {
            transform: 'translateY(0)',
          },
          '40%': {
            transform: 'translateY(-10px)',
          },
          '60%': {
            transform: 'translateY(-5px)',
          },
        },
      },
      boxShadow: {
        'gaming': '0 0 20px rgba(255, 102, 0, 0.3)',
        'gaming-lg': '0 0 40px rgba(255, 102, 0, 0.4)',
        'neon-blue': '0 0 20px rgba(59, 130, 246, 0.5)',
        'neon-purple': '0 0 20px rgba(147, 51, 234, 0.5)',
        'neon-green': '0 0 20px rgba(34, 197, 94, 0.5)',
      },
      backdropBlur: {
        'xs': '2px',
        'xl': '24px',
      },
      borderWidth: {
        '3': '3px',
      },
    },
  },
  plugins: [
    require('@tailwindcss/forms'),
    require('@tailwindcss/typography'),
  ],
}