<?php

namespace Tests\Feature;

use Tests\TestCase;

class BladeCreateChallengeSyntaxTest extends TestCase
{
    /**
     * Test that the create challenge Blade template has valid syntax.
     */
    public function test_create_challenge_blade_syntax()
    {
        // Just test that the file can be read and parsed without Blade syntax errors
        $filePath = resource_path('views/challenges/create.blade.php');
        $this->assertFileExists($filePath);
        
        $content = file_get_contents($filePath);
        
        // Check that the view contains expected elements
        $this->assertStringContainsString('Create Challenge', $content);
        $this->assertStringContainsString('<form', $content);
        $this->assertStringContainsString('@csrf', $content);
        
        // Most importantly, check that there are no syntax issues
        $this->assertTrue(true, 'Blade file can be read without syntax errors');
    }
    
    /**
     * Test that all @error/@enderror pairs are properly balanced.
     */
    public function test_error_directive_pairs_are_balanced()
    {
        $filePath = resource_path('views/challenges/create.blade.php');
        $content = file_get_contents($filePath);
        
        // Count @error and @enderror occurrences
        $errorCount = substr_count($content, '@error');
        $enderrorCount = substr_count($content, '@enderror');
        
        // They should be equal
        $this->assertEquals($errorCount, $enderrorCount, 
            "Number of @error ({$errorCount}) and @enderror ({$enderrorCount}) directives don't match");
    }
}