<?php

namespace Tests\Feature;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;

/**
 * Test CSS compilation and blade template rendering
 */
class CSSCompilationTest extends TestCase
{
    use RefreshDatabase;

    /**
     * Test that CSS builds without syntax errors
     */
    public function test_css_builds_without_errors()
    {
        // Verify that the manifest file exists (created by successful Vite build)
        $manifestPath = public_path('build/manifest.json');
        $this->assertFileExists($manifestPath, 'Vite manifest should exist after successful CSS build');

        // Verify the manifest contains expected assets
        $manifest = json_decode(file_get_contents($manifestPath), true);
        $this->assertArrayHasKey('resources/css/app.css', $manifest);
        $this->assertArrayHasKey('resources/js/app.js', $manifest);
    }

    /**
     * Test that the app layout renders without CSS errors
     */
    public function test_app_layout_renders_without_css_errors()
    {
        // Create a simple test view that extends the app layout
        $response = $this->get('/');
        
        // Should not return 500 due to CSS syntax errors
        $response->assertStatus(200);
        
        // Should contain the Vite directive output (indicating CSS loaded)
        $content = $response->getContent();
        $this->assertStringContainsString('build/assets/', $content);
    }
}