<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use App\Models\Friend;
use App\Models\Challenge;
use App\Models\Tournament;
use App\Models\TournamentParticipant;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Auth;

class Fixed500ErrorsTest extends TestCase
{
    use RefreshDatabase;

    /**
     * Test that friend suggestions page loads without error
     */
    public function test_friend_suggestions_loads_without_error()
    {
        // Create some test users
        $user1 = User::factory()->create(['username' => 'user1', 'xp' => 1000, 'status' => 'active']);
        $user2 = User::factory()->create(['username' => 'user2', 'xp' => 2000, 'status' => 'active']);
        $user3 = User::factory()->create(['username' => 'user3', 'xp' => 1500, 'status' => 'active']);
        
        // Create a completed challenge between user1 and user2
        Challenge::factory()->create([
            'creator_id' => $user1->id,
            'accepter_id' => $user2->id,
            'status' => 'completed'
        ]);
        
        // Login as user1
        Auth::login($user1);
        
        // Try to access friend suggestions page
        $response = $this->get('/friends/suggestions');
        
        // Should not get a 500 error
        $response->assertStatus(200);
    }

    /**
     * Test that leaderboard page loads without error
     */
    public function test_leaderboard_loads_without_error()
    {
        // Create some test users with different XP
        $user1 = User::factory()->create(['username' => 'user1', 'xp' => 1000, 'status' => 'active']);
        $user2 = User::factory()->create(['username' => 'user2', 'xp' => 2000, 'status' => 'active']);
        $user3 = User::factory()->create(['username' => 'user3', 'xp' => 1500, 'status' => 'active']);
        
        // Login as user1
        Auth::login($user1);
        
        // Try to access leaderboard page
        $response = $this->get('/leaderboards');
        
        // Should not get a 500 error
        $response->assertStatus(200);
    }

    /**
     * Test that getRank method works correctly
     */
    public function test_get_rank_method_works()
    {
        // Create users with different XP values
        $user1 = User::factory()->create(['xp' => 1000, 'status' => 'active']);
        $user2 = User::factory()->create(['xp' => 2000, 'status' => 'active']);
        $user3 = User::factory()->create(['xp' => 1500, 'status' => 'active']);
        $user4 = User::factory()->create(['xp' => 500, 'status' => 'active']);
        
        // Test ranks
        $this->assertEquals(1, $user2->getRank()); // Highest XP
        $this->assertEquals(2, $user3->getRank()); // Second highest
        $this->assertEquals(3, $user1->getRank()); // Third highest
        $this->assertEquals(4, $user4->getRank()); // Lowest XP
    }
}