<?php

namespace Tests\Feature;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;

class FixedIssuesTest extends TestCase
{
    use RefreshDatabase;

    /**
     * Test that routes now work after fixes when database is available
     */
    public function test_routes_work_with_database(): void
    {
        // Test leaderboards route
        $response = $this->get('/leaderboards');
        $response->assertStatus(200);

        // Test friends suggestions route  
        $response = $this->get('/friends/suggestions');
        $response->assertStatus(200);
    }

    /**
     * Test CheckLevel middleware syntax is valid
     */
    public function test_check_level_middleware_syntax(): void
    {
        // If this test runs without errors, it means the PHP syntax is valid
        $middleware = new \App\Http\Middleware\CheckLevel();
        $this->assertNotNull($middleware);
    }
}