<?php

namespace Tests\Feature;

use App\Models\User;
use App\Services\BadgeService;
use App\Services\XPService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class LoggingFixTest extends TestCase
{
    use RefreshDatabase;

    /**
     * Test that BadgeService can use logging without errors.
     * This test verifies that the "Class App\Services\Log not found" error is fixed.
     */
    public function test_badge_service_logging_works()
    {
        // Create a mock user to test badge awarding
        $user = User::factory()->create([
            'username' => 'testuser',
            'email' => 'test@example.com'
        ]);

        $badgeService = new BadgeService();
        
        // Force a scenario that would trigger the log call
        // We need to create a situation where awardBadge gets called with logging
        $reflection = new \ReflectionClass($badgeService);
        $method = $reflection->getMethod('awardBadge');
        $method->setAccessible(true);
        
        // This should not throw "Class App\Services\Log not found" error
        try {
            $method->invoke($badgeService, $user, 'First Victory');
            $this->assertTrue(true, 'BadgeService logging works correctly');
        } catch (\Error $e) {
            if (str_contains($e->getMessage(), 'Class "Log" not found')) {
                $this->fail('BadgeService still has logging class error: ' . $e->getMessage());
            }
            throw $e;
        }
    }

    /**
     * Test that XPService can use logging without errors.
     * This test verifies that the "Class App\Services\Log not found" error is fixed.
     */
    public function test_xp_service_logging_works()
    {
        // Create a mock user to test XP awarding
        $user = User::factory()->create([
            'username' => 'testuser',
            'email' => 'test@example.com',
            'xp' => 0
        ]);

        $xpService = new XPService();
        
        // This should not throw "Class App\Services\Log not found" error
        try {
            $xpService->awardXP($user, 100, 'challenge_won');
            $this->assertTrue(true, 'XPService logging works correctly');
        } catch (\Error $e) {
            if (str_contains($e->getMessage(), 'Class "Log" not found')) {
                $this->fail('XPService still has logging class error: ' . $e->getMessage());
            }
            throw $e;
        }
    }
}