<?php

namespace Database\Factories;

use App\Models\Admin;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Admin>
 */
class AdminFactory extends Factory
{
    protected $model = Admin::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail(),
            'password' => Hash::make('password'),
            'role' => self::ROLE_ADMIN,
            'permissions' => json_encode(['all']),
            'is_active' => true,
            'last_login_at' => null,
        ];
            // Use a realistic default set of permissions; can be overridden with withPermissions()
            'permissions' => json_encode(['view_users', 'edit_users']),
            'is_active' => true,
            'last_login_at' => null,
        ];
    }

    /**
     * Set custom permissions for the admin.
     *
     * @param array $permissions
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    public function withPermissions(array $permissions)
    {
        return $this->state(function (array $attributes) use ($permissions) {
            return [
                'permissions' => json_encode($permissions),
            ];
        });
    }
}
