<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Service;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            // Airtime Services
            [
                'name' => 'MTN Airtime',
                'slug' => 'mtn-airtime',
                'category' => 'airtime',
                'provider_code' => 'mtn',
                'provider_name' => 'MTN Nigeria',
                'available_amounts' => json_encode([100, 200, 500, 1000, 2000, 5000]),
                'minimum_amount' => 50,
                'maximum_amount' => 10000,
                'commission_percentage' => 2.5,
                'is_active' => true,
            ],
            [
                'name' => 'Glo Airtime', 
                'slug' => 'glo-airtime',
                'category' => 'airtime',
                'provider_code' => 'glo',
                'provider_name' => 'Globacom Nigeria',
                'available_amounts' => json_encode([100, 200, 500, 1000, 2000, 5000]),
                'minimum_amount' => 50,
                'maximum_amount' => 10000,
                'commission_percentage' => 2.5,
                'is_active' => true,
            ],
            [
                'name' => 'Airtel Airtime',
                'slug' => 'airtel-airtime', 
                'category' => 'airtime',
                'provider_code' => 'airtel',
                'provider_name' => 'Airtel Nigeria',
                'available_amounts' => json_encode([100, 200, 500, 1000, 2000, 5000]),
                'minimum_amount' => 50,
                'maximum_amount' => 10000,
                'commission_percentage' => 2.5,
                'is_active' => true,
            ],
            [
                'name' => '9mobile Airtime',
                'slug' => '9mobile-airtime',
                'category' => 'airtime', 
                'provider_code' => '9mobile',
                'provider_name' => '9mobile Nigeria',
                'available_amounts' => json_encode([100, 200, 500, 1000, 2000, 5000]),
                'minimum_amount' => 50,
                'maximum_amount' => 10000,
                'commission_percentage' => 2.5,
                'is_active' => true,
            ],

            // Data Services
            [
                'name' => 'MTN Data',
                'slug' => 'mtn-data',
                'category' => 'data',
                'provider_code' => 'mtn-data',
                'provider_name' => 'MTN Nigeria',
                'available_amounts' => json_encode([500, 1000, 1500, 2000, 3000, 5000]),
                'minimum_amount' => 500,
                'maximum_amount' => 20000,
                'commission_percentage' => 3.0,
                'is_active' => true,
            ],

            // Electricity Services
            [
                'name' => 'EKEDC',
                'slug' => 'ekedc',
                'category' => 'electricity',
                'provider_code' => 'ekedc',
                'provider_name' => 'Eko Electricity Distribution Company',
                'minimum_amount' => 1000,
                'maximum_amount' => 50000,
                'commission_percentage' => 1.5,
                'is_active' => true,
            ]
        ];

        foreach ($services as $service) {
            Service::create($service);
        }
    }
}