@extends('layouts.admin-sidebar')

@section('title', 'KYC Management')
@section('page-title', 'KYC Management')
@section('page-description', 'Review and manage user identity verification requests')

@section('content')
<div class="space-y-6">

    <!-- Page Actions -->
    <div class="flex justify-end mb-6">
        <a href="{{ route('admin.kyc.analytics') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
            </svg>
            Analytics
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-5 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100">
                    <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Total</p>
                    <p class="text-2xl font-semibold text-gray-900">{{ number_format($stats['total']) }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-yellow-100">
                    <svg class="w-6 h-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Pending</p>
                    <p class="text-2xl font-semibold text-yellow-600">{{ number_format($stats['pending']) }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100">
                    <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Verified</p>
                    <p class="text-2xl font-semibold text-green-600">{{ number_format($stats['verified']) }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-red-100">
                    <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Failed</p>
                    <p class="text-2xl font-semibold text-red-600">{{ number_format($stats['failed']) }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-4">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-gray-100">
                    <svg class="w-6 h-6 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3a4 4 0 118 0v4m-4 8h0m0 0h0m0 0v3m0-3a3 3 0 013-3 3 3 0 11-6 0c0 1.657 1.343 3 3 3z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Expired</p>
                    <p class="text-2xl font-semibold text-gray-600">{{ number_format($stats['expired']) }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <form method="GET" action="{{ route('admin.kyc.index') }}" class="grid grid-cols-1 md:grid-cols-6 gap-4">
            <!-- Search -->
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Search User</label>
                <input type="text" name="search" id="search" value="{{ request('search') }}" 
                       placeholder="Name or email..." 
                       class="form-input">
            </div>

            <!-- Status Filter -->
            <div>
                <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" id="status" class="form-input">
                    <option value="">All Status</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="verified" {{ request('status') === 'verified' ? 'selected' : '' }}>Verified</option>
                    <option value="failed" {{ request('status') === 'failed' ? 'selected' : '' }}>Failed</option>
                    <option value="expired" {{ request('status') === 'expired' ? 'selected' : '' }}>Expired</option>
                </select>
            </div>

            <!-- Type Filter -->
            <div>
                <label for="type" class="block text-sm font-medium text-gray-700 mb-1">Type</label>
                <select name="type" id="type" class="form-input">
                    <option value="">All Types</option>
                    <option value="bvn" {{ request('type') === 'bvn' ? 'selected' : '' }}>BVN</option>
                    <option value="nin" {{ request('type') === 'nin' ? 'selected' : '' }}>NIN</option>
                    <option value="passport" {{ request('type') === 'passport' ? 'selected' : '' }}>Passport</option>
                    <option value="drivers_license" {{ request('type') === 'drivers_license' ? 'selected' : '' }}>Driver's License</option>
                    <option value="voters_card" {{ request('type') === 'voters_card' ? 'selected' : '' }}>Voter's Card</option>
                </select>
            </div>

            <!-- Date From -->
            <div>
                <label for="date_from" class="block text-sm font-medium text-gray-700 mb-1">From Date</label>
                <input type="date" name="date_from" id="date_from" value="{{ request('date_from') }}" class="form-input">
            </div>

            <!-- Date To -->
            <div>
                <label for="date_to" class="block text-sm font-medium text-gray-700 mb-1">To Date</label>
                <input type="date" name="date_to" id="date_to" value="{{ request('date_to') }}" class="form-input">
            </div>

            <!-- Search Button -->
            <div class="flex items-end">
                <button type="submit" class="btn-primary w-full">
                    Filter & Search
                </button>
            </div>
        </form>
    </div>

    <!-- Bulk Actions -->
    @if($kycVerifications->where('status', 'pending')->count() > 0)
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <input type="checkbox" id="select-all" class="mr-3">
                <label for="select-all" class="text-sm font-medium text-gray-700">Select All Pending</label>
            </div>
            <div class="flex space-x-2">
                <button onclick="bulkApprove()" class="btn-success" disabled id="bulk-approve-btn">
                    Bulk Approve
                </button>
                <button onclick="showBulkRejectModal()" class="btn-danger" disabled id="bulk-reject-btn">
                    Bulk Reject
                </button>
            </div>
        </div>
    </div>
    @endif

    <!-- KYC Verifications Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="px-6 py-4 bg-gray-50 border-b">
            <h2 class="text-lg font-semibold text-gray-900">KYC Verifications ({{ $kycVerifications->total() }})</h2>
        </div>

        @if($kycVerifications->count() > 0)
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        @if($kycVerifications->where('status', 'pending')->count() > 0)
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            <input type="checkbox" id="select-all-header">
                        </th>
                        @endif
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Submitted</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Provider</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($kycVerifications as $kyc)
                    <tr class="hover:bg-gray-50">
                        @if($kyc->status === 'pending')
                        <td class="px-6 py-4 whitespace-nowrap">
                            <input type="checkbox" class="kyc-checkbox" value="{{ $kyc->id }}">
                        </td>
                        @elseif($kycVerifications->where('status', 'pending')->count() > 0)
                        <td class="px-6 py-4 whitespace-nowrap"></td>
                        @endif
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="flex-shrink-0 h-10 w-10">
                                    <div class="h-10 w-10 rounded-full bg-gray-300 flex items-center justify-center">
                                        <span class="text-sm font-medium text-gray-700">
                                            {{ strtoupper(substr($kyc->user->first_name, 0, 1) . substr($kyc->user->last_name, 0, 1)) }}
                                        </span>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900">{{ $kyc->user->full_name }}</div>
                                    <div class="text-sm text-gray-500">{{ $kyc->user->email }}</div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                                {{ strtoupper($kyc->type) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($kyc->status === 'pending')
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Pending</span>
                            @elseif($kyc->status === 'verified')
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Verified</span>
                            @elseif($kyc->status === 'failed')
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Failed</span>
                            @else
                                <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-800">Expired</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <div>{{ $kyc->created_at->format('M d, Y') }}</div>
                            <div class="text-xs text-gray-400">{{ $kyc->created_at->format('H:i') }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            {{ $kyc->provider ?: 'Manual' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                            <a href="{{ route('admin.kyc.show', $kyc) }}" class="text-blue-600 hover:text-blue-900">View</a>
                            
                            @if($kyc->document_path)
                                <a href="{{ route('admin.kyc.download', $kyc) }}" class="text-green-600 hover:text-green-900">Download</a>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="px-6 py-4 bg-gray-50 border-t">
            {{ $kycVerifications->links() }}
        </div>
        @else
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No KYC verifications found</h3>
            <p class="mt-1 text-sm text-gray-500">No KYC verifications match your current filters.</p>
        </div>
        @endif
    </div>
</div>

<!-- Bulk Reject Modal -->
<div id="bulkRejectModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Bulk Reject KYC Verifications</h3>
            <form id="bulk-reject-form" method="POST" action="{{ route('admin.kyc.bulk-reject') }}">
                @csrf
                <input type="hidden" name="kyc_ids" id="bulk-reject-ids">
                <div class="mb-4">
                    <label for="bulk_reason" class="block text-sm font-medium text-gray-700 mb-1">Rejection Reason</label>
                    <textarea name="reason" id="bulk_reason" required rows="3" class="form-input" 
                              placeholder="Provide reason for rejection..."></textarea>
                </div>
                <div class="flex justify-end space-x-2">
                    <button type="button" onclick="hideBulkRejectModal()" class="btn-secondary">Cancel</button>
                    <button type="submit" class="btn-danger">Reject Selected</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Bulk actions functionality
document.addEventListener('DOMContentLoaded', function() {
    const selectAllCheckboxes = document.querySelectorAll('#select-all, #select-all-header');
    const kycCheckboxes = document.querySelectorAll('.kyc-checkbox');
    const bulkApproveBtn = document.getElementById('bulk-approve-btn');
    const bulkRejectBtn = document.getElementById('bulk-reject-btn');

    // Handle select all
    selectAllCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            kycCheckboxes.forEach(cb => {
                cb.checked = this.checked;
            });
            updateBulkButtons();
            // Sync both select all checkboxes
            selectAllCheckboxes.forEach(cb => cb.checked = this.checked);
        });
    });

    // Handle individual checkboxes
    kycCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateBulkButtons);
    });

    function updateBulkButtons() {
        const checkedBoxes = document.querySelectorAll('.kyc-checkbox:checked');
        const hasSelected = checkedBoxes.length > 0;
        
        if (bulkApproveBtn) bulkApproveBtn.disabled = !hasSelected;
        if (bulkRejectBtn) bulkRejectBtn.disabled = !hasSelected;
        
        // Update select all state
        const allChecked = kycCheckboxes.length > 0 && checkedBoxes.length === kycCheckboxes.length;
        const someChecked = checkedBoxes.length > 0 && checkedBoxes.length < kycCheckboxes.length;
        
        selectAllCheckboxes.forEach(checkbox => {
            checkbox.checked = allChecked;
            checkbox.indeterminate = someChecked;
        });
    }
});

function bulkApprove() {
    const checkedBoxes = document.querySelectorAll('.kyc-checkbox:checked');
    if (checkedBoxes.length === 0) return;
    
    if (confirm(`Are you sure you want to approve ${checkedBoxes.length} KYC verification(s)?`)) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '{{ route("admin.kyc.bulk-approve") }}';
        
        const csrfInput = document.createElement('input');
        csrfInput.type = 'hidden';
        csrfInput.name = '_token';
        csrfInput.value = '{{ csrf_token() }}';
        form.appendChild(csrfInput);
        
        checkedBoxes.forEach(checkbox => {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'kyc_ids[]';
            input.value = checkbox.value;
            form.appendChild(input);
        });
        
        document.body.appendChild(form);
        form.submit();
    }
}

function showBulkRejectModal() {
    const checkedBoxes = document.querySelectorAll('.kyc-checkbox:checked');
    if (checkedBoxes.length === 0) return;
    
    const ids = Array.from(checkedBoxes).map(cb => cb.value);
    document.getElementById('bulk-reject-ids').value = JSON.stringify(ids);
    document.getElementById('bulkRejectModal').classList.remove('hidden');
}

function hideBulkRejectModal() {
    document.getElementById('bulkRejectModal').classList.add('hidden');
}
</script>
@endsection