@extends('layouts.mobile')

@section('title', 'Virtual Cards')

@section('content')
<div class="space-y-6">
    <!-- KYC Warning -->
    @if(!auth()->user()->hasCompletedKyc())
    <div class="bg-warning-600/20 border border-warning-600/30 rounded-lg p-4">
        <div class="flex items-start">
            <i class="fas fa-exclamation-triangle text-warning-400 mr-3 mt-1"></i>
            <div class="flex-1">
                <h4 class="text-warning-400 font-semibold mb-1">KYC Verification Required</h4>
                <p class="text-gray-300 text-sm mb-3">Complete your identity verification to request virtual cards.</p>
                <a href="{{ route('kyc.index') }}" class="btn btn-warning text-sm px-4 py-2">
                    Complete KYC
                </a>
            </div>
        </div>
    </div>
    @endif

    <!-- Card Statistics -->
    <div class="grid grid-cols-2 gap-4">
        <div class="card bg-gradient-to-r from-primary-600/20 to-primary-700/20 border-primary-600/30">
            <div class="text-center">
                <p class="text-primary-400 text-sm font-medium mb-1">Total Cards</p>
                <p class="text-2xl font-bold text-white">{{ $cards->count() ?? 0 }}</p>
            </div>
        </div>
        
        <div class="card bg-gradient-to-r from-success-600/20 to-success-700/20 border-success-600/30">
            <div class="text-center">
                <p class="text-success-400 text-sm font-medium mb-1">Active Cards</p>
                <p class="text-2xl font-bold text-white">{{ $cards->where('status', 'active')->count() ?? 0 }}</p>
            </div>
        </div>
    </div>

    <!-- Request New Card Button -->
    @if(auth()->user()->hasCompletedKyc())
    <div class="text-center">
        <button onclick="openCreateCardModal()" class="btn btn-primary w-full">
            <i class="fas fa-plus mr-2"></i>
            Request New Virtual Card
        </button>
    </div>
    @endif

    <!-- Cards List -->
    @if($cards && $cards->count() > 0)
    <div class="space-y-4">
        <h3 class="text-lg font-semibold text-white">My Cards</h3>
        
        <div class="space-y-4">
            @foreach($cards as $card)
            <div class="card p-0 overflow-hidden" onclick="showCardDetails('{{ $card->id }}')">
                <!-- Card Design -->
                <div class="bg-gradient-to-r {{ $card->status === 'active' ? 'from-gray-900 to-gray-700' : 'from-gray-600 to-gray-500' }} text-white p-6 relative cursor-pointer">
                    <div class="flex justify-between items-start mb-4">
                        <div>
                            <p class="text-xs opacity-75 uppercase tracking-wide">{{ $card->card_type }} Card</p>
                            <p class="text-sm opacity-90">{{ $card->currency }}</p>
                        </div>
                        <div class="status-badge {{ $card->status === 'active' ? 'status-success' : ($card->status === 'frozen' ? 'status-pending' : 'status-failed') }}">
                            {{ ucfirst($card->status) }}
                        </div>
                    </div>
                    
                    <div class="mb-4">
                        <p class="text-lg font-mono tracking-wider" id="card-number-{{ $card->id }}">
                            •••• •••• •••• {{ substr($card->masked_pan ?? '0000', -4) }}
                        </p>
                    </div>
                    
                    <div class="flex justify-between items-end">
                        <div>
                            <p class="text-xs opacity-75">Available Balance</p>
                            <p class="text-xl font-bold">{{ $card->currency }} {{ number_format($card->balance ?? 0, 2) }}</p>
                        </div>
                        <div class="text-right">
                            <p class="text-xs opacity-75">Expires</p>
                            <p class="text-sm">{{ $card->expires_at ? \Carbon\Carbon::parse($card->expires_at)->format('m/y') : '--/--' }}</p>
                        </div>
                    </div>
                    
                    <!-- Card Actions -->
                    <div class="flex justify-between items-center mt-4 pt-4 border-t border-white/20">
                        <button onclick="event.stopPropagation(); fundCard('{{ $card->id }}')" class="text-xs text-blue-300 hover:text-blue-200">
                            <i class="fas fa-plus mr-1"></i>
                            Fund
                        </button>
                        
                        @if($card->status === 'active')
                        <button onclick="event.stopPropagation(); freezeCard('{{ $card->id }}')" class="text-xs text-orange-300 hover:text-orange-200">
                            <i class="fas fa-pause mr-1"></i>
                            Freeze
                        </button>
                        @else
                        <button onclick="event.stopPropagation(); unfreezeCard('{{ $card->id }}')" class="text-xs text-green-300 hover:text-green-200">
                            <i class="fas fa-play mr-1"></i>
                            Unfreeze
                        </button>
                        @endif
                        
                        <button onclick="event.stopPropagation(); showCardDetails('{{ $card->id }}')" class="text-xs text-gray-300 hover:text-gray-200">
                            <i class="fas fa-info mr-1"></i>
                            Details
                        </button>
                    </div>
                </div>
                
                <!-- Card Usage Summary -->
                <div class="p-4 bg-dark-800/50">
                    <div class="grid grid-cols-3 gap-4 text-center">
                        <div>
                            <p class="text-gray-400 text-xs">Daily Limit</p>
                            <p class="text-white font-semibold text-sm">{{ $card->currency }} {{ number_format($card->daily_limit ?? 0, 0) }}</p>
                        </div>
                        <div>
                            <p class="text-gray-400 text-xs">Monthly Limit</p>
                            <p class="text-white font-semibold text-sm">{{ $card->currency }} {{ number_format($card->monthly_limit ?? 0, 0) }}</p>
                        </div>
                        <div>
                            <p class="text-gray-400 text-xs">Brand</p>
                            <p class="text-white font-semibold text-sm">{{ ucfirst($card->brand ?? 'Visa') }}</p>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @else
    <div class="text-center py-12">
        <div class="w-16 h-16 bg-dark-800 rounded-full flex items-center justify-center mx-auto mb-4">
            <i class="fas fa-credit-card text-gray-500 text-2xl"></i>
        </div>
        <p class="text-gray-400 font-medium mb-2">No virtual cards yet</p>
        @if(auth()->user()->hasCompletedKyc())
            <p class="text-gray-500 text-sm mb-4">Request your first virtual card to start making online payments</p>
            <button onclick="openCreateCardModal()" class="btn btn-primary">Request Virtual Card</button>
        @else
            <p class="text-gray-500 text-sm mb-4">Complete KYC verification to request virtual cards</p>
            <a href="{{ route('kyc.index') }}" class="btn btn-primary">Complete KYC</a>
        @endif
    </div>
    @endif

    <!-- Card Benefits -->
    <div class="card">
        <h3 class="text-lg font-semibold text-white mb-4">Card Benefits</h3>
        <div class="space-y-3">
            <div class="flex items-center">
                <i class="fas fa-shield-alt text-success-400 mr-3"></i>
                <span class="text-gray-300 text-sm">Secure online payments worldwide</span>
            </div>
            <div class="flex items-center">
                <i class="fas fa-lock text-primary-400 mr-3"></i>
                <span class="text-gray-300 text-sm">Instant freeze/unfreeze controls</span>
            </div>
            <div class="flex items-center">
                <i class="fas fa-chart-line text-warning-400 mr-3"></i>
                <span class="text-gray-300 text-sm">Real-time transaction tracking</span>
            </div>
            <div class="flex items-center">
                <i class="fas fa-globe text-purple-400 mr-3"></i>
                <span class="text-gray-300 text-sm">International payment support</span>
            </div>
        </div>
    </div>
</div>

<!-- Create Card Modal -->
<div id="createCardModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="absolute bottom-0 left-0 right-0 bg-dark-900 rounded-t-3xl p-6 slide-up">
        <div class="w-12 h-1 bg-gray-600 rounded-full mx-auto mb-6"></div>
        <h3 class="text-xl font-semibold text-white mb-6">Request Virtual Card</h3>
        
        <form id="createCardForm" method="POST" action="{{ route('cards.create') }}">
            @csrf
            <div class="space-y-4">
                <div>
                    <label for="card_type" class="form-label">Card Type</label>
                    <select name="card_type" id="card_type" class="form-input" required>
                        <option value="">Select card type</option>
                        <option value="virtual">Virtual Card</option>
                        <option value="disposable">Disposable Card</option>
                    </select>
                </div>
                
                <div>
                    <label for="currency" class="form-label">Currency</label>
                    <select name="currency" id="currency" class="form-input" required>
                        <option value="USD">USD - US Dollar</option>
                        <option value="NGN">NGN - Nigerian Naira</option>
                        <option value="EUR">EUR - Euro</option>
                        <option value="GBP">GBP - British Pound</option>
                    </select>
                </div>
                
                <div>
                    <label for="daily_limit" class="form-label">Daily Spending Limit</label>
                    <select name="daily_limit" id="daily_limit" class="form-input" required>
                        <option value="100">$100</option>
                        <option value="500">$500</option>
                        <option value="1000">$1,000</option>
                        <option value="2000">$2,000</option>
                        <option value="5000">$5,000</option>
                    </select>
                </div>
                
                <div class="bg-dark-800/50 rounded-lg p-4">
                    <h4 class="text-white font-medium mb-2">Card Features</h4>
                    <ul class="text-gray-400 text-sm space-y-1">
                        <li>• Instant card creation</li>
                        <li>• Real-time transaction alerts</li>
                        <li>• Freeze/unfreeze anytime</li>
                        <li>• International payments supported</li>
                    </ul>
                </div>
            </div>
            
            <div class="flex space-x-3 mt-6">
                <button type="button" onclick="closeCreateCardModal()" class="flex-1 btn btn-secondary">
                    Cancel
                </button>
                <button type="submit" class="flex-1 btn btn-primary">
                    Request Card
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Card Details Modal -->
<div id="cardDetailsModal" class="fixed inset-0 bg-black/50 backdrop-blur-sm hidden z-50">
    <div class="absolute bottom-0 left-0 right-0 bg-dark-900 rounded-t-3xl p-6 slide-up">
        <div class="w-12 h-1 bg-gray-600 rounded-full mx-auto mb-6"></div>
        <div id="cardDetailsContent">
            <!-- Card details will be loaded here -->
        </div>
        <button onclick="closeCardDetailsModal()" class="w-full btn btn-secondary mt-4">Close</button>
    </div>
</div>

@push('scripts')
<script>
function openCreateCardModal() {
    document.getElementById('createCardModal').classList.remove('hidden');
}

function closeCreateCardModal() {
    document.getElementById('createCardModal').classList.add('hidden');
}

function showCardDetails(cardId) {
    document.getElementById('cardDetailsModal').classList.remove('hidden');
    document.getElementById('cardDetailsContent').innerHTML = `
        <div class="text-center py-8">
            <div class="w-8 h-8 border-2 border-primary-600 border-t-transparent rounded-full animate-spin mx-auto mb-4"></div>
            <p class="text-gray-400">Loading card details...</p>
        </div>
    `;
    
    // TODO: Load actual card details via API
    setTimeout(() => {
        document.getElementById('cardDetailsContent').innerHTML = `
            <h3 class="text-xl font-semibold text-white mb-4">Card Details</h3>
            <div class="space-y-3">
                <div class="flex justify-between">
                    <span class="text-gray-400">Card ID:</span>
                    <span class="text-white font-mono">${cardId}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-400">Status:</span>
                    <span class="status-badge status-success">Active</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-400">Created:</span>
                    <span class="text-white">${new Date().toLocaleDateString()}</span>
                </div>
            </div>
        `;
    }, 1000);
}

function closeCardDetailsModal() {
    document.getElementById('cardDetailsModal').classList.add('hidden');
}

function fundCard(cardId) {
    // TODO: Implement card funding
    showToast('Card funding feature coming soon!', 'info');
}

function freezeCard(cardId) {
    if (confirm('Are you sure you want to freeze this card?')) {
        // TODO: Implement card freeze
        showToast('Card freeze feature coming soon!', 'info');
    }
}

function unfreezeCard(cardId) {
    if (confirm('Are you sure you want to unfreeze this card?')) {
        // TODO: Implement card unfreeze
        showToast('Card unfreeze feature coming soon!', 'info');
    }
}

function showToast(message, type = 'info') {
    const toast = document.createElement('div');
    toast.className = `fixed top-4 right-4 p-4 rounded-lg text-white z-50 ${type === 'success' ? 'bg-success-600' : type === 'error' ? 'bg-error-600' : 'bg-primary-600'}`;
    toast.textContent = message;
    document.body.appendChild(toast);
    
    setTimeout(() => {
        toast.remove();
    }, 3000);
}

// Close modals when clicking outside
document.addEventListener('click', function(event) {
    const createModal = document.getElementById('createCardModal');
    const detailsModal = document.getElementById('cardDetailsModal');
    
    if (event.target === createModal) {
        closeCreateCardModal();
    }
    if (event.target === detailsModal) {
        closeCardDetailsModal();
    }
});
</script>
@endpush
@endsection
                
                <div class="flex justify-between items-end">
                    <div>
                        <p class="text-xs opacity-75">Balance</p>
                        <p class="text-lg font-bold">₦{{ number_format($card->balance, 2) }}</p>
                    </div>
                    <div class="text-right">
                        <p class="text-xs opacity-75">Limit</p>
                        <p class="text-sm">₦{{ number_format($card->spending_limit, 0) }}</p>
                    </div>
                </div>
                
                <!-- Card type indicator -->
                <div class="absolute top-4 right-4">
                    @if($card->card_type === 'international')
                        <span class="text-xs bg-blue-500 px-2 py-1 rounded">🌍 International</span>
                    @else
                        <span class="text-xs bg-green-500 px-2 py-1 rounded">🇳🇬 Domestic</span>
                    @endif
                </div>
            </div>
            
            <!-- Card Actions -->
            <div class="p-4">
                <div class="flex justify-between items-center mb-3">
                    <span class="text-sm text-gray-600">Created {{ $card->created_at->format('M d, Y') }}</span>
                    <span class="text-sm text-gray-600">Usage: {{ $card->transactions_count ?? 0 }}</span>
                </div>
                
                <!-- Quick Actions -->
                <div class="grid grid-cols-2 gap-2 mb-3">
                    @if($card->status === 'active')
                        <button onclick="topUpCard('{{ $card->id }}')" class="text-xs px-3 py-2 bg-green-100 text-green-800 rounded hover:bg-green-200">
                            💰 Top Up
                        </button>
                        <button onclick="freezeCard('{{ $card->id }}')" class="text-xs px-3 py-2 bg-yellow-100 text-yellow-800 rounded hover:bg-yellow-200">
                            ❄️ Freeze
                        </button>
                    @elseif($card->status === 'frozen')
                        <button onclick="topUpCard('{{ $card->id }}')" class="text-xs px-3 py-2 bg-green-100 text-green-800 rounded hover:bg-green-200">
                            💰 Top Up
                        </button>
                        <button onclick="unfreezeCard('{{ $card->id }}')" class="text-xs px-3 py-2 bg-blue-100 text-blue-800 rounded hover:bg-blue-200">
                            🔥 Unfreeze
                        </button>
                    @endif
                </div>
                
                <div class="grid grid-cols-2 gap-2">
                    <button onclick="viewCardDetails('{{ $card->id }}')" class="text-xs px-3 py-2 bg-gray-100 text-gray-800 rounded hover:bg-gray-200">
                        👁️ View Details
                    </button>
                    <button onclick="viewTransactions('{{ $card->id }}')" class="text-xs px-3 py-2 bg-blue-100 text-blue-800 rounded hover:bg-blue-200">
                        📊 Transactions
                    </button>
                </div>
            </div>
        </div>
        @endforeach
    </div>
    
    <!-- Pagination -->
    <div class="mt-6">
        {{ $cards->links() }}
    </div>
@else
    <div class="card text-center py-12">
        <span class="text-6xl mb-4 block">💳</span>
        <h3 class="text-xl font-bold text-gray-900 mb-2">No Virtual Cards Yet</h3>
        <p class="text-gray-600 mb-6">
            @if(auth()->user()->hasCompletedKyc())
                Request your first virtual card to start making secure online payments.
            @else
                Complete your KYC verification to request virtual cards.
            @endif
        </p>
        @if(auth()->user()->hasCompletedKyc())
        <button onclick="openCreateCardModal()" class="btn-primary">
            Request Your First Card
        </button>
        @else
        <a href="{{ route('kyc.index') }}" class="btn-primary">
            Complete KYC First
        </a>
        @endif
    </div>
@endif

<!-- Create Card Modal -->
<div id="createCardModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-medium text-gray-900">Request New Virtual Card</h3>
                <button onclick="closeCreateCardModal()" class="text-gray-400 hover:text-gray-600">
                    <span class="text-2xl">&times;</span>
                </button>
            </div>
            
            <form id="createCardForm" method="POST" action="{{ route('cards.create') }}">
                @csrf
                <div class="space-y-4">
                    <div>
                        <label for="card_type" class="block text-sm font-medium text-gray-700 mb-2">Card Type</label>
                        <select name="card_type" id="card_type" required class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Card Type</option>
                            <option value="domestic">Domestic (Nigeria only)</option>
                            <option value="international">International (Worldwide)</option>
                        </select>
                    </div>
                    
                    <div>
                        <label for="spending_limit" class="block text-sm font-medium text-gray-700 mb-2">Monthly Spending Limit</label>
                        <select name="spending_limit" id="spending_limit" required class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                            <option value="">Select Limit</option>
                            <option value="50000">₦50,000</option>
                            <option value="100000">₦100,000</option>
                            <option value="500000">₦500,000</option>
                            <option value="1000000">₦1,000,000</option>
                        </select>
                    </div>
                    
                    <div>
                        <label for="card_pin" class="block text-sm font-medium text-gray-700 mb-2">4-Digit PIN</label>
                        <input type="password" name="pin" id="card_pin" maxlength="4" pattern="[0-9]{4}" required 
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                               placeholder="Enter 4-digit PIN">
                    </div>
                    
                    <div>
                        <label for="confirm_pin" class="block text-sm font-medium text-gray-700 mb-2">Confirm PIN</label>
                        <input type="password" name="confirm_pin" id="confirm_pin" maxlength="4" pattern="[0-9]{4}" required 
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                               placeholder="Confirm PIN">
                    </div>
                    
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-3">
                        <p class="text-sm text-blue-800">
                            <strong>Note:</strong> Card creation fee is ₦1,000. International cards have higher limits but additional fees may apply.
                        </p>
                    </div>
                </div>
                
                <div class="flex justify-center space-x-4 mt-6">
                    <button type="button" onclick="closeCreateCardModal()" 
                            class="px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400">
                        Cancel
                    </button>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                        Create Card (₦1,000)
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Card Details Modal -->
<div id="cardDetailsModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-medium text-gray-900">Card Details</h3>
                <button onclick="closeCardDetailsModal()" class="text-gray-400 hover:text-gray-600">
                    <span class="text-2xl">&times;</span>
                </button>
            </div>
            <div id="cardDetailsContent">
                <!-- Card details will be loaded here -->
            </div>
        </div>
    </div>
</div>

<script>
function openCreateCardModal() {
    document.getElementById('createCardModal').classList.remove('hidden');
}

function closeCreateCardModal() {
    document.getElementById('createCardModal').classList.add('hidden');
}

function openCardDetailsModal() {
    document.getElementById('cardDetailsModal').classList.remove('hidden');
}

function closeCardDetailsModal() {
    document.getElementById('cardDetailsModal').classList.add('hidden');
}

function topUpCard(cardId) {
    const amount = prompt('Enter top-up amount (₦):');
    if (amount && !isNaN(amount) && parseFloat(amount) > 0) {
        // Implementation for card top-up
        alert(`Top-up of ₦${amount} initiated for card ${cardId}`);
    }
}

function freezeCard(cardId) {
    if (confirm('Are you sure you want to freeze this card? You can unfreeze it later.')) {
        // Make AJAX request to freeze card
        fetch(`{{ url('/cards') }}/${cardId}/freeze`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            alert(data.message || 'Card frozen successfully');
            location.reload();
        })
        .catch(error => {
            alert('Error freezing card');
        });
    }
}

function unfreezeCard(cardId) {
    if (confirm('Are you sure you want to unfreeze this card?')) {
        // Make AJAX request to unfreeze card
        fetch(`{{ url('/cards') }}/${cardId}/unfreeze`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
            },
        })
        .then(response => response.json())
        .then(data => {
            alert(data.message || 'Card unfrozen successfully');
            location.reload();
        })
        .catch(error => {
            alert('Error unfreezing card');
        });
    }
}

function viewCardDetails(cardId) {
    openCardDetailsModal();
    document.getElementById('cardDetailsContent').innerHTML = '<p class="text-center">Loading...</p>';
    
    // Load card details (placeholder implementation)
    setTimeout(() => {
        document.getElementById('cardDetailsContent').innerHTML = `
            <div class="space-y-3">
                <div class="bg-gray-50 rounded-lg p-3">
                    <p class="text-sm text-gray-600">Card Number</p>
                    <p class="font-mono text-lg">**** **** **** ****</p>
                    <button onclick="revealCardNumber('${cardId}')" class="text-blue-600 text-sm">Click to reveal</button>
                </div>
                <div class="bg-gray-50 rounded-lg p-3">
                    <p class="text-sm text-gray-600">CVV</p>
                    <p class="font-mono">***</p>
                    <button onclick="revealCVV('${cardId}')" class="text-blue-600 text-sm">Click to reveal</button>
                </div>
                <div class="bg-gray-50 rounded-lg p-3">
                    <p class="text-sm text-gray-600">Expiry Date</p>
                    <p class="font-mono">**/**</p>
                    <button onclick="revealExpiry('${cardId}')" class="text-blue-600 text-sm">Click to reveal</button>
                </div>
                <div class="mt-4 text-xs text-gray-500 text-center">
                    Card details are hidden for security. Click to reveal individual fields.
                </div>
            </div>
        `;
    }, 500);
}

function viewTransactions(cardId) {
    window.location.href = `{{ url('/transactions') }}?card_id=${cardId}`;
}

function revealCardNumber(cardId) {
    // Implementation for revealing card number with security confirmation
    alert('Security verification required to reveal card number');
}

function revealCVV(cardId) {
    // Implementation for revealing CVV
    alert('Security verification required to reveal CVV');
}

function revealExpiry(cardId) {
    // Implementation for revealing expiry date
    alert('Security verification required to reveal expiry date');
}

// Close modals when clicking outside
document.getElementById('createCardModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeCreateCardModal();
    }
});

document.getElementById('cardDetailsModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeCardDetailsModal();
    }
});

// Validate PIN confirmation
document.getElementById('confirm_pin').addEventListener('input', function() {
    const pin = document.getElementById('card_pin').value;
    const confirmPin = this.value;
    
    if (confirmPin && pin !== confirmPin) {
        this.setCustomValidity('PINs do not match');
    } else {
        this.setCustomValidity('');
    }
});
</script>
@endsection