<?php

namespace App\Http\Controllers;

use App\Models\Page;
use Illuminate\Http\Request;

class PageController extends Controller
{
    /**
     * Display a published page by its slug.
     */
    public function show($slug)
    {
        $page = Page::where('published', true)
            ->where('slug', $slug)
            ->firstOrFail();

        return view('page', compact('page'));
    }
}
